/*
 * wsdl-memory.h: Free memory allocated to WSDL structs
 *
 * Authors:
 *	Dick Porter (dick@ximian.com)
 *
 * Copyright (C) 2001, Ximian, Inc.
 */

#ifndef _WSDL_MEMORY_H_
#define _WSDL_MEMORY_H_

#include "wsdl-parse.h"

extern void wsdl_free_types(wsdl_types *);
extern void wsdl_free_message_part(wsdl_message_part *);
extern void wsdl_free_message(wsdl_message *);
extern void wsdl_free_porttype_operation_iof(wsdl_porttype_operation_inoutfault *);
extern void wsdl_free_porttype_operation(wsdl_porttype_operation *);
extern void wsdl_free_porttype(wsdl_porttype *);
extern void wsdl_free_soap_binding(wsdl_soap_binding *);
extern void wsdl_free_soap_operation(wsdl_soap_operation *);
extern void wsdl_free_soap_body(wsdl_soap_body *);
extern void wsdl_free_soap_header(wsdl_soap_header *);
extern void wsdl_free_soap_fault(wsdl_soap_fault *);
extern void wsdl_free_binding_operation_iof(wsdl_binding_operation_inoutfault *);
extern void wsdl_free_binding_operation(wsdl_binding_operation *);
extern void wsdl_free_binding(wsdl_binding *);
extern void wsdl_free_soap_address(wsdl_soap_address *);
extern void wsdl_free_service_port(wsdl_service_port *);
extern void wsdl_free_service(wsdl_service *);
extern void wsdl_free_definitions(wsdl_definitions *);

#endif /* _WSDL_MEMORY_H_ */
