/* rygel-live-response.c generated by valac, the Vala compiler
 * generated from rygel-live-response.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gst/gst.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_RESPONSE (rygel_http_response_get_type ())
#define RYGEL_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponse))
#define RYGEL_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))
#define RYGEL_IS_HTTP_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_IS_HTTP_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_RESPONSE))
#define RYGEL_HTTP_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_RESPONSE, RygelHTTPResponseClass))

typedef struct _RygelHTTPResponse RygelHTTPResponse;
typedef struct _RygelHTTPResponseClass RygelHTTPResponseClass;
typedef struct _RygelHTTPResponsePrivate RygelHTTPResponsePrivate;

#define RYGEL_TYPE_LIVE_RESPONSE (rygel_live_response_get_type ())
#define RYGEL_LIVE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponse))
#define RYGEL_LIVE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponseClass))
#define RYGEL_IS_LIVE_RESPONSE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LIVE_RESPONSE))
#define RYGEL_IS_LIVE_RESPONSE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LIVE_RESPONSE))
#define RYGEL_LIVE_RESPONSE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponseClass))

typedef struct _RygelLiveResponse RygelLiveResponse;
typedef struct _RygelLiveResponseClass RygelLiveResponseClass;
typedef struct _RygelLiveResponsePrivate RygelLiveResponsePrivate;

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;
#define _gst_object_unref0(var) ((var == NULL) ? NULL : (var = (gst_object_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _RygelLiveResponseRunData RygelLiveResponseRunData;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _gst_caps_unref0(var) ((var == NULL) ? NULL : (var = (gst_caps_unref (var), NULL)))
typedef struct _Block2Data Block2Data;
#define _gst_buffer_unref0(var) ((var == NULL) ? NULL : (var = (gst_buffer_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPResponse {
	GObject parent_instance;
	RygelHTTPResponsePrivate * priv;
	SoupMessage* msg;
};

struct _RygelHTTPResponseClass {
	GObjectClass parent_class;
	void (*run) (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelHTTPResponse* self, GAsyncResult* _res_);
	void (*end) (RygelHTTPResponse* self, gboolean aborted, guint status);
};

struct _RygelLiveResponse {
	RygelHTTPResponse parent_instance;
	RygelLiveResponsePrivate * priv;
};

struct _RygelLiveResponseClass {
	RygelHTTPResponseClass parent_class;
};

struct _RygelLiveResponsePrivate {
	GstPipeline* pipeline;
	RygelHTTPSeek* time_range;
	GSourceFunc run_continue;
	gpointer run_continue_target;
	GDestroyNotify run_continue_target_destroy_notify;
};

struct _RygelLiveResponseRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelLiveResponse* self;
	gboolean _tmp0_;
	GSourceFunc _tmp1_;
};

typedef enum  {
	RYGEL_GST_ERROR_MISSING_PLUGIN,
	RYGEL_GST_ERROR_LINK
} RygelGstError;
#define RYGEL_GST_ERROR rygel_gst_error_quark ()
struct _Block2Data {
	int _ref_count_;
	RygelLiveResponse * self;
	GstBuffer* buffer;
};


static gpointer rygel_live_response_parent_class = NULL;

GType rygel_state_machine_get_type (void);
GType rygel_http_response_get_type (void);
GType rygel_live_response_get_type (void);
GType rygel_http_seek_get_type (void);
#define RYGEL_LIVE_RESPONSE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_LIVE_RESPONSE, RygelLiveResponsePrivate))
enum  {
	RYGEL_LIVE_RESPONSE_DUMMY_PROPERTY
};
#define RYGEL_LIVE_RESPONSE_SINK_NAME "fakesink"
RygelHTTPResponse* rygel_http_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, gboolean partial, GCancellable* cancellable);
static void rygel_live_response_prepare_pipeline (RygelLiveResponse* self, const char* name, GstElement* src, GError** error);
RygelLiveResponse* rygel_live_response_new (SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error);
RygelLiveResponse* rygel_live_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error);
static void rygel_live_response_real_run_data_free (gpointer _data);
static void rygel_live_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_live_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
void rygel_http_response_run (RygelHTTPResponse* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_http_response_run_finish (RygelHTTPResponse* self, GAsyncResult* _res_);
static gboolean _rygel_live_response_real_run_co_gsource_func (gpointer self);
static gboolean rygel_live_response_real_run_co (RygelLiveResponseRunData* data);
SoupServer* rygel_http_response_get_server (RygelHTTPResponse* self);
void rygel_http_response_end (RygelHTTPResponse* self, gboolean aborted, guint status);
static void rygel_live_response_real_end (RygelHTTPResponse* base, gboolean aborted, guint status);
GQuark rygel_gst_error_quark (void);
static inline void _dynamic_set_signal_handoffs2 (GstElement* obj, gboolean value);
static void rygel_live_response_on_new_buffer (RygelLiveResponse* self, GstElement* sink, GstBuffer* buffer, GstPad* pad);
static void _rygel_live_response_on_new_buffer_dynamic_handoff0_ (GstElement* _sender, GstBuffer* buffer, GstPad* pad, gpointer self);
void _dynamic_handoff1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data);
static void rygel_live_response_src_pad_added (RygelLiveResponse* self, GstElement* src, GstPad* src_pad);
static void _rygel_live_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self);
static gboolean rygel_live_response_bus_handler (RygelLiveResponse* self, GstBus* bus, GstMessage* message);
static gboolean _rygel_live_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self);
GstElement* rygel_gst_utils_get_rtp_depayloader (GstCaps* caps);
void rygel_http_response_push_data (RygelHTTPResponse* self, void* data, gsize length);
static gboolean _lambda2_ (Block2Data* _data2_);
static gboolean __lambda2__gsource_func (gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean rygel_live_response_seek (RygelLiveResponse* self);
static gboolean _lambda3_ (RygelLiveResponse* self);
static gboolean __lambda3__gsource_func (gpointer self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
static void rygel_live_response_finalize (GObject* obj);


static void g_cclosure_user_marshal_VOID__GST_MINI_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 38 "rygel-live-response.vala"
RygelLiveResponse* rygel_live_response_construct (GType object_type, SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error) {
#line 202 "rygel-live-response.c"
	GError * _inner_error_;
	RygelLiveResponse * self;
	RygelHTTPSeek* _tmp0_;
#line 38 "rygel-live-response.vala"
	g_return_val_if_fail (server != NULL, NULL);
#line 38 "rygel-live-response.vala"
	g_return_val_if_fail (msg != NULL, NULL);
#line 38 "rygel-live-response.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 38 "rygel-live-response.vala"
	g_return_val_if_fail (src != NULL, NULL);
#line 214 "rygel-live-response.c"
	_inner_error_ = NULL;
#line 44 "rygel-live-response.vala"
	self = (RygelLiveResponse*) rygel_http_response_construct (object_type, server, msg, FALSE, cancellable);
#line 46 "rygel-live-response.vala"
	soup_message_headers_set_encoding (((RygelHTTPResponse*) self)->msg->response_headers, SOUP_ENCODING_EOF);
#line 48 "rygel-live-response.vala"
	rygel_live_response_prepare_pipeline (self, name, src, &_inner_error_);
#line 222 "rygel-live-response.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		g_object_unref (self);
		return NULL;
	}
#line 49 "rygel-live-response.vala"
	self->priv->time_range = (_tmp0_ = _g_object_ref0 (time_range), _g_object_unref0 (self->priv->time_range), _tmp0_);
#line 230 "rygel-live-response.c"
	return self;
}


#line 38 "rygel-live-response.vala"
RygelLiveResponse* rygel_live_response_new (SoupServer* server, SoupMessage* msg, const char* name, GstElement* src, RygelHTTPSeek* time_range, GCancellable* cancellable, GError** error) {
#line 38 "rygel-live-response.vala"
	return rygel_live_response_construct (RYGEL_TYPE_LIVE_RESPONSE, server, msg, name, src, time_range, cancellable, error);
#line 239 "rygel-live-response.c"
}


static void rygel_live_response_real_run_data_free (gpointer _data) {
	RygelLiveResponseRunData* data;
	data = _data;
	g_object_unref (data->self);
	g_slice_free (RygelLiveResponseRunData, data);
}


static void rygel_live_response_real_run (RygelHTTPResponse* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelLiveResponse * self;
	RygelLiveResponseRunData* _data_;
	self = (RygelLiveResponse*) base;
	_data_ = g_slice_new0 (RygelLiveResponseRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_live_response_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_live_response_real_run_data_free);
	_data_->self = g_object_ref (self);
	rygel_live_response_real_run_co (_data_);
}


static void rygel_live_response_real_run_finish (RygelHTTPResponse* base, GAsyncResult* _res_) {
	RygelLiveResponseRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_live_response_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelLiveResponseRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_live_response_real_run_co (data);
}


#line 52 "rygel-live-response.vala"
static gboolean _rygel_live_response_real_run_co_gsource_func (gpointer self) {
#line 279 "rygel-live-response.c"
	return rygel_live_response_real_run_co (self);
}


static gboolean rygel_live_response_real_run_co (RygelLiveResponseRunData* data) {
	switch (data->_state_) {
		case 0:
		goto _state_0;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
#line 54 "rygel-live-response.vala"
		if (data->self->priv->time_range != NULL) {
#line 54 "rygel-live-response.vala"
			data->_tmp0_ = rygel_http_seek_get_start (data->self->priv->time_range) > 0;
#line 299 "rygel-live-response.c"
		} else {
#line 54 "rygel-live-response.vala"
			data->_tmp0_ = FALSE;
#line 303 "rygel-live-response.c"
		}
#line 54 "rygel-live-response.vala"
		if (data->_tmp0_) {
#line 55 "rygel-live-response.vala"
			gst_element_set_state ((GstElement*) data->self->priv->pipeline, GST_STATE_PAUSED);
#line 309 "rygel-live-response.c"
		} else {
#line 57 "rygel-live-response.vala"
			gst_element_set_state ((GstElement*) data->self->priv->pipeline, GST_STATE_PLAYING);
#line 313 "rygel-live-response.c"
		}
#line 60 "rygel-live-response.vala"
		data->self->priv->run_continue = (data->_tmp1_ = _rygel_live_response_real_run_co_gsource_func, ((data->self->priv->run_continue_target_destroy_notify == NULL) ? NULL : data->self->priv->run_continue_target_destroy_notify (data->self->priv->run_continue_target), data->self->priv->run_continue = NULL, data->self->priv->run_continue_target = NULL, data->self->priv->run_continue_target_destroy_notify = NULL), data->self->priv->run_continue_target = data, data->self->priv->run_continue_target_destroy_notify = NULL, data->_tmp1_);
#line 317 "rygel-live-response.c"
		data->_state_ = 2;
		return FALSE;
		_state_2:
		;
	}
	{
		if (data->_state_ == 0) {
			g_simple_async_result_complete_in_idle (data->_async_result);
		} else {
			g_simple_async_result_complete (data->_async_result);
		}
		g_object_unref (data->_async_result);
		return FALSE;
	}
}


#line 65 "rygel-live-response.vala"
static void rygel_live_response_real_end (RygelHTTPResponse* base, gboolean aborted, guint status) {
#line 337 "rygel-live-response.c"
	RygelLiveResponse * self;
	self = (RygelLiveResponse*) base;
#line 66 "rygel-live-response.vala"
	gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_NULL);
#line 68 "rygel-live-response.vala"
	if (!aborted) {
#line 69 "rygel-live-response.vala"
		soup_message_body_complete (((RygelHTTPResponse*) self)->msg->response_body);
#line 70 "rygel-live-response.vala"
		soup_server_unpause_message (rygel_http_response_get_server ((RygelHTTPResponse*) self), ((RygelHTTPResponse*) self)->msg);
#line 348 "rygel-live-response.c"
	}
#line 73 "rygel-live-response.vala"
	RYGEL_HTTP_RESPONSE_CLASS (rygel_live_response_parent_class)->end (RYGEL_HTTP_RESPONSE (self), aborted, status);
#line 75 "rygel-live-response.vala"
	self->priv->run_continue (self->priv->run_continue_target);
#line 354 "rygel-live-response.c"
}


static inline void _dynamic_set_signal_handoffs2 (GstElement* obj, gboolean value) {
	g_object_set (obj, "signal-handoffs", value, NULL);
}


#line 148 "rygel-live-response.vala"
static void _rygel_live_response_on_new_buffer_dynamic_handoff0_ (GstElement* _sender, GstBuffer* buffer, GstPad* pad, gpointer self) {
#line 365 "rygel-live-response.c"
	rygel_live_response_on_new_buffer (self, _sender, buffer, pad);
}


void _dynamic_handoff1_connect (gpointer obj, const char * signal_name, GCallback handler, gpointer data) {
	g_signal_connect_object (obj, signal_name, handler, data, 0);
}


static gpointer _gst_object_ref0 (gpointer self) {
	return self ? gst_object_ref (self) : NULL;
}


#line 112 "rygel-live-response.vala"
static void _rygel_live_response_src_pad_added_gst_element_pad_added (GstElement* _sender, GstPad* pad, gpointer self) {
#line 382 "rygel-live-response.c"
	rygel_live_response_src_pad_added (self, _sender, pad);
}


#line 159 "rygel-live-response.vala"
static gboolean _rygel_live_response_bus_handler_gst_bus_func (GstBus* bus, GstMessage* message, gpointer self) {
#line 389 "rygel-live-response.c"
	return rygel_live_response_bus_handler (self, bus, message);
}


#line 78 "rygel-live-response.vala"
static void rygel_live_response_prepare_pipeline (RygelLiveResponse* self, const char* name, GstElement* src, GError** error) {
#line 396 "rygel-live-response.c"
	GError * _inner_error_;
	GstElement* sink;
	GstPipeline* _tmp0_;
	GstBus* bus;
#line 78 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 78 "rygel-live-response.vala"
	g_return_if_fail (name != NULL);
#line 78 "rygel-live-response.vala"
	g_return_if_fail (src != NULL);
#line 407 "rygel-live-response.c"
	_inner_error_ = NULL;
#line 80 "rygel-live-response.vala"
	sink = gst_element_factory_make ("fakesink", RYGEL_LIVE_RESPONSE_SINK_NAME);
#line 82 "rygel-live-response.vala"
	if (sink == NULL) {
#line 413 "rygel-live-response.c"
		_inner_error_ = g_error_new_literal (RYGEL_GST_ERROR, RYGEL_GST_ERROR_MISSING_PLUGIN, "Required plugin " "'fakesink' missing");
		{
			g_propagate_error (error, _inner_error_);
			_gst_object_unref0 (sink);
			return;
		}
	}
#line 87 "rygel-live-response.vala"
	_dynamic_set_signal_handoffs2 (sink, TRUE);
#line 88 "rygel-live-response.vala"
	_dynamic_handoff1_connect (sink, "handoff", (GCallback) _rygel_live_response_on_new_buffer_dynamic_handoff0_, self);
#line 90 "rygel-live-response.vala"
	self->priv->pipeline = (_tmp0_ = (GstPipeline*) gst_pipeline_new (name), _gst_object_unref0 (self->priv->pipeline), _tmp0_);
#line 91 "rygel-live-response.vala"
	g_assert (self->priv->pipeline != NULL);
#line 93 "rygel-live-response.vala"
	gst_bin_add_many ((GstBin*) self->priv->pipeline, _gst_object_ref0 (src), _gst_object_ref0 (sink), NULL);
#line 95 "rygel-live-response.vala"
	if (src->numpads == 0) {
#line 97 "rygel-live-response.vala"
		g_signal_connect_object (src, "pad-added", (GCallback) _rygel_live_response_src_pad_added_gst_element_pad_added, self, 0);
#line 435 "rygel-live-response.c"
	} else {
#line 100 "rygel-live-response.vala"
		if (!gst_element_link (src, sink)) {
#line 439 "rygel-live-response.c"
			char* _tmp3_;
			char* _tmp2_;
			char* _tmp1_;
			GError* _tmp4_;
			_inner_error_ = (_tmp4_ = g_error_new_literal (RYGEL_GST_ERROR, RYGEL_GST_ERROR_LINK, _tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat ("Failed to link ", gst_object_get_name ((GstObject*) src), NULL), " to ", NULL), gst_object_get_name ((GstObject*) sink), NULL)), _g_free0 (_tmp3_), _g_free0 (_tmp2_), _g_free0 (_tmp1_), _tmp4_);
			{
				g_propagate_error (error, _inner_error_);
				_gst_object_unref0 (sink);
				return;
			}
		}
	}
#line 108 "rygel-live-response.vala"
	bus = gst_pipeline_get_bus (self->priv->pipeline);
#line 109 "rygel-live-response.vala"
	gst_bus_add_watch_full (bus, G_PRIORITY_DEFAULT, _rygel_live_response_bus_handler_gst_bus_func, g_object_ref (self), g_object_unref);
#line 456 "rygel-live-response.c"
	_gst_object_unref0 (sink);
	_gst_object_unref0 (bus);
}


#line 112 "rygel-live-response.vala"
static void rygel_live_response_src_pad_added (RygelLiveResponse* self, GstElement* src, GstPad* src_pad) {
#line 464 "rygel-live-response.c"
	GstCaps* caps;
	GstElement* sink;
	GstPad* sink_pad;
	GstElement* depay;
#line 112 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 112 "rygel-live-response.vala"
	g_return_if_fail (src != NULL);
#line 112 "rygel-live-response.vala"
	g_return_if_fail (src_pad != NULL);
#line 114 "rygel-live-response.vala"
	caps = gst_pad_get_caps (src_pad);
#line 116 "rygel-live-response.vala"
	sink = gst_bin_get_by_name ((GstBin*) self->priv->pipeline, RYGEL_LIVE_RESPONSE_SINK_NAME);
#line 479 "rygel-live-response.c"
	sink_pad = NULL;
#line 119 "rygel-live-response.vala"
	depay = rygel_gst_utils_get_rtp_depayloader (caps);
#line 120 "rygel-live-response.vala"
	if (depay != NULL) {
#line 485 "rygel-live-response.c"
		GstPad* _tmp0_;
#line 121 "rygel-live-response.vala"
		gst_bin_add ((GstBin*) self->priv->pipeline, _gst_object_ref0 (depay));
#line 122 "rygel-live-response.vala"
		if (!gst_element_link (depay, sink)) {
#line 123 "rygel-live-response.vala"
			g_critical ("rygel-live-response.vala:123: Failed to link %s to %s", gst_object_get_name ((GstObject*) depay), gst_object_get_name ((GstObject*) sink));
#line 126 "rygel-live-response.vala"
			rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 495 "rygel-live-response.c"
			_gst_caps_unref0 (caps);
			_gst_object_unref0 (sink);
			_gst_object_unref0 (sink_pad);
			_gst_object_unref0 (depay);
#line 127 "rygel-live-response.vala"
			return;
#line 502 "rygel-live-response.c"
		}
#line 130 "rygel-live-response.vala"
		sink_pad = (_tmp0_ = _gst_object_ref0 (gst_element_get_compatible_pad (depay, src_pad, caps)), _gst_object_unref0 (sink_pad), _tmp0_);
#line 506 "rygel-live-response.c"
	} else {
		GstPad* _tmp1_;
#line 132 "rygel-live-response.vala"
		sink_pad = (_tmp1_ = _gst_object_ref0 (gst_element_get_compatible_pad (sink, src_pad, caps)), _gst_object_unref0 (sink_pad), _tmp1_);
#line 511 "rygel-live-response.c"
	}
#line 135 "rygel-live-response.vala"
	if (gst_pad_link (src_pad, sink_pad) != GST_PAD_LINK_OK) {
#line 136 "rygel-live-response.vala"
		g_critical ("rygel-live-response.vala:136: Failed to link pad %s to %s", gst_object_get_name ((GstObject*) src_pad), gst_object_get_name ((GstObject*) sink_pad));
#line 139 "rygel-live-response.vala"
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 519 "rygel-live-response.c"
		_gst_caps_unref0 (caps);
		_gst_object_unref0 (sink);
		_gst_object_unref0 (sink_pad);
		_gst_object_unref0 (depay);
#line 140 "rygel-live-response.vala"
		return;
#line 526 "rygel-live-response.c"
	}
#line 143 "rygel-live-response.vala"
	if (depay != NULL) {
#line 144 "rygel-live-response.vala"
		gst_element_sync_state_with_parent (depay);
#line 532 "rygel-live-response.c"
	}
	_gst_caps_unref0 (caps);
	_gst_object_unref0 (sink);
	_gst_object_unref0 (sink_pad);
	_gst_object_unref0 (depay);
}


#line 152 "rygel-live-response.vala"
static gboolean _lambda2_ (Block2Data* _data2_) {
#line 543 "rygel-live-response.c"
	RygelLiveResponse * self;
	gboolean result = FALSE;
	self = _data2_->self;
#line 153 "rygel-live-response.vala"
	rygel_http_response_push_data ((RygelHTTPResponse*) self, _data2_->buffer->data, (gsize) _data2_->buffer->size);
#line 549 "rygel-live-response.c"
	result = FALSE;
#line 155 "rygel-live-response.vala"
	return result;
#line 553 "rygel-live-response.c"
}


#line 152 "rygel-live-response.vala"
static gboolean __lambda2__gsource_func (gpointer self) {
#line 559 "rygel-live-response.c"
	return _lambda2_ (self);
}


static gpointer _gst_buffer_ref0 (gpointer self) {
	return self ? gst_buffer_ref (self) : NULL;
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	++_data2_->_ref_count_;
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if ((--_data2_->_ref_count_) == 0) {
		_g_object_unref0 (_data2_->self);
		_gst_buffer_unref0 (_data2_->buffer);
		g_slice_free (Block2Data, _data2_);
	}
}


#line 148 "rygel-live-response.vala"
static void rygel_live_response_on_new_buffer (RygelLiveResponse* self, GstElement* sink, GstBuffer* buffer, GstPad* pad) {
#line 586 "rygel-live-response.c"
	Block2Data* _data2_;
#line 148 "rygel-live-response.vala"
	g_return_if_fail (self != NULL);
#line 148 "rygel-live-response.vala"
	g_return_if_fail (sink != NULL);
#line 148 "rygel-live-response.vala"
	g_return_if_fail (buffer != NULL);
#line 148 "rygel-live-response.vala"
	g_return_if_fail (pad != NULL);
#line 596 "rygel-live-response.c"
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	_data2_->buffer = _gst_buffer_ref0 (buffer);
#line 151 "rygel-live-response.vala"
	g_idle_add_full (G_PRIORITY_HIGH_IDLE, __lambda2__gsource_func, block2_data_ref (_data2_), block2_data_unref);
#line 603 "rygel-live-response.c"
	block2_data_unref (_data2_);
}


#line 205 "rygel-live-response.vala"
static gboolean _lambda3_ (RygelLiveResponse* self) {
#line 610 "rygel-live-response.c"
	gboolean result = FALSE;
#line 206 "rygel-live-response.vala"
	rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_NONE);
#line 614 "rygel-live-response.c"
	result = FALSE;
#line 208 "rygel-live-response.vala"
	return result;
#line 618 "rygel-live-response.c"
}


#line 205 "rygel-live-response.vala"
static gboolean __lambda3__gsource_func (gpointer self) {
#line 624 "rygel-live-response.c"
	return _lambda3_ (self);
}


#line 159 "rygel-live-response.vala"
static gboolean rygel_live_response_bus_handler (RygelLiveResponse* self, GstBus* bus, GstMessage* message) {
#line 631 "rygel-live-response.c"
	gboolean result = FALSE;
	gboolean ret;
#line 159 "rygel-live-response.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 159 "rygel-live-response.vala"
	g_return_val_if_fail (bus != NULL, FALSE);
#line 159 "rygel-live-response.vala"
	g_return_val_if_fail (message != NULL, FALSE);
#line 161 "rygel-live-response.vala"
	ret = TRUE;
#line 163 "rygel-live-response.vala"
	if (message->type == GST_MESSAGE_EOS) {
#line 164 "rygel-live-response.vala"
		ret = FALSE;
#line 646 "rygel-live-response.c"
	} else {
#line 165 "rygel-live-response.vala"
		if (message->type == GST_MESSAGE_STATE_CHANGED) {
#line 650 "rygel-live-response.c"
			gboolean _tmp0_ = FALSE;
#line 166 "rygel-live-response.vala"
			if (message->src != GST_OBJECT (self->priv->pipeline)) {
#line 654 "rygel-live-response.c"
				result = TRUE;
#line 167 "rygel-live-response.vala"
				return result;
#line 658 "rygel-live-response.c"
			}
#line 170 "rygel-live-response.vala"
			if (self->priv->time_range != NULL) {
#line 170 "rygel-live-response.vala"
				_tmp0_ = rygel_http_seek_get_start (self->priv->time_range) > 0;
#line 664 "rygel-live-response.c"
			} else {
#line 170 "rygel-live-response.vala"
				_tmp0_ = FALSE;
#line 668 "rygel-live-response.c"
			}
#line 170 "rygel-live-response.vala"
			if (_tmp0_) {
#line 672 "rygel-live-response.c"
				GstState old_state = 0;
				GstState new_state = 0;
				gboolean _tmp1_ = FALSE;
#line 174 "rygel-live-response.vala"
				gst_message_parse_state_changed (message, &old_state, &new_state, NULL);
#line 178 "rygel-live-response.vala"
				if (old_state == GST_STATE_READY) {
#line 178 "rygel-live-response.vala"
					_tmp1_ = new_state == GST_STATE_PAUSED;
#line 682 "rygel-live-response.c"
				} else {
#line 178 "rygel-live-response.vala"
					_tmp1_ = FALSE;
#line 686 "rygel-live-response.c"
				}
#line 178 "rygel-live-response.vala"
				if (_tmp1_) {
#line 179 "rygel-live-response.vala"
					if (rygel_live_response_seek (self)) {
#line 180 "rygel-live-response.vala"
						gst_element_set_state ((GstElement*) self->priv->pipeline, GST_STATE_PLAYING);
#line 694 "rygel-live-response.c"
					}
				}
			}
		} else {
			GError* err;
			char* err_msg;
			err = NULL;
			err_msg = NULL;
#line 188 "rygel-live-response.vala"
			if (message->type == GST_MESSAGE_ERROR) {
#line 705 "rygel-live-response.c"
				char* _tmp5_;
				char* _tmp4_ = NULL;
				GError* _tmp3_;
				GError* _tmp2_ = NULL;
#line 189 "rygel-live-response.vala"
				(gst_message_parse_error (message, &_tmp2_, &_tmp4_), err = (_tmp3_ = _tmp2_, _g_error_free0 (err), _tmp3_));
#line 189 "rygel-live-response.vala"
				err_msg = (_tmp5_ = _tmp4_, _g_free0 (err_msg), _tmp5_);
#line 190 "rygel-live-response.vala"
				g_critical ("rygel-live-response.vala:190: Error from pipeline %s:%s", gst_object_get_name ((GstObject*) self->priv->pipeline), err_msg);
#line 194 "rygel-live-response.vala"
				ret = FALSE;
#line 718 "rygel-live-response.c"
			} else {
#line 195 "rygel-live-response.vala"
				if (message->type == GST_MESSAGE_WARNING) {
#line 722 "rygel-live-response.c"
					char* _tmp9_;
					char* _tmp8_ = NULL;
					GError* _tmp7_;
					GError* _tmp6_ = NULL;
#line 196 "rygel-live-response.vala"
					(gst_message_parse_warning (message, &_tmp6_, &_tmp8_), err = (_tmp7_ = _tmp6_, _g_error_free0 (err), _tmp7_));
#line 196 "rygel-live-response.vala"
					err_msg = (_tmp9_ = _tmp8_, _g_free0 (err_msg), _tmp9_);
#line 197 "rygel-live-response.vala"
					g_warning ("rygel-live-response.vala:197: Warning from pipeline %s:%s", gst_object_get_name ((GstObject*) self->priv->pipeline), err_msg);
#line 733 "rygel-live-response.c"
				}
			}
			_g_error_free0 (err);
			_g_free0 (err_msg);
		}
	}
#line 203 "rygel-live-response.vala"
	if (!ret) {
#line 204 "rygel-live-response.vala"
		g_idle_add_full (G_PRIORITY_HIGH_IDLE, __lambda3__gsource_func, g_object_ref (self), g_object_unref);
#line 744 "rygel-live-response.c"
	}
	result = ret;
#line 212 "rygel-live-response.vala"
	return result;
#line 749 "rygel-live-response.c"
}


#line 215 "rygel-live-response.vala"
static gboolean rygel_live_response_seek (RygelLiveResponse* self) {
#line 755 "rygel-live-response.c"
	gboolean result = FALSE;
	GstSeekType stop_type = 0;
#line 215 "rygel-live-response.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 218 "rygel-live-response.vala"
	if (rygel_http_seek_get_stop (self->priv->time_range) > 0) {
#line 219 "rygel-live-response.vala"
		stop_type = GST_SEEK_TYPE_SET;
#line 764 "rygel-live-response.c"
	} else {
#line 221 "rygel-live-response.vala"
		stop_type = GST_SEEK_TYPE_NONE;
#line 768 "rygel-live-response.c"
	}
#line 224 "rygel-live-response.vala"
	if (!gst_element_seek ((GstElement*) self->priv->pipeline, 1.0, GST_FORMAT_TIME, GST_SEEK_FLAG_FLUSH, GST_SEEK_TYPE_SET, rygel_http_seek_get_start (self->priv->time_range), stop_type, rygel_http_seek_get_stop (self->priv->time_range))) {
#line 231 "rygel-live-response.vala"
		g_warning ("rygel-live-response.vala:231: Failed to seek to offset %lld", rygel_http_seek_get_start (self->priv->time_range));
#line 233 "rygel-live-response.vala"
		rygel_http_response_end ((RygelHTTPResponse*) self, FALSE, (guint) SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE);
#line 776 "rygel-live-response.c"
		result = FALSE;
#line 236 "rygel-live-response.vala"
		return result;
#line 780 "rygel-live-response.c"
	}
	result = TRUE;
#line 239 "rygel-live-response.vala"
	return result;
#line 785 "rygel-live-response.c"
}


static void rygel_live_response_class_init (RygelLiveResponseClass * klass) {
	rygel_live_response_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelLiveResponsePrivate));
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run = rygel_live_response_real_run;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->run_finish = rygel_live_response_real_run_finish;
	RYGEL_HTTP_RESPONSE_CLASS (klass)->end = rygel_live_response_real_end;
	G_OBJECT_CLASS (klass)->finalize = rygel_live_response_finalize;
}


static void rygel_live_response_instance_init (RygelLiveResponse * self) {
	self->priv = RYGEL_LIVE_RESPONSE_GET_PRIVATE (self);
}


static void rygel_live_response_finalize (GObject* obj) {
	RygelLiveResponse * self;
	self = RYGEL_LIVE_RESPONSE (obj);
	_gst_object_unref0 (self->priv->pipeline);
	_g_object_unref0 (self->priv->time_range);
	(self->priv->run_continue_target_destroy_notify == NULL) ? NULL : self->priv->run_continue_target_destroy_notify (self->priv->run_continue_target);
	self->priv->run_continue = NULL;
	self->priv->run_continue_target = NULL;
	self->priv->run_continue_target_destroy_notify = NULL;
	G_OBJECT_CLASS (rygel_live_response_parent_class)->finalize (obj);
}


GType rygel_live_response_get_type (void) {
	static volatile gsize rygel_live_response_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_live_response_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelLiveResponseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_live_response_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelLiveResponse), 0, (GInstanceInitFunc) rygel_live_response_instance_init, NULL };
		GType rygel_live_response_type_id;
		rygel_live_response_type_id = g_type_register_static (RYGEL_TYPE_HTTP_RESPONSE, "RygelLiveResponse", &g_define_type_info, 0);
		g_once_init_leave (&rygel_live_response_type_id__volatile, rygel_live_response_type_id);
	}
	return rygel_live_response_type_id__volatile;
}



static void g_cclosure_user_marshal_VOID__GST_MINI_OBJECT_OBJECT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__GST_MINI_OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__GST_MINI_OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__GST_MINI_OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, gst_value_get_mini_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}



