/* rygel-meta-config.c generated by valac, the Vala compiler
 * generated from rygel-meta-config.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Nokia Corporation.
 * Copyright (C) 2008,2009 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>


#define RYGEL_TYPE_CONFIGURATION (rygel_configuration_get_type ())
#define RYGEL_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfiguration))
#define RYGEL_IS_CONFIGURATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONFIGURATION))
#define RYGEL_CONFIGURATION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_CONFIGURATION, RygelConfigurationIface))

typedef struct _RygelConfiguration RygelConfiguration;
typedef struct _RygelConfigurationIface RygelConfigurationIface;

#define RYGEL_TYPE_LOG_LEVEL (rygel_log_level_get_type ())

#define RYGEL_TYPE_META_CONFIG (rygel_meta_config_get_type ())
#define RYGEL_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfig))
#define RYGEL_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))
#define RYGEL_IS_META_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_META_CONFIG))
#define RYGEL_IS_META_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_META_CONFIG))
#define RYGEL_META_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_META_CONFIG, RygelMetaConfigClass))

typedef struct _RygelMetaConfig RygelMetaConfig;
typedef struct _RygelMetaConfigClass RygelMetaConfigClass;
typedef struct _RygelMetaConfigPrivate RygelMetaConfigPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CMDLINE_CONFIG (rygel_cmdline_config_get_type ())
#define RYGEL_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfig))
#define RYGEL_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))
#define RYGEL_IS_CMDLINE_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_IS_CMDLINE_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CMDLINE_CONFIG))
#define RYGEL_CMDLINE_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CMDLINE_CONFIG, RygelCmdlineConfigClass))

typedef struct _RygelCmdlineConfig RygelCmdlineConfig;
typedef struct _RygelCmdlineConfigClass RygelCmdlineConfigClass;

#define RYGEL_TYPE_USER_CONFIG (rygel_user_config_get_type ())
#define RYGEL_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfig))
#define RYGEL_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))
#define RYGEL_IS_USER_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_IS_USER_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_USER_CONFIG))
#define RYGEL_USER_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_USER_CONFIG, RygelUserConfigClass))

typedef struct _RygelUserConfig RygelUserConfig;
typedef struct _RygelUserConfigClass RygelUserConfigClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_LOG_LEVEL_INVALID = 0,
	RYGEL_LOG_LEVEL_CRITICAL = 1,
	RYGEL_LOG_LEVEL_ERROR = 2,
	RYGEL_LOG_LEVEL_WARNING = 3,
	RYGEL_LOG_LEVEL_INFO = 4,
	RYGEL_LOG_LEVEL_DEFAULT = 4,
	RYGEL_LOG_LEVEL_DEBUG = 5
} RygelLogLevel;

struct _RygelConfigurationIface {
	GTypeInterface parent_iface;
	gboolean (*get_upnp_enabled) (RygelConfiguration* self, GError** error);
	char* (*get_interface) (RygelConfiguration* self, GError** error);
	gint (*get_port) (RygelConfiguration* self, GError** error);
	gboolean (*get_transcoding) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp3_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_mp2ts_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_lpcm_transcoder) (RygelConfiguration* self, GError** error);
	gboolean (*get_wmv_transcoder) (RygelConfiguration* self, GError** error);
	RygelLogLevel (*get_log_level) (RygelConfiguration* self, GError** error);
	gboolean (*get_enabled) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_title) (RygelConfiguration* self, const char* section, GError** error);
	char* (*get_string) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	GeeArrayList* (*get_string_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gint (*get_int) (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
	GeeArrayList* (*get_int_list) (RygelConfiguration* self, const char* section, const char* key, GError** error);
	gboolean (*get_bool) (RygelConfiguration* self, const char* section, const char* key, GError** error);
};

struct _RygelMetaConfig {
	GObject parent_instance;
	RygelMetaConfigPrivate * priv;
};

struct _RygelMetaConfigClass {
	GObjectClass parent_class;
};

struct _RygelMetaConfigPrivate {
	GeeArrayList* configs;
};

typedef enum  {
	RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET,
	RYGEL_CONFIGURATION_ERROR_VALUE_OUT_OF_RANGE
} RygelConfigurationError;
#define RYGEL_CONFIGURATION_ERROR rygel_configuration_error_quark ()

static RygelMetaConfig* rygel_meta_config_meta_config;
static RygelMetaConfig* rygel_meta_config_meta_config = NULL;
static gpointer rygel_meta_config_parent_class = NULL;
static RygelConfigurationIface* rygel_meta_config_rygel_configuration_parent_iface = NULL;

GType rygel_log_level_get_type (void);
GType rygel_configuration_get_type (void);
GType rygel_meta_config_get_type (void);
#define RYGEL_META_CONFIG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_META_CONFIG, RygelMetaConfigPrivate))
enum  {
	RYGEL_META_CONFIG_DUMMY_PROPERTY
};
RygelMetaConfig* rygel_meta_config_new (void);
RygelMetaConfig* rygel_meta_config_construct (GType object_type);
RygelMetaConfig* rygel_meta_config_get_default (void);
GType rygel_cmdline_config_get_type (void);
RygelCmdlineConfig* rygel_cmdline_config_get_default (void);
GType rygel_user_config_get_type (void);
RygelUserConfig* rygel_user_config_get_default (GError** error);
gboolean rygel_configuration_get_upnp_enabled (RygelConfiguration* self, GError** error);
GQuark rygel_configuration_error_quark (void);
static gboolean rygel_meta_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error);
char* rygel_configuration_get_interface (RygelConfiguration* self, GError** error);
static char* rygel_meta_config_real_get_interface (RygelConfiguration* base, GError** error);
gint rygel_configuration_get_port (RygelConfiguration* self, GError** error);
static gint rygel_meta_config_real_get_port (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_transcoding (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_transcoding (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_mp3_transcoder (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_mp2ts_transcoder (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_lpcm_transcoder (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_wmv_transcoder (RygelConfiguration* self, GError** error);
static gboolean rygel_meta_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error);
RygelLogLevel rygel_configuration_get_log_level (RygelConfiguration* self, GError** error);
static RygelLogLevel rygel_meta_config_real_get_log_level (RygelConfiguration* base, GError** error);
gboolean rygel_configuration_get_enabled (RygelConfiguration* self, const char* section, GError** error);
static gboolean rygel_meta_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error);
char* rygel_configuration_get_title (RygelConfiguration* self, const char* section, GError** error);
static char* rygel_meta_config_real_get_title (RygelConfiguration* base, const char* section, GError** error);
char* rygel_configuration_get_string (RygelConfiguration* self, const char* section, const char* key, GError** error);
static char* rygel_meta_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error);
GeeArrayList* rygel_configuration_get_string_list (RygelConfiguration* self, const char* section, const char* key, GError** error);
static GeeArrayList* rygel_meta_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
gint rygel_configuration_get_int (RygelConfiguration* self, const char* section, const char* key, gint min, gint max, GError** error);
static gint rygel_meta_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error);
GeeArrayList* rygel_configuration_get_int_list (RygelConfiguration* self, const char* section, const char* key, GError** error);
static GeeArrayList* rygel_meta_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error);
gboolean rygel_configuration_get_bool (RygelConfiguration* self, const char* section, const char* key, GError** error);
static gboolean rygel_meta_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error);
static void rygel_meta_config_finalize (GObject* obj);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 41 "rygel-meta-config.vala"
RygelMetaConfig* rygel_meta_config_get_default (void) {
#line 192 "rygel-meta-config.c"
	RygelMetaConfig* result = NULL;
#line 42 "rygel-meta-config.vala"
	if (rygel_meta_config_meta_config == NULL) {
#line 196 "rygel-meta-config.c"
		RygelMetaConfig* _tmp0_;
#line 43 "rygel-meta-config.vala"
		rygel_meta_config_meta_config = (_tmp0_ = rygel_meta_config_new (), _g_object_unref0 (rygel_meta_config_meta_config), _tmp0_);
#line 200 "rygel-meta-config.c"
	}
	result = _g_object_ref0 (rygel_meta_config_meta_config);
#line 46 "rygel-meta-config.vala"
	return result;
#line 205 "rygel-meta-config.c"
}


#line 49 "rygel-meta-config.vala"
RygelMetaConfig* rygel_meta_config_construct (GType object_type) {
#line 211 "rygel-meta-config.c"
	GError * _inner_error_;
	RygelMetaConfig * self;
	GeeArrayList* _tmp0_;
	RygelCmdlineConfig* _tmp1_;
	_inner_error_ = NULL;
#line 49 "rygel-meta-config.vala"
	self = (RygelMetaConfig*) g_object_new (object_type, NULL);
#line 50 "rygel-meta-config.vala"
	self->priv->configs = (_tmp0_ = gee_array_list_new (RYGEL_TYPE_CONFIGURATION, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->configs), _tmp0_);
#line 52 "rygel-meta-config.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->configs, (RygelConfiguration*) (_tmp1_ = rygel_cmdline_config_get_default ()));
#line 223 "rygel-meta-config.c"
	_g_object_unref0 (_tmp1_);
	{
		RygelUserConfig* user_config;
#line 54 "rygel-meta-config.vala"
		user_config = rygel_user_config_get_default (&_inner_error_);
#line 229 "rygel-meta-config.c"
		if (_inner_error_ != NULL) {
			goto __catch7_g_error;
		}
#line 55 "rygel-meta-config.vala"
		gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->configs, (RygelConfiguration*) user_config);
#line 235 "rygel-meta-config.c"
		_g_object_unref0 (user_config);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		{
#line 57 "rygel-meta-config.vala"
			g_warning ("rygel-meta-config.vala:57: Failed to load user configuration: %s", err->message);
#line 247 "rygel-meta-config.c"
			_g_error_free0 (err);
		}
	}
	__finally7:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


#line 49 "rygel-meta-config.vala"
RygelMetaConfig* rygel_meta_config_new (void) {
#line 49 "rygel-meta-config.vala"
	return rygel_meta_config_construct (RYGEL_TYPE_META_CONFIG);
#line 265 "rygel-meta-config.c"
}


#line 61 "rygel-meta-config.vala"
static gboolean rygel_meta_config_real_get_upnp_enabled (RygelConfiguration* base, GError** error) {
#line 271 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 62 "rygel-meta-config.vala"
	val = TRUE;
#line 63 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 283 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 65 "rygel-meta-config.vala"
		while (TRUE) {
#line 289 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 65 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 65 "rygel-meta-config.vala"
				break;
#line 295 "rygel-meta-config.c"
			}
#line 65 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 299 "rygel-meta-config.c"
			{
				gboolean _tmp0_;
#line 67 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_upnp_enabled (config, &_inner_error_);
#line 304 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch8_g_error;
				}
#line 67 "rygel-meta-config.vala"
				val = _tmp0_;
#line 68 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 312 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 69 "rygel-meta-config.vala"
				break;
#line 316 "rygel-meta-config.c"
			}
			goto __finally8;
			__catch8_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally8:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 73 "rygel-meta-config.vala"
	if (unavailable) {
#line 341 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = val;
#line 77 "rygel-meta-config.vala"
	return result;
#line 351 "rygel-meta-config.c"
}


#line 80 "rygel-meta-config.vala"
static char* rygel_meta_config_real_get_interface (RygelConfiguration* base, GError** error) {
#line 357 "rygel-meta-config.c"
	RygelMetaConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 81 "rygel-meta-config.vala"
	val = NULL;
#line 82 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 369 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 84 "rygel-meta-config.vala"
		while (TRUE) {
#line 375 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 84 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 84 "rygel-meta-config.vala"
				break;
#line 381 "rygel-meta-config.c"
			}
#line 84 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 385 "rygel-meta-config.c"
			{
				char* _tmp0_;
				char* _tmp1_;
#line 86 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_interface (config, &_inner_error_);
#line 391 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch9_g_error;
				}
#line 86 "rygel-meta-config.vala"
				val = (_tmp1_ = _tmp0_, _g_free0 (val), _tmp1_);
#line 87 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 399 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 88 "rygel-meta-config.vala"
				break;
#line 403 "rygel-meta-config.c"
			}
			goto __finally9;
			__catch9_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally9:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 92 "rygel-meta-config.vala"
	if (unavailable) {
#line 429 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			return NULL;
		}
	}
	result = val;
#line 96 "rygel-meta-config.vala"
	return result;
#line 440 "rygel-meta-config.c"
}


#line 99 "rygel-meta-config.vala"
static gint rygel_meta_config_real_get_port (RygelConfiguration* base, GError** error) {
#line 446 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gint result = 0;
	GError * _inner_error_;
	gint val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 100 "rygel-meta-config.vala"
	val = 0;
#line 101 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 458 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 103 "rygel-meta-config.vala"
		while (TRUE) {
#line 464 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 103 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 103 "rygel-meta-config.vala"
				break;
#line 470 "rygel-meta-config.c"
			}
#line 103 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 474 "rygel-meta-config.c"
			{
				gint _tmp0_;
#line 105 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_port (config, &_inner_error_);
#line 479 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch10_g_error;
				}
#line 105 "rygel-meta-config.vala"
				val = _tmp0_;
#line 106 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 487 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 107 "rygel-meta-config.vala"
				break;
#line 491 "rygel-meta-config.c"
			}
			goto __finally10;
			__catch10_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally10:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return 0;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 111 "rygel-meta-config.vala"
	if (unavailable) {
#line 516 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return 0;
		}
	}
	result = val;
#line 115 "rygel-meta-config.vala"
	return result;
#line 526 "rygel-meta-config.c"
}


#line 118 "rygel-meta-config.vala"
static gboolean rygel_meta_config_real_get_transcoding (RygelConfiguration* base, GError** error) {
#line 532 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 119 "rygel-meta-config.vala"
	val = TRUE;
#line 120 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 544 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 122 "rygel-meta-config.vala"
		while (TRUE) {
#line 550 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 122 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 122 "rygel-meta-config.vala"
				break;
#line 556 "rygel-meta-config.c"
			}
#line 122 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 560 "rygel-meta-config.c"
			{
				gboolean _tmp0_;
#line 124 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_transcoding (config, &_inner_error_);
#line 565 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch11_g_error;
				}
#line 124 "rygel-meta-config.vala"
				val = _tmp0_;
#line 125 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 573 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 126 "rygel-meta-config.vala"
				break;
#line 577 "rygel-meta-config.c"
			}
			goto __finally11;
			__catch11_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally11:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 130 "rygel-meta-config.vala"
	if (unavailable) {
#line 602 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = val;
#line 134 "rygel-meta-config.vala"
	return result;
#line 612 "rygel-meta-config.c"
}


#line 137 "rygel-meta-config.vala"
static gboolean rygel_meta_config_real_get_mp3_transcoder (RygelConfiguration* base, GError** error) {
#line 618 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 138 "rygel-meta-config.vala"
	val = TRUE;
#line 139 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 630 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 141 "rygel-meta-config.vala"
		while (TRUE) {
#line 636 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 141 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 141 "rygel-meta-config.vala"
				break;
#line 642 "rygel-meta-config.c"
			}
#line 141 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 646 "rygel-meta-config.c"
			{
				gboolean _tmp0_;
#line 143 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_mp3_transcoder (config, &_inner_error_);
#line 651 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch12_g_error;
				}
#line 143 "rygel-meta-config.vala"
				val = _tmp0_;
#line 144 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 659 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 145 "rygel-meta-config.vala"
				break;
#line 663 "rygel-meta-config.c"
			}
			goto __finally12;
			__catch12_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally12:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 149 "rygel-meta-config.vala"
	if (unavailable) {
#line 688 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = val;
#line 153 "rygel-meta-config.vala"
	return result;
#line 698 "rygel-meta-config.c"
}


#line 156 "rygel-meta-config.vala"
static gboolean rygel_meta_config_real_get_mp2ts_transcoder (RygelConfiguration* base, GError** error) {
#line 704 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 157 "rygel-meta-config.vala"
	val = TRUE;
#line 158 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 716 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 160 "rygel-meta-config.vala"
		while (TRUE) {
#line 722 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 160 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 160 "rygel-meta-config.vala"
				break;
#line 728 "rygel-meta-config.c"
			}
#line 160 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 732 "rygel-meta-config.c"
			{
				gboolean _tmp0_;
#line 162 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_mp2ts_transcoder (config, &_inner_error_);
#line 737 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch13_g_error;
				}
#line 162 "rygel-meta-config.vala"
				val = _tmp0_;
#line 163 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 745 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 164 "rygel-meta-config.vala"
				break;
#line 749 "rygel-meta-config.c"
			}
			goto __finally13;
			__catch13_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally13:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 168 "rygel-meta-config.vala"
	if (unavailable) {
#line 774 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = val;
#line 172 "rygel-meta-config.vala"
	return result;
#line 784 "rygel-meta-config.c"
}


#line 175 "rygel-meta-config.vala"
static gboolean rygel_meta_config_real_get_lpcm_transcoder (RygelConfiguration* base, GError** error) {
#line 790 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 176 "rygel-meta-config.vala"
	val = TRUE;
#line 177 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 802 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 179 "rygel-meta-config.vala"
		while (TRUE) {
#line 808 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 179 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 179 "rygel-meta-config.vala"
				break;
#line 814 "rygel-meta-config.c"
			}
#line 179 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 818 "rygel-meta-config.c"
			{
				gboolean _tmp0_;
#line 181 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_lpcm_transcoder (config, &_inner_error_);
#line 823 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch14_g_error;
				}
#line 181 "rygel-meta-config.vala"
				val = _tmp0_;
#line 182 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 831 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 183 "rygel-meta-config.vala"
				break;
#line 835 "rygel-meta-config.c"
			}
			goto __finally14;
			__catch14_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally14:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 187 "rygel-meta-config.vala"
	if (unavailable) {
#line 860 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = val;
#line 191 "rygel-meta-config.vala"
	return result;
#line 870 "rygel-meta-config.c"
}


#line 194 "rygel-meta-config.vala"
static gboolean rygel_meta_config_real_get_wmv_transcoder (RygelConfiguration* base, GError** error) {
#line 876 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 195 "rygel-meta-config.vala"
	val = TRUE;
#line 196 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 888 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 198 "rygel-meta-config.vala"
		while (TRUE) {
#line 894 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 198 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 198 "rygel-meta-config.vala"
				break;
#line 900 "rygel-meta-config.c"
			}
#line 198 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 904 "rygel-meta-config.c"
			{
				gboolean _tmp0_;
#line 200 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_wmv_transcoder (config, &_inner_error_);
#line 909 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch15_g_error;
				}
#line 200 "rygel-meta-config.vala"
				val = _tmp0_;
#line 201 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 917 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 202 "rygel-meta-config.vala"
				break;
#line 921 "rygel-meta-config.c"
			}
			goto __finally15;
			__catch15_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally15:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 206 "rygel-meta-config.vala"
	if (unavailable) {
#line 946 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = val;
#line 210 "rygel-meta-config.vala"
	return result;
#line 956 "rygel-meta-config.c"
}


#line 213 "rygel-meta-config.vala"
static RygelLogLevel rygel_meta_config_real_get_log_level (RygelConfiguration* base, GError** error) {
#line 962 "rygel-meta-config.c"
	RygelMetaConfig * self;
	RygelLogLevel result = 0;
	GError * _inner_error_;
	RygelLogLevel val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
	_inner_error_ = NULL;
#line 214 "rygel-meta-config.vala"
	val = RYGEL_LOG_LEVEL_DEFAULT;
#line 215 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 974 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 217 "rygel-meta-config.vala"
		while (TRUE) {
#line 980 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 217 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 217 "rygel-meta-config.vala"
				break;
#line 986 "rygel-meta-config.c"
			}
#line 217 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 990 "rygel-meta-config.c"
			{
				RygelLogLevel _tmp0_;
#line 219 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_log_level (config, &_inner_error_);
#line 995 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch16_g_error;
				}
#line 219 "rygel-meta-config.vala"
				val = _tmp0_;
#line 220 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 1003 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 221 "rygel-meta-config.vala"
				break;
#line 1007 "rygel-meta-config.c"
			}
			goto __finally16;
			__catch16_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally16:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return 0;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 225 "rygel-meta-config.vala"
	if (unavailable) {
#line 1032 "rygel-meta-config.c"
		_inner_error_ = g_error_new_literal (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available");
		{
			g_propagate_error (error, _inner_error_);
			return 0;
		}
	}
	result = val;
#line 229 "rygel-meta-config.vala"
	return result;
#line 1042 "rygel-meta-config.c"
}


#line 232 "rygel-meta-config.vala"
static gboolean rygel_meta_config_real_get_enabled (RygelConfiguration* base, const char* section, GError** error) {
#line 1048 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
#line 232 "rygel-meta-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 1057 "rygel-meta-config.c"
	_inner_error_ = NULL;
#line 233 "rygel-meta-config.vala"
	val = TRUE;
#line 234 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 1063 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 236 "rygel-meta-config.vala"
		while (TRUE) {
#line 1069 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 236 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 236 "rygel-meta-config.vala"
				break;
#line 1075 "rygel-meta-config.c"
			}
#line 236 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 1079 "rygel-meta-config.c"
			{
				gboolean _tmp0_;
#line 238 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_enabled (config, section, &_inner_error_);
#line 1084 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch17_g_error;
				}
#line 238 "rygel-meta-config.vala"
				val = _tmp0_;
#line 239 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 1092 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 240 "rygel-meta-config.vala"
				break;
#line 1096 "rygel-meta-config.c"
			}
			goto __finally17;
			__catch17_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally17:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 244 "rygel-meta-config.vala"
	if (unavailable) {
#line 1121 "rygel-meta-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available for '%s/enabled'", section);
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = val;
#line 250 "rygel-meta-config.vala"
	return result;
#line 1131 "rygel-meta-config.c"
}


#line 253 "rygel-meta-config.vala"
static char* rygel_meta_config_real_get_title (RygelConfiguration* base, const char* section, GError** error) {
#line 1137 "rygel-meta-config.c"
	RygelMetaConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* val;
	self = (RygelMetaConfig*) base;
#line 253 "rygel-meta-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 1145 "rygel-meta-config.c"
	_inner_error_ = NULL;
#line 254 "rygel-meta-config.vala"
	val = NULL;
#line 1149 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 256 "rygel-meta-config.vala"
		while (TRUE) {
#line 1155 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 256 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 256 "rygel-meta-config.vala"
				break;
#line 1161 "rygel-meta-config.c"
			}
#line 256 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 1165 "rygel-meta-config.c"
			{
				char* _tmp0_;
				char* _tmp1_;
#line 258 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_title (config, section, &_inner_error_);
#line 1171 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch18_g_error;
				}
#line 258 "rygel-meta-config.vala"
				val = (_tmp1_ = _tmp0_, _g_free0 (val), _tmp1_);
#line 1177 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 259 "rygel-meta-config.vala"
				break;
#line 1181 "rygel-meta-config.c"
			}
			goto __finally18;
			__catch18_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally18:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 263 "rygel-meta-config.vala"
	if (val == NULL) {
#line 1207 "rygel-meta-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available for '%s/enabled'", section);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			return NULL;
		}
	}
	result = val;
#line 269 "rygel-meta-config.vala"
	return result;
#line 1218 "rygel-meta-config.c"
}


#line 272 "rygel-meta-config.vala"
static char* rygel_meta_config_real_get_string (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 1224 "rygel-meta-config.c"
	RygelMetaConfig * self;
	char* result = NULL;
	GError * _inner_error_;
	char* val;
	self = (RygelMetaConfig*) base;
#line 272 "rygel-meta-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 272 "rygel-meta-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1234 "rygel-meta-config.c"
	_inner_error_ = NULL;
#line 274 "rygel-meta-config.vala"
	val = NULL;
#line 1238 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 276 "rygel-meta-config.vala"
		while (TRUE) {
#line 1244 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 276 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 276 "rygel-meta-config.vala"
				break;
#line 1250 "rygel-meta-config.c"
			}
#line 276 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 1254 "rygel-meta-config.c"
			{
				char* _tmp0_;
				char* _tmp1_;
#line 278 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_string (config, section, key, &_inner_error_);
#line 1260 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch19_g_error;
				}
#line 278 "rygel-meta-config.vala"
				val = (_tmp1_ = _tmp0_, _g_free0 (val), _tmp1_);
#line 1266 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 279 "rygel-meta-config.vala"
				break;
#line 1270 "rygel-meta-config.c"
			}
			goto __finally19;
			__catch19_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally19:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				_g_free0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 283 "rygel-meta-config.vala"
	if (val == NULL) {
#line 1296 "rygel-meta-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available for '%s/%s'", section, key);
		{
			g_propagate_error (error, _inner_error_);
			_g_free0 (val);
			return NULL;
		}
	}
	result = val;
#line 290 "rygel-meta-config.vala"
	return result;
#line 1307 "rygel-meta-config.c"
}


#line 293 "rygel-meta-config.vala"
static GeeArrayList* rygel_meta_config_real_get_string_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 1313 "rygel-meta-config.c"
	RygelMetaConfig * self;
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* val;
	self = (RygelMetaConfig*) base;
#line 293 "rygel-meta-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 293 "rygel-meta-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1323 "rygel-meta-config.c"
	_inner_error_ = NULL;
#line 296 "rygel-meta-config.vala"
	val = NULL;
#line 1327 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 298 "rygel-meta-config.vala"
		while (TRUE) {
#line 1333 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 298 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 298 "rygel-meta-config.vala"
				break;
#line 1339 "rygel-meta-config.c"
			}
#line 298 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 1343 "rygel-meta-config.c"
			{
				GeeArrayList* _tmp0_;
				GeeArrayList* _tmp1_;
#line 300 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_string_list (config, section, key, &_inner_error_);
#line 1349 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch20_g_error;
				}
#line 300 "rygel-meta-config.vala"
				val = (_tmp1_ = _tmp0_, _g_object_unref0 (val), _tmp1_);
#line 1355 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 301 "rygel-meta-config.vala"
				break;
#line 1359 "rygel-meta-config.c"
			}
			goto __finally20;
			__catch20_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally20:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				_g_object_unref0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 305 "rygel-meta-config.vala"
	if (val == NULL) {
#line 1385 "rygel-meta-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available for '%s/%s'", section, key);
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (val);
			return NULL;
		}
	}
	result = val;
#line 312 "rygel-meta-config.vala"
	return result;
#line 1396 "rygel-meta-config.c"
}


#line 315 "rygel-meta-config.vala"
static gint rygel_meta_config_real_get_int (RygelConfiguration* base, const char* section, const char* key, gint min, gint max, GError** error) {
#line 1402 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gint result = 0;
	GError * _inner_error_;
	gint val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
#line 315 "rygel-meta-config.vala"
	g_return_val_if_fail (section != NULL, 0);
#line 315 "rygel-meta-config.vala"
	g_return_val_if_fail (key != NULL, 0);
#line 1413 "rygel-meta-config.c"
	_inner_error_ = NULL;
#line 320 "rygel-meta-config.vala"
	val = 0;
#line 321 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 1419 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 323 "rygel-meta-config.vala"
		while (TRUE) {
#line 1425 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 323 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 323 "rygel-meta-config.vala"
				break;
#line 1431 "rygel-meta-config.c"
			}
#line 323 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 1435 "rygel-meta-config.c"
			{
				gint _tmp0_;
#line 325 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_int (config, section, key, min, max, &_inner_error_);
#line 1440 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch21_g_error;
				}
#line 325 "rygel-meta-config.vala"
				val = _tmp0_;
#line 326 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 1448 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 327 "rygel-meta-config.vala"
				break;
#line 1452 "rygel-meta-config.c"
			}
			goto __finally21;
			__catch21_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally21:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return 0;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 331 "rygel-meta-config.vala"
	if (unavailable) {
#line 1477 "rygel-meta-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available for '%s/%s'", section, key);
		{
			g_propagate_error (error, _inner_error_);
			return 0;
		}
	}
	result = val;
#line 338 "rygel-meta-config.vala"
	return result;
#line 1487 "rygel-meta-config.c"
}


#line 341 "rygel-meta-config.vala"
static GeeArrayList* rygel_meta_config_real_get_int_list (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 1493 "rygel-meta-config.c"
	RygelMetaConfig * self;
	GeeArrayList* result = NULL;
	GError * _inner_error_;
	GeeArrayList* val;
	self = (RygelMetaConfig*) base;
#line 341 "rygel-meta-config.vala"
	g_return_val_if_fail (section != NULL, NULL);
#line 341 "rygel-meta-config.vala"
	g_return_val_if_fail (key != NULL, NULL);
#line 1503 "rygel-meta-config.c"
	_inner_error_ = NULL;
#line 344 "rygel-meta-config.vala"
	val = NULL;
#line 1507 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 346 "rygel-meta-config.vala"
		while (TRUE) {
#line 1513 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 346 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 346 "rygel-meta-config.vala"
				break;
#line 1519 "rygel-meta-config.c"
			}
#line 346 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 1523 "rygel-meta-config.c"
			{
				GeeArrayList* _tmp0_;
				GeeArrayList* _tmp1_;
#line 348 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_int_list (config, section, key, &_inner_error_);
#line 1529 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch22_g_error;
				}
#line 348 "rygel-meta-config.vala"
				val = (_tmp1_ = _tmp0_, _g_object_unref0 (val), _tmp1_);
#line 1535 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 349 "rygel-meta-config.vala"
				break;
#line 1539 "rygel-meta-config.c"
			}
			goto __finally22;
			__catch22_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally22:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				_g_object_unref0 (val);
				return NULL;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 353 "rygel-meta-config.vala"
	if (val == NULL) {
#line 1565 "rygel-meta-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available for '%s/%s'", section, key);
		{
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (val);
			return NULL;
		}
	}
	result = val;
#line 360 "rygel-meta-config.vala"
	return result;
#line 1576 "rygel-meta-config.c"
}


#line 363 "rygel-meta-config.vala"
static gboolean rygel_meta_config_real_get_bool (RygelConfiguration* base, const char* section, const char* key, GError** error) {
#line 1582 "rygel-meta-config.c"
	RygelMetaConfig * self;
	gboolean result = FALSE;
	GError * _inner_error_;
	gboolean val;
	gboolean unavailable;
	self = (RygelMetaConfig*) base;
#line 363 "rygel-meta-config.vala"
	g_return_val_if_fail (section != NULL, FALSE);
#line 363 "rygel-meta-config.vala"
	g_return_val_if_fail (key != NULL, FALSE);
#line 1593 "rygel-meta-config.c"
	_inner_error_ = NULL;
#line 366 "rygel-meta-config.vala"
	val = FALSE;
#line 367 "rygel-meta-config.vala"
	unavailable = TRUE;
#line 1599 "rygel-meta-config.c"
	{
		GeeIterator* _config_it;
		_config_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->configs);
#line 369 "rygel-meta-config.vala"
		while (TRUE) {
#line 1605 "rygel-meta-config.c"
			RygelConfiguration* config;
#line 369 "rygel-meta-config.vala"
			if (!gee_iterator_next (_config_it)) {
#line 369 "rygel-meta-config.vala"
				break;
#line 1611 "rygel-meta-config.c"
			}
#line 369 "rygel-meta-config.vala"
			config = (RygelConfiguration*) gee_iterator_get (_config_it);
#line 1615 "rygel-meta-config.c"
			{
				gboolean _tmp0_;
#line 371 "rygel-meta-config.vala"
				_tmp0_ = rygel_configuration_get_bool (config, section, key, &_inner_error_);
#line 1620 "rygel-meta-config.c"
				if (_inner_error_ != NULL) {
					goto __catch23_g_error;
				}
#line 371 "rygel-meta-config.vala"
				val = _tmp0_;
#line 372 "rygel-meta-config.vala"
				unavailable = FALSE;
#line 1628 "rygel-meta-config.c"
				_g_object_unref0 (config);
#line 373 "rygel-meta-config.vala"
				break;
#line 1632 "rygel-meta-config.c"
			}
			goto __finally23;
			__catch23_g_error:
			{
				GError * err;
				err = _inner_error_;
				_inner_error_ = NULL;
				{
					_g_error_free0 (err);
				}
			}
			__finally23:
			if (_inner_error_ != NULL) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (config);
				_g_object_unref0 (_config_it);
				return FALSE;
			}
			_g_object_unref0 (config);
		}
		_g_object_unref0 (_config_it);
	}
#line 377 "rygel-meta-config.vala"
	if (unavailable) {
#line 1657 "rygel-meta-config.c"
		_inner_error_ = g_error_new (RYGEL_CONFIGURATION_ERROR, RYGEL_CONFIGURATION_ERROR_NO_VALUE_SET, "No value available for '%s/%s'", section, key);
		{
			g_propagate_error (error, _inner_error_);
			return FALSE;
		}
	}
	result = val;
#line 384 "rygel-meta-config.vala"
	return result;
#line 1667 "rygel-meta-config.c"
}


static void rygel_meta_config_class_init (RygelMetaConfigClass * klass) {
	rygel_meta_config_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMetaConfigPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_meta_config_finalize;
}


static void rygel_meta_config_rygel_configuration_interface_init (RygelConfigurationIface * iface) {
	rygel_meta_config_rygel_configuration_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_upnp_enabled = rygel_meta_config_real_get_upnp_enabled;
	iface->get_interface = rygel_meta_config_real_get_interface;
	iface->get_port = rygel_meta_config_real_get_port;
	iface->get_transcoding = rygel_meta_config_real_get_transcoding;
	iface->get_mp3_transcoder = rygel_meta_config_real_get_mp3_transcoder;
	iface->get_mp2ts_transcoder = rygel_meta_config_real_get_mp2ts_transcoder;
	iface->get_lpcm_transcoder = rygel_meta_config_real_get_lpcm_transcoder;
	iface->get_wmv_transcoder = rygel_meta_config_real_get_wmv_transcoder;
	iface->get_log_level = rygel_meta_config_real_get_log_level;
	iface->get_enabled = rygel_meta_config_real_get_enabled;
	iface->get_title = rygel_meta_config_real_get_title;
	iface->get_string = rygel_meta_config_real_get_string;
	iface->get_string_list = rygel_meta_config_real_get_string_list;
	iface->get_int = rygel_meta_config_real_get_int;
	iface->get_int_list = rygel_meta_config_real_get_int_list;
	iface->get_bool = rygel_meta_config_real_get_bool;
}


static void rygel_meta_config_instance_init (RygelMetaConfig * self) {
	self->priv = RYGEL_META_CONFIG_GET_PRIVATE (self);
}


static void rygel_meta_config_finalize (GObject* obj) {
	RygelMetaConfig * self;
	self = RYGEL_META_CONFIG (obj);
	_g_object_unref0 (self->priv->configs);
	G_OBJECT_CLASS (rygel_meta_config_parent_class)->finalize (obj);
}


GType rygel_meta_config_get_type (void) {
	static volatile gsize rygel_meta_config_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_meta_config_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMetaConfigClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_meta_config_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMetaConfig), 0, (GInstanceInitFunc) rygel_meta_config_instance_init, NULL };
		static const GInterfaceInfo rygel_configuration_info = { (GInterfaceInitFunc) rygel_meta_config_rygel_configuration_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType rygel_meta_config_type_id;
		rygel_meta_config_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMetaConfig", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_meta_config_type_id, RYGEL_TYPE_CONFIGURATION, &rygel_configuration_info);
		g_once_init_leave (&rygel_meta_config_type_id__volatile, rygel_meta_config_type_id);
	}
	return rygel_meta_config_type_id__volatile;
}




