/* rygel-media-db-container.c generated by valac, the Vala compiler
 * generated from rygel-media-db-container.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gio/gio.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;
typedef struct _RygelMediaContainerPrivate RygelMediaContainerPrivate;

#define RYGEL_TYPE_SEARCH_EXPRESSION (rygel_search_expression_get_type ())
#define RYGEL_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpression))
#define RYGEL_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))
#define RYGEL_IS_SEARCH_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_IS_SEARCH_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SEARCH_EXPRESSION))
#define RYGEL_SEARCH_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SEARCH_EXPRESSION, RygelSearchExpressionClass))

typedef struct _RygelSearchExpression RygelSearchExpression;
typedef struct _RygelSearchExpressionClass RygelSearchExpressionClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_MEDIA_DB_CONTAINER (rygel_media_db_container_get_type ())
#define RYGEL_MEDIA_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainer))
#define RYGEL_MEDIA_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainerClass))
#define RYGEL_IS_MEDIA_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER))
#define RYGEL_IS_MEDIA_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB_CONTAINER))
#define RYGEL_MEDIA_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB_CONTAINER, RygelMediaDBContainerClass))

typedef struct _RygelMediaDBContainer RygelMediaDBContainer;
typedef struct _RygelMediaDBContainerClass RygelMediaDBContainerClass;
typedef struct _RygelMediaDBContainerPrivate RygelMediaDBContainerPrivate;

#define RYGEL_TYPE_MEDIA_DB (rygel_media_db_get_type ())
#define RYGEL_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDB))
#define RYGEL_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))
#define RYGEL_IS_MEDIA_DB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_IS_MEDIA_DB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_DB))
#define RYGEL_MEDIA_DB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_DB, RygelMediaDBClass))

typedef struct _RygelMediaDB RygelMediaDB;
typedef struct _RygelMediaDBClass RygelMediaDBClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _RygelMediaDbContainerGetChildrenData RygelMediaDbContainerGetChildrenData;
#define _rygel_search_expression_unref0(var) ((var == NULL) ? NULL : (var = (rygel_search_expression_unref (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _RygelMediaDbContainerSearchData RygelMediaDbContainerSearchData;
typedef struct _RygelSearchExpressionPrivate RygelSearchExpressionPrivate;

#define RYGEL_TYPE_LOGICAL_OPERATOR (rygel_logical_operator_get_type ())

#define RYGEL_TYPE_LOGICAL_EXPRESSION (rygel_logical_expression_get_type ())
#define RYGEL_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpression))
#define RYGEL_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))
#define RYGEL_IS_LOGICAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_IS_LOGICAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_LOGICAL_EXPRESSION))
#define RYGEL_LOGICAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_LOGICAL_EXPRESSION, RygelLogicalExpressionClass))

typedef struct _RygelLogicalExpression RygelLogicalExpression;
typedef struct _RygelLogicalExpressionClass RygelLogicalExpressionClass;

#define RYGEL_TYPE_RELATIONAL_EXPRESSION (rygel_relational_expression_get_type ())
#define RYGEL_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpression))
#define RYGEL_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))
#define RYGEL_IS_RELATIONAL_EXPRESSION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_IS_RELATIONAL_EXPRESSION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_RELATIONAL_EXPRESSION))
#define RYGEL_RELATIONAL_EXPRESSION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_RELATIONAL_EXPRESSION, RygelRelationalExpressionClass))

typedef struct _RygelRelationalExpression RygelRelationalExpression;
typedef struct _RygelRelationalExpressionClass RygelRelationalExpressionClass;

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaContainer {
	RygelMediaObject parent_instance;
	RygelMediaContainerPrivate * priv;
	guint child_count;
	guint32 update_id;
};

struct _RygelMediaContainerClass {
	RygelMediaObjectClass parent_class;
	void (*get_children) (RygelMediaContainer* self, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*get_children_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
	void (*search) (RygelMediaContainer* self, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GeeList* (*search_finish) (RygelMediaContainer* self, GAsyncResult* _res_, guint* total_matches, GError** error);
	void (*add_item) (RygelMediaContainer* self, RygelMediaItem* item, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_item_finish) (RygelMediaContainer* self, GAsyncResult* _res_, GError** error);
};

struct _RygelMediaDBContainer {
	RygelMediaContainer parent_instance;
	RygelMediaDBContainerPrivate * priv;
	RygelMediaDB* media_db;
};

struct _RygelMediaDBContainerClass {
	RygelMediaContainerClass parent_class;
};

typedef enum  {
	RYGEL_DATABASE_ERROR_SQLITE_ERROR
} RygelDatabaseError;
#define RYGEL_DATABASE_ERROR rygel_database_error_quark ()
struct _RygelMediaDbContainerGetChildrenData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaDBContainer* self;
	guint offset;
	guint max_count;
	GCancellable* cancellable;
	GeeList* result;
	GeeArrayList* children;
	GeeIterator* _child_it;
	RygelMediaObject* child;
	GError * _inner_error_;
};

struct _RygelMediaDbContainerSearchData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelMediaDBContainer* self;
	RygelSearchExpression* expression;
	guint offset;
	guint max_count;
	guint total_matches;
	GCancellable* cancellable;
	GeeList* result;
	GValueArray* args;
	char* filter;
	char* _tmp0_;
	gint i;
	gboolean _tmp1_;
	guint max_objects;
	GeeArrayList* children;
	GError * _inner_error_;
};

struct _RygelSearchExpression {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelSearchExpressionPrivate * priv;
	gpointer op;
	gpointer operand1;
	gpointer operand2;
};

struct _RygelSearchExpressionClass {
	GTypeClass parent_class;
	void (*finalize) (RygelSearchExpression *self);
	gboolean (*satisfied_by) (RygelSearchExpression* self, RygelMediaObject* media_object);
	char* (*to_string) (RygelSearchExpression* self);
};

typedef enum  {
	RYGEL_LOGICAL_OPERATOR_AND,
	RYGEL_LOGICAL_OPERATOR_OR
} RygelLogicalOperator;


static gpointer rygel_media_db_container_parent_class = NULL;

GType rygel_media_object_get_type (void);
GType rygel_media_container_get_type (void);
gpointer rygel_search_expression_ref (gpointer instance);
void rygel_search_expression_unref (gpointer instance);
GParamSpec* rygel_param_spec_search_expression (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_search_expression (GValue* value, gpointer v_object);
gpointer rygel_value_get_search_expression (const GValue* value);
GType rygel_search_expression_get_type (void);
GType rygel_media_item_get_type (void);
GType rygel_media_db_container_get_type (void);
GType rygel_media_db_get_type (void);
enum  {
	RYGEL_MEDIA_DB_CONTAINER_DUMMY_PROPERTY
};
GQuark rygel_database_error_quark (void);
gint rygel_media_db_get_child_count (RygelMediaDB* self, const char* container_id, GError** error);
RygelMediaContainer* rygel_media_container_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title, guint child_count);
static void rygel_media_db_container_on_db_container_updated (RygelMediaDBContainer* self, RygelMediaContainer* container, RygelMediaContainer* container_updated);
static void _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self);
RygelMediaDBContainer* rygel_media_db_container_new (RygelMediaDB* media_db, const char* id, const char* title);
RygelMediaDBContainer* rygel_media_db_container_construct (GType object_type, RygelMediaDB* media_db, const char* id, const char* title);
static void rygel_media_db_container_real_get_children_data_free (gpointer _data);
static void rygel_media_db_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_db_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GeeArrayList* rygel_media_db_get_children (RygelMediaDB* self, const char* container_id, glong offset, glong max_count, GError** error);
static gboolean rygel_media_db_container_real_get_children_co (RygelMediaDbContainerGetChildrenData* data);
static void rygel_media_db_container_real_search_data_free (gpointer _data);
static void rygel_media_db_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_media_db_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static char* rygel_media_db_container_search_expression_to_sql (RygelMediaDBContainer* self, RygelSearchExpression* expression, GValueArray* args);
char* rygel_search_expression_to_string (RygelSearchExpression* self);
GeeArrayList* rygel_media_db_get_objects_by_filter (RygelMediaDB* self, const char* filter, GValueArray* args, const char* container_id, glong offset, glong max_count, GError** error);
static gboolean rygel_media_db_container_real_search_co (RygelMediaDbContainerSearchData* data);
GType rygel_logical_operator_get_type (void);
GType rygel_logical_expression_get_type (void);
static char* rygel_media_db_container_logexp_to_sql (RygelMediaDBContainer* self, RygelLogicalExpression* exp, GValueArray* args);
GType rygel_relational_expression_get_type (void);
static char* rygel_media_db_container_relexp_to_sql (RygelMediaDBContainer* self, RygelRelationalExpression* exp, GValueArray* args);
static char* rygel_media_db_container_map_operand_to_column (RygelMediaDBContainer* self, const char* operand);
static void rygel_media_db_container_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 42 "rygel-media-db-container.vala"
static void _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated (RygelMediaContainer* _sender, RygelMediaContainer* container, gpointer self) {
#line 286 "rygel-media-db-container.c"
	rygel_media_db_container_on_db_container_updated (self, _sender, container);
}


#line 27 "rygel-media-db-container.vala"
RygelMediaDBContainer* rygel_media_db_container_construct (GType object_type, RygelMediaDB* media_db, const char* id, const char* title) {
#line 293 "rygel-media-db-container.c"
	GError * _inner_error_;
	RygelMediaDBContainer * self;
	gint count = 0;
	RygelMediaDB* _tmp1_;
#line 27 "rygel-media-db-container.vala"
	g_return_val_if_fail (media_db != NULL, NULL);
#line 27 "rygel-media-db-container.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 27 "rygel-media-db-container.vala"
	g_return_val_if_fail (title != NULL, NULL);
#line 304 "rygel-media-db-container.c"
	_inner_error_ = NULL;
	{
		gint _tmp0_;
#line 30 "rygel-media-db-container.vala"
		_tmp0_ = rygel_media_db_get_child_count (media_db, id, &_inner_error_);
#line 310 "rygel-media-db-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch61_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
#line 30 "rygel-media-db-container.vala"
		count = _tmp0_;
#line 321 "rygel-media-db-container.c"
	}
	goto __finally61;
	__catch61_rygel_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 32 "rygel-media-db-container.vala"
			g_debug ("rygel-media-db-container.vala:32: Could not get child count from database: %s", e->message);
#line 34 "rygel-media-db-container.vala"
			count = 0;
#line 334 "rygel-media-db-container.c"
			_g_error_free0 (e);
		}
	}
	__finally61:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 36 "rygel-media-db-container.vala"
	self = (RygelMediaDBContainer*) rygel_media_container_construct (object_type, id, NULL, title, (guint) count);
#line 38 "rygel-media-db-container.vala"
	self->media_db = (_tmp1_ = _g_object_ref0 (media_db), _g_object_unref0 (self->media_db), _tmp1_);
#line 39 "rygel-media-db-container.vala"
	g_signal_connect_object ((RygelMediaContainer*) self, "container-updated", (GCallback) _rygel_media_db_container_on_db_container_updated_rygel_media_container_container_updated, self, 0);
#line 350 "rygel-media-db-container.c"
	return self;
}


#line 27 "rygel-media-db-container.vala"
RygelMediaDBContainer* rygel_media_db_container_new (RygelMediaDB* media_db, const char* id, const char* title) {
#line 27 "rygel-media-db-container.vala"
	return rygel_media_db_container_construct (RYGEL_TYPE_MEDIA_DB_CONTAINER, media_db, id, title);
#line 359 "rygel-media-db-container.c"
}


#line 42 "rygel-media-db-container.vala"
static void rygel_media_db_container_on_db_container_updated (RygelMediaDBContainer* self, RygelMediaContainer* container, RygelMediaContainer* container_updated) {
#line 365 "rygel-media-db-container.c"
	GError * _inner_error_;
#line 42 "rygel-media-db-container.vala"
	g_return_if_fail (self != NULL);
#line 42 "rygel-media-db-container.vala"
	g_return_if_fail (container != NULL);
#line 42 "rygel-media-db-container.vala"
	g_return_if_fail (container_updated != NULL);
#line 373 "rygel-media-db-container.c"
	_inner_error_ = NULL;
	{
		gint _tmp0_;
#line 45 "rygel-media-db-container.vala"
		_tmp0_ = rygel_media_db_get_child_count (self->media_db, ((RygelMediaObject*) self)->id, &_inner_error_);
#line 379 "rygel-media-db-container.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				goto __catch62_rygel_database_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
#line 45 "rygel-media-db-container.vala"
		((RygelMediaContainer*) self)->child_count = (guint) _tmp0_;
#line 390 "rygel-media-db-container.c"
	}
	goto __finally62;
	__catch62_rygel_database_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
#line 47 "rygel-media-db-container.vala"
			g_debug ("rygel-media-db-container.vala:47: Could not get child count from database: %s", e->message);
#line 49 "rygel-media-db-container.vala"
			((RygelMediaContainer*) self)->child_count = (guint) 0;
#line 403 "rygel-media-db-container.c"
			_g_error_free0 (e);
		}
	}
	__finally62:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void rygel_media_db_container_real_get_children_data_free (gpointer _data) {
	RygelMediaDbContainerGetChildrenData* data;
	data = _data;
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelMediaDbContainerGetChildrenData, data);
}


static void rygel_media_db_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaDBContainer * self;
	RygelMediaDbContainerGetChildrenData* _data_;
	self = (RygelMediaDBContainer*) base;
	_data_ = g_slice_new0 (RygelMediaDbContainerGetChildrenData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_db_container_real_get_children);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_db_container_real_get_children_data_free);
	_data_->self = self;
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_db_container_real_get_children_co (_data_);
}


static GeeList* rygel_media_db_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* _res_, GError** error) {
	GeeList* result;
	RygelMediaDbContainerGetChildrenData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_db_container_get_children_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaDbContainerGetChildrenData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_db_container_real_get_children_co (data);
}


static gboolean rygel_media_db_container_real_get_children_co (RygelMediaDbContainerGetChildrenData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->children = rygel_media_db_get_children (data->self->media_db, ((RygelMediaObject*) data->self)->id, (glong) data->offset, (glong) data->max_count, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
			{
				data->_child_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) data->children);
#line 61 "rygel-media-db-container.vala"
				while (TRUE) {
#line 61 "rygel-media-db-container.vala"
					if (!gee_iterator_next (data->_child_it)) {
#line 61 "rygel-media-db-container.vala"
						break;
#line 489 "rygel-media-db-container.c"
					}
					data->child = (RygelMediaObject*) gee_iterator_get (data->_child_it);
#line 62 "rygel-media-db-container.vala"
					data->child->parent = (RygelMediaContainer*) data->self;
#line 494 "rygel-media-db-container.c"
					_g_object_unref0 (data->child);
				}
				_g_object_unref0 (data->_child_it);
			}
			data->result = (GeeList*) data->children;
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_object_unref0 (data->children);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


static void rygel_media_db_container_real_search_data_free (gpointer _data) {
	RygelMediaDbContainerSearchData* data;
	data = _data;
	_rygel_search_expression_unref0 (data->expression);
	_g_object_unref0 (data->cancellable);
	_g_object_unref0 (data->result);
	g_slice_free (RygelMediaDbContainerSearchData, data);
}


static gpointer _rygel_search_expression_ref0 (gpointer self) {
	return self ? rygel_search_expression_ref (self) : NULL;
}


static void rygel_media_db_container_real_search (RygelMediaContainer* base, RygelSearchExpression* expression, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelMediaDBContainer * self;
	RygelMediaDbContainerSearchData* _data_;
	self = (RygelMediaDBContainer*) base;
	_data_ = g_slice_new0 (RygelMediaDbContainerSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_media_db_container_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_media_db_container_real_search_data_free);
	_data_->self = self;
	_data_->expression = _rygel_search_expression_ref0 (expression);
	_data_->offset = offset;
	_data_->max_count = max_count;
	_data_->cancellable = _g_object_ref0 (cancellable);
	rygel_media_db_container_real_search_co (_data_);
}


static GeeList* rygel_media_db_container_real_search_finish (RygelMediaContainer* base, GAsyncResult* _res_, guint* total_matches, GError** error) {
	GeeList* result;
	RygelMediaDbContainerSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	*total_matches = _data_->total_matches;
	_data_->total_matches = NULL;
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void rygel_media_db_container_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelMediaDbContainerSearchData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_media_db_container_real_search_co (data);
}


static gboolean rygel_media_db_container_real_search_co (RygelMediaDbContainerSearchData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
			data->args = g_value_array_new ((guint) 0);
			data->filter = rygel_media_db_container_search_expression_to_sql (data->self, data->expression, data->args);
#line 79 "rygel-media-db-container.vala"
			if (data->filter == NULL) {
#line 80 "rygel-media-db-container.vala"
				data->total_matches = (guint) 0;
#line 590 "rygel-media-db-container.c"
				data->result = (GeeList*) gee_array_list_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL);
				_g_value_array_free0 (data->args);
				_g_free0 (data->filter);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 85 "rygel-media-db-container.vala"
			g_debug ("rygel-media-db-container.vala:85: Orignal search: %s", data->_tmp0_ = rygel_search_expression_to_string (data->expression));
#line 606 "rygel-media-db-container.c"
			_g_free0 (data->_tmp0_);
#line 86 "rygel-media-db-container.vala"
			g_debug ("rygel-media-db-container.vala:86: Parsed search expression: %s", data->filter);
#line 610 "rygel-media-db-container.c"
			{
				data->i = 0;
				{
					data->_tmp1_ = TRUE;
#line 88 "rygel-media-db-container.vala"
					while (TRUE) {
#line 88 "rygel-media-db-container.vala"
						if (!data->_tmp1_) {
#line 88 "rygel-media-db-container.vala"
							data->i++;
#line 621 "rygel-media-db-container.c"
						}
#line 88 "rygel-media-db-container.vala"
						data->_tmp1_ = FALSE;
#line 88 "rygel-media-db-container.vala"
						if (!(data->i < data->args->n_values)) {
#line 88 "rygel-media-db-container.vala"
							break;
#line 629 "rygel-media-db-container.c"
						}
#line 89 "rygel-media-db-container.vala"
						g_debug ("rygel-media-db-container.vala:89: Arg %d: %s", data->i, g_value_get_string (g_value_array_get_nth (data->args, (guint) data->i)));
#line 633 "rygel-media-db-container.c"
					}
				}
			}
			data->max_objects = data->max_count;
#line 93 "rygel-media-db-container.vala"
			if (data->max_objects == 0) {
#line 94 "rygel-media-db-container.vala"
				data->max_objects = (guint) (-1);
#line 642 "rygel-media-db-container.c"
			}
			data->children = rygel_media_db_get_objects_by_filter (data->self->media_db, data->filter, data->args, ((RygelMediaObject*) data->self)->id, (glong) data->offset, (glong) data->max_objects, &data->_inner_error_);
			if (data->_inner_error_ != NULL) {
				g_simple_async_result_set_from_error (data->_async_result, data->_inner_error_);
				g_error_free (data->_inner_error_);
				_g_value_array_free0 (data->args);
				_g_free0 (data->filter);
				{
					if (data->_state_ == 0) {
						g_simple_async_result_complete_in_idle (data->_async_result);
					} else {
						g_simple_async_result_complete (data->_async_result);
					}
					g_object_unref (data->_async_result);
					return FALSE;
				}
			}
#line 102 "rygel-media-db-container.vala"
			data->total_matches = (guint) gee_collection_get_size ((GeeCollection*) data->children);
#line 662 "rygel-media-db-container.c"
			data->result = (GeeList*) data->children;
			_g_value_array_free0 (data->args);
			_g_free0 (data->filter);
			{
				if (data->_state_ == 0) {
					g_simple_async_result_complete_in_idle (data->_async_result);
				} else {
					g_simple_async_result_complete (data->_async_result);
				}
				g_object_unref (data->_async_result);
				return FALSE;
			}
			_g_value_array_free0 (data->args);
			_g_free0 (data->filter);
			_g_object_unref0 (data->children);
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 107 "rygel-media-db-container.vala"
static char* rygel_media_db_container_logexp_to_sql (RygelMediaDBContainer* self, RygelLogicalExpression* exp, GValueArray* args) {
#line 694 "rygel-media-db-container.c"
	char* result;
	char* left;
	char* right;
	char* op;
#line 107 "rygel-media-db-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 107 "rygel-media-db-container.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 109 "rygel-media-db-container.vala"
	left = rygel_media_db_container_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) exp)->operand1, args);
#line 110 "rygel-media-db-container.vala"
	right = rygel_media_db_container_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) exp)->operand2, args);
#line 707 "rygel-media-db-container.c"
	op = NULL;
#line 112 "rygel-media-db-container.vala"
	if (GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op) == RYGEL_LOGICAL_OPERATOR_AND) {
#line 711 "rygel-media-db-container.c"
		char* _tmp0_;
#line 113 "rygel-media-db-container.vala"
		op = (_tmp0_ = g_strdup ("AND"), _g_free0 (op), _tmp0_);
#line 715 "rygel-media-db-container.c"
	} else {
		char* _tmp1_;
#line 115 "rygel-media-db-container.vala"
		op = (_tmp1_ = g_strdup ("OR"), _g_free0 (op), _tmp1_);
#line 720 "rygel-media-db-container.c"
	}
	result = g_strdup_printf ("(%s %s %s)", left, op, right);
	_g_free0 (left);
	_g_free0 (right);
	_g_free0 (op);
#line 118 "rygel-media-db-container.vala"
	return result;
#line 728 "rygel-media-db-container.c"
}


#line 121 "rygel-media-db-container.vala"
static char* rygel_media_db_container_search_expression_to_sql (RygelMediaDBContainer* self, RygelSearchExpression* expression, GValueArray* args) {
#line 734 "rygel-media-db-container.c"
	char* result;
	char* _result_;
#line 121 "rygel-media-db-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 121 "rygel-media-db-container.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 123 "rygel-media-db-container.vala"
	_result_ = NULL;
#line 125 "rygel-media-db-container.vala"
	if (expression == NULL) {
#line 745 "rygel-media-db-container.c"
		result = _result_;
#line 126 "rygel-media-db-container.vala"
		return result;
#line 749 "rygel-media-db-container.c"
	}
#line 129 "rygel-media-db-container.vala"
	if (RYGEL_IS_LOGICAL_EXPRESSION (expression)) {
#line 753 "rygel-media-db-container.c"
		RygelSearchExpression* _tmp0_;
		result = rygel_media_db_container_logexp_to_sql (self, (_tmp0_ = expression, RYGEL_IS_LOGICAL_EXPRESSION (_tmp0_) ? ((RygelLogicalExpression*) _tmp0_) : NULL), args);
		_g_free0 (_result_);
#line 130 "rygel-media-db-container.vala"
		return result;
#line 759 "rygel-media-db-container.c"
	} else {
		RygelSearchExpression* _tmp1_;
		result = rygel_media_db_container_relexp_to_sql (self, (_tmp1_ = expression, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp1_) ? ((RygelRelationalExpression*) _tmp1_) : NULL), args);
		_g_free0 (_result_);
#line 132 "rygel-media-db-container.vala"
		return result;
#line 766 "rygel-media-db-container.c"
	}
	_g_free0 (_result_);
}


#line 136 "rygel-media-db-container.vala"
static char* rygel_media_db_container_map_operand_to_column (RygelMediaDBContainer* self, const char* operand) {
#line 774 "rygel-media-db-container.c"
	char* result;
	char* column;
	GQuark _tmp7_;
	const char* _tmp6_;
	static GQuark _tmp7__label0 = 0;
	static GQuark _tmp7__label1 = 0;
	static GQuark _tmp7__label2 = 0;
	static GQuark _tmp7__label3 = 0;
	static GQuark _tmp7__label4 = 0;
	static GQuark _tmp7__label5 = 0;
#line 136 "rygel-media-db-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 136 "rygel-media-db-container.vala"
	g_return_val_if_fail (operand != NULL, NULL);
#line 137 "rygel-media-db-container.vala"
	column = NULL;
#line 791 "rygel-media-db-container.c"
	_tmp6_ = operand;
	_tmp7_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp7_ == ((0 != _tmp7__label0) ? _tmp7__label0 : (_tmp7__label0 = g_quark_from_static_string ("@id"))))
	do {
		char* _tmp0_;
#line 141 "rygel-media-db-container.vala"
		column = (_tmp0_ = g_strdup ("o.upnp_id"), _g_free0 (column), _tmp0_);
#line 142 "rygel-media-db-container.vala"
		break;
#line 801 "rygel-media-db-container.c"
	} while (0); else if (_tmp7_ == ((0 != _tmp7__label1) ? _tmp7__label1 : (_tmp7__label1 = g_quark_from_static_string ("@parentID"))))
	do {
		char* _tmp1_;
#line 144 "rygel-media-db-container.vala"
		column = (_tmp1_ = g_strdup ("o.parent"), _g_free0 (column), _tmp1_);
#line 145 "rygel-media-db-container.vala"
		break;
#line 809 "rygel-media-db-container.c"
	} while (0); else if (_tmp7_ == ((0 != _tmp7__label2) ? _tmp7__label2 : (_tmp7__label2 = g_quark_from_static_string ("upnp:class"))))
	do {
		char* _tmp2_;
#line 147 "rygel-media-db-container.vala"
		column = (_tmp2_ = g_strdup ("m.class"), _g_free0 (column), _tmp2_);
#line 148 "rygel-media-db-container.vala"
		break;
#line 817 "rygel-media-db-container.c"
	} while (0); else if (_tmp7_ == ((0 != _tmp7__label3) ? _tmp7__label3 : (_tmp7__label3 = g_quark_from_static_string ("dc:title"))))
	do {
		char* _tmp3_;
#line 150 "rygel-media-db-container.vala"
		column = (_tmp3_ = g_strdup ("o.title"), _g_free0 (column), _tmp3_);
#line 151 "rygel-media-db-container.vala"
		break;
#line 825 "rygel-media-db-container.c"
	} while (0); else if (_tmp7_ == ((0 != _tmp7__label4) ? _tmp7__label4 : (_tmp7__label4 = g_quark_from_static_string ("dc:creator"))))
	do {
		char* _tmp4_;
#line 153 "rygel-media-db-container.vala"
		column = (_tmp4_ = g_strdup ("m.author"), _g_free0 (column), _tmp4_);
#line 154 "rygel-media-db-container.vala"
		break;
#line 833 "rygel-media-db-container.c"
	} while (0); else if (_tmp7_ == ((0 != _tmp7__label5) ? _tmp7__label5 : (_tmp7__label5 = g_quark_from_static_string ("dc:date"))))
	do {
		char* _tmp5_;
#line 156 "rygel-media-db-container.vala"
		column = (_tmp5_ = g_strdup ("m.date"), _g_free0 (column), _tmp5_);
#line 157 "rygel-media-db-container.vala"
		break;
#line 841 "rygel-media-db-container.c"
	} while (0); else
	do {
#line 159 "rygel-media-db-container.vala"
		g_warning ("rygel-media-db-container.vala:159: Unsupported: %s", operand);
#line 160 "rygel-media-db-container.vala"
		break;
#line 848 "rygel-media-db-container.c"
	} while (0);
	result = column;
#line 163 "rygel-media-db-container.vala"
	return result;
#line 853 "rygel-media-db-container.c"
}


#line 166 "rygel-media-db-container.vala"
static char* rygel_media_db_container_relexp_to_sql (RygelMediaDBContainer* self, RygelRelationalExpression* exp, GValueArray* args) {
#line 859 "rygel-media-db-container.c"
	char* result;
	char* func;
	GValue* v;
	char* column;
#line 166 "rygel-media-db-container.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 166 "rygel-media-db-container.vala"
	g_return_val_if_fail (args != NULL, NULL);
#line 168 "rygel-media-db-container.vala"
	func = NULL;
#line 169 "rygel-media-db-container.vala"
	v = NULL;
#line 171 "rygel-media-db-container.vala"
	column = rygel_media_db_container_map_operand_to_column (self, (const char*) ((RygelSearchExpression*) exp)->operand1);
#line 172 "rygel-media-db-container.vala"
	if (column == NULL) {
#line 876 "rygel-media-db-container.c"
		result = NULL;
		_g_free0 (func);
		_g_free0 (v);
		_g_free0 (column);
#line 173 "rygel-media-db-container.vala"
		return result;
#line 883 "rygel-media-db-container.c"
	}
#line 176 "rygel-media-db-container.vala"
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op)) {
#line 887 "rygel-media-db-container.c"
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
#line 178 "rygel-media-db-container.vala"
			if (_vala_strcmp0 ((const char*) ((RygelSearchExpression*) exp)->operand2, "true") == 0) {
#line 892 "rygel-media-db-container.c"
				char* _tmp0_;
#line 179 "rygel-media-db-container.vala"
				func = (_tmp0_ = g_strdup ("IS NOT NULL AND %s != ''"), _g_free0 (func), _tmp0_);
#line 896 "rygel-media-db-container.c"
			} else {
				char* _tmp1_;
#line 181 "rygel-media-db-container.vala"
				func = (_tmp1_ = g_strdup ("IS NULL OR %s = ''"), _g_free0 (func), _tmp1_);
#line 901 "rygel-media-db-container.c"
			}
#line 182 "rygel-media-db-container.vala"
			break;
#line 905 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		{
			char* _tmp2_;
			GValue* _tmp4_;
			GValue* _tmp3_ = NULL;
#line 184 "rygel-media-db-container.vala"
			func = (_tmp2_ = g_strdup ("="), _g_free0 (func), _tmp2_);
#line 185 "rygel-media-db-container.vala"
			v = (_tmp4_ = (_tmp3_ = g_new0 (GValue, 1), g_value_init (_tmp3_, G_TYPE_STRING), g_value_set_string (_tmp3_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp3_), _g_free0 (v), _tmp4_);
#line 186 "rygel-media-db-container.vala"
			break;
#line 918 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		{
			char* _tmp5_;
			GValue* _tmp7_;
			GValue* _tmp6_ = NULL;
#line 188 "rygel-media-db-container.vala"
			func = (_tmp5_ = g_strdup ("!="), _g_free0 (func), _tmp5_);
#line 189 "rygel-media-db-container.vala"
			v = (_tmp7_ = (_tmp6_ = g_new0 (GValue, 1), g_value_init (_tmp6_, G_TYPE_STRING), g_value_set_string (_tmp6_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp6_), _g_free0 (v), _tmp7_);
#line 190 "rygel-media-db-container.vala"
			break;
#line 931 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		{
			char* _tmp8_;
			GValue* _tmp10_;
			GValue* _tmp9_ = NULL;
#line 192 "rygel-media-db-container.vala"
			func = (_tmp8_ = g_strdup ("<"), _g_free0 (func), _tmp8_);
#line 193 "rygel-media-db-container.vala"
			v = (_tmp10_ = (_tmp9_ = g_new0 (GValue, 1), g_value_init (_tmp9_, G_TYPE_STRING), g_value_set_string (_tmp9_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp9_), _g_free0 (v), _tmp10_);
#line 194 "rygel-media-db-container.vala"
			break;
#line 944 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		{
			char* _tmp11_;
			GValue* _tmp13_;
			GValue* _tmp12_ = NULL;
#line 196 "rygel-media-db-container.vala"
			func = (_tmp11_ = g_strdup ("<="), _g_free0 (func), _tmp11_);
#line 197 "rygel-media-db-container.vala"
			v = (_tmp13_ = (_tmp12_ = g_new0 (GValue, 1), g_value_init (_tmp12_, G_TYPE_STRING), g_value_set_string (_tmp12_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp12_), _g_free0 (v), _tmp13_);
#line 198 "rygel-media-db-container.vala"
			break;
#line 957 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		{
			char* _tmp14_;
			GValue* _tmp16_;
			GValue* _tmp15_ = NULL;
#line 200 "rygel-media-db-container.vala"
			func = (_tmp14_ = g_strdup (">"), _g_free0 (func), _tmp14_);
#line 201 "rygel-media-db-container.vala"
			v = (_tmp16_ = (_tmp15_ = g_new0 (GValue, 1), g_value_init (_tmp15_, G_TYPE_STRING), g_value_set_string (_tmp15_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp15_), _g_free0 (v), _tmp16_);
#line 202 "rygel-media-db-container.vala"
			break;
#line 970 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			char* _tmp17_;
			GValue* _tmp19_;
			GValue* _tmp18_ = NULL;
#line 204 "rygel-media-db-container.vala"
			func = (_tmp17_ = g_strdup (">="), _g_free0 (func), _tmp17_);
#line 205 "rygel-media-db-container.vala"
			v = (_tmp19_ = (_tmp18_ = g_new0 (GValue, 1), g_value_init (_tmp18_, G_TYPE_STRING), g_value_set_string (_tmp18_, (const char*) ((RygelSearchExpression*) exp)->operand2), _tmp18_), _g_free0 (v), _tmp19_);
#line 206 "rygel-media-db-container.vala"
			break;
#line 983 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			char* _tmp20_;
			GValue* _tmp23_;
			GValue* _tmp22_ = NULL;
			char* _tmp21_;
#line 208 "rygel-media-db-container.vala"
			func = (_tmp20_ = g_strdup ("LIKE"), _g_free0 (func), _tmp20_);
#line 209 "rygel-media-db-container.vala"
			v = (_tmp23_ = (_tmp22_ = g_new0 (GValue, 1), g_value_init (_tmp22_, G_TYPE_STRING), g_value_set_string (_tmp22_, _tmp21_ = g_strdup_printf ("%%%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp22_), _g_free0 (v), _tmp23_);
#line 995 "rygel-media-db-container.c"
			_g_free0 (_tmp21_);
#line 210 "rygel-media-db-container.vala"
			break;
#line 999 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			char* _tmp24_;
			GValue* _tmp27_;
			GValue* _tmp26_ = NULL;
			char* _tmp25_;
#line 212 "rygel-media-db-container.vala"
			func = (_tmp24_ = g_strdup ("NOT LIKE"), _g_free0 (func), _tmp24_);
#line 213 "rygel-media-db-container.vala"
			v = (_tmp27_ = (_tmp26_ = g_new0 (GValue, 1), g_value_init (_tmp26_, G_TYPE_STRING), g_value_set_string (_tmp26_, _tmp25_ = g_strdup_printf ("%%%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp26_), _g_free0 (v), _tmp27_);
#line 1011 "rygel-media-db-container.c"
			_g_free0 (_tmp25_);
#line 214 "rygel-media-db-container.vala"
			break;
#line 1015 "rygel-media-db-container.c"
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			char* _tmp28_;
			GValue* _tmp31_;
			GValue* _tmp30_ = NULL;
			char* _tmp29_;
#line 216 "rygel-media-db-container.vala"
			func = (_tmp28_ = g_strdup ("LIKE"), _g_free0 (func), _tmp28_);
#line 217 "rygel-media-db-container.vala"
			v = (_tmp31_ = (_tmp30_ = g_new0 (GValue, 1), g_value_init (_tmp30_, G_TYPE_STRING), g_value_set_string (_tmp30_, _tmp29_ = g_strdup_printf ("%s%%", (const char*) ((RygelSearchExpression*) exp)->operand2)), _tmp30_), _g_free0 (v), _tmp31_);
#line 1027 "rygel-media-db-container.c"
			_g_free0 (_tmp29_);
#line 218 "rygel-media-db-container.vala"
			break;
#line 1031 "rygel-media-db-container.c"
		}
		default:
		{
#line 220 "rygel-media-db-container.vala"
			g_warning ("rygel-media-db-container.vala:220: Unsupported op %d", (gint) GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op));
#line 221 "rygel-media-db-container.vala"
			break;
#line 1039 "rygel-media-db-container.c"
		}
	}
#line 224 "rygel-media-db-container.vala"
	if (v != NULL) {
#line 225 "rygel-media-db-container.vala"
		g_value_array_append (args, v);
#line 1046 "rygel-media-db-container.c"
	}
	result = g_strdup_printf ("%s %s ?", column, func);
	_g_free0 (func);
	_g_free0 (v);
	_g_free0 (column);
#line 228 "rygel-media-db-container.vala"
	return result;
#line 1054 "rygel-media-db-container.c"
}


static void rygel_media_db_container_class_init (RygelMediaDBContainerClass * klass) {
	rygel_media_db_container_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_media_db_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_media_db_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search = rygel_media_db_container_real_search;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->search_finish = rygel_media_db_container_real_search_finish;
	G_OBJECT_CLASS (klass)->finalize = rygel_media_db_container_finalize;
}


static void rygel_media_db_container_instance_init (RygelMediaDBContainer * self) {
}


static void rygel_media_db_container_finalize (GObject* obj) {
	RygelMediaDBContainer * self;
	self = RYGEL_MEDIA_DB_CONTAINER (obj);
	_g_object_unref0 (self->media_db);
	G_OBJECT_CLASS (rygel_media_db_container_parent_class)->finalize (obj);
}


GType rygel_media_db_container_get_type (void) {
	static GType rygel_media_db_container_type_id = 0;
	if (rygel_media_db_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaDBContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_db_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaDBContainer), 0, (GInstanceInitFunc) rygel_media_db_container_instance_init, NULL };
		rygel_media_db_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelMediaDBContainer", &g_define_type_info, 0);
	}
	return rygel_media_db_container_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




