/* rygel-http-server.c generated by valac, the Vala compiler
 * generated from rygel-http-server.vala, do not modify */

/*
 * Copyright (C) 2008, 2009 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <libgupnp-av/gupnp-av.h>
#include <gio/gio.h>
#include <libgupnp/gupnp.h>
#include <gee.h>
#include <libsoup/soup.h>
#include <gst/gst.h>


#define RYGEL_TYPE_TRANSCODE_MANAGER (rygel_transcode_manager_get_type ())
#define RYGEL_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManager))
#define RYGEL_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))
#define RYGEL_IS_TRANSCODE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_IS_TRANSCODE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_TRANSCODE_MANAGER))
#define RYGEL_TRANSCODE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_TRANSCODE_MANAGER, RygelTranscodeManagerClass))

typedef struct _RygelTranscodeManager RygelTranscodeManager;
typedef struct _RygelTranscodeManagerClass RygelTranscodeManagerClass;
typedef struct _RygelTranscodeManagerPrivate RygelTranscodeManagerPrivate;

#define RYGEL_TYPE_MEDIA_OBJECT (rygel_media_object_get_type ())
#define RYGEL_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObject))
#define RYGEL_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))
#define RYGEL_IS_MEDIA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_IS_MEDIA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_OBJECT))
#define RYGEL_MEDIA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_OBJECT, RygelMediaObjectClass))

typedef struct _RygelMediaObject RygelMediaObject;
typedef struct _RygelMediaObjectClass RygelMediaObjectClass;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;

#define RYGEL_TYPE_STATE_MACHINE (rygel_state_machine_get_type ())
#define RYGEL_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachine))
#define RYGEL_IS_STATE_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_STATE_MACHINE))
#define RYGEL_STATE_MACHINE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), RYGEL_TYPE_STATE_MACHINE, RygelStateMachineIface))

typedef struct _RygelStateMachine RygelStateMachine;
typedef struct _RygelStateMachineIface RygelStateMachineIface;

#define RYGEL_TYPE_HTTP_SERVER (rygel_http_server_get_type ())
#define RYGEL_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServer))
#define RYGEL_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))
#define RYGEL_IS_HTTP_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_IS_HTTP_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SERVER))
#define RYGEL_HTTP_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerClass))

typedef struct _RygelHTTPServer RygelHTTPServer;
typedef struct _RygelHTTPServerClass RygelHTTPServerClass;
typedef struct _RygelHTTPServerPrivate RygelHTTPServerPrivate;

#define RYGEL_TYPE_MEDIA_CONTAINER (rygel_media_container_get_type ())
#define RYGEL_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainer))
#define RYGEL_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))
#define RYGEL_IS_MEDIA_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_IS_MEDIA_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_CONTAINER))
#define RYGEL_MEDIA_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_CONTAINER, RygelMediaContainerClass))

typedef struct _RygelMediaContainer RygelMediaContainer;
typedef struct _RygelMediaContainerClass RygelMediaContainerClass;

#define RYGEL_TYPE_HTTP_REQUEST (rygel_http_request_get_type ())
#define RYGEL_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequest))
#define RYGEL_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))
#define RYGEL_IS_HTTP_REQUEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_IS_HTTP_REQUEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_REQUEST))
#define RYGEL_HTTP_REQUEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_REQUEST, RygelHTTPRequestClass))

typedef struct _RygelHTTPRequest RygelHTTPRequest;
typedef struct _RygelHTTPRequestClass RygelHTTPRequestClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_CONTENT_DIRECTORY (rygel_content_directory_get_type ())
#define RYGEL_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectory))
#define RYGEL_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))
#define RYGEL_IS_CONTENT_DIRECTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_IS_CONTENT_DIRECTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_CONTENT_DIRECTORY))
#define RYGEL_CONTENT_DIRECTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_CONTENT_DIRECTORY, RygelContentDirectoryClass))

typedef struct _RygelContentDirectory RygelContentDirectory;
typedef struct _RygelContentDirectoryClass RygelContentDirectoryClass;
typedef struct _RygelContentDirectoryPrivate RygelContentDirectoryPrivate;
typedef struct _RygelHttpServerRunData RygelHttpServerRunData;
typedef struct _RygelMediaObjectPrivate RygelMediaObjectPrivate;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_ICON_INFO (rygel_icon_info_get_type ())
#define RYGEL_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfo))
#define RYGEL_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))
#define RYGEL_IS_ICON_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_ICON_INFO))
#define RYGEL_IS_ICON_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_ICON_INFO))
#define RYGEL_ICON_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_ICON_INFO, RygelIconInfoClass))

typedef struct _RygelIconInfo RygelIconInfo;
typedef struct _RygelIconInfoClass RygelIconInfoClass;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelIconInfoPrivate RygelIconInfoPrivate;
#define _rygel_icon_info_unref0(var) ((var == NULL) ? NULL : (var = (rygel_icon_info_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_ITEM_URI (rygel_http_item_uri_get_type ())
#define RYGEL_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURI))
#define RYGEL_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))
#define RYGEL_IS_HTTP_ITEM_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_IS_HTTP_ITEM_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_ITEM_URI))
#define RYGEL_HTTP_ITEM_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_ITEM_URI, RygelHTTPItemURIClass))

typedef struct _RygelHTTPItemURI RygelHTTPItemURI;
typedef struct _RygelHTTPItemURIClass RygelHTTPItemURIClass;
typedef struct _RygelHTTPRequestPrivate RygelHTTPRequestPrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;

#define RYGEL_TYPE_HTTP_POST (rygel_http_post_get_type ())
#define RYGEL_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPost))
#define RYGEL_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))
#define RYGEL_IS_HTTP_POST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_POST))
#define RYGEL_IS_HTTP_POST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_POST))
#define RYGEL_HTTP_POST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_POST, RygelHTTPPostClass))

typedef struct _RygelHTTPPost RygelHTTPPost;
typedef struct _RygelHTTPPostClass RygelHTTPPostClass;

struct _RygelTranscodeManager {
	GObject parent_instance;
	RygelTranscodeManagerPrivate * priv;
};

struct _RygelTranscodeManagerClass {
	GObjectClass parent_class;
	char* (*create_uri_for_item) (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, const char* transcode_target);
	void (*add_resources) (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
	char* (*get_protocol) (RygelTranscodeManager* self);
	char* (*get_protocol_info) (RygelTranscodeManager* self);
};

struct _RygelStateMachineIface {
	GTypeInterface parent_iface;
	void (*run) (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*run_finish) (RygelStateMachine* self, GAsyncResult* _res_);
	GCancellable* (*get_cancellable) (RygelStateMachine* self);
	void (*set_cancellable) (RygelStateMachine* self, GCancellable* value);
};

struct _RygelHTTPServer {
	RygelTranscodeManager parent_instance;
	RygelHTTPServerPrivate * priv;
	RygelMediaContainer* root_container;
	GUPnPContext* context;
};

struct _RygelHTTPServerClass {
	RygelTranscodeManagerClass parent_class;
};

struct _RygelHTTPServerPrivate {
	char* _path_root;
	GeeArrayList* requests;
	GCancellable* _cancellable;
};

struct _RygelContentDirectory {
	GUPnPService parent_instance;
	RygelContentDirectoryPrivate * priv;
	char* feature_list;
	char* sort_caps;
	RygelHTTPServer* http_server;
	RygelMediaContainer* root_container;
	GCancellable* cancellable;
	guint32 system_update_id;
};

struct _RygelContentDirectoryClass {
	GUPnPServiceClass parent_class;
	RygelMediaContainer* (*create_root_container) (RygelContentDirectory* self);
	void (*browse_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*search_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*create_object_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*import_resource_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*get_transfer_progress_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
	void (*stop_transfer_resource_cb) (RygelContentDirectory* self, RygelContentDirectory* content_dir, GUPnPServiceAction* action);
};

struct _RygelHttpServerRunData {
	int _state_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	RygelHTTPServer* self;
};

struct _RygelMediaObject {
	GObject parent_instance;
	RygelMediaObjectPrivate * priv;
	char* id;
	char* upnp_class;
	guint64 modified;
	GeeArrayList* uris;
	RygelMediaContainer* parent;
	RygelMediaContainer* parent_ref;
};

struct _RygelMediaObjectClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	RygelMediaObject parent_instance;
	RygelMediaItemPrivate * priv;
	char* author;
	char* album;
	char* date;
	char* mime_type;
	char* dlna_profile;
	glong size;
	glong duration;
	gint bitrate;
	gint sample_freq;
	gint bits_per_sample;
	gint n_audio_channels;
	gint track_number;
	gint width;
	gint height;
	gint pixel_width;
	gint pixel_height;
	gint color_depth;
	GeeArrayList* thumbnails;
	gboolean place_holder;
};

struct _RygelMediaItemClass {
	RygelMediaObjectClass parent_class;
	GstElement* (*create_stream_source) (RygelMediaItem* self);
	gboolean (*should_stream) (RygelMediaItem* self);
};

struct _RygelIconInfo {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelIconInfoPrivate * priv;
	char* mime_type;
	char* uri;
	glong size;
	gint width;
	gint height;
	gint depth;
};

struct _RygelIconInfoClass {
	GTypeClass parent_class;
	void (*finalize) (RygelIconInfo *self);
};

struct _RygelHTTPRequest {
	GObject parent_instance;
	RygelHTTPRequestPrivate * priv;
	RygelHTTPServer* http_server;
	SoupServer* server;
	SoupMessage* msg;
	RygelHTTPItemURI* uri;
	RygelMediaItem* item;
};

struct _RygelHTTPRequestClass {
	GObjectClass parent_class;
	void (*handle) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*handle_finish) (RygelHTTPRequest* self, GAsyncResult* _res_);
	void (*find_item) (RygelHTTPRequest* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*find_item_finish) (RygelHTTPRequest* self, GAsyncResult* _res_);
	void (*handle_error) (RygelHTTPRequest* self, GError* _error_);
};


static gpointer rygel_http_server_parent_class = NULL;
static RygelStateMachineIface* rygel_http_server_rygel_state_machine_parent_iface = NULL;

GType rygel_transcode_manager_get_type (void);
GType rygel_media_object_get_type (void);
GType rygel_media_item_get_type (void);
GType rygel_state_machine_get_type (void);
GType rygel_http_server_get_type (void);
GType rygel_media_container_get_type (void);
GType rygel_http_request_get_type (void);
#define RYGEL_HTTP_SERVER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_SERVER, RygelHTTPServerPrivate))
enum  {
	RYGEL_HTTP_SERVER_DUMMY_PROPERTY,
	RYGEL_HTTP_SERVER_PATH_ROOT,
	RYGEL_HTTP_SERVER_CANCELLABLE
};
#define RYGEL_HTTP_SERVER_SERVER_PATH_PREFIX "/RygelHTTPServer"
RygelTranscodeManager* rygel_transcode_manager_construct (GType object_type, GError** error);
GType rygel_content_directory_get_type (void);
void rygel_state_machine_set_cancellable (RygelStateMachine* self, GCancellable* value);
static void rygel_http_server_set_path_root (RygelHTTPServer* self, const char* value);
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const char* name, GError** error);
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const char* name, GError** error);
static void rygel_http_server_real_run_data_free (gpointer _data);
static void rygel_http_server_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void rygel_http_server_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
const char* rygel_http_server_get_path_root (RygelHTTPServer* self);
static void rygel_http_server_server_handler (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const char* server_path, GHashTable* query, SoupClientContext* soup_client);
static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client);
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self);
GCancellable* rygel_state_machine_get_cancellable (RygelStateMachine* self);
static void rygel_http_server_on_cancelled (RygelHTTPServer* self, GCancellable* cancellable);
static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self);
static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* data);
static gboolean rygel_http_server_http_uri_present (RygelHTTPServer* self, RygelMediaItem* item);
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
void rygel_transcode_manager_add_resources (RygelTranscodeManager* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
gpointer rygel_icon_info_ref (gpointer instance);
void rygel_icon_info_unref (gpointer instance);
GParamSpec* rygel_param_spec_icon_info (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_value_set_icon_info (GValue* value, gpointer v_object);
gpointer rygel_value_get_icon_info (const GValue* value);
GType rygel_icon_info_get_type (void);
GType rygel_thumbnail_get_type (void);
static gboolean rygel_http_server_is_http_uri (RygelHTTPServer* self, const char* uri);
char* rygel_transcode_manager_create_uri_for_item (RygelTranscodeManager* self, RygelMediaItem* item, gint thumbnail_index, const char* transcode_target);
GUPnPDIDLLiteResource* rygel_thumbnail_add_resource (RygelThumbnail* self, GUPnPDIDLLiteItem* didl_item, const char* protocol);
char* rygel_transcode_manager_get_protocol (RygelTranscodeManager* self);
static void rygel_http_server_real_add_resources (RygelTranscodeManager* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error);
GUPnPDIDLLiteResource* rygel_media_item_add_resource (RygelMediaItem* self, GUPnPDIDLLiteItem* didl_item, const char* uri, const char* protocol, const char* import_uri, GError** error);
RygelHTTPItemURI* rygel_http_item_uri_new (const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, const char* transcode_target);
RygelHTTPItemURI* rygel_http_item_uri_construct (GType object_type, const char* item_id, RygelHTTPServer* http_server, gint thumbnail_index, const char* transcode_target);
GType rygel_http_item_uri_get_type (void);
char* rygel_http_item_uri_to_string (RygelHTTPItemURI* self);
static char* rygel_http_server_real_create_uri_for_item (RygelTranscodeManager* base, RygelMediaItem* item, gint thumbnail_index, const char* transcode_target);
static char* rygel_http_server_real_get_protocol (RygelTranscodeManager* base);
char* rygel_transcode_manager_get_protocol_info (RygelTranscodeManager* self);
static char* rygel_http_server_real_get_protocol_info (RygelTranscodeManager* base);
static void rygel_http_server_on_request_completed (RygelHTTPServer* self, RygelHTTPRequest* request);
static void _lambda0_ (const char* name, const char* value, RygelHTTPServer* self);
static void __lambda0__soup_message_headers_foreach_func (const char* name, const char* value, gpointer self);
static void rygel_http_server_queue_request (RygelHTTPServer* self, RygelHTTPRequest* request);
RygelHTTPGet* rygel_http_get_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg, GHashTable* query);
RygelHTTPGet* rygel_http_get_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg, GHashTable* query);
GType rygel_http_get_get_type (void);
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg);
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self);
RygelHTTPPost* rygel_http_post_new (RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
RygelHTTPPost* rygel_http_post_construct (GType object_type, RygelHTTPServer* http_server, SoupServer* server, SoupMessage* msg);
GType rygel_http_post_get_type (void);
static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelHTTPRequest* _sender, gpointer self);
void rygel_state_machine_run (RygelStateMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void rygel_state_machine_run_finish (RygelStateMachine* self, GAsyncResult* _res_);
static void rygel_http_server_finalize (GObject* obj);
static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static int _vala_strcmp0 (const char * str1, const char * str2);



static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


#line 39 "rygel-http-server.vala"
RygelHTTPServer* rygel_http_server_construct (GType object_type, RygelContentDirectory* content_dir, const char* name, GError** error) {
#line 418 "rygel-http-server.c"
	RygelHTTPServer * self;
	RygelMediaContainer* _tmp0_;
	GUPnPContext* _tmp1_;
	GeeArrayList* _tmp2_;
	char* _tmp3_;
#line 39 "rygel-http-server.vala"
	g_return_val_if_fail (content_dir != NULL, NULL);
#line 39 "rygel-http-server.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 41 "rygel-http-server.vala"
	self = (RygelHTTPServer*) rygel_transcode_manager_construct (object_type, error);
#line 43 "rygel-http-server.vala"
	self->root_container = (_tmp0_ = _g_object_ref0 (content_dir->root_container), _g_object_unref0 (self->root_container), _tmp0_);
#line 44 "rygel-http-server.vala"
	self->context = (_tmp1_ = _g_object_ref0 (gupnp_service_info_get_context ((GUPnPServiceInfo*) content_dir)), _g_object_unref0 (self->context), _tmp1_);
#line 45 "rygel-http-server.vala"
	self->priv->requests = (_tmp2_ = gee_array_list_new (RYGEL_TYPE_HTTP_REQUEST, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL), _g_object_unref0 (self->priv->requests), _tmp2_);
#line 46 "rygel-http-server.vala"
	rygel_state_machine_set_cancellable ((RygelStateMachine*) self, content_dir->cancellable);
#line 48 "rygel-http-server.vala"
	rygel_http_server_set_path_root (self, _tmp3_ = g_strconcat (RYGEL_HTTP_SERVER_SERVER_PATH_PREFIX "/", name, NULL));
#line 440 "rygel-http-server.c"
	_g_free0 (_tmp3_);
	return self;
}


#line 39 "rygel-http-server.vala"
RygelHTTPServer* rygel_http_server_new (RygelContentDirectory* content_dir, const char* name, GError** error) {
#line 39 "rygel-http-server.vala"
	return rygel_http_server_construct (RYGEL_TYPE_HTTP_SERVER, content_dir, name, error);
#line 450 "rygel-http-server.c"
}


static void rygel_http_server_real_run_data_free (gpointer _data) {
	RygelHttpServerRunData* data;
	data = _data;
	g_slice_free (RygelHttpServerRunData, data);
}


static void rygel_http_server_real_run (RygelStateMachine* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	RygelHTTPServer * self;
	RygelHttpServerRunData* _data_;
	self = (RygelHTTPServer*) base;
	_data_ = g_slice_new0 (RygelHttpServerRunData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, rygel_http_server_real_run);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, rygel_http_server_real_run_data_free);
	_data_->self = self;
	rygel_http_server_real_run_co (_data_);
}


static void rygel_http_server_real_run_finish (RygelStateMachine* base, GAsyncResult* _res_) {
	RygelHttpServerRunData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void rygel_http_server_run_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	RygelHttpServerRunData* data;
	data = _user_data_;
	data->_res_ = _res_;
	rygel_http_server_real_run_co (data);
}


#line 161 "rygel-http-server.vala"
static void _rygel_http_server_server_handler_soup_server_callback (SoupServer* server, SoupMessage* msg, const char* path, GHashTable* query, SoupClientContext* client, gpointer self) {
#line 489 "rygel-http-server.c"
	rygel_http_server_server_handler (self, server, msg, path, query, client);
}


#line 176 "rygel-http-server.vala"
static void _rygel_http_server_on_request_aborted_soup_server_request_aborted (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 496 "rygel-http-server.c"
	rygel_http_server_on_request_aborted (self, _sender, msg, client);
}


#line 191 "rygel-http-server.vala"
static void _rygel_http_server_on_request_started_soup_server_request_started (SoupServer* _sender, SoupMessage* msg, SoupClientContext* client, gpointer self) {
#line 503 "rygel-http-server.c"
	rygel_http_server_on_request_started (self, _sender, msg, client);
}


#line 119 "rygel-http-server.vala"
static void _rygel_http_server_on_cancelled_g_cancellable_cancelled (GCancellable* _sender, gpointer self) {
#line 510 "rygel-http-server.c"
	rygel_http_server_on_cancelled (self, _sender);
}


static gboolean rygel_http_server_real_run_co (RygelHttpServerRunData* data) {
	switch (data->_state_) {
		default:
		g_assert_not_reached ();
		case 0:
		{
#line 52 "rygel-http-server.vala"
			soup_server_add_handler (gupnp_context_get_server (data->self->context), data->self->priv->_path_root, _rygel_http_server_server_handler_soup_server_callback, g_object_ref (data->self), g_object_unref);
#line 53 "rygel-http-server.vala"
			g_signal_connect_object (gupnp_context_get_server (data->self->context), "request-aborted", (GCallback) _rygel_http_server_on_request_aborted_soup_server_request_aborted, data->self, 0);
#line 54 "rygel-http-server.vala"
			g_signal_connect_object (gupnp_context_get_server (data->self->context), "request-started", (GCallback) _rygel_http_server_on_request_started_soup_server_request_started, data->self, 0);
#line 56 "rygel-http-server.vala"
			if (rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self) != NULL) {
#line 57 "rygel-http-server.vala"
				g_signal_connect_object (rygel_state_machine_get_cancellable ((RygelStateMachine*) data->self), "cancelled", (GCallback) _rygel_http_server_on_cancelled_g_cancellable_cancelled, data->self, 0);
#line 531 "rygel-http-server.c"
			}
		}
		{
			if (data->_state_ == 0) {
				g_simple_async_result_complete_in_idle (data->_async_result);
			} else {
				g_simple_async_result_complete (data->_async_result);
			}
			g_object_unref (data->_async_result);
			return FALSE;
		}
	}
}


#line 66 "rygel-http-server.vala"
static void rygel_http_server_real_add_resources (RygelTranscodeManager* base, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
#line 549 "rygel-http-server.c"
	RygelHTTPServer * self;
	GError * _inner_error_;
	self = (RygelHTTPServer*) base;
#line 66 "rygel-http-server.vala"
	g_return_if_fail (didl_item != NULL);
#line 66 "rygel-http-server.vala"
	g_return_if_fail (item != NULL);
#line 557 "rygel-http-server.c"
	_inner_error_ = NULL;
#line 69 "rygel-http-server.vala"
	if (!rygel_http_server_http_uri_present (self, item)) {
#line 70 "rygel-http-server.vala"
		rygel_http_server_add_proxy_resource (self, didl_item, item, &_inner_error_);
#line 563 "rygel-http-server.c"
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
#line 73 "rygel-http-server.vala"
	RYGEL_TRANSCODE_MANAGER_CLASS (rygel_http_server_parent_class)->add_resources (RYGEL_TRANSCODE_MANAGER (self), didl_item, item, &_inner_error_);
#line 571 "rygel-http-server.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	{
		GeeIterator* _thumbnail_it;
		_thumbnail_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) item->thumbnails);
#line 76 "rygel-http-server.vala"
		while (TRUE) {
#line 581 "rygel-http-server.c"
			RygelThumbnail* thumbnail;
#line 76 "rygel-http-server.vala"
			if (!gee_iterator_next (_thumbnail_it)) {
#line 76 "rygel-http-server.vala"
				break;
#line 587 "rygel-http-server.c"
			}
#line 76 "rygel-http-server.vala"
			thumbnail = (RygelThumbnail*) gee_iterator_get (_thumbnail_it);
#line 77 "rygel-http-server.vala"
			if (!rygel_http_server_is_http_uri (self, ((RygelIconInfo*) thumbnail)->uri)) {
#line 593 "rygel-http-server.c"
				char* uri;
				gint index;
				char* _tmp0_;
				GUPnPDIDLLiteResource* _tmp2_;
				char* _tmp1_;
				char* _tmp3_;
#line 78 "rygel-http-server.vala"
				uri = g_strdup (((RygelIconInfo*) thumbnail)->uri);
#line 79 "rygel-http-server.vala"
				index = gee_abstract_list_index_of ((GeeAbstractList*) item->thumbnails, thumbnail);
#line 81 "rygel-http-server.vala"
				((RygelIconInfo*) thumbnail)->uri = (_tmp0_ = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) self, item, index, NULL), _g_free0 (((RygelIconInfo*) thumbnail)->uri), _tmp0_);
#line 82 "rygel-http-server.vala"
				_tmp2_ = rygel_thumbnail_add_resource (thumbnail, didl_item, _tmp1_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self));
#line 608 "rygel-http-server.c"
				_g_object_unref0 (_tmp2_);
				_g_free0 (_tmp1_);
#line 85 "rygel-http-server.vala"
				((RygelIconInfo*) thumbnail)->uri = (_tmp3_ = g_strdup (uri), _g_free0 (((RygelIconInfo*) thumbnail)->uri), _tmp3_);
#line 613 "rygel-http-server.c"
				_g_free0 (uri);
			}
			_rygel_icon_info_unref0 (thumbnail);
		}
		_g_object_unref0 (_thumbnail_it);
	}
}


#line 1045 "glib-2.0.vapi"
static const char* string_to_string (const char* self) {
#line 625 "rygel-http-server.c"
	const char* result;
#line 1045 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 629 "rygel-http-server.c"
	result = self;
#line 1046 "glib-2.0.vapi"
	return result;
#line 633 "rygel-http-server.c"
}


#line 90 "rygel-http-server.vala"
void rygel_http_server_add_proxy_resource (RygelHTTPServer* self, GUPnPDIDLLiteItem* didl_item, RygelMediaItem* item, GError** error) {
#line 639 "rygel-http-server.c"
	GError * _inner_error_;
	char* uri;
	GUPnPDIDLLiteResource* _tmp1_;
	char* _tmp0_;
#line 90 "rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 90 "rygel-http-server.vala"
	g_return_if_fail (didl_item != NULL);
#line 90 "rygel-http-server.vala"
	g_return_if_fail (item != NULL);
#line 650 "rygel-http-server.c"
	_inner_error_ = NULL;
#line 93 "rygel-http-server.vala"
	uri = rygel_transcode_manager_create_uri_for_item ((RygelTranscodeManager*) self, item, -1, NULL);
#line 95 "rygel-http-server.vala"
	_tmp1_ = rygel_media_item_add_resource (item, didl_item, string_to_string (uri), _tmp0_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self), string_to_string (uri), &_inner_error_);
#line 656 "rygel-http-server.c"
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (uri);
		return;
	}
	_g_object_unref0 (_tmp1_);
	_g_free0 (_tmp0_);
	_g_free0 (uri);
}


#line 101 "rygel-http-server.vala"
static gboolean rygel_http_server_http_uri_present (RygelHTTPServer* self, RygelMediaItem* item) {
#line 670 "rygel-http-server.c"
	gboolean result;
	gboolean present;
#line 101 "rygel-http-server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 101 "rygel-http-server.vala"
	g_return_val_if_fail (item != NULL, FALSE);
#line 102 "rygel-http-server.vala"
	present = FALSE;
#line 679 "rygel-http-server.c"
	{
		GeeIterator* _uri_it;
		_uri_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) ((RygelMediaObject*) item)->uris);
#line 104 "rygel-http-server.vala"
		while (TRUE) {
#line 685 "rygel-http-server.c"
			char* uri;
#line 104 "rygel-http-server.vala"
			if (!gee_iterator_next (_uri_it)) {
#line 104 "rygel-http-server.vala"
				break;
#line 691 "rygel-http-server.c"
			}
#line 104 "rygel-http-server.vala"
			uri = (char*) gee_iterator_get (_uri_it);
#line 105 "rygel-http-server.vala"
			if (rygel_http_server_is_http_uri (self, uri)) {
#line 106 "rygel-http-server.vala"
				present = TRUE;
#line 699 "rygel-http-server.c"
				_g_free0 (uri);
#line 108 "rygel-http-server.vala"
				break;
#line 703 "rygel-http-server.c"
			}
			_g_free0 (uri);
		}
		_g_object_unref0 (_uri_it);
	}
	result = present;
#line 112 "rygel-http-server.vala"
	return result;
#line 712 "rygel-http-server.c"
}


#line 115 "rygel-http-server.vala"
static gboolean rygel_http_server_is_http_uri (RygelHTTPServer* self, const char* uri) {
#line 718 "rygel-http-server.c"
	gboolean result;
	char* _tmp0_;
	gboolean _tmp1_;
#line 115 "rygel-http-server.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 115 "rygel-http-server.vala"
	g_return_val_if_fail (uri != NULL, FALSE);
#line 726 "rygel-http-server.c"
	result = (_tmp1_ = _vala_strcmp0 (_tmp0_ = g_uri_parse_scheme (uri), "http") == 0, _g_free0 (_tmp0_), _tmp1_);
#line 116 "rygel-http-server.vala"
	return result;
#line 730 "rygel-http-server.c"
}


#line 119 "rygel-http-server.vala"
static void rygel_http_server_on_cancelled (RygelHTTPServer* self, GCancellable* cancellable) {
#line 119 "rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 119 "rygel-http-server.vala"
	g_return_if_fail (cancellable != NULL);
#line 121 "rygel-http-server.vala"
	g_cancellable_cancel (rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
#line 123 "rygel-http-server.vala"
	soup_server_remove_handler (gupnp_context_get_server (self->context), self->priv->_path_root);
#line 125 "rygel-http-server.vala"
	g_signal_emit_by_name ((RygelStateMachine*) self, "completed");
#line 746 "rygel-http-server.c"
}


#line 128 "rygel-http-server.vala"
static char* rygel_http_server_real_create_uri_for_item (RygelTranscodeManager* base, RygelMediaItem* item, gint thumbnail_index, const char* transcode_target) {
#line 752 "rygel-http-server.c"
	RygelHTTPServer * self;
	char* result;
	RygelHTTPItemURI* uri;
	self = (RygelHTTPServer*) base;
#line 128 "rygel-http-server.vala"
	g_return_val_if_fail (item != NULL, NULL);
#line 131 "rygel-http-server.vala"
	uri = rygel_http_item_uri_new (((RygelMediaObject*) item)->id, self, thumbnail_index, transcode_target);
#line 761 "rygel-http-server.c"
	result = rygel_http_item_uri_to_string (uri);
	_g_object_unref0 (uri);
#line 136 "rygel-http-server.vala"
	return result;
#line 766 "rygel-http-server.c"
}


#line 139 "rygel-http-server.vala"
static char* rygel_http_server_real_get_protocol (RygelTranscodeManager* base) {
#line 772 "rygel-http-server.c"
	RygelHTTPServer * self;
	char* result;
	self = (RygelHTTPServer*) base;
	result = g_strdup ("http-get");
#line 140 "rygel-http-server.vala"
	return result;
#line 779 "rygel-http-server.c"
}


#line 143 "rygel-http-server.vala"
static char* rygel_http_server_real_get_protocol_info (RygelTranscodeManager* base) {
#line 785 "rygel-http-server.c"
	RygelHTTPServer * self;
	char* result;
	char* _tmp0_;
	char* _tmp1_;
	char* protocol_info;
	char* base_info;
	self = (RygelHTTPServer*) base;
#line 144 "rygel-http-server.vala"
	protocol_info = (_tmp1_ = g_strconcat (_tmp0_ = rygel_transcode_manager_get_protocol ((RygelTranscodeManager*) self), ":*:*:*", NULL), _g_free0 (_tmp0_), _tmp1_);
#line 145 "rygel-http-server.vala"
	base_info = RYGEL_TRANSCODE_MANAGER_CLASS (rygel_http_server_parent_class)->get_protocol_info (RYGEL_TRANSCODE_MANAGER (self));
#line 147 "rygel-http-server.vala"
	if (_vala_strcmp0 (base_info, "") != 0) {
#line 799 "rygel-http-server.c"
		char* _tmp3_;
		char* _tmp2_;
#line 148 "rygel-http-server.vala"
		protocol_info = (_tmp3_ = g_strconcat (protocol_info, _tmp2_ = g_strconcat (",", base_info, NULL), NULL), _g_free0 (protocol_info), _tmp3_);
#line 804 "rygel-http-server.c"
		_g_free0 (_tmp2_);
	}
	result = protocol_info;
	_g_free0 (base_info);
#line 150 "rygel-http-server.vala"
	return result;
#line 811 "rygel-http-server.c"
}


#line 153 "rygel-http-server.vala"
static void rygel_http_server_on_request_completed (RygelHTTPServer* self, RygelHTTPRequest* request) {
#line 817 "rygel-http-server.c"
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_ = NULL;
#line 153 "rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 153 "rygel-http-server.vala"
	g_return_if_fail (request != NULL);
#line 154 "rygel-http-server.vala"
	gee_abstract_collection_remove ((GeeAbstractCollection*) self->priv->requests, request);
#line 156 "rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:156: HTTP %s request for URI '%s' handled.", _tmp1_ = (g_object_get (request->msg, "method", &_tmp0_, NULL), _tmp0_), _tmp2_ = soup_uri_to_string (soup_message_get_uri (request->msg), FALSE));
#line 829 "rygel-http-server.c"
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
}


#line 169 "rygel-http-server.vala"
static void _lambda0_ (const char* name, const char* value, RygelHTTPServer* self) {
#line 169 "rygel-http-server.vala"
	g_return_if_fail (name != NULL);
#line 169 "rygel-http-server.vala"
	g_return_if_fail (value != NULL);
#line 170 "rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:170: %s : %s", name, value);
#line 843 "rygel-http-server.c"
}


#line 169 "rygel-http-server.vala"
static void __lambda0__soup_message_headers_foreach_func (const char* name, const char* value, gpointer self) {
#line 849 "rygel-http-server.c"
	_lambda0_ (name, value, self);
}


#line 161 "rygel-http-server.vala"
static void rygel_http_server_server_handler (RygelHTTPServer* self, SoupServer* server, SoupMessage* msg, const char* server_path, GHashTable* query, SoupClientContext* soup_client) {
#line 856 "rygel-http-server.c"
	char* _tmp2_;
	char* _tmp1_;
	char* _tmp0_ = NULL;
	RygelHTTPGet* _tmp3_;
#line 161 "rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 161 "rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 161 "rygel-http-server.vala"
	g_return_if_fail (msg != NULL);
#line 161 "rygel-http-server.vala"
	g_return_if_fail (server_path != NULL);
#line 161 "rygel-http-server.vala"
	g_return_if_fail (soup_client != NULL);
#line 166 "rygel-http-server.vala"
	g_debug ("rygel-http-server.vala:166: HTTP %s request for URI '%s'. Headers:", _tmp1_ = (g_object_get (msg, "method", &_tmp0_, NULL), _tmp0_), _tmp2_ = soup_uri_to_string (soup_message_get_uri (msg), FALSE));
#line 873 "rygel-http-server.c"
	_g_free0 (_tmp2_);
	_g_free0 (_tmp1_);
#line 169 "rygel-http-server.vala"
	soup_message_headers_foreach (msg->request_headers, __lambda0__soup_message_headers_foreach_func, self);
#line 173 "rygel-http-server.vala"
	rygel_http_server_queue_request (self, (RygelHTTPRequest*) (_tmp3_ = rygel_http_get_new (self, server, msg, query)));
#line 880 "rygel-http-server.c"
	_g_object_unref0 (_tmp3_);
}


#line 176 "rygel-http-server.vala"
static void rygel_http_server_on_request_aborted (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
#line 176 "rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 176 "rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 176 "rygel-http-server.vala"
	g_return_if_fail (message != NULL);
#line 176 "rygel-http-server.vala"
	g_return_if_fail (client != NULL);
#line 895 "rygel-http-server.c"
	{
		GeeIterator* _request_it;
		_request_it = gee_abstract_collection_iterator ((GeeAbstractCollection*) self->priv->requests);
#line 179 "rygel-http-server.vala"
		while (TRUE) {
#line 901 "rygel-http-server.c"
			RygelHTTPRequest* request;
#line 179 "rygel-http-server.vala"
			if (!gee_iterator_next (_request_it)) {
#line 179 "rygel-http-server.vala"
				break;
#line 907 "rygel-http-server.c"
			}
#line 179 "rygel-http-server.vala"
			request = (RygelHTTPRequest*) gee_iterator_get (_request_it);
#line 180 "rygel-http-server.vala"
			if (request->msg == message) {
#line 913 "rygel-http-server.c"
				char* _tmp2_;
				char* _tmp1_;
				char* _tmp0_ = NULL;
#line 181 "rygel-http-server.vala"
				g_cancellable_cancel (rygel_state_machine_get_cancellable ((RygelStateMachine*) request));
#line 182 "rygel-http-server.vala"
				g_debug ("rygel-http-server.vala:182: HTTP client aborted %s request for URI '%s'.", _tmp1_ = (g_object_get (request->msg, "method", &_tmp0_, NULL), _tmp0_), _tmp2_ = soup_uri_to_string (soup_message_get_uri (request->msg), FALSE));
#line 921 "rygel-http-server.c"
				_g_free0 (_tmp2_);
				_g_free0 (_tmp1_);
				_g_object_unref0 (request);
#line 186 "rygel-http-server.vala"
				break;
#line 927 "rygel-http-server.c"
			}
			_g_object_unref0 (request);
		}
		_g_object_unref0 (_request_it);
	}
}


#line 197 "rygel-http-server.vala"
static void _rygel_http_server_on_got_headers_soup_message_got_headers (SoupMessage* _sender, gpointer self) {
#line 938 "rygel-http-server.c"
	rygel_http_server_on_got_headers (self, _sender);
}


#line 191 "rygel-http-server.vala"
static void rygel_http_server_on_request_started (RygelHTTPServer* self, SoupServer* server, SoupMessage* message, SoupClientContext* client) {
#line 191 "rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 191 "rygel-http-server.vala"
	g_return_if_fail (server != NULL);
#line 191 "rygel-http-server.vala"
	g_return_if_fail (message != NULL);
#line 191 "rygel-http-server.vala"
	g_return_if_fail (client != NULL);
#line 194 "rygel-http-server.vala"
	g_signal_connect_object (message, "got-headers", (GCallback) _rygel_http_server_on_got_headers_soup_message_got_headers, self, 0);
#line 955 "rygel-http-server.c"
}


#line 197 "rygel-http-server.vala"
static void rygel_http_server_on_got_headers (RygelHTTPServer* self, SoupMessage* msg) {
#line 961 "rygel-http-server.c"
	gboolean _tmp0_ = FALSE;
	char* _tmp2_;
	char* _tmp1_ = NULL;
	gboolean _tmp3_;
#line 197 "rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 197 "rygel-http-server.vala"
	g_return_if_fail (msg != NULL);
#line 198 "rygel-http-server.vala"
	if ((_tmp3_ = _vala_strcmp0 (_tmp2_ = (g_object_get (msg, "method", &_tmp1_, NULL), _tmp1_), "POST") == 0, _g_free0 (_tmp2_), _tmp3_)) {
#line 199 "rygel-http-server.vala"
		_tmp0_ = g_str_has_prefix (soup_message_get_uri (msg)->path, self->priv->_path_root);
#line 974 "rygel-http-server.c"
	} else {
#line 198 "rygel-http-server.vala"
		_tmp0_ = FALSE;
#line 978 "rygel-http-server.c"
	}
#line 198 "rygel-http-server.vala"
	if (_tmp0_) {
#line 982 "rygel-http-server.c"
		char* _tmp4_;
		RygelHTTPPost* _tmp5_;
#line 200 "rygel-http-server.vala"
		g_debug ("rygel-http-server.vala:200: HTTP POST request for URI '%s'", _tmp4_ = soup_uri_to_string (soup_message_get_uri (msg), FALSE));
#line 987 "rygel-http-server.c"
		_g_free0 (_tmp4_);
#line 203 "rygel-http-server.vala"
		rygel_http_server_queue_request (self, (RygelHTTPRequest*) (_tmp5_ = rygel_http_post_new (self, gupnp_context_get_server (self->context), msg)));
#line 991 "rygel-http-server.c"
		_g_object_unref0 (_tmp5_);
	}
}


#line 153 "rygel-http-server.vala"
static void _rygel_http_server_on_request_completed_rygel_state_machine_completed (RygelHTTPRequest* _sender, gpointer self) {
#line 999 "rygel-http-server.c"
	rygel_http_server_on_request_completed (self, _sender);
}


#line 207 "rygel-http-server.vala"
static void rygel_http_server_queue_request (RygelHTTPServer* self, RygelHTTPRequest* request) {
#line 207 "rygel-http-server.vala"
	g_return_if_fail (self != NULL);
#line 207 "rygel-http-server.vala"
	g_return_if_fail (request != NULL);
#line 208 "rygel-http-server.vala"
	g_signal_connect_object ((RygelStateMachine*) request, "completed", (GCallback) _rygel_http_server_on_request_completed_rygel_state_machine_completed, self, 0);
#line 209 "rygel-http-server.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) self->priv->requests, request);
#line 210 "rygel-http-server.vala"
	rygel_state_machine_run ((RygelStateMachine*) request, NULL, NULL);
#line 1016 "rygel-http-server.c"
}


const char* rygel_http_server_get_path_root (RygelHTTPServer* self) {
	const char* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_path_root;
#line 30 "rygel-http-server.vala"
	return result;
#line 1026 "rygel-http-server.c"
}


static void rygel_http_server_set_path_root (RygelHTTPServer* self, const char* value) {
	char* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_path_root = (_tmp0_ = g_strdup (value), _g_free0 (self->priv->_path_root), _tmp0_);
	g_object_notify ((GObject *) self, "path-root");
}


static GCancellable* rygel_http_server_real_get_cancellable (RygelStateMachine* base) {
	GCancellable* result;
	RygelHTTPServer* self;
	self = (RygelHTTPServer*) base;
	result = self->priv->_cancellable;
#line 37 "rygel-http-server.vala"
	return result;
#line 1045 "rygel-http-server.c"
}


static void rygel_http_server_real_set_cancellable (RygelStateMachine* base, GCancellable* value) {
	RygelHTTPServer* self;
	GCancellable* _tmp0_;
	self = (RygelHTTPServer*) base;
	self->priv->_cancellable = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_cancellable), _tmp0_);
	g_object_notify ((GObject *) self, "cancellable");
}


static void rygel_http_server_class_init (RygelHTTPServerClass * klass) {
	rygel_http_server_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPServerPrivate));
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->add_resources = rygel_http_server_real_add_resources;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->create_uri_for_item = rygel_http_server_real_create_uri_for_item;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol = rygel_http_server_real_get_protocol;
	RYGEL_TRANSCODE_MANAGER_CLASS (klass)->get_protocol_info = rygel_http_server_real_get_protocol_info;
	G_OBJECT_CLASS (klass)->get_property = rygel_http_server_get_property;
	G_OBJECT_CLASS (klass)->set_property = rygel_http_server_set_property;
	G_OBJECT_CLASS (klass)->finalize = rygel_http_server_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_PATH_ROOT, g_param_spec_string ("path-root", "path-root", "path-root", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_override_property (G_OBJECT_CLASS (klass), RYGEL_HTTP_SERVER_CANCELLABLE, "cancellable");
}


static void rygel_http_server_rygel_state_machine_interface_init (RygelStateMachineIface * iface) {
	rygel_http_server_rygel_state_machine_parent_iface = g_type_interface_peek_parent (iface);
	iface->run = rygel_http_server_real_run;
	iface->run_finish = rygel_http_server_real_run_finish;
	iface->get_cancellable = rygel_http_server_real_get_cancellable;
	iface->set_cancellable = rygel_http_server_real_set_cancellable;
}


static void rygel_http_server_instance_init (RygelHTTPServer * self) {
	self->priv = RYGEL_HTTP_SERVER_GET_PRIVATE (self);
}


static void rygel_http_server_finalize (GObject* obj) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (obj);
	_g_free0 (self->priv->_path_root);
	_g_object_unref0 (self->root_container);
	_g_object_unref0 (self->context);
	_g_object_unref0 (self->priv->requests);
	_g_object_unref0 (self->priv->_cancellable);
	G_OBJECT_CLASS (rygel_http_server_parent_class)->finalize (obj);
}


GType rygel_http_server_get_type (void) {
	static GType rygel_http_server_type_id = 0;
	if (rygel_http_server_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPServerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_server_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPServer), 0, (GInstanceInitFunc) rygel_http_server_instance_init, NULL };
		static const GInterfaceInfo rygel_state_machine_info = { (GInterfaceInitFunc) rygel_http_server_rygel_state_machine_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		rygel_http_server_type_id = g_type_register_static (RYGEL_TYPE_TRANSCODE_MANAGER, "RygelHTTPServer", &g_define_type_info, 0);
		g_type_add_interface_static (rygel_http_server_type_id, RYGEL_TYPE_STATE_MACHINE, &rygel_state_machine_info);
	}
	return rygel_http_server_type_id;
}


static void rygel_http_server_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		g_value_set_string (value, rygel_http_server_get_path_root (self));
		break;
		case RYGEL_HTTP_SERVER_CANCELLABLE:
		g_value_set_object (value, rygel_state_machine_get_cancellable ((RygelStateMachine*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void rygel_http_server_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	RygelHTTPServer * self;
	self = RYGEL_HTTP_SERVER (object);
	switch (property_id) {
		case RYGEL_HTTP_SERVER_PATH_ROOT:
		rygel_http_server_set_path_root (self, g_value_get_string (value));
		break;
		case RYGEL_HTTP_SERVER_CANCELLABLE:
		rygel_state_machine_set_cancellable ((RygelStateMachine*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




