/* rygel-database.c generated by valac, the Vala compiler
 * generated from rygel-database.vala, do not modify */

/*
 * Copyright (C) 2009 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <sqlite3.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define RYGEL_TYPE_DATABASE (rygel_database_get_type ())
#define RYGEL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DATABASE, RygelDatabase))
#define RYGEL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DATABASE, RygelDatabaseClass))
#define RYGEL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DATABASE))
#define RYGEL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DATABASE))
#define RYGEL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DATABASE, RygelDatabaseClass))

typedef struct _RygelDatabase RygelDatabase;
typedef struct _RygelDatabaseClass RygelDatabaseClass;
typedef struct _RygelDatabasePrivate RygelDatabasePrivate;
#define _sqlite3_close0(var) ((var == NULL) ? NULL : (var = (sqlite3_close (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))

typedef enum  {
	RYGEL_DATABASE_ERROR_IO_ERROR,
	RYGEL_DATABASE_ERROR_SQLITE_ERROR
} RygelDatabaseError;
#define RYGEL_DATABASE_ERROR rygel_database_error_quark ()
struct _RygelDatabase {
	GObject parent_instance;
	RygelDatabasePrivate * priv;
};

struct _RygelDatabaseClass {
	GObjectClass parent_class;
};

struct _RygelDatabasePrivate {
	sqlite3* db;
};

typedef gboolean (*RygelDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);

static gpointer rygel_database_parent_class = NULL;

GQuark rygel_database_error_quark (void);
GType rygel_database_get_type (void);
#define RYGEL_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DATABASE, RygelDatabasePrivate))
enum  {
	RYGEL_DATABASE_DUMMY_PROPERTY
};
RygelDatabase* rygel_database_new (const char* name, GError** error);
RygelDatabase* rygel_database_construct (GType object_type, const char* name, GError** error);
static sqlite3_stmt* rygel_database_prepare_statement (RygelDatabase* self, const char* sql, GValue* values, int values_length1, GError** error);
gint rygel_database_exec (RygelDatabase* self, const char* sql, GValue* values, int values_length1, RygelDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
void rygel_database_analyze (RygelDatabase* self);
void rygel_database_null (GValue* result);
void rygel_database_begin (RygelDatabase* self, GError** error);
void rygel_database_commit (RygelDatabase* self, GError** error);
void rygel_database_rollback (RygelDatabase* self);
static void rygel_database_finalize (GObject* obj);



GQuark rygel_database_error_quark (void) {
	return g_quark_from_static_string ("rygel_database_error-quark");
}


#line 52 "rygel-database.vala"
RygelDatabase* rygel_database_construct (GType object_type, const char* name, GError** error) {
#line 97 "rygel-database.c"
	GError * _inner_error_;
	RygelDatabase * self;
	char* dirname;
	char* _tmp0_;
	char* _tmp1_;
	char* db_file;
	sqlite3* _tmp4_;
	gint _tmp3_;
	sqlite3* _tmp2_ = NULL;
	gint rc;
#line 52 "rygel-database.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 110 "rygel-database.c"
	_inner_error_ = NULL;
#line 52 "rygel-database.vala"
	self = (RygelDatabase*) g_object_new (object_type, NULL);
#line 53 "rygel-database.vala"
	dirname = g_build_filename (g_get_user_cache_dir (), "rygel", NULL);
#line 55 "rygel-database.vala"
	g_mkdir_with_parents (dirname, 0750);
#line 56 "rygel-database.vala"
	db_file = (_tmp1_ = g_build_filename (dirname, _tmp0_ = g_strdup_printf ("%s.db", name), NULL), _g_free0 (_tmp0_), _tmp1_);
#line 57 "rygel-database.vala"
	g_debug ("rygel-database.vala:57: Using database file %s", db_file);
#line 58 "rygel-database.vala"
	rc = (_tmp3_ = sqlite3_open (db_file, &_tmp2_), self->priv->db = (_tmp4_ = _tmp2_, _sqlite3_close0 (self->priv->db), _tmp4_), _tmp3_);
#line 59 "rygel-database.vala"
	if (rc != SQLITE_OK) {
#line 126 "rygel-database.c"
		char* msg;
#line 60 "rygel-database.vala"
		msg = g_strdup_printf ("Failed to open database: %d, %s", rc, sqlite3_errmsg (self->priv->db));
#line 130 "rygel-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_DATABASE_ERROR, RYGEL_DATABASE_ERROR_IO_ERROR, msg);
		{
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_free0 (msg);
				_g_free0 (dirname);
				_g_free0 (db_file);
				g_object_unref (self);
				return NULL;
			} else {
				_g_free0 (msg);
				_g_free0 (dirname);
				_g_free0 (db_file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
		_g_free0 (msg);
	}
#line 67 "rygel-database.vala"
	sqlite3_exec (self->priv->db, "PRAGMA cache_size = 32768", NULL, NULL, NULL);
#line 68 "rygel-database.vala"
	sqlite3_exec (self->priv->db, "PRAGMA synchronous = OFF", NULL, NULL, NULL);
#line 69 "rygel-database.vala"
	sqlite3_exec (self->priv->db, "PRAGMA temp_store = MEMORY", NULL, NULL, NULL);
#line 70 "rygel-database.vala"
	sqlite3_exec (self->priv->db, "PRAGMA count_changes = OFF", NULL, NULL, NULL);
#line 159 "rygel-database.c"
	_g_free0 (dirname);
	_g_free0 (db_file);
	return self;
}


#line 52 "rygel-database.vala"
RygelDatabase* rygel_database_new (const char* name, GError** error) {
#line 52 "rygel-database.vala"
	return rygel_database_construct (RYGEL_TYPE_DATABASE, name, error);
#line 170 "rygel-database.c"
}


#line 87 "rygel-database.vala"
gint rygel_database_exec (RygelDatabase* self, const char* sql, GValue* values, int values_length1, RygelDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error) {
#line 176 "rygel-database.c"
	gint result = 0;
	GError * _inner_error_;
	gint rc = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp3_ = FALSE;
#line 87 "rygel-database.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 87 "rygel-database.vala"
	g_return_val_if_fail (sql != NULL, 0);
#line 187 "rygel-database.c"
	_inner_error_ = NULL;
#line 96 "rygel-database.vala"
	if (values == NULL) {
#line 96 "rygel-database.vala"
		_tmp1_ = callback == NULL;
#line 193 "rygel-database.c"
	} else {
#line 96 "rygel-database.vala"
		_tmp1_ = FALSE;
#line 197 "rygel-database.c"
	}
#line 96 "rygel-database.vala"
	if (_tmp1_) {
#line 96 "rygel-database.vala"
		_tmp0_ = cancellable == NULL;
#line 203 "rygel-database.c"
	} else {
#line 96 "rygel-database.vala"
		_tmp0_ = FALSE;
#line 207 "rygel-database.c"
	}
#line 96 "rygel-database.vala"
	if (_tmp0_) {
#line 97 "rygel-database.vala"
		rc = sqlite3_exec (self->priv->db, sql, NULL, NULL, NULL);
#line 213 "rygel-database.c"
	} else {
		sqlite3_stmt* statement;
#line 99 "rygel-database.vala"
		statement = rygel_database_prepare_statement (self, sql, values, values_length1, &_inner_error_);
#line 218 "rygel-database.c"
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
#line 100 "rygel-database.vala"
		while (TRUE) {
#line 231 "rygel-database.c"
			gboolean _tmp2_ = FALSE;
#line 100 "rygel-database.vala"
			if (!((rc = sqlite3_step (statement)) == SQLITE_ROW)) {
#line 100 "rygel-database.vala"
				break;
#line 237 "rygel-database.c"
			}
#line 101 "rygel-database.vala"
			if (cancellable != NULL) {
#line 101 "rygel-database.vala"
				_tmp2_ = g_cancellable_is_cancelled (cancellable);
#line 243 "rygel-database.c"
			} else {
#line 101 "rygel-database.vala"
				_tmp2_ = FALSE;
#line 247 "rygel-database.c"
			}
#line 101 "rygel-database.vala"
			if (_tmp2_) {
#line 102 "rygel-database.vala"
				break;
#line 253 "rygel-database.c"
			}
#line 105 "rygel-database.vala"
			if (callback != NULL) {
#line 106 "rygel-database.vala"
				if (!callback (statement, callback_target)) {
#line 107 "rygel-database.vala"
					rc = SQLITE_DONE;
#line 109 "rygel-database.vala"
					break;
#line 263 "rygel-database.c"
				}
			}
		}
		_sqlite3_finalize0 (statement);
	}
#line 115 "rygel-database.vala"
	if (rc != SQLITE_DONE) {
#line 115 "rygel-database.vala"
		_tmp3_ = rc != SQLITE_OK;
#line 273 "rygel-database.c"
	} else {
#line 115 "rygel-database.vala"
		_tmp3_ = FALSE;
#line 277 "rygel-database.c"
	}
#line 115 "rygel-database.vala"
	if (_tmp3_) {
#line 281 "rygel-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_DATABASE_ERROR, RYGEL_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return 0;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return 0;
			}
		}
	}
	result = rc;
#line 122 "rygel-database.vala"
	return result;
#line 297 "rygel-database.c"
}


#line 139 "rygel-database.vala"
static sqlite3_stmt* rygel_database_prepare_statement (RygelDatabase* self, const char* sql, GValue* values, int values_length1, GError** error) {
#line 303 "rygel-database.c"
	sqlite3_stmt* result = NULL;
	GError * _inner_error_;
	sqlite3_stmt* statement;
	sqlite3_stmt* _tmp2_;
	gint _tmp1_;
	sqlite3_stmt* _tmp0_ = NULL;
	gint rc;
#line 139 "rygel-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 139 "rygel-database.vala"
	g_return_val_if_fail (sql != NULL, NULL);
#line 315 "rygel-database.c"
	_inner_error_ = NULL;
	statement = NULL;
#line 143 "rygel-database.vala"
	rc = (_tmp1_ = sqlite3_prepare_v2 (self->priv->db, sql, -1, &_tmp0_, NULL), statement = (_tmp2_ = _tmp0_, _sqlite3_finalize0 (statement), _tmp2_), _tmp1_);
#line 144 "rygel-database.vala"
	if (rc != SQLITE_OK) {
#line 322 "rygel-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_DATABASE_ERROR, RYGEL_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				_sqlite3_finalize0 (statement);
				return NULL;
			} else {
				_sqlite3_finalize0 (statement);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
#line 147 "rygel-database.vala"
	if (values != NULL) {
#line 339 "rygel-database.c"
		{
			gint i;
#line 148 "rygel-database.vala"
			i = 0;
#line 344 "rygel-database.c"
			{
				gboolean _tmp3_;
#line 148 "rygel-database.vala"
				_tmp3_ = TRUE;
#line 148 "rygel-database.vala"
				while (TRUE) {
#line 351 "rygel-database.c"
					GValue _tmp4_;
#line 148 "rygel-database.vala"
					if (!_tmp3_) {
#line 148 "rygel-database.vala"
						i++;
#line 357 "rygel-database.c"
					}
#line 148 "rygel-database.vala"
					_tmp3_ = FALSE;
#line 148 "rygel-database.vala"
					if (!(i < values_length1)) {
#line 148 "rygel-database.vala"
						break;
#line 365 "rygel-database.c"
					}
#line 149 "rygel-database.vala"
					if (G_VALUE_HOLDS ((_tmp4_ = values[i], &_tmp4_), G_TYPE_INT)) {
#line 369 "rygel-database.c"
						GValue _tmp5_;
#line 150 "rygel-database.vala"
						rc = sqlite3_bind_int (statement, i + 1, g_value_get_int ((_tmp5_ = values[i], &_tmp5_)));
#line 373 "rygel-database.c"
					} else {
						GValue _tmp6_;
#line 151 "rygel-database.vala"
						if (G_VALUE_HOLDS ((_tmp6_ = values[i], &_tmp6_), G_TYPE_INT64)) {
#line 378 "rygel-database.c"
							GValue _tmp7_;
#line 152 "rygel-database.vala"
							rc = sqlite3_bind_int64 (statement, i + 1, g_value_get_int64 ((_tmp7_ = values[i], &_tmp7_)));
#line 382 "rygel-database.c"
						} else {
							GValue _tmp8_;
#line 153 "rygel-database.vala"
							if (G_VALUE_HOLDS ((_tmp8_ = values[i], &_tmp8_), G_TYPE_LONG)) {
#line 387 "rygel-database.c"
								GValue _tmp9_;
#line 154 "rygel-database.vala"
								rc = sqlite3_bind_int64 (statement, i + 1, (gint64) g_value_get_long ((_tmp9_ = values[i], &_tmp9_)));
#line 391 "rygel-database.c"
							} else {
								GValue _tmp10_;
#line 155 "rygel-database.vala"
								if (G_VALUE_HOLDS ((_tmp10_ = values[i], &_tmp10_), G_TYPE_STRING)) {
#line 396 "rygel-database.c"
									GValue _tmp11_;
#line 156 "rygel-database.vala"
									rc = sqlite3_bind_text (statement, i + 1, g_strdup (g_value_get_string ((_tmp11_ = values[i], &_tmp11_))), -1, g_free);
#line 400 "rygel-database.c"
								} else {
									GValue _tmp12_;
#line 157 "rygel-database.vala"
									if (G_VALUE_HOLDS ((_tmp12_ = values[i], &_tmp12_), G_TYPE_POINTER)) {
#line 405 "rygel-database.c"
										GValue _tmp13_;
#line 158 "rygel-database.vala"
										if (g_value_peek_pointer ((_tmp13_ = values[i], &_tmp13_)) == NULL) {
#line 159 "rygel-database.vala"
											rc = sqlite3_bind_null (statement, i + 1);
#line 411 "rygel-database.c"
										} else {
#line 161 "rygel-database.vala"
											g_assert_not_reached ();
#line 415 "rygel-database.c"
										}
									} else {
										GValue _tmp14_;
										GType t;
#line 164 "rygel-database.vala"
										t = G_VALUE_TYPE ((_tmp14_ = values[i], &_tmp14_));
#line 165 "rygel-database.vala"
										g_warning ("rygel-database.vala:165: Unsupported type %s", g_type_name (t));
#line 166 "rygel-database.vala"
										g_assert_not_reached ();
#line 426 "rygel-database.c"
									}
								}
							}
						}
					}
#line 168 "rygel-database.vala"
					if (rc != SQLITE_OK) {
#line 434 "rygel-database.c"
						_inner_error_ = g_error_new_literal (RYGEL_DATABASE_ERROR, RYGEL_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
						{
							if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
								g_propagate_error (error, _inner_error_);
								_sqlite3_finalize0 (statement);
								return NULL;
							} else {
								_sqlite3_finalize0 (statement);
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return NULL;
							}
						}
					}
				}
			}
		}
	}
	result = statement;
#line 174 "rygel-database.vala"
	return result;
#line 456 "rygel-database.c"
}


#line 180 "rygel-database.vala"
void rygel_database_analyze (RygelDatabase* self) {
#line 180 "rygel-database.vala"
	g_return_if_fail (self != NULL);
#line 181 "rygel-database.vala"
	sqlite3_exec (self->priv->db, "ANALYZE", NULL, NULL, NULL);
#line 466 "rygel-database.c"
}


#line 188 "rygel-database.vala"
void rygel_database_null (GValue* result) {
#line 472 "rygel-database.c"
	GValue v = {0};
	g_value_init (&v, G_TYPE_POINTER);
#line 190 "rygel-database.vala"
	g_value_set_pointer (&v, NULL);
#line 477 "rygel-database.c"
	*result = v;
#line 192 "rygel-database.vala"
	return;
#line 481 "rygel-database.c"
}


#line 198 "rygel-database.vala"
void rygel_database_begin (RygelDatabase* self, GError** error) {
#line 487 "rygel-database.c"
	GError * _inner_error_;
#line 198 "rygel-database.vala"
	g_return_if_fail (self != NULL);
#line 491 "rygel-database.c"
	_inner_error_ = NULL;
#line 199 "rygel-database.vala"
	if (sqlite3_exec (self->priv->db, "BEGIN", NULL, NULL, NULL) != SQLITE_OK) {
#line 495 "rygel-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_DATABASE_ERROR, RYGEL_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


#line 207 "rygel-database.vala"
void rygel_database_commit (RygelDatabase* self, GError** error) {
#line 513 "rygel-database.c"
	GError * _inner_error_;
#line 207 "rygel-database.vala"
	g_return_if_fail (self != NULL);
#line 517 "rygel-database.c"
	_inner_error_ = NULL;
#line 208 "rygel-database.vala"
	if (sqlite3_exec (self->priv->db, "COMMIT", NULL, NULL, NULL) != SQLITE_OK) {
#line 521 "rygel-database.c"
		_inner_error_ = g_error_new_literal (RYGEL_DATABASE_ERROR, RYGEL_DATABASE_ERROR_SQLITE_ERROR, sqlite3_errmsg (self->priv->db));
		{
			if (_inner_error_->domain == RYGEL_DATABASE_ERROR) {
				g_propagate_error (error, _inner_error_);
				return;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
	}
}


#line 216 "rygel-database.vala"
void rygel_database_rollback (RygelDatabase* self) {
#line 216 "rygel-database.vala"
	g_return_if_fail (self != NULL);
#line 217 "rygel-database.vala"
	if (sqlite3_exec (self->priv->db, "ROLLBACK", NULL, NULL, NULL) != SQLITE_OK) {
#line 218 "rygel-database.vala"
		g_critical ("rygel-database.vala:218: Failed to rollback transaction: %s", sqlite3_errmsg (self->priv->db));
#line 545 "rygel-database.c"
	}
}


static void rygel_database_class_init (RygelDatabaseClass * klass) {
	rygel_database_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelDatabasePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_database_finalize;
}


static void rygel_database_instance_init (RygelDatabase * self) {
	self->priv = RYGEL_DATABASE_GET_PRIVATE (self);
}


static void rygel_database_finalize (GObject* obj) {
	RygelDatabase * self;
	self = RYGEL_DATABASE (obj);
	_sqlite3_close0 (self->priv->db);
	G_OBJECT_CLASS (rygel_database_parent_class)->finalize (obj);
}


GType rygel_database_get_type (void) {
	static volatile gsize rygel_database_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_database_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDatabase), 0, (GInstanceInitFunc) rygel_database_instance_init, NULL };
		GType rygel_database_type_id;
		rygel_database_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelDatabase", &g_define_type_info, 0);
		g_once_init_leave (&rygel_database_type_id__volatile, rygel_database_type_id);
	}
	return rygel_database_type_id__volatile;
}




