/* rygel-http-byte-seek-test.c generated by valac, the Vala compiler
 * generated from rygel-http-byte-seek-test.vala, do not modify */

/*
 * Copyright (C) 2010 Nokia Corporation.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshan.ali@nokia.com>
 *                               <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <libsoup/soup.h>
#include <stdlib.h>
#include <string.h>


#define RYGEL_TYPE_HTTP_IDENTITY_HANDLER (rygel_http_identity_handler_get_type ())
#define RYGEL_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandler))
#define RYGEL_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_IS_HTTP_IDENTITY_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_IDENTITY_HANDLER))
#define RYGEL_HTTP_IDENTITY_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_IDENTITY_HANDLER, RygelHTTPIdentityHandlerClass))

typedef struct _RygelHTTPIdentityHandler RygelHTTPIdentityHandler;
typedef struct _RygelHTTPIdentityHandlerClass RygelHTTPIdentityHandlerClass;
typedef struct _RygelHTTPIdentityHandlerPrivate RygelHTTPIdentityHandlerPrivate;

#define RYGEL_TYPE_MEDIA_ITEM (rygel_media_item_get_type ())
#define RYGEL_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItem))
#define RYGEL_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))
#define RYGEL_IS_MEDIA_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_IS_MEDIA_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_ITEM))
#define RYGEL_MEDIA_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_ITEM, RygelMediaItemClass))

typedef struct _RygelMediaItem RygelMediaItem;
typedef struct _RygelMediaItemClass RygelMediaItemClass;
typedef struct _RygelMediaItemPrivate RygelMediaItemPrivate;

#define RYGEL_TYPE_THUMBNAIL (rygel_thumbnail_get_type ())
#define RYGEL_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnail))
#define RYGEL_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))
#define RYGEL_IS_THUMBNAIL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_IS_THUMBNAIL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_THUMBNAIL))
#define RYGEL_THUMBNAIL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_THUMBNAIL, RygelThumbnailClass))

typedef struct _RygelThumbnail RygelThumbnail;
typedef struct _RygelThumbnailClass RygelThumbnailClass;
typedef struct _RygelThumbnailPrivate RygelThumbnailPrivate;

#define RYGEL_TYPE_SUBTITLE (rygel_subtitle_get_type ())
#define RYGEL_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitle))
#define RYGEL_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))
#define RYGEL_IS_SUBTITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_SUBTITLE))
#define RYGEL_IS_SUBTITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_SUBTITLE))
#define RYGEL_SUBTITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_SUBTITLE, RygelSubtitleClass))

typedef struct _RygelSubtitle RygelSubtitle;
typedef struct _RygelSubtitleClass RygelSubtitleClass;
typedef struct _RygelSubtitlePrivate RygelSubtitlePrivate;

#define RYGEL_TYPE_HTTP_GET (rygel_http_get_get_type ())
#define RYGEL_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGet))
#define RYGEL_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))
#define RYGEL_IS_HTTP_GET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_GET))
#define RYGEL_IS_HTTP_GET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_GET))
#define RYGEL_HTTP_GET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_GET, RygelHTTPGetClass))

typedef struct _RygelHTTPGet RygelHTTPGet;
typedef struct _RygelHTTPGetClass RygelHTTPGetClass;
typedef struct _RygelHTTPGetPrivate RygelHTTPGetPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define RYGEL_TYPE_HTTP_BYTE_SEEK_TEST (rygel_http_byte_seek_test_get_type ())
#define RYGEL_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTest))
#define RYGEL_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_IS_HTTP_BYTE_SEEK_TEST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST))
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestClass))

typedef struct _RygelHTTPByteSeekTest RygelHTTPByteSeekTest;
typedef struct _RygelHTTPByteSeekTestClass RygelHTTPByteSeekTestClass;
typedef struct _RygelHTTPByteSeekTestPrivate RygelHTTPByteSeekTestPrivate;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define RYGEL_TYPE_HTTP_SEEK (rygel_http_seek_get_type ())
#define RYGEL_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeek))
#define RYGEL_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))
#define RYGEL_IS_HTTP_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_IS_HTTP_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_SEEK))
#define RYGEL_HTTP_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_SEEK, RygelHTTPSeekClass))

typedef struct _RygelHTTPSeek RygelHTTPSeek;
typedef struct _RygelHTTPSeekClass RygelHTTPSeekClass;

#define RYGEL_TYPE_HTTP_BYTE_SEEK (rygel_http_byte_seek_get_type ())
#define RYGEL_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeek))
#define RYGEL_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))
#define RYGEL_IS_HTTP_BYTE_SEEK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_IS_HTTP_BYTE_SEEK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_HTTP_BYTE_SEEK))
#define RYGEL_HTTP_BYTE_SEEK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_HTTP_BYTE_SEEK, RygelHTTPByteSeekClass))

typedef struct _RygelHTTPByteSeek RygelHTTPByteSeek;
typedef struct _RygelHTTPByteSeekClass RygelHTTPByteSeekClass;
#define _g_free0(var) (var = (g_free (var), NULL))

typedef enum  {
	RYGEL_TEST_ERROR_SKIP
} RygelTestError;
#define RYGEL_TEST_ERROR rygel_test_error_quark ()
struct _RygelHTTPIdentityHandler {
	GObject parent_instance;
	RygelHTTPIdentityHandlerPrivate * priv;
};

struct _RygelHTTPIdentityHandlerClass {
	GObjectClass parent_class;
};

struct _RygelMediaItem {
	GObject parent_instance;
	RygelMediaItemPrivate * priv;
	gint64 size;
};

struct _RygelMediaItemClass {
	GObjectClass parent_class;
};

struct _RygelThumbnail {
	GObject parent_instance;
	RygelThumbnailPrivate * priv;
	gint64 size;
};

struct _RygelThumbnailClass {
	GObjectClass parent_class;
};

struct _RygelSubtitle {
	GObject parent_instance;
	RygelSubtitlePrivate * priv;
	gint64 size;
};

struct _RygelSubtitleClass {
	GObjectClass parent_class;
};

struct _RygelHTTPGet {
	GObject parent_instance;
	RygelHTTPGetPrivate * priv;
	SoupMessage* msg;
	RygelMediaItem* item;
	RygelThumbnail* thumbnail;
	RygelSubtitle* subtitle;
	RygelHTTPIdentityHandler* handler;
};

struct _RygelHTTPGetClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTest {
	GObject parent_instance;
	RygelHTTPByteSeekTestPrivate * priv;
};

struct _RygelHTTPByteSeekTestClass {
	GObjectClass parent_class;
};

struct _RygelHTTPByteSeekTestPrivate {
	GRegex* range_regex;
};

typedef enum  {
	RYGEL_HTTP_SEEK_ERROR_INVALID_RANGE = SOUP_STATUS_BAD_REQUEST,
	RYGEL_HTTP_SEEK_ERROR_OUT_OF_RANGE = SOUP_STATUS_REQUESTED_RANGE_NOT_SATISFIABLE
} RygelHTTPSeekError;
#define RYGEL_HTTP_SEEK_ERROR rygel_http_seek_error_quark ()

static gpointer rygel_http_identity_handler_parent_class = NULL;
static gpointer rygel_media_item_parent_class = NULL;
static gpointer rygel_thumbnail_parent_class = NULL;
static gpointer rygel_subtitle_parent_class = NULL;
static gpointer rygel_http_get_parent_class = NULL;
static gpointer rygel_http_byte_seek_test_parent_class = NULL;

GQuark rygel_test_error_quark (void);
GType rygel_http_identity_handler_get_type (void);
enum  {
	RYGEL_HTTP_IDENTITY_HANDLER_DUMMY_PROPERTY
};
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void);
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type);
GType rygel_media_item_get_type (void);
enum  {
	RYGEL_MEDIA_ITEM_DUMMY_PROPERTY
};
RygelMediaItem* rygel_media_item_new (void);
RygelMediaItem* rygel_media_item_construct (GType object_type);
static void rygel_media_item_finalize (GObject* obj);
GType rygel_thumbnail_get_type (void);
enum  {
	RYGEL_THUMBNAIL_DUMMY_PROPERTY
};
RygelThumbnail* rygel_thumbnail_new (void);
RygelThumbnail* rygel_thumbnail_construct (GType object_type);
static void rygel_thumbnail_finalize (GObject* obj);
GType rygel_subtitle_get_type (void);
enum  {
	RYGEL_SUBTITLE_DUMMY_PROPERTY
};
RygelSubtitle* rygel_subtitle_new (void);
RygelSubtitle* rygel_subtitle_construct (GType object_type);
static void rygel_subtitle_finalize (GObject* obj);
GType rygel_http_get_get_type (void);
enum  {
	RYGEL_HTTP_GET_DUMMY_PROPERTY
};
#define RYGEL_HTTP_GET_ITEM_URI "http://DoesntMatterWhatThisIs"
RygelHTTPGet* rygel_http_get_new (void);
RygelHTTPGet* rygel_http_get_construct (GType object_type);
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start);
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start);
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop);
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop);
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop);
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop);
static void rygel_http_get_finalize (GObject* obj);
GType rygel_http_byte_seek_test_get_type (void);
#define RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_HTTP_BYTE_SEEK_TEST, RygelHTTPByteSeekTestPrivate))
enum  {
	RYGEL_HTTP_BYTE_SEEK_TEST_DUMMY_PROPERTY
};
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void);
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type);
GQuark rygel_http_seek_error_quark (void);
void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error);
gint rygel_http_byte_seek_test_main (char** args, int args_length1);
static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, GError** error);
static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, GError** error);
static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, GError** error);
static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, GError** error);
static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error);
gboolean rygel_http_byte_seek_needed (RygelHTTPGet* request);
RygelHTTPByteSeek* rygel_http_byte_seek_new (RygelHTTPGet* request, GError** error);
RygelHTTPByteSeek* rygel_http_byte_seek_construct (GType object_type, RygelHTTPGet* request, GError** error);
GType rygel_http_seek_get_type (void);
GType rygel_http_byte_seek_get_type (void);
void rygel_http_seek_add_response_headers (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_start (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_stop (RygelHTTPSeek* self);
gint64 rygel_http_seek_get_length (RygelHTTPSeek* self);
static void rygel_http_byte_seek_test_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



GQuark rygel_test_error_quark (void) {
	return g_quark_from_static_string ("rygel_test_error-quark");
}


#line 28 "rygel-http-byte-seek-test.vala"
RygelHTTPIdentityHandler* rygel_http_identity_handler_construct (GType object_type) {
#line 287 "rygel-http-byte-seek-test.c"
	RygelHTTPIdentityHandler * self;
#line 28 "rygel-http-byte-seek-test.vala"
	self = (RygelHTTPIdentityHandler*) g_object_new (object_type, NULL);
#line 291 "rygel-http-byte-seek-test.c"
	return self;
}


#line 28 "rygel-http-byte-seek-test.vala"
RygelHTTPIdentityHandler* rygel_http_identity_handler_new (void) {
#line 28 "rygel-http-byte-seek-test.vala"
	return rygel_http_identity_handler_construct (RYGEL_TYPE_HTTP_IDENTITY_HANDLER);
#line 300 "rygel-http-byte-seek-test.c"
}


static void rygel_http_identity_handler_class_init (RygelHTTPIdentityHandlerClass * klass) {
	rygel_http_identity_handler_parent_class = g_type_class_peek_parent (klass);
}


static void rygel_http_identity_handler_instance_init (RygelHTTPIdentityHandler * self) {
}


GType rygel_http_identity_handler_get_type (void) {
	static volatile gsize rygel_http_identity_handler_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_identity_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPIdentityHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_identity_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPIdentityHandler), 0, (GInstanceInitFunc) rygel_http_identity_handler_instance_init, NULL };
		GType rygel_http_identity_handler_type_id;
		rygel_http_identity_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPIdentityHandler", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_identity_handler_type_id__volatile, rygel_http_identity_handler_type_id);
	}
	return rygel_http_identity_handler_type_id__volatile;
}


#line 30 "rygel-http-byte-seek-test.vala"
RygelMediaItem* rygel_media_item_construct (GType object_type) {
#line 327 "rygel-http-byte-seek-test.c"
	RygelMediaItem * self;
#line 30 "rygel-http-byte-seek-test.vala"
	self = (RygelMediaItem*) g_object_new (object_type, NULL);
#line 331 "rygel-http-byte-seek-test.c"
	return self;
}


#line 30 "rygel-http-byte-seek-test.vala"
RygelMediaItem* rygel_media_item_new (void) {
#line 30 "rygel-http-byte-seek-test.vala"
	return rygel_media_item_construct (RYGEL_TYPE_MEDIA_ITEM);
#line 340 "rygel-http-byte-seek-test.c"
}


static void rygel_media_item_class_init (RygelMediaItemClass * klass) {
	rygel_media_item_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_media_item_finalize;
}


static void rygel_media_item_instance_init (RygelMediaItem * self) {
	self->size = (gint64) 1024;
}


static void rygel_media_item_finalize (GObject* obj) {
	RygelMediaItem * self;
	self = RYGEL_MEDIA_ITEM (obj);
	G_OBJECT_CLASS (rygel_media_item_parent_class)->finalize (obj);
}


GType rygel_media_item_get_type (void) {
	static volatile gsize rygel_media_item_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaItem), 0, (GInstanceInitFunc) rygel_media_item_instance_init, NULL };
		GType rygel_media_item_type_id;
		rygel_media_item_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaItem", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_item_type_id__volatile, rygel_media_item_type_id);
	}
	return rygel_media_item_type_id__volatile;
}


#line 34 "rygel-http-byte-seek-test.vala"
RygelThumbnail* rygel_thumbnail_construct (GType object_type) {
#line 376 "rygel-http-byte-seek-test.c"
	RygelThumbnail * self;
#line 34 "rygel-http-byte-seek-test.vala"
	self = (RygelThumbnail*) g_object_new (object_type, NULL);
#line 380 "rygel-http-byte-seek-test.c"
	return self;
}


#line 34 "rygel-http-byte-seek-test.vala"
RygelThumbnail* rygel_thumbnail_new (void) {
#line 34 "rygel-http-byte-seek-test.vala"
	return rygel_thumbnail_construct (RYGEL_TYPE_THUMBNAIL);
#line 389 "rygel-http-byte-seek-test.c"
}


static void rygel_thumbnail_class_init (RygelThumbnailClass * klass) {
	rygel_thumbnail_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_thumbnail_finalize;
}


static void rygel_thumbnail_instance_init (RygelThumbnail * self) {
	self->size = (gint64) 1024;
}


static void rygel_thumbnail_finalize (GObject* obj) {
	RygelThumbnail * self;
	self = RYGEL_THUMBNAIL (obj);
	G_OBJECT_CLASS (rygel_thumbnail_parent_class)->finalize (obj);
}


GType rygel_thumbnail_get_type (void) {
	static volatile gsize rygel_thumbnail_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_thumbnail_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelThumbnailClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_thumbnail_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelThumbnail), 0, (GInstanceInitFunc) rygel_thumbnail_instance_init, NULL };
		GType rygel_thumbnail_type_id;
		rygel_thumbnail_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelThumbnail", &g_define_type_info, 0);
		g_once_init_leave (&rygel_thumbnail_type_id__volatile, rygel_thumbnail_type_id);
	}
	return rygel_thumbnail_type_id__volatile;
}


#line 38 "rygel-http-byte-seek-test.vala"
RygelSubtitle* rygel_subtitle_construct (GType object_type) {
#line 425 "rygel-http-byte-seek-test.c"
	RygelSubtitle * self;
#line 38 "rygel-http-byte-seek-test.vala"
	self = (RygelSubtitle*) g_object_new (object_type, NULL);
#line 429 "rygel-http-byte-seek-test.c"
	return self;
}


#line 38 "rygel-http-byte-seek-test.vala"
RygelSubtitle* rygel_subtitle_new (void) {
#line 38 "rygel-http-byte-seek-test.vala"
	return rygel_subtitle_construct (RYGEL_TYPE_SUBTITLE);
#line 438 "rygel-http-byte-seek-test.c"
}


static void rygel_subtitle_class_init (RygelSubtitleClass * klass) {
	rygel_subtitle_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_subtitle_finalize;
}


static void rygel_subtitle_instance_init (RygelSubtitle * self) {
	self->size = (gint64) 1024;
}


static void rygel_subtitle_finalize (GObject* obj) {
	RygelSubtitle * self;
	self = RYGEL_SUBTITLE (obj);
	G_OBJECT_CLASS (rygel_subtitle_parent_class)->finalize (obj);
}


GType rygel_subtitle_get_type (void) {
	static volatile gsize rygel_subtitle_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_subtitle_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelSubtitleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_subtitle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelSubtitle), 0, (GInstanceInitFunc) rygel_subtitle_instance_init, NULL };
		GType rygel_subtitle_type_id;
		rygel_subtitle_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelSubtitle", &g_define_type_info, 0);
		g_once_init_leave (&rygel_subtitle_type_id__volatile, rygel_subtitle_type_id);
	}
	return rygel_subtitle_type_id__volatile;
}


#line 52 "rygel-http-byte-seek-test.vala"
RygelHTTPGet* rygel_http_get_construct (GType object_type) {
#line 474 "rygel-http-byte-seek-test.c"
	RygelHTTPGet * self;
	SoupMessage* _tmp0_;
	RygelMediaItem* _tmp1_;
	RygelHTTPIdentityHandler* _tmp2_;
#line 52 "rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) g_object_new (object_type, NULL);
#line 53 "rygel-http-byte-seek-test.vala"
	self->msg = (_tmp0_ = soup_message_new ("HTTP", RYGEL_HTTP_GET_ITEM_URI), _g_object_unref0 (self->msg), _tmp0_);
#line 54 "rygel-http-byte-seek-test.vala"
	self->item = (_tmp1_ = rygel_media_item_new (), _g_object_unref0 (self->item), _tmp1_);
#line 55 "rygel-http-byte-seek-test.vala"
	self->handler = (_tmp2_ = rygel_http_identity_handler_new (), _g_object_unref0 (self->handler), _tmp2_);
#line 487 "rygel-http-byte-seek-test.c"
	return self;
}


#line 52 "rygel-http-byte-seek-test.vala"
RygelHTTPGet* rygel_http_get_new (void) {
#line 52 "rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct (RYGEL_TYPE_HTTP_GET);
#line 496 "rygel-http-byte-seek-test.c"
}


#line 58 "rygel-http-byte-seek-test.vala"
RygelHTTPGet* rygel_http_get_construct_seek_start (GType object_type, gint64 start) {
#line 502 "rygel-http-byte-seek-test.c"
	RygelHTTPGet * self;
#line 59 "rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type);
#line 61 "rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, start, (gint64) (-1));
#line 508 "rygel-http-byte-seek-test.c"
	return self;
}


#line 58 "rygel-http-byte-seek-test.vala"
RygelHTTPGet* rygel_http_get_new_seek_start (gint64 start) {
#line 58 "rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_start (RYGEL_TYPE_HTTP_GET, start);
#line 517 "rygel-http-byte-seek-test.c"
}


#line 64 "rygel-http-byte-seek-test.vala"
RygelHTTPGet* rygel_http_get_construct_seek_stop (GType object_type, gint64 stop) {
#line 523 "rygel-http-byte-seek-test.c"
	RygelHTTPGet * self;
#line 65 "rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type);
#line 67 "rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, (gint64) 0, stop);
#line 529 "rygel-http-byte-seek-test.c"
	return self;
}


#line 64 "rygel-http-byte-seek-test.vala"
RygelHTTPGet* rygel_http_get_new_seek_stop (gint64 stop) {
#line 64 "rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_stop (RYGEL_TYPE_HTTP_GET, stop);
#line 538 "rygel-http-byte-seek-test.c"
}


#line 70 "rygel-http-byte-seek-test.vala"
RygelHTTPGet* rygel_http_get_construct_seek_start_stop (GType object_type, gint64 start, gint64 stop) {
#line 544 "rygel-http-byte-seek-test.c"
	RygelHTTPGet * self;
#line 71 "rygel-http-byte-seek-test.vala"
	self = (RygelHTTPGet*) rygel_http_get_construct (object_type);
#line 73 "rygel-http-byte-seek-test.vala"
	rygel_http_get_add_headers (self, start, stop);
#line 550 "rygel-http-byte-seek-test.c"
	return self;
}


#line 70 "rygel-http-byte-seek-test.vala"
RygelHTTPGet* rygel_http_get_new_seek_start_stop (gint64 start, gint64 stop) {
#line 70 "rygel-http-byte-seek-test.vala"
	return rygel_http_get_construct_seek_start_stop (RYGEL_TYPE_HTTP_GET, start, stop);
#line 559 "rygel-http-byte-seek-test.c"
}


#line 76 "rygel-http-byte-seek-test.vala"
static void rygel_http_get_add_headers (RygelHTTPGet* self, gint64 start, gint64 stop) {
#line 76 "rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 77 "rygel-http-byte-seek-test.vala"
	soup_message_headers_set_range (self->msg->request_headers, start, stop);
#line 569 "rygel-http-byte-seek-test.c"
}


static void rygel_http_get_class_init (RygelHTTPGetClass * klass) {
	rygel_http_get_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_http_get_finalize;
}


static void rygel_http_get_instance_init (RygelHTTPGet * self) {
}


static void rygel_http_get_finalize (GObject* obj) {
	RygelHTTPGet * self;
	self = RYGEL_HTTP_GET (obj);
	_g_object_unref0 (self->msg);
	_g_object_unref0 (self->item);
	_g_object_unref0 (self->thumbnail);
	_g_object_unref0 (self->subtitle);
	_g_object_unref0 (self->handler);
	G_OBJECT_CLASS (rygel_http_get_parent_class)->finalize (obj);
}


GType rygel_http_get_get_type (void) {
	static volatile gsize rygel_http_get_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_get_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPGetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_get_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPGet), 0, (GInstanceInitFunc) rygel_http_get_instance_init, NULL };
		GType rygel_http_get_type_id;
		rygel_http_get_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPGet", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_get_type_id__volatile, rygel_http_get_type_id);
	}
	return rygel_http_get_type_id__volatile;
}


#line 84 "rygel-http-byte-seek-test.vala"
gint rygel_http_byte_seek_test_main (char** args, int args_length1) {
#line 609 "rygel-http-byte-seek-test.c"
	gint result = 0;
	GError * _inner_error_;
	_inner_error_ = NULL;
	{
		RygelHTTPByteSeekTest* test;
#line 86 "rygel-http-byte-seek-test.vala"
		test = rygel_http_byte_seek_test_new ();
#line 88 "rygel-http-byte-seek-test.vala"
		rygel_http_byte_seek_test_run (test, &_inner_error_);
#line 619 "rygel-http-byte-seek-test.c"
		if (_inner_error_ != NULL) {
			_g_object_unref0 (test);
			if (g_error_matches (_inner_error_, RYGEL_TEST_ERROR, RYGEL_TEST_ERROR_SKIP)) {
				goto __catch0_rygel_test_error_skip;
			}
			goto __catch0_g_error;
		}
		_g_object_unref0 (test);
	}
	goto __finally0;
	__catch0_rygel_test_error_skip:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
			result = 77;
			_g_error_free0 (_error_);
#line 90 "rygel-http-byte-seek-test.vala"
			return result;
#line 640 "rygel-http-byte-seek-test.c"
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		{
#line 92 "rygel-http-byte-seek-test.vala"
			g_critical ("rygel-http-byte-seek-test.vala:92: %s", _error_->message);
#line 652 "rygel-http-byte-seek-test.c"
			result = -1;
			_g_error_free0 (_error_);
#line 94 "rygel-http-byte-seek-test.vala"
			return result;
#line 657 "rygel-http-byte-seek-test.c"
		}
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	result = 0;
#line 97 "rygel-http-byte-seek-test.vala"
	return result;
#line 669 "rygel-http-byte-seek-test.c"
}


#line 84 "rygel-http-byte-seek-test.vala"
int main (int argc, char ** argv) {
#line 675 "rygel-http-byte-seek-test.c"
	g_thread_init (NULL);
#line 84 "rygel-http-byte-seek-test.vala"
	g_type_init ();
#line 84 "rygel-http-byte-seek-test.vala"
	return rygel_http_byte_seek_test_main (argv, argc);
#line 681 "rygel-http-byte-seek-test.c"
}


#line 100 "rygel-http-byte-seek-test.vala"
void rygel_http_byte_seek_test_run (RygelHTTPByteSeekTest* self, GError** error) {
#line 687 "rygel-http-byte-seek-test.c"
	GError * _inner_error_;
#line 100 "rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 691 "rygel-http-byte-seek-test.c"
	_inner_error_ = NULL;
#line 101 "rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_no_seek (self, &_inner_error_);
#line 695 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 102 "rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_start_only_seek (self, &_inner_error_);
#line 708 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 103 "rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_stop_only_seek (self, &_inner_error_);
#line 721 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 104 "rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_start_stop_seek (self, &_inner_error_);
#line 734 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


#line 107 "rygel-http-byte-seek-test.vala"
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_construct (GType object_type) {
#line 750 "rygel-http-byte-seek-test.c"
	GError * _inner_error_;
	RygelHTTPByteSeekTest * self;
	GRegex* _tmp0_;
	GRegex* _tmp1_;
	_inner_error_ = NULL;
#line 107 "rygel-http-byte-seek-test.vala"
	self = (RygelHTTPByteSeekTest*) g_object_new (object_type, NULL);
#line 108 "rygel-http-byte-seek-test.vala"
	_tmp0_ = g_regex_new ("bytes +[0-9]+-[0-9]+/[0-9]+", G_REGEX_CASELESS, 0, &_inner_error_);
#line 760 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
#line 108 "rygel-http-byte-seek-test.vala"
	self->priv->range_regex = (_tmp1_ = _tmp0_, _g_regex_unref0 (self->priv->range_regex), _tmp1_);
#line 768 "rygel-http-byte-seek-test.c"
	return self;
}


#line 107 "rygel-http-byte-seek-test.vala"
static RygelHTTPByteSeekTest* rygel_http_byte_seek_test_new (void) {
#line 107 "rygel-http-byte-seek-test.vala"
	return rygel_http_byte_seek_test_construct (RYGEL_TYPE_HTTP_BYTE_SEEK_TEST);
#line 777 "rygel-http-byte-seek-test.c"
}


#line 112 "rygel-http-byte-seek-test.vala"
static void rygel_http_byte_seek_test_test_no_seek (RygelHTTPByteSeekTest* self, GError** error) {
#line 783 "rygel-http-byte-seek-test.c"
	GError * _inner_error_;
	RygelHTTPGet* request;
#line 112 "rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 788 "rygel-http-byte-seek-test.c"
	_inner_error_ = NULL;
#line 113 "rygel-http-byte-seek-test.vala"
	request = rygel_http_get_new ();
#line 115 "rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 0, request->item->size - 1, &_inner_error_);
#line 794 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


#line 118 "rygel-http-byte-seek-test.vala"
static void rygel_http_byte_seek_test_test_start_only_seek (RygelHTTPByteSeekTest* self, GError** error) {
#line 813 "rygel-http-byte-seek-test.c"
	GError * _inner_error_;
	RygelHTTPGet* request;
#line 118 "rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 818 "rygel-http-byte-seek-test.c"
	_inner_error_ = NULL;
#line 119 "rygel-http-byte-seek-test.vala"
	request = rygel_http_get_new_seek_start ((gint64) 128);
#line 121 "rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 128, request->item->size - 1, &_inner_error_);
#line 824 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


#line 124 "rygel-http-byte-seek-test.vala"
static void rygel_http_byte_seek_test_test_stop_only_seek (RygelHTTPByteSeekTest* self, GError** error) {
#line 843 "rygel-http-byte-seek-test.c"
	GError * _inner_error_;
	RygelHTTPGet* request;
#line 124 "rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 848 "rygel-http-byte-seek-test.c"
	_inner_error_ = NULL;
#line 125 "rygel-http-byte-seek-test.vala"
	request = rygel_http_get_new_seek_stop ((gint64) 128);
#line 127 "rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 0, (gint64) 128, &_inner_error_);
#line 854 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


#line 130 "rygel-http-byte-seek-test.vala"
static void rygel_http_byte_seek_test_test_start_stop_seek (RygelHTTPByteSeekTest* self, GError** error) {
#line 873 "rygel-http-byte-seek-test.c"
	GError * _inner_error_;
	RygelHTTPGet* request;
#line 130 "rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 878 "rygel-http-byte-seek-test.c"
	_inner_error_ = NULL;
#line 131 "rygel-http-byte-seek-test.vala"
	request = rygel_http_get_new_seek_start_stop ((gint64) 128, (gint64) 256);
#line 133 "rygel-http-byte-seek-test.vala"
	rygel_http_byte_seek_test_test_seek (self, request, (gint64) 128, (gint64) 256, &_inner_error_);
#line 884 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (request);
			return;
		} else {
			_g_object_unref0 (request);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_g_object_unref0 (request);
}


#line 136 "rygel-http-byte-seek-test.vala"
static void rygel_http_byte_seek_test_test_seek (RygelHTTPByteSeekTest* self, RygelHTTPGet* request, gint64 start, gint64 stop, GError** error) {
#line 903 "rygel-http-byte-seek-test.c"
	GError * _inner_error_;
	RygelHTTPByteSeek* seek;
	char* header;
	char* _tmp0_;
#line 136 "rygel-http-byte-seek-test.vala"
	g_return_if_fail (self != NULL);
#line 136 "rygel-http-byte-seek-test.vala"
	g_return_if_fail (request != NULL);
#line 912 "rygel-http-byte-seek-test.c"
	_inner_error_ = NULL;
#line 139 "rygel-http-byte-seek-test.vala"
	g_assert (rygel_http_byte_seek_needed (request));
#line 141 "rygel-http-byte-seek-test.vala"
	seek = rygel_http_byte_seek_new (request, &_inner_error_);
#line 918 "rygel-http-byte-seek-test.c"
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_HTTP_SEEK_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
#line 142 "rygel-http-byte-seek-test.vala"
	rygel_http_seek_add_response_headers ((RygelHTTPSeek*) seek);
#line 144 "rygel-http-byte-seek-test.vala"
	g_assert (seek != NULL);
#line 145 "rygel-http-byte-seek-test.vala"
	g_assert (rygel_http_seek_get_start ((RygelHTTPSeek*) seek) == start);
#line 146 "rygel-http-byte-seek-test.vala"
	g_assert (rygel_http_seek_get_stop ((RygelHTTPSeek*) seek) == stop);
#line 147 "rygel-http-byte-seek-test.vala"
	g_assert (rygel_http_seek_get_length ((RygelHTTPSeek*) seek) == request->item->size);
#line 149 "rygel-http-byte-seek-test.vala"
	header = g_strdup (soup_message_headers_get (request->msg->response_headers, "Accept-Ranges"));
#line 150 "rygel-http-byte-seek-test.vala"
	g_assert (_vala_strcmp0 (header, "bytes") == 0);
#line 151 "rygel-http-byte-seek-test.vala"
	header = (_tmp0_ = g_strdup (soup_message_headers_get (request->msg->response_headers, "Content-Range")), _g_free0 (header), _tmp0_);
#line 152 "rygel-http-byte-seek-test.vala"
	g_assert (header != NULL);
#line 153 "rygel-http-byte-seek-test.vala"
	g_assert (g_regex_match (self->priv->range_regex, header, 0, NULL));
#line 155 "rygel-http-byte-seek-test.vala"
	g_assert (soup_message_headers_get_content_length (request->msg->response_headers) == ((rygel_http_seek_get_stop ((RygelHTTPSeek*) seek) + 1) - rygel_http_seek_get_start ((RygelHTTPSeek*) seek)));
#line 951 "rygel-http-byte-seek-test.c"
	_g_object_unref0 (seek);
	_g_free0 (header);
}


static void rygel_http_byte_seek_test_class_init (RygelHTTPByteSeekTestClass * klass) {
	rygel_http_byte_seek_test_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelHTTPByteSeekTestPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_http_byte_seek_test_finalize;
}


static void rygel_http_byte_seek_test_instance_init (RygelHTTPByteSeekTest * self) {
	self->priv = RYGEL_HTTP_BYTE_SEEK_TEST_GET_PRIVATE (self);
}


static void rygel_http_byte_seek_test_finalize (GObject* obj) {
	RygelHTTPByteSeekTest * self;
	self = RYGEL_HTTP_BYTE_SEEK_TEST (obj);
	_g_regex_unref0 (self->priv->range_regex);
	G_OBJECT_CLASS (rygel_http_byte_seek_test_parent_class)->finalize (obj);
}


GType rygel_http_byte_seek_test_get_type (void) {
	static volatile gsize rygel_http_byte_seek_test_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_http_byte_seek_test_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelHTTPByteSeekTestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_http_byte_seek_test_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelHTTPByteSeekTest), 0, (GInstanceInitFunc) rygel_http_byte_seek_test_instance_init, NULL };
		GType rygel_http_byte_seek_test_type_id;
		rygel_http_byte_seek_test_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelHTTPByteSeekTest", &g_define_type_info, 0);
		g_once_init_leave (&rygel_http_byte_seek_test_type_id__volatile, rygel_http_byte_seek_test_type_id);
	}
	return rygel_http_byte_seek_test_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




