/*
 * Copyright (C) 2013 Intel Corporation.
 *
 * Author: Jussi Kukkonen <jussi.kukkonen@intel.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

using Rygel;

private Rygel.LMS.PluginFactory plugin_factory;

public void module_init (PluginLoader loader) {
    plugin_factory = new Rygel.LMS.PluginFactory (loader);
}

public class Rygel.LMS.PluginFactory {

    PluginLoader loader;

    public PluginFactory (PluginLoader loader) {
        this.loader = loader;
        this.loader.add_plugin (new LMS.Plugin ());
    }

}
