/* rygel-1.0.vapi generated by valac, do not modify. */

[CCode (cprefix = "Rygel", lower_case_cprefix = "rygel_")]
namespace Rygel {
	[CCode (cheader_filename = "rygel-connection-manager.h")]
	public class ConnectionManager : GUPnP.Service {
		protected string connection_ids;
		protected string sink_protocol_info;
		protected string source_protocol_info;
		public const string DESCRIPTION_PATH;
		public const string UPNP_ID;
		public const string UPNP_TYPE;
		public ConnectionManager ();
	}
	[CCode (cheader_filename = "rygel-content-directory.h")]
	public class ContentDirectory : GUPnP.Service {
		protected string feature_list;
		protected Rygel.HTTPServer http_server;
		protected Rygel.MediaContainer root_container;
		protected string search_caps;
		protected string sort_caps;
		protected uint32 system_update_id;
		public const string DESCRIPTION_PATH;
		public const string UPNP_ID;
		public const string UPNP_TYPE;
		public virtual void add_children_metadata (GUPnP.DIDLLiteWriter didl_writer, BrowseArgs args) throws GLib.Error;
		public virtual void add_metadata (GUPnP.DIDLLiteWriter didl_writer, BrowseArgs args) throws GLib.Error;
		public virtual void add_root_children_metadata (GUPnP.DIDLLiteWriter didl_writer, BrowseArgs args) throws GLib.Error;
		protected virtual void browse_cb (Rygel.ContentDirectory content_dir, GUPnP.ServiceAction action);
		public ContentDirectory ();
	}
	[CCode (cheader_filename = "rygel-http-response.h")]
	public class HTTPResponse : GLib.Object {
		protected Soup.Message msg;
		public virtual void end (bool aborted, uint status);
		public HTTPResponse (Soup.Server server, Soup.Message msg, bool partial);
		public void push_data (void* data, size_t length);
		public void set_mime_type (string mime_type);
		public Soup.Server server { get; set; }
		public signal void ended ();
	}
	[CCode (cheader_filename = "rygel-http-server.h")]
	public class HTTPServer : GLib.Object {
		public string create_http_uri_for_item (Rygel.MediaItem item);
		public void destroy ();
		public HTTPServer (GUPnP.Context context, string name);
		public signal void item_requested (string item_id, out Rygel.MediaItem item);
		public signal void need_stream_source (Rygel.MediaItem item, out Gst.Element src);
	}
	[CCode (ref_function = "rygel_icon_info_ref", unref_function = "rygel_icon_info_unref", param_spec_function = "rygel_param_spec_icon_info", cheader_filename = "rygel-icon-info.h")]
	public class IconInfo {
		public uint depth;
		public uint height;
		public string mimetype;
		public string path;
		public uint width;
		public IconInfo (string mimetype, uint width, uint height, uint depth, string path);
	}
	[CCode (cheader_filename = "rygel-live-response.h")]
	public class LiveResponse : Rygel.HTTPResponse {
		public LiveResponse (Soup.Server server, Soup.Message msg, string name, Gst.Element src) throws GLib.Error;
		public void start ();
	}
	[CCode (cheader_filename = "rygel-media-container.h")]
	public class MediaContainer : Rygel.MediaObject {
		public uint child_count;
		public MediaContainer (string id, string parent_id, string title, uint child_count);
		public MediaContainer.root (string title, uint child_count);
	}
	[CCode (cheader_filename = "rygel-media-item.h")]
	public class MediaItem : Rygel.MediaObject {
		public string album;
		public string author;
		public string date;
		protected Rygel.HTTPServer http_server;
		public GUPnP.DIDLLiteResource res;
		public int track_number;
		public string upnp_class;
		public const string AUDIO_CLASS;
		public const string IMAGE_CLASS;
		public const string MUSIC_CLASS;
		public const string VIDEO_CLASS;
		public MediaItem (string id, string parent_id, string title, string upnp_class, Rygel.HTTPServer http_server);
	}
	[CCode (ref_function = "rygel_media_object_ref", unref_function = "rygel_media_object_unref", param_spec_function = "rygel_param_spec_media_object", cheader_filename = "rygel-media-object.h")]
	public abstract class MediaObject {
		public string id;
		public string parent_id;
		public string title;
		public abstract void serialize (GUPnP.DIDLLiteWriter didl_writer) throws GLib.Error;
	}
	[CCode (cheader_filename = "rygel-media-receiver-registrar.h")]
	public class MediaReceiverRegistrar : GUPnP.Service {
		public const string DESCRIPTION_PATH;
		public const string UPNP_ID;
		public const string UPNP_TYPE;
		public MediaReceiverRegistrar ();
	}
	[CCode (cheader_filename = "rygel-plugin.h")]
	public class Plugin : GUPnP.ResourceFactory {
		public Gee.ArrayList<Rygel.IconInfo> icon_infos;
		public string name;
		public Gee.ArrayList<Rygel.ResourceInfo> resource_infos;
		public void add_icon (Rygel.IconInfo icon_info);
		public void add_resource (Rygel.ResourceInfo resource_info);
		public Plugin (string name);
	}
	[CCode (ref_function = "rygel_resource_info_ref", unref_function = "rygel_resource_info_unref", param_spec_function = "rygel_param_spec_resource_info", cheader_filename = "rygel-resource-info.h")]
	public class ResourceInfo {
		public string description_path;
		public GLib.Type type;
		public string upnp_id;
		public string upnp_type;
		public ResourceInfo (string upnp_id, string upnp_type, string description_path, GLib.Type type);
	}
	[CCode (cheader_filename = "rygel-http-response.h")]
	public class Seek : GLib.Object {
		public Seek (Gst.Format format, int64 start, int64 stop);
		public Gst.Format format { get; set; }
		public int64 length { get; set; }
		public int64 start { get; set; }
		public int64 stop { get; set; }
	}
	[CCode (cheader_filename = "rygel-seekable-response.h")]
	public class SeekableResponse : Rygel.HTTPResponse {
		public SeekableResponse (Soup.Server server, Soup.Message msg, string uri, Rygel.Seek? seek, size_t file_length) throws GLib.Error;
	}
	[CCode (cprefix = "RYGEL_CONTENT_DIRECTORY_ERROR_", cheader_filename = "rygel-content-directory.h")]
	public errordomain ContentDirectoryError {
		NO_SUCH_OBJECT,
		INVALID_ARGS,
	}
	[CCode (cprefix = "RYGEL_HTTP_SERVER_ERROR_", cheader_filename = "rygel-http-server.h")]
	public errordomain HTTPServerError {
		UNACCEPTABLE,
		INVALID_RANGE,
		OUT_OF_RANGE,
	}
	[CCode (cprefix = "RYGEL_LIVE_RESPONSE_ERROR_", cheader_filename = "rygel-live-response.h")]
	public errordomain LiveResponseError {
		MISSING_PLUGIN,
		LINK,
	}
	[CCode (cprefix = "RYGEL_MEDIA_ITEM_ERROR_", cheader_filename = "rygel-media-item.h")]
	public errordomain MediaItemError {
		UNKNOWN_URI_TYPE,
	}
}
[CCode (ref_function = "browse_args_ref", unref_function = "browse_args_unref", param_spec_function = "param_spec_browse_args", cheader_filename = "rygel-content-directory.h")]
public class BrowseArgs {
	public string browse_flag;
	public string filter;
	public uint index;
	public uint number_returned;
	public string object_id;
	public uint requested_count;
	public string sort_criteria;
	public uint total_matches;
	public uint update_id;
	public BrowseArgs ();
}
