/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-dvb-channel.h"
#include <rygel-media-object.h>
#include <libgupnp-av/gupnp-av.h>




struct _RygelDVBChannelPrivate {
	guint cid;
};

#define RYGEL_DVB_CHANNEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_DVB_CHANNEL, RygelDVBChannelPrivate))
enum  {
	RYGEL_DVB_CHANNEL_DUMMY_PROPERTY
};
DBusGProxy* rygel_dvb_channel_channel_list = NULL;
char* _dynamic_GetChannelName4 (DBusGProxy* self, guint param1, GError** error);
gboolean _dynamic_IsRadioChannel5 (DBusGProxy* self, guint param1, GError** error);
char* _dynamic_GetChannelURL6 (DBusGProxy* self, guint param1, GError** error);
static gpointer rygel_dvb_channel_parent_class = NULL;
static void rygel_dvb_channel_finalize (RygelMediaObject* obj);



/* The DVB Daemon Channel ID */
RygelDVBChannel* rygel_dvb_channel_construct (GType object_type, guint cid, const char* parent_id, DBusGProxy* channel_list, RygelHTTPServer* http_server, GError** error) {
	GError * inner_error;
	RygelDVBChannel* self;
	char* _tmp1;
	char* _tmp0;
	char* _tmp2;
	char* id;
	DBusGProxy* _tmp4;
	DBusGProxy* _tmp3;
	g_return_val_if_fail (parent_id != NULL, NULL);
	g_return_val_if_fail (channel_list != NULL, NULL);
	g_return_val_if_fail (http_server != NULL, NULL);
	inner_error = NULL;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	id = (_tmp2 = g_strconcat (_tmp0 = g_strconcat (parent_id, ":", NULL), _tmp1 = g_strdup_printf ("%u", cid), NULL), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
	/* UPnP ID */
	self = (RygelDVBChannel*) rygel_media_item_construct (object_type, id, parent_id, "Unknown", "Unknown", http_server);
	/* Title Unknown at this point 
	 UPnP Class Unknown at this point */
	self->priv->cid = cid;
	_tmp4 = NULL;
	_tmp3 = NULL;
	rygel_dvb_channel_channel_list = (_tmp4 = (_tmp3 = channel_list, (_tmp3 == NULL) ? NULL : g_object_ref (_tmp3)), (rygel_dvb_channel_channel_list == NULL) ? NULL : (rygel_dvb_channel_channel_list = (g_object_unref (rygel_dvb_channel_channel_list), NULL)), _tmp4);
	rygel_dvb_channel_fetch_metadata (self, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		id = (g_free (id), NULL);
		return NULL;
	}
	id = (g_free (id), NULL);
	return self;
}


RygelDVBChannel* rygel_dvb_channel_new (guint cid, const char* parent_id, DBusGProxy* channel_list, RygelHTTPServer* http_server, GError** error) {
	return rygel_dvb_channel_construct (RYGEL_TYPE_DVB_CHANNEL, cid, parent_id, channel_list, http_server, error);
}


char* _dynamic_GetChannelName4 (DBusGProxy* self, guint param1, GError** error) {
	char* result;
	dbus_g_proxy_call (self, "GetChannelName", error, G_TYPE_UINT, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


gboolean _dynamic_IsRadioChannel5 (DBusGProxy* self, guint param1, GError** error) {
	gboolean result;
	dbus_g_proxy_call (self, "IsRadioChannel", error, G_TYPE_UINT, param1, G_TYPE_INVALID, G_TYPE_BOOLEAN, &result, G_TYPE_INVALID);
	if (*error) {
		return FALSE;
	}
	return result;
}


char* _dynamic_GetChannelURL6 (DBusGProxy* self, guint param1, GError** error) {
	char* result;
	dbus_g_proxy_call (self, "GetChannelURL", error, G_TYPE_UINT, param1, G_TYPE_INVALID, G_TYPE_STRING, &result, G_TYPE_INVALID);
	if (*error) {
		return NULL;
	}
	return result;
}


void rygel_dvb_channel_fetch_metadata (RygelDVBChannel* self, GError** error) {
	GError * inner_error;
	char* _tmp0;
	char* _tmp1;
	gboolean is_radio;
	char* _tmp4;
	char* _tmp5;
	char* _tmp6;
	g_return_if_fail (self != NULL);
	inner_error = NULL;
	_tmp0 = _dynamic_GetChannelName4 (rygel_dvb_channel_channel_list, self->priv->cid, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	/* TODO: make this async */
	_tmp1 = NULL;
	((RygelMediaObject*) self)->title = (_tmp1 = _tmp0, ((RygelMediaObject*) self)->title = (g_free (((RygelMediaObject*) self)->title), NULL), _tmp1);
	is_radio = _dynamic_IsRadioChannel5 (rygel_dvb_channel_channel_list, self->priv->cid, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	if (is_radio) {
		char* _tmp2;
		_tmp2 = NULL;
		((RygelMediaItem*) self)->upnp_class = (_tmp2 = g_strdup ("object.item.audioItem.audioBroadcast"), ((RygelMediaItem*) self)->upnp_class = (g_free (((RygelMediaItem*) self)->upnp_class), NULL), _tmp2);
	} else {
		char* _tmp3;
		_tmp3 = NULL;
		((RygelMediaItem*) self)->upnp_class = (_tmp3 = g_strdup ("object.item.videoItem.videoBroadcast"), ((RygelMediaItem*) self)->upnp_class = (g_free (((RygelMediaItem*) self)->upnp_class), NULL), _tmp3);
	}
	_tmp4 = NULL;
	((RygelMediaItem*) self)->res.mime_type = (_tmp4 = g_strdup ("video/mpeg"), ((RygelMediaItem*) self)->res.mime_type = (g_free (((RygelMediaItem*) self)->res.mime_type), NULL), _tmp4);
	_tmp5 = _dynamic_GetChannelURL6 (rygel_dvb_channel_channel_list, self->priv->cid, &inner_error);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	_tmp6 = NULL;
	((RygelMediaItem*) self)->res.uri = (_tmp6 = _tmp5, ((RygelMediaItem*) self)->res.uri = (g_free (((RygelMediaItem*) self)->res.uri), NULL), _tmp6);
}


static void rygel_dvb_channel_class_init (RygelDVBChannelClass * klass) {
	rygel_dvb_channel_parent_class = g_type_class_peek_parent (klass);
	RYGEL_MEDIA_OBJECT_CLASS (klass)->finalize = rygel_dvb_channel_finalize;
	g_type_class_add_private (klass, sizeof (RygelDVBChannelPrivate));
}


static void rygel_dvb_channel_instance_init (RygelDVBChannel * self) {
	self->priv = RYGEL_DVB_CHANNEL_GET_PRIVATE (self);
}


static void rygel_dvb_channel_finalize (RygelMediaObject* obj) {
	RygelDVBChannel * self;
	self = RYGEL_DVB_CHANNEL (obj);
	RYGEL_MEDIA_OBJECT_CLASS (rygel_dvb_channel_parent_class)->finalize (obj);
}


GType rygel_dvb_channel_get_type (void) {
	static GType rygel_dvb_channel_type_id = 0;
	if (rygel_dvb_channel_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelDVBChannelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_dvb_channel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelDVBChannel), 0, (GInstanceInitFunc) rygel_dvb_channel_instance_init, NULL };
		rygel_dvb_channel_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_ITEM, "RygelDVBChannel", &g_define_type_info, 0);
	}
	return rygel_dvb_channel_type_id;
}




