/*
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_MEDIA_SERVER_H__
#define __RYGEL_MEDIA_SERVER_H__

#include <glib.h>
#include <glib-object.h>
#include <libgupnp/gupnp.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <stdlib.h>
#include <string.h>
#include "rygel-plugin.h"

G_BEGIN_DECLS


#define RYGEL_TYPE_MEDIA_SERVER (rygel_media_server_get_type ())
#define RYGEL_MEDIA_SERVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_MEDIA_SERVER, RygelMediaServer))
#define RYGEL_MEDIA_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_MEDIA_SERVER, RygelMediaServerClass))
#define RYGEL_IS_MEDIA_SERVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_MEDIA_SERVER))
#define RYGEL_IS_MEDIA_SERVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_MEDIA_SERVER))
#define RYGEL_MEDIA_SERVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_MEDIA_SERVER, RygelMediaServerClass))

typedef struct _RygelMediaServer RygelMediaServer;
typedef struct _RygelMediaServerClass RygelMediaServerClass;
typedef struct _RygelMediaServerPrivate RygelMediaServerPrivate;

/**
 * Represents a MediaServer device.
 */
struct _RygelMediaServer {
	GUPnPRootDevice parent_instance;
	RygelMediaServerPrivate * priv;
};

struct _RygelMediaServerClass {
	GUPnPRootDeviceClass parent_class;
};


RygelMediaServer* rygel_media_server_construct (GType object_type, GUPnPContext* context, RygelPlugin* plugin, xmlDoc* description_doc, const char* relative_location);
RygelMediaServer* rygel_media_server_new (GUPnPContext* context, RygelPlugin* plugin, xmlDoc* description_doc, const char* relative_location);
GType rygel_media_server_get_type (void);


G_END_DECLS

#endif
