/*
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-main.h"
#include <gee/arraylist.h>
#include <glib/gi18n-lib.h>
#include <libgupnp/gupnp.h>
#include <gee/collection.h>
#include <cstuff.h>
#include <gst/gst.h>
#include "rygel-plugin-loader.h"
#include "rygel-media-server-factory.h"
#include "rygel-media-server.h"
#include "rygel-plugin.h"




struct _RygelMainPrivate {
	RygelPluginLoader* plugin_loader;
	RygelMediaServerFactory* ms_factory;
	GeeArrayList* media_servers;
	GMainLoop* main_loop;
	gint exit_code;
};

#define RYGEL_MAIN_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_MAIN, RygelMainPrivate))
enum  {
	RYGEL_MAIN_DUMMY_PROPERTY
};
static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self);
static void _rygel_main_application_exit_cb_cstuff_utils_application_exit_cb (gpointer self);
static void rygel_main_application_exit_cb (RygelMain* self);
static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin);
static gpointer rygel_main_parent_class = NULL;
static void rygel_main_finalize (GObject* obj);



static void _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available (RygelPluginLoader* _sender, RygelPlugin* plugin, gpointer self) {
	rygel_main_on_plugin_loaded (self, _sender, plugin);
}


static void _rygel_main_application_exit_cb_cstuff_utils_application_exit_cb (gpointer self) {
	rygel_main_application_exit_cb (self);
}


RygelMain* rygel_main_construct (GType object_type, GError** error) {
	GError * inner_error;
	RygelMain * self;
	GeeArrayList* _tmp0;
	RygelPluginLoader* _tmp1;
	RygelMediaServerFactory* _tmp2;
	GMainLoop* _tmp3;
	inner_error = NULL;
	self = g_object_newv (object_type, 0, NULL);
	g_set_application_name (_ (PACKAGE_NAME));
	_tmp0 = NULL;
	self->priv->media_servers = (_tmp0 = gee_array_list_new (RYGEL_TYPE_MEDIA_SERVER, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), (self->priv->media_servers == NULL) ? NULL : (self->priv->media_servers = (g_object_unref (self->priv->media_servers), NULL)), _tmp0);
	_tmp1 = NULL;
	self->priv->plugin_loader = (_tmp1 = rygel_plugin_loader_new (), (self->priv->plugin_loader == NULL) ? NULL : (self->priv->plugin_loader = (g_object_unref (self->priv->plugin_loader), NULL)), _tmp1);
	_tmp2 = NULL;
	self->priv->ms_factory = (_tmp2 = rygel_media_server_factory_new (&inner_error), (self->priv->ms_factory == NULL) ? NULL : (self->priv->ms_factory = (rygel_media_server_factory_unref (self->priv->ms_factory), NULL)), _tmp2);
	if (inner_error != NULL) {
		g_propagate_error (error, inner_error);
		return;
	}
	_tmp3 = NULL;
	self->priv->main_loop = (_tmp3 = g_main_loop_new (NULL, FALSE), (self->priv->main_loop == NULL) ? NULL : (self->priv->main_loop = (g_main_loop_unref (self->priv->main_loop), NULL)), _tmp3);
	self->priv->exit_code = 0;
	g_signal_connect_object (self->priv->plugin_loader, "plugin-available", (GCallback) _rygel_main_on_plugin_loaded_rygel_plugin_loader_plugin_available, self, 0);
	on_application_exit (_rygel_main_application_exit_cb_cstuff_utils_application_exit_cb, self);
	return self;
}


RygelMain* rygel_main_new (GError** error) {
	return rygel_main_construct (RYGEL_TYPE_MAIN, error);
}


gint rygel_main_run (RygelMain* self) {
	g_return_val_if_fail (self != NULL, 0);
	rygel_plugin_loader_load_plugins (self->priv->plugin_loader);
	g_main_loop_run (self->priv->main_loop);
	return self->priv->exit_code;
}


void rygel_main_exit (RygelMain* self, gint exit_code) {
	g_return_if_fail (self != NULL);
	self->priv->exit_code = exit_code;
	g_main_loop_quit (self->priv->main_loop);
}


static void rygel_main_application_exit_cb (RygelMain* self) {
	g_return_if_fail (self != NULL);
	rygel_main_exit (self, 0);
}


static void rygel_main_on_plugin_loaded (RygelMain* self, RygelPluginLoader* plugin_loader, RygelPlugin* plugin) {
	GError * inner_error;
	g_return_if_fail (self != NULL);
	g_return_if_fail (plugin_loader != NULL);
	g_return_if_fail (plugin != NULL);
	inner_error = NULL;
	{
		RygelMediaServer* server;
		server = rygel_media_server_factory_create_media_server (self->priv->ms_factory, plugin, &inner_error);
		if (inner_error != NULL) {
			goto __catch16_g_error;
			goto __finally16;
		}
		/* Make our device available */
		gupnp_root_device_set_available ((GUPnPRootDevice*) server, TRUE);
		gee_collection_add ((GeeCollection*) self->priv->media_servers, server);
		(server == NULL) ? NULL : (server = (g_object_unref (server), NULL));
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError * error;
		error = inner_error;
		inner_error = NULL;
		{
			g_warning ("rygel-main.vala:80: Failed to create MediaServer for %s. Reason: %s\n", plugin->name, error->message);
			(error == NULL) ? NULL : (error = (g_error_free (error), NULL));
		}
	}
	__finally16:
	if (inner_error != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return;
	}
}


gint rygel_main_main (char** args, int args_length1) {
	GError * inner_error;
	RygelMain* main;
	gint exit_code;
	gint _tmp2;
	inner_error = NULL;
	main = NULL;
	/* initialize gstreamer*/
	gst_init (&args_length1, &args);
	{
		RygelMain* _tmp0;
		_tmp0 = NULL;
		main = (_tmp0 = rygel_main_new (&inner_error), (main == NULL) ? NULL : (main = (g_object_unref (main), NULL)), _tmp0);
		if (inner_error != NULL) {
			goto __catch17_g_error;
			goto __finally17;
		}
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError * err;
		err = inner_error;
		inner_error = NULL;
		{
			gint _tmp1;
			g_error ("rygel-main.vala:95: %s", err->message);
			return (_tmp1 = -1, (err == NULL) ? NULL : (err = (g_error_free (err), NULL)), (main == NULL) ? NULL : (main = (g_object_unref (main), NULL)), _tmp1);
		}
	}
	__finally17:
	if (inner_error != NULL) {
		(main == NULL) ? NULL : (main = (g_object_unref (main), NULL));
		g_critical ("file %s: line %d: uncaught error: %s", __FILE__, __LINE__, inner_error->message);
		g_clear_error (&inner_error);
		return 0;
	}
	exit_code = rygel_main_run (main);
	return (_tmp2 = exit_code, (main == NULL) ? NULL : (main = (g_object_unref (main), NULL)), _tmp2);
}


int main (int argc, char ** argv) {
	g_type_init ();
	return rygel_main_main (argv, argc);
}


static void rygel_main_class_init (RygelMainClass * klass) {
	rygel_main_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMainPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_main_finalize;
}


static void rygel_main_instance_init (RygelMain * self) {
	self->priv = RYGEL_MAIN_GET_PRIVATE (self);
}


static void rygel_main_finalize (GObject* obj) {
	RygelMain * self;
	self = RYGEL_MAIN (obj);
	(self->priv->plugin_loader == NULL) ? NULL : (self->priv->plugin_loader = (g_object_unref (self->priv->plugin_loader), NULL));
	(self->priv->ms_factory == NULL) ? NULL : (self->priv->ms_factory = (rygel_media_server_factory_unref (self->priv->ms_factory), NULL));
	(self->priv->media_servers == NULL) ? NULL : (self->priv->media_servers = (g_object_unref (self->priv->media_servers), NULL));
	(self->priv->main_loop == NULL) ? NULL : (self->priv->main_loop = (g_main_loop_unref (self->priv->main_loop), NULL));
	G_OBJECT_CLASS (rygel_main_parent_class)->finalize (obj);
}


GType rygel_main_get_type (void) {
	static GType rygel_main_type_id = 0;
	if (rygel_main_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMain), 0, (GInstanceInitFunc) rygel_main_instance_init, NULL };
		rygel_main_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMain", &g_define_type_info, 0);
	}
	return rygel_main_type_id;
}




