/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-tracker-root-container.h"
#include <gee/arraylist.h>
#include <gee/collection.h>
#include <rygel-simple-async-result.h>
#include <gee/iterable.h>
#include <gee/iterator.h>
#include "rygel-tracker-category.h"
#include "rygel-tracker-image-category.h"
#include "rygel-tracker-music-category.h"
#include "rygel-tracker-video-category.h"




struct _RygelTrackerRootContainerPrivate {
	GeeArrayList* categories;
};

#define RYGEL_TRACKER_ROOT_CONTAINER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_TYPE_TRACKER_ROOT_CONTAINER, RygelTrackerRootContainerPrivate))
enum  {
	RYGEL_TRACKER_ROOT_CONTAINER_DUMMY_PROPERTY
};
static void rygel_tracker_root_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target);
static GeeList* rygel_tracker_root_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error);
static void rygel_tracker_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target);
static RygelMediaObject* rygel_tracker_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error);
static RygelTrackerCategory* rygel_tracker_root_container_find_category_by_id (RygelTrackerRootContainer* self, const char* category_id);
static RygelTrackerCategory* rygel_tracker_root_container_get_item_category (RygelTrackerRootContainer* self, const char* item_id);
static gpointer rygel_tracker_root_container_parent_class = NULL;
static void rygel_tracker_root_container_finalize (GObject* obj);
static int _vala_strcmp0 (const char * str1, const char * str2);



RygelTrackerRootContainer* rygel_tracker_root_container_construct (GType object_type, const char* title) {
	RygelTrackerRootContainer * self;
	GeeArrayList* _tmp0;
	RygelTrackerImageCategory* _tmp1;
	RygelTrackerMusicCategory* _tmp2;
	RygelTrackerVideoCategory* _tmp3;
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelTrackerRootContainer*) rygel_media_container_construct_root (object_type, title, (guint) 0);
	_tmp0 = NULL;
	self->priv->categories = (_tmp0 = gee_array_list_new (RYGEL_TYPE_TRACKER_CATEGORY, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), (self->priv->categories == NULL) ? NULL : (self->priv->categories = (g_object_unref (self->priv->categories), NULL)), _tmp0);
	_tmp1 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->categories, (RygelTrackerCategory*) (_tmp1 = rygel_tracker_image_category_new ("16", (RygelMediaContainer*) self, "All Images")));
	(_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL));
	_tmp2 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->categories, (RygelTrackerCategory*) (_tmp2 = rygel_tracker_music_category_new ("14", (RygelMediaContainer*) self, "All Music")));
	(_tmp2 == NULL) ? NULL : (_tmp2 = (g_object_unref (_tmp2), NULL));
	_tmp3 = NULL;
	gee_collection_add ((GeeCollection*) self->priv->categories, (RygelTrackerCategory*) (_tmp3 = rygel_tracker_video_category_new ("15", (RygelMediaContainer*) self, "All Videos")));
	(_tmp3 == NULL) ? NULL : (_tmp3 = (g_object_unref (_tmp3), NULL));
	((RygelMediaContainer*) self)->child_count = (guint) gee_collection_get_size ((GeeCollection*) self->priv->categories);
	return self;
}


RygelTrackerRootContainer* rygel_tracker_root_container_new (const char* title) {
	return rygel_tracker_root_container_construct (RYGEL_TYPE_TRACKER_ROOT_CONTAINER, title);
}


static void rygel_tracker_root_container_real_get_children (RygelMediaContainer* base, guint offset, guint max_count, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target) {
	RygelTrackerRootContainer * self;
	guint stop;
	GeeList* children;
	RygelSimpleAsyncResult* res;
	GeeList* _tmp1;
	GeeList* _tmp0;
	self = (RygelTrackerRootContainer*) base;
	stop = offset + max_count;
	stop = CLAMP (stop, (guint) 0, ((RygelMediaContainer*) self)->child_count);
	children = gee_list_slice ((GeeList*) self->priv->categories, (gint) offset, (gint) stop);
	res = rygel_simple_async_result_new (GEE_TYPE_LIST, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GObject*) self, callback, callback_target);
	_tmp1 = NULL;
	_tmp0 = NULL;
	res->data = (_tmp1 = (_tmp0 = children, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (res->data == NULL) ? NULL : (res->data = (g_object_unref (res->data), NULL)), _tmp1);
	rygel_simple_async_result_complete_in_idle (res);
	(children == NULL) ? NULL : (children = (g_object_unref (children), NULL));
	(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
}


static GeeList* rygel_tracker_root_container_real_get_children_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error) {
	RygelTrackerRootContainer * self;
	RygelSimpleAsyncResult* _tmp0;
	RygelSimpleAsyncResult* simple_res;
	GeeList* _tmp1;
	GeeList* _tmp2;
	self = (RygelTrackerRootContainer*) base;
	g_return_val_if_fail (res != NULL, NULL);
	_tmp0 = NULL;
	simple_res = (_tmp0 = RYGEL_SIMPLE_ASYNC_RESULT (res), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = (GeeList*) simple_res->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (simple_res == NULL) ? NULL : (simple_res = (g_object_unref (simple_res), NULL)), _tmp2);
}


static void rygel_tracker_root_container_real_find_object (RygelMediaContainer* base, const char* id, GCancellable* cancellable, GAsyncReadyCallback callback, void* callback_target) {
	RygelTrackerRootContainer * self;
	RygelMediaObject* media_object;
	RygelSimpleAsyncResult* res;
	RygelMediaObject* _tmp1;
	RygelMediaObject* _tmp0;
	self = (RygelTrackerRootContainer*) base;
	g_return_if_fail (id != NULL);
	/* First try containers */
	media_object = (RygelMediaObject*) rygel_tracker_root_container_find_category_by_id (self, id);
	if (media_object == NULL) {
		RygelTrackerCategory* category;
		/* Now try items */
		category = rygel_tracker_root_container_get_item_category (self, id);
		if (category != NULL) {
			rygel_media_container_find_object ((RygelMediaContainer*) category, id, cancellable, callback, callback_target);
			(category == NULL) ? NULL : (category = (g_object_unref (category), NULL));
			(media_object == NULL) ? NULL : (media_object = (g_object_unref (media_object), NULL));
			return;
		}
		(category == NULL) ? NULL : (category = (g_object_unref (category), NULL));
	}
	res = rygel_simple_async_result_new (RYGEL_TYPE_MEDIA_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, (GObject*) self, callback, callback_target);
	_tmp1 = NULL;
	_tmp0 = NULL;
	res->data = (_tmp1 = (_tmp0 = media_object, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (res->data == NULL) ? NULL : (res->data = (g_object_unref (res->data), NULL)), _tmp1);
	rygel_simple_async_result_complete_in_idle (res);
	(media_object == NULL) ? NULL : (media_object = (g_object_unref (media_object), NULL));
	(res == NULL) ? NULL : (res = (g_object_unref (res), NULL));
}


static RygelMediaObject* rygel_tracker_root_container_real_find_object_finish (RygelMediaContainer* base, GAsyncResult* res, GError** error) {
	RygelTrackerRootContainer * self;
	RygelSimpleAsyncResult* _tmp0;
	RygelSimpleAsyncResult* simple_res;
	RygelMediaObject* _tmp1;
	RygelMediaObject* _tmp2;
	self = (RygelTrackerRootContainer*) base;
	g_return_val_if_fail (res != NULL, NULL);
	_tmp0 = NULL;
	simple_res = (_tmp0 = RYGEL_SIMPLE_ASYNC_RESULT (res), (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0));
	_tmp1 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (_tmp1 = (RygelMediaObject*) simple_res->data, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (simple_res == NULL) ? NULL : (simple_res = (g_object_unref (simple_res), NULL)), _tmp2);
}


/* Private methods */
static RygelTrackerCategory* rygel_tracker_root_container_find_category_by_id (RygelTrackerRootContainer* self, const char* category_id) {
	RygelTrackerCategory* category;
	RygelTrackerCategory* _tmp0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (category_id != NULL, NULL);
	category = NULL;
	_tmp0 = NULL;
	category = (_tmp0 = NULL, (category == NULL) ? NULL : (category = (g_object_unref (category), NULL)), _tmp0);
	{
		GeeIterator* _tmp_it;
		_tmp_it = gee_iterable_iterator ((GeeIterable*) self->priv->categories);
		while (gee_iterator_next (_tmp_it)) {
			RygelTrackerCategory* tmp;
			tmp = (RygelTrackerCategory*) gee_iterator_get (_tmp_it);
			if (_vala_strcmp0 (category_id, ((RygelMediaObject*) tmp)->id) == 0) {
				RygelTrackerCategory* _tmp2;
				RygelTrackerCategory* _tmp1;
				_tmp2 = NULL;
				_tmp1 = NULL;
				category = (_tmp2 = (_tmp1 = tmp, (_tmp1 == NULL) ? NULL : g_object_ref (_tmp1)), (category == NULL) ? NULL : (category = (g_object_unref (category), NULL)), _tmp2);
				(tmp == NULL) ? NULL : (tmp = (g_object_unref (tmp), NULL));
				break;
			}
			(tmp == NULL) ? NULL : (tmp = (g_object_unref (tmp), NULL));
		}
		(_tmp_it == NULL) ? NULL : (_tmp_it = (g_object_unref (_tmp_it), NULL));
	}
	return category;
}


static RygelTrackerCategory* rygel_tracker_root_container_get_item_category (RygelTrackerRootContainer* self, const char* item_id) {
	RygelTrackerCategory* category;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	category = NULL;
	{
		GeeIterator* _tmp_it;
		_tmp_it = gee_iterable_iterator ((GeeIterable*) self->priv->categories);
		while (gee_iterator_next (_tmp_it)) {
			RygelTrackerCategory* tmp;
			tmp = (RygelTrackerCategory*) gee_iterator_get (_tmp_it);
			if (rygel_tracker_category_is_thy_child (tmp, item_id)) {
				RygelTrackerCategory* _tmp1;
				RygelTrackerCategory* _tmp0;
				_tmp1 = NULL;
				_tmp0 = NULL;
				category = (_tmp1 = (_tmp0 = tmp, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (category == NULL) ? NULL : (category = (g_object_unref (category), NULL)), _tmp1);
				(tmp == NULL) ? NULL : (tmp = (g_object_unref (tmp), NULL));
				break;
			}
			(tmp == NULL) ? NULL : (tmp = (g_object_unref (tmp), NULL));
		}
		(_tmp_it == NULL) ? NULL : (_tmp_it = (g_object_unref (_tmp_it), NULL));
	}
	return category;
}


static void rygel_tracker_root_container_class_init (RygelTrackerRootContainerClass * klass) {
	rygel_tracker_root_container_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelTrackerRootContainerPrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_tracker_root_container_finalize;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children = rygel_tracker_root_container_real_get_children;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->get_children_finish = rygel_tracker_root_container_real_get_children_finish;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object = rygel_tracker_root_container_real_find_object;
	RYGEL_MEDIA_CONTAINER_CLASS (klass)->find_object_finish = rygel_tracker_root_container_real_find_object_finish;
}


static void rygel_tracker_root_container_instance_init (RygelTrackerRootContainer * self) {
	self->priv = RYGEL_TRACKER_ROOT_CONTAINER_GET_PRIVATE (self);
}


static void rygel_tracker_root_container_finalize (GObject* obj) {
	RygelTrackerRootContainer * self;
	self = RYGEL_TRACKER_ROOT_CONTAINER (obj);
	(self->priv->categories == NULL) ? NULL : (self->priv->categories = (g_object_unref (self->priv->categories), NULL));
	G_OBJECT_CLASS (rygel_tracker_root_container_parent_class)->finalize (obj);
}


GType rygel_tracker_root_container_get_type (void) {
	static GType rygel_tracker_root_container_type_id = 0;
	if (rygel_tracker_root_container_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerRootContainerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_root_container_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerRootContainer), 0, (GInstanceInitFunc) rygel_tracker_root_container_instance_init, NULL };
		rygel_tracker_root_container_type_id = g_type_register_static (RYGEL_TYPE_MEDIA_CONTAINER, "RygelTrackerRootContainer", &g_define_type_info, 0);
	}
	return rygel_tracker_root_container_type_id;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




