/*
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-plugin.h"
#include <gee/collection.h>
#include "rygel-connection-manager.h"
#include "rygel-media-receiver-registrar.h"




enum  {
	RYGEL_PLUGIN_DUMMY_PROPERTY
};
static gpointer rygel_plugin_parent_class = NULL;
static void rygel_plugin_finalize (GObject* obj);



RygelPlugin* rygel_plugin_construct (GType object_type, const char* name) {
	RygelPlugin * self;
	char* _tmp1;
	const char* _tmp0;
	GeeArrayList* _tmp2;
	GeeArrayList* _tmp3;
	RygelResourceInfo* resource_info;
	RygelResourceInfo* _tmp4;
	g_return_val_if_fail (name != NULL, NULL);
	self = g_object_newv (object_type, 0, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->name = (_tmp1 = (_tmp0 = name, (_tmp0 == NULL) ? NULL : g_strdup (_tmp0)), self->name = (g_free (self->name), NULL), _tmp1);
	_tmp2 = NULL;
	self->resource_infos = (_tmp2 = gee_array_list_new (RYGEL_TYPE_RESOURCE_INFO, (GBoxedCopyFunc) rygel_resource_info_ref, rygel_resource_info_unref, g_direct_equal), (self->resource_infos == NULL) ? NULL : (self->resource_infos = (g_object_unref (self->resource_infos), NULL)), _tmp2);
	_tmp3 = NULL;
	self->icon_infos = (_tmp3 = gee_array_list_new (RYGEL_TYPE_ICON_INFO, (GBoxedCopyFunc) rygel_icon_info_ref, rygel_icon_info_unref, g_direct_equal), (self->icon_infos == NULL) ? NULL : (self->icon_infos = (g_object_unref (self->icon_infos), NULL)), _tmp3);
	resource_info = rygel_resource_info_new (RYGEL_CONNECTION_MANAGER_UPNP_ID, RYGEL_CONNECTION_MANAGER_UPNP_TYPE, RYGEL_CONNECTION_MANAGER_DESCRIPTION_PATH, RYGEL_TYPE_CONNECTION_MANAGER);
	rygel_plugin_add_resource (self, resource_info);
	_tmp4 = NULL;
	resource_info = (_tmp4 = rygel_resource_info_new (RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_ID, RYGEL_MEDIA_RECEIVER_REGISTRAR_UPNP_TYPE, RYGEL_MEDIA_RECEIVER_REGISTRAR_DESCRIPTION_PATH, RYGEL_TYPE_MEDIA_RECEIVER_REGISTRAR), (resource_info == NULL) ? NULL : (resource_info = (rygel_resource_info_unref (resource_info), NULL)), _tmp4);
	rygel_plugin_add_resource (self, resource_info);
	return self;
}


RygelPlugin* rygel_plugin_new (const char* name) {
	return rygel_plugin_construct (RYGEL_TYPE_PLUGIN, name);
}


void rygel_plugin_add_resource (RygelPlugin* self, RygelResourceInfo* resource_info) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (resource_info != NULL);
	gee_collection_add ((GeeCollection*) self->resource_infos, resource_info);
	gupnp_resource_factory_register_resource_type ((GUPnPResourceFactory*) self, resource_info->upnp_type, resource_info->type);
}


void rygel_plugin_add_icon (RygelPlugin* self, RygelIconInfo* icon_info) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (icon_info != NULL);
	gee_collection_add ((GeeCollection*) self->icon_infos, icon_info);
}


static void rygel_plugin_class_init (RygelPluginClass * klass) {
	rygel_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = rygel_plugin_finalize;
}


static void rygel_plugin_instance_init (RygelPlugin * self) {
}


static void rygel_plugin_finalize (GObject* obj) {
	RygelPlugin * self;
	self = RYGEL_PLUGIN (obj);
	self->name = (g_free (self->name), NULL);
	(self->resource_infos == NULL) ? NULL : (self->resource_infos = (g_object_unref (self->resource_infos), NULL));
	(self->icon_infos == NULL) ? NULL : (self->icon_infos = (g_object_unref (self->icon_infos), NULL));
	G_OBJECT_CLASS (rygel_plugin_parent_class)->finalize (obj);
}


GType rygel_plugin_get_type (void) {
	static GType rygel_plugin_type_id = 0;
	if (rygel_plugin_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelPluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelPlugin), 0, (GInstanceInitFunc) rygel_plugin_instance_init, NULL };
		rygel_plugin_type_id = g_type_register_static (GUPNP_TYPE_RESOURCE_FACTORY, "RygelPlugin", &g_define_type_info, 0);
	}
	return rygel_plugin_type_id;
}




