/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali <zeenix@gmail.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-tracker-image-category.h"
#include <rygel-media-object.h>
#include "rygel-tracker-image-item.h"




enum  {
	RYGEL_TRACKER_IMAGE_CATEGORY_DUMMY_PROPERTY
};
static char** rygel_tracker_image_category_real_get_metadata_keys (RygelTrackerCategory* base, int* result_length1);
static RygelMediaItem* rygel_tracker_image_category_real_create_item (RygelTrackerCategory* base, const char* path, char** metadata, int metadata_length1);
static gpointer rygel_tracker_image_category_parent_class = NULL;



RygelTrackerImageCategory* rygel_tracker_image_category_construct (GType object_type, const char* id, RygelMediaContainer* parent, const char* title) {
	RygelTrackerImageCategory * self;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (title != NULL, NULL);
	self = (RygelTrackerImageCategory*) rygel_tracker_category_construct (object_type, id, parent, title, "Images", RYGEL_MEDIA_ITEM_IMAGE_CLASS);
	return self;
}


RygelTrackerImageCategory* rygel_tracker_image_category_new (const char* id, RygelMediaContainer* parent, const char* title) {
	return rygel_tracker_image_category_construct (RYGEL_TYPE_TRACKER_IMAGE_CATEGORY, id, parent, title);
}


static char** rygel_tracker_image_category_real_get_metadata_keys (RygelTrackerCategory* base, int* result_length1) {
	RygelTrackerImageCategory * self;
	gint _tmp0;
	char** _tmp1;
	self = (RygelTrackerImageCategory*) base;
	_tmp1 = NULL;
	return (_tmp1 = rygel_tracker_image_item_get_metadata_keys (&_tmp0), *result_length1 = _tmp0, _tmp1);
}


static RygelMediaItem* rygel_tracker_image_category_real_create_item (RygelTrackerCategory* base, const char* path, char** metadata, int metadata_length1) {
	RygelTrackerImageCategory * self;
	char* _tmp1;
	char* _tmp0;
	RygelMediaItem* _tmp2;
	self = (RygelTrackerImageCategory*) base;
	g_return_val_if_fail (path != NULL, NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	return (_tmp2 = (RygelMediaItem*) rygel_tracker_image_item_new (_tmp1 = g_strconcat (_tmp0 = g_strconcat (((RygelMediaObject*) self)->id, ":", NULL), path, NULL), path, (RygelTrackerCategory*) self, metadata, metadata_length1), _tmp1 = (g_free (_tmp1), NULL), _tmp0 = (g_free (_tmp0), NULL), _tmp2);
}


static void rygel_tracker_image_category_class_init (RygelTrackerImageCategoryClass * klass) {
	rygel_tracker_image_category_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_CATEGORY_CLASS (klass)->get_metadata_keys = rygel_tracker_image_category_real_get_metadata_keys;
	RYGEL_TRACKER_CATEGORY_CLASS (klass)->create_item = rygel_tracker_image_category_real_create_item;
}


static void rygel_tracker_image_category_instance_init (RygelTrackerImageCategory * self) {
}


GType rygel_tracker_image_category_get_type (void) {
	static GType rygel_tracker_image_category_type_id = 0;
	if (rygel_tracker_image_category_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerImageCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_image_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerImageCategory), 0, (GInstanceInitFunc) rygel_tracker_image_category_instance_init, NULL };
		rygel_tracker_image_category_type_id = g_type_register_static (RYGEL_TYPE_TRACKER_CATEGORY, "RygelTrackerImageCategory", &g_define_type_info, 0);
	}
	return rygel_tracker_image_category_type_id;
}




