/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-test-plugin.h"
#include <stdlib.h>
#include <string.h>
#include <rygel-resource-info.h>
#include <rygel-content-directory.h>
#include "rygel-test-content-dir.h"







RygelPlugin* load_plugin (void) {
	RygelPlugin* plugin;
	RygelResourceInfo* resource_info;
	RygelPlugin* _tmp0;
	plugin = rygel_plugin_new ("Test");
	/* We only implement a ContentDirectory service*/
	resource_info = rygel_resource_info_new (RYGEL_CONTENT_DIRECTORY_UPNP_ID, RYGEL_CONTENT_DIRECTORY_UPNP_TYPE, RYGEL_CONTENT_DIRECTORY_DESCRIPTION_PATH, RYGEL_TYPE_TEST_CONTENT_DIR);
	rygel_plugin_add_resource (plugin, resource_info);
	_tmp0 = NULL;
	return (_tmp0 = plugin, (resource_info == NULL) ? NULL : (resource_info = (rygel_resource_info_unref (resource_info), NULL)), _tmp0);
}




