/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include "rygel-test-content-dir.h"
#include <libgupnp/gupnp.h>
#include <stdlib.h>
#include <string.h>
#include "rygel-test-root-container.h"




enum  {
	RYGEL_TEST_CONTENT_DIR_DUMMY_PROPERTY
};
static RygelMediaContainer* rygel_test_content_dir_real_create_root_container (RygelContentDirectory* base);
static gpointer rygel_test_content_dir_parent_class = NULL;



/* Pubic methods */
static RygelMediaContainer* rygel_test_content_dir_real_create_root_container (RygelContentDirectory* base) {
	RygelTestContentDir * self;
	GUPnPRootDevice* _tmp1;
	GUPnPRootDevice* _tmp0;
	char* _tmp2;
	char* friendly_name;
	RygelMediaContainer* _tmp3;
	self = (RygelTestContentDir*) base;
	_tmp1 = NULL;
	_tmp0 = NULL;
	_tmp2 = NULL;
	friendly_name = (_tmp2 = gupnp_device_info_get_friendly_name ((GUPnPDeviceInfo*) (_tmp1 = (g_object_get ((GUPnPService*) self, "root-device", &_tmp0, NULL), _tmp0))), (_tmp1 == NULL) ? NULL : (_tmp1 = (g_object_unref (_tmp1), NULL)), _tmp2);
	_tmp3 = NULL;
	return (_tmp3 = (RygelMediaContainer*) rygel_test_root_container_new (friendly_name), friendly_name = (g_free (friendly_name), NULL), _tmp3);
}


/**
 * Implementation of ContentDirectory service, meant for testing purposes only.
 */
RygelTestContentDir* rygel_test_content_dir_construct (GType object_type) {
	RygelTestContentDir * self;
	self = (RygelTestContentDir*) rygel_content_directory_construct (object_type);
	return self;
}


RygelTestContentDir* rygel_test_content_dir_new (void) {
	return rygel_test_content_dir_construct (RYGEL_TYPE_TEST_CONTENT_DIR);
}


static void rygel_test_content_dir_class_init (RygelTestContentDirClass * klass) {
	rygel_test_content_dir_parent_class = g_type_class_peek_parent (klass);
	RYGEL_CONTENT_DIRECTORY_CLASS (klass)->create_root_container = rygel_test_content_dir_real_create_root_container;
}


static void rygel_test_content_dir_instance_init (RygelTestContentDir * self) {
}


GType rygel_test_content_dir_get_type (void) {
	static GType rygel_test_content_dir_type_id = 0;
	if (rygel_test_content_dir_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTestContentDirClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_test_content_dir_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTestContentDir), 0, (GInstanceInitFunc) rygel_test_content_dir_instance_init, NULL };
		rygel_test_content_dir_type_id = g_type_register_static (RYGEL_TYPE_CONTENT_DIRECTORY, "RygelTestContentDir", &g_define_type_info, 0);
	}
	return rygel_test_content_dir_type_id;
}




