/*
 * Copyright (C) 2008 Zeeshan Ali (Khattak) <zeeshanak@gnome.org>.
 * Copyright (C) 2008 Nokia Corporation, all rights reserved.
 *
 * Author: Zeeshan Ali (Khattak) <zeeshanak@gnome.org>
 *                               <zeeshan.ali@nokia.com>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#ifndef __RYGEL_DVB_CHANNEL_H__
#define __RYGEL_DVB_CHANNEL_H__

#include <glib.h>
#include <glib-object.h>
#include <rygel-media-item.h>
#include <dbus/dbus-glib-lowlevel.h>
#include <dbus/dbus-glib.h>
#include <rygel-media-container.h>

G_BEGIN_DECLS


#define RYGEL_TYPE_DVB_CHANNEL (rygel_dvb_channel_get_type ())
#define RYGEL_DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_DVB_CHANNEL, RygelDVBChannel))
#define RYGEL_DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_DVB_CHANNEL, RygelDVBChannelClass))
#define RYGEL_IS_DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_DVB_CHANNEL))
#define RYGEL_IS_DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_DVB_CHANNEL))
#define RYGEL_DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_DVB_CHANNEL, RygelDVBChannelClass))

typedef struct _RygelDVBChannel RygelDVBChannel;
typedef struct _RygelDVBChannelClass RygelDVBChannelClass;
typedef struct _RygelDVBChannelPrivate RygelDVBChannelPrivate;

/**
 * Represents DVB item.
 */
struct _RygelDVBChannel {
	RygelMediaItem parent_instance;
	RygelDVBChannelPrivate * priv;
};

struct _RygelDVBChannelClass {
	RygelMediaItemClass parent_class;
};


extern DBusGProxy* rygel_dvb_channel_channel_list;
RygelDVBChannel* rygel_dvb_channel_construct (GType object_type, guint cid, RygelMediaContainer* parent, DBusGProxy* channel_list, GError** error);
RygelDVBChannel* rygel_dvb_channel_new (guint cid, RygelMediaContainer* parent, DBusGProxy* channel_list, GError** error);
void rygel_dvb_channel_fetch_metadata (RygelDVBChannel* self, GError** error);
GType rygel_dvb_channel_get_type (void);


G_END_DECLS

#endif
