/* rygel-tracker-music-item-factory.c generated by valac 0.14.2, the Vala compiler
 * generated from rygel-tracker-music-item-factory.vala, do not modify */

/*
 * Copyright (C) 2008 Zeeshan Ali <zeenix@gmail.com>.
 * Copyright (C) 2008 Nokia Corporation.
 * Copyright (C) 2010 MediaNet Inh.
 *
 * Authors: Zeeshan Ali <zeenix@gmail.com>
 *          Sunil Mohan Adapa <sunil@medhas.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <rygel.h>
#include <gee.h>


#define RYGEL_TRACKER_TYPE_ITEM_FACTORY (rygel_tracker_item_factory_get_type ())
#define RYGEL_TRACKER_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactory))
#define RYGEL_TRACKER_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))
#define RYGEL_TRACKER_IS_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_ITEM_FACTORY))
#define RYGEL_TRACKER_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_ITEM_FACTORY, RygelTrackerItemFactoryClass))

typedef struct _RygelTrackerItemFactory RygelTrackerItemFactory;
typedef struct _RygelTrackerItemFactoryClass RygelTrackerItemFactoryClass;
typedef struct _RygelTrackerItemFactoryPrivate RygelTrackerItemFactoryPrivate;

#define RYGEL_TRACKER_TYPE_SEARCH_CONTAINER (rygel_tracker_search_container_get_type ())
#define RYGEL_TRACKER_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainer))
#define RYGEL_TRACKER_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_IS_SEARCH_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER))
#define RYGEL_TRACKER_SEARCH_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_SEARCH_CONTAINER, RygelTrackerSearchContainerClass))

typedef struct _RygelTrackerSearchContainer RygelTrackerSearchContainer;
typedef struct _RygelTrackerSearchContainerClass RygelTrackerSearchContainerClass;

#define RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY (rygel_tracker_music_item_factory_get_type ())
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactory))
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactoryClass))
#define RYGEL_TRACKER_IS_MUSIC_ITEM_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY))
#define RYGEL_TRACKER_IS_MUSIC_ITEM_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY))
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY, RygelTrackerMusicItemFactoryClass))

typedef struct _RygelTrackerMusicItemFactory RygelTrackerMusicItemFactory;
typedef struct _RygelTrackerMusicItemFactoryClass RygelTrackerMusicItemFactoryClass;
typedef struct _RygelTrackerMusicItemFactoryPrivate RygelTrackerMusicItemFactoryPrivate;

#define RYGEL_TRACKER_ITEM_FACTORY_TYPE_METADATA (rygel_tracker_item_factory_metadata_get_type ())

#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_TYPE_MUSIC_METADATA (rygel_tracker_music_item_factory_music_metadata_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _RygelTrackerItemFactory {
	GTypeInstance parent_instance;
	volatile int ref_count;
	RygelTrackerItemFactoryPrivate * priv;
	gchar* category;
	gchar* category_iri;
	gchar* upnp_class;
	gchar* upload_dir;
	GeeArrayList* properties;
};

struct _RygelTrackerItemFactoryClass {
	GTypeClass parent_class;
	void (*finalize) (RygelTrackerItemFactory *self);
	RygelMediaItem* (*create) (RygelTrackerItemFactory* self, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
	void (*set_metadata) (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
};

struct _RygelTrackerMusicItemFactory {
	RygelTrackerItemFactory parent_instance;
	RygelTrackerMusicItemFactoryPrivate * priv;
};

struct _RygelTrackerMusicItemFactoryClass {
	RygelTrackerItemFactoryClass parent_class;
};

typedef enum  {
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_URL,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_PLACE_HOLDER,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_FILE_NAME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_TITLE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DLNA_PROFILE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_MIME,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_SIZE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_DATE,
	RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY
} RygelTrackerItemFactoryMetadata;

typedef enum  {
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION = RYGEL_TRACKER_ITEM_FACTORY_METADATA_LAST_KEY,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE,
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY
} RygelTrackerMusicItemFactoryMusicMetadata;


static gpointer rygel_tracker_music_item_factory_parent_class = NULL;

gpointer rygel_tracker_item_factory_ref (gpointer instance);
void rygel_tracker_item_factory_unref (gpointer instance);
GParamSpec* rygel_tracker_param_spec_item_factory (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_tracker_value_set_item_factory (GValue* value, gpointer v_object);
void rygel_tracker_value_take_item_factory (GValue* value, gpointer v_object);
gpointer rygel_tracker_value_get_item_factory (const GValue* value);
GType rygel_tracker_item_factory_get_type (void) G_GNUC_CONST;
GType rygel_tracker_search_container_get_type (void) G_GNUC_CONST;
GType rygel_tracker_music_item_factory_get_type (void) G_GNUC_CONST;
enum  {
	RYGEL_TRACKER_MUSIC_ITEM_FACTORY_DUMMY_PROPERTY
};
GType rygel_tracker_item_factory_metadata_get_type (void) G_GNUC_CONST;
static GType rygel_tracker_music_item_factory_music_metadata_get_type (void) G_GNUC_UNUSED;
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY "nmm:MusicPiece"
#define RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY_IRI "http://www.tracker-project.org/" "temp/nmm#MusicPiece"
RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_new (void);
RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_construct (GType object_type);
RygelTrackerItemFactory* rygel_tracker_item_factory_construct (GType object_type, const gchar* category, const gchar* category_iri, const gchar* upnp_class, const gchar* upload_dir);
static RygelMediaItem* rygel_tracker_music_item_factory_real_create (RygelTrackerItemFactory* base, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error);
void rygel_tracker_item_factory_set_metadata (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
static void rygel_tracker_music_item_factory_real_set_metadata (RygelTrackerItemFactory* base, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error);
void rygel_tracker_item_factory_set_ref_id (RygelTrackerItemFactory* self, RygelMediaItem* item, const gchar* prefix);


static GType rygel_tracker_music_item_factory_music_metadata_get_type (void) {
	static volatile gsize rygel_tracker_music_item_factory_music_metadata_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_music_item_factory_music_metadata_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION", "duration"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM", "audio-album"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST", "audio-artist"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM", "audio-track-num"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE", "audio-genre"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE", "sample-rate"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS", "channels"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE", "bits-per-sample"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE", "bitrate"}, {RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY, "RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_LAST_KEY", "last-key"}, {0, NULL, NULL}};
		GType rygel_tracker_music_item_factory_music_metadata_type_id;
		rygel_tracker_music_item_factory_music_metadata_type_id = g_enum_register_static ("RygelTrackerMusicItemFactoryMusicMetadata", values);
		g_once_init_leave (&rygel_tracker_music_item_factory_music_metadata_type_id__volatile, rygel_tracker_music_item_factory_music_metadata_type_id);
	}
	return rygel_tracker_music_item_factory_music_metadata_type_id__volatile;
}


RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_construct (GType object_type) {
	RygelTrackerMusicItemFactory* self = NULL;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* upload_folder;
	const gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	GeeArrayList* _tmp11_;
	GeeArrayList* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_get_user_special_dir (G_USER_DIRECTORY_MUSIC);
	_tmp1_ = g_strdup (_tmp0_);
	upload_folder = _tmp1_;
	{
		RygelMetaConfig* _tmp2_ = NULL;
		RygelMetaConfig* config;
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		_tmp2_ = rygel_meta_config_get_default ();
		config = _tmp2_;
		_tmp3_ = rygel_configuration_get_music_upload_folder ((RygelConfiguration*) config, &_inner_error_);
		_tmp4_ = _tmp3_;
		if (_inner_error_ != NULL) {
			_g_object_unref0 (config);
			goto __catch10_g_error;
		}
		_g_free0 (upload_folder);
		upload_folder = _tmp4_;
		_g_object_unref0 (config);
	}
	goto __finally10;
	__catch10_g_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_g_error_free0 (_error_);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		_g_free0 (upload_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp5_ = upload_folder;
	self = (RygelTrackerMusicItemFactory*) rygel_tracker_item_factory_construct (object_type, RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY, RYGEL_TRACKER_MUSIC_ITEM_FACTORY_CATEGORY_IRI, RYGEL_MUSIC_ITEM_UPNP_CLASS, _tmp5_);
	_tmp6_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp6_, "res@duration");
	_tmp7_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp7_, "upnp:album");
	_tmp8_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, "upnp:artist");
	_tmp9_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, "upnp:originalTrackNumber");
	_tmp10_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, "upnp:genre");
	_tmp11_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, "sampleRate");
	_tmp12_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp12_, "upnp:nrAudioChannels");
	_tmp13_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, "upnp:bitsPerSample");
	_tmp14_ = ((RygelTrackerItemFactory*) self)->properties;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, "upnp:bitrate");
	_g_free0 (upload_folder);
	return self;
}


RygelTrackerMusicItemFactory* rygel_tracker_music_item_factory_new (void) {
	return rygel_tracker_music_item_factory_construct (RYGEL_TRACKER_TYPE_MUSIC_ITEM_FACTORY);
}


static RygelMediaItem* rygel_tracker_music_item_factory_real_create (RygelTrackerItemFactory* base, const gchar* id, const gchar* uri, RygelTrackerSearchContainer* parent, gchar** metadata, int metadata_length1, GError** error) {
	RygelTrackerMusicItemFactory * self;
	RygelMediaItem* result = NULL;
	const gchar* _tmp0_;
	RygelTrackerSearchContainer* _tmp1_;
	RygelMusicItem* _tmp2_;
	RygelMusicItem* item;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerMusicItemFactory*) base;
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (parent != NULL, NULL);
	_tmp0_ = id;
	_tmp1_ = parent;
	_tmp2_ = rygel_music_item_new (_tmp0_, (RygelMediaContainer*) _tmp1_, "", RYGEL_MUSIC_ITEM_UPNP_CLASS);
	item = _tmp2_;
	_tmp3_ = uri;
	_tmp4_ = metadata;
	_tmp4__length1 = metadata_length1;
	rygel_tracker_item_factory_set_metadata ((RygelTrackerItemFactory*) self, (RygelMediaItem*) item, _tmp3_, _tmp4_, _tmp4__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (item);
		return NULL;
	}
	result = (RygelMediaItem*) item;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void rygel_tracker_music_item_factory_real_set_metadata (RygelTrackerItemFactory* base, RygelMediaItem* item, const gchar* uri, gchar** metadata, int metadata_length1, GError** error) {
	RygelTrackerMusicItemFactory * self;
	RygelMediaItem* _tmp0_;
	const gchar* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	RygelMediaItem* _tmp3_;
	RygelMediaItem* _tmp4_;
	RygelMusicItem* _tmp5_;
	RygelMusicItem* music;
	gboolean _tmp6_ = FALSE;
	gchar** _tmp7_;
	gint _tmp7__length1;
	const gchar* _tmp8_;
	gboolean _tmp11_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	const gchar* _tmp17_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	const gchar* _tmp23_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	const gchar* _tmp29_;
	gchar** _tmp36_;
	gint _tmp36__length1;
	const gchar* _tmp37_;
	gchar** _tmp42_;
	gint _tmp42__length1;
	const gchar* _tmp43_;
	gchar** _tmp50_;
	gint _tmp50__length1;
	const gchar* _tmp51_;
	gchar** _tmp56_;
	gint _tmp56__length1;
	const gchar* _tmp57_;
	gchar** _tmp62_;
	gint _tmp62__length1;
	const gchar* _tmp63_;
	RygelMusicItem* _tmp68_;
	GError * _inner_error_ = NULL;
	self = (RygelTrackerMusicItemFactory*) base;
	g_return_if_fail (item != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = item;
	_tmp1_ = uri;
	_tmp2_ = metadata;
	_tmp2__length1 = metadata_length1;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (rygel_tracker_music_item_factory_parent_class)->set_metadata (RYGEL_TRACKER_ITEM_FACTORY (self), _tmp0_, _tmp1_, _tmp2_, _tmp2__length1, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = item;
	rygel_tracker_item_factory_set_ref_id ((RygelTrackerItemFactory*) self, _tmp3_, "AllMusic");
	_tmp4_ = item;
	_tmp5_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (_tmp4_) ? ((RygelMusicItem*) _tmp4_) : NULL);
	music = _tmp5_;
	_tmp7_ = metadata;
	_tmp7__length1 = metadata_length1;
	_tmp8_ = _tmp7_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION];
	if (g_strcmp0 (_tmp8_, "") != 0) {
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		_tmp9_ = metadata;
		_tmp9__length1 = metadata_length1;
		_tmp10_ = _tmp9_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION];
		_tmp6_ = g_strcmp0 (_tmp10_, "0") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	_tmp11_ = _tmp6_;
	if (_tmp11_) {
		RygelMusicItem* _tmp12_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		gint _tmp15_ = 0;
		_tmp12_ = music;
		_tmp13_ = metadata;
		_tmp13__length1 = metadata_length1;
		_tmp14_ = _tmp13_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_DURATION];
		_tmp15_ = atoi (_tmp14_);
		((RygelAudioItem*) _tmp12_)->duration = (glong) _tmp15_;
	}
	_tmp16_ = metadata;
	_tmp16__length1 = metadata_length1;
	_tmp17_ = _tmp16_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE];
	if (g_strcmp0 (_tmp17_, "") != 0) {
		RygelMusicItem* _tmp18_;
		gchar** _tmp19_;
		gint _tmp19__length1;
		const gchar* _tmp20_;
		gint _tmp21_ = 0;
		_tmp18_ = music;
		_tmp19_ = metadata;
		_tmp19__length1 = metadata_length1;
		_tmp20_ = _tmp19_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_SAMPLE_RATE];
		_tmp21_ = atoi (_tmp20_);
		((RygelAudioItem*) _tmp18_)->sample_freq = _tmp21_;
	}
	_tmp22_ = metadata;
	_tmp22__length1 = metadata_length1;
	_tmp23_ = _tmp22_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS];
	if (g_strcmp0 (_tmp23_, "") != 0) {
		RygelMusicItem* _tmp24_;
		gchar** _tmp25_;
		gint _tmp25__length1;
		const gchar* _tmp26_;
		gint _tmp27_ = 0;
		_tmp24_ = music;
		_tmp25_ = metadata;
		_tmp25__length1 = metadata_length1;
		_tmp26_ = _tmp25_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_CHANNELS];
		_tmp27_ = atoi (_tmp26_);
		((RygelAudioItem*) _tmp24_)->channels = _tmp27_;
	}
	_tmp28_ = metadata;
	_tmp28__length1 = metadata_length1;
	_tmp29_ = _tmp28_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE];
	if (g_strcmp0 (_tmp29_, "") != 0) {
		gchar** _tmp30_;
		gint _tmp30__length1;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* bits_per_sample;
		RygelMusicItem* _tmp33_;
		const gchar* _tmp34_;
		gint _tmp35_ = 0;
		_tmp30_ = metadata;
		_tmp30__length1 = metadata_length1;
		_tmp31_ = _tmp30_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITS_PER_SAMPLE];
		_tmp32_ = g_strdup (_tmp31_);
		bits_per_sample = _tmp32_;
		_tmp33_ = music;
		_tmp34_ = bits_per_sample;
		_tmp35_ = atoi (_tmp34_);
		((RygelAudioItem*) _tmp33_)->bits_per_sample = _tmp35_;
		_g_free0 (bits_per_sample);
	}
	_tmp36_ = metadata;
	_tmp36__length1 = metadata_length1;
	_tmp37_ = _tmp36_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE];
	if (g_strcmp0 (_tmp37_, "") != 0) {
		RygelMusicItem* _tmp38_;
		gchar** _tmp39_;
		gint _tmp39__length1;
		const gchar* _tmp40_;
		gint _tmp41_ = 0;
		_tmp38_ = music;
		_tmp39_ = metadata;
		_tmp39__length1 = metadata_length1;
		_tmp40_ = _tmp39_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_BITRATE];
		_tmp41_ = atoi (_tmp40_);
		((RygelAudioItem*) _tmp38_)->bitrate = _tmp41_ / 8;
	}
	_tmp42_ = metadata;
	_tmp42__length1 = metadata_length1;
	_tmp43_ = _tmp42_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM];
	if (g_strcmp0 (_tmp43_, "") != 0) {
		gchar** _tmp44_;
		gint _tmp44__length1;
		const gchar* _tmp45_;
		gchar* _tmp46_;
		gchar* track_number;
		RygelMusicItem* _tmp47_;
		const gchar* _tmp48_;
		gint _tmp49_ = 0;
		_tmp44_ = metadata;
		_tmp44__length1 = metadata_length1;
		_tmp45_ = _tmp44_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_TRACK_NUM];
		_tmp46_ = g_strdup (_tmp45_);
		track_number = _tmp46_;
		_tmp47_ = music;
		_tmp48_ = track_number;
		_tmp49_ = atoi (_tmp48_);
		_tmp47_->track_number = _tmp49_;
		_g_free0 (track_number);
	}
	_tmp50_ = metadata;
	_tmp50__length1 = metadata_length1;
	_tmp51_ = _tmp50_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST];
	if (g_strcmp0 (_tmp51_, "") != 0) {
		RygelMusicItem* _tmp52_;
		gchar** _tmp53_;
		gint _tmp53__length1;
		const gchar* _tmp54_;
		gchar* _tmp55_;
		_tmp52_ = music;
		_tmp53_ = metadata;
		_tmp53__length1 = metadata_length1;
		_tmp54_ = _tmp53_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ARTIST];
		_tmp55_ = g_strdup (_tmp54_);
		_g_free0 (_tmp52_->artist);
		_tmp52_->artist = _tmp55_;
	}
	_tmp56_ = metadata;
	_tmp56__length1 = metadata_length1;
	_tmp57_ = _tmp56_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM];
	if (g_strcmp0 (_tmp57_, "") != 0) {
		RygelMusicItem* _tmp58_;
		gchar** _tmp59_;
		gint _tmp59__length1;
		const gchar* _tmp60_;
		gchar* _tmp61_;
		_tmp58_ = music;
		_tmp59_ = metadata;
		_tmp59__length1 = metadata_length1;
		_tmp60_ = _tmp59_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_ALBUM];
		_tmp61_ = g_strdup (_tmp60_);
		_g_free0 (_tmp58_->album);
		_tmp58_->album = _tmp61_;
	}
	_tmp62_ = metadata;
	_tmp62__length1 = metadata_length1;
	_tmp63_ = _tmp62_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE];
	if (g_strcmp0 (_tmp63_, "") != 0) {
		RygelMusicItem* _tmp64_;
		gchar** _tmp65_;
		gint _tmp65__length1;
		const gchar* _tmp66_;
		gchar* _tmp67_;
		_tmp64_ = music;
		_tmp65_ = metadata;
		_tmp65__length1 = metadata_length1;
		_tmp66_ = _tmp65_[RYGEL_TRACKER_MUSIC_ITEM_FACTORY_MUSIC_METADATA_AUDIO_GENRE];
		_tmp67_ = g_strdup (_tmp66_);
		_g_free0 (_tmp64_->genre);
		_tmp64_->genre = _tmp67_;
	}
	_tmp68_ = music;
	rygel_music_item_lookup_album_art (_tmp68_);
	_g_object_unref0 (music);
}


static void rygel_tracker_music_item_factory_class_init (RygelTrackerMusicItemFactoryClass * klass) {
	rygel_tracker_music_item_factory_parent_class = g_type_class_peek_parent (klass);
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->create = rygel_tracker_music_item_factory_real_create;
	RYGEL_TRACKER_ITEM_FACTORY_CLASS (klass)->set_metadata = rygel_tracker_music_item_factory_real_set_metadata;
}


static void rygel_tracker_music_item_factory_instance_init (RygelTrackerMusicItemFactory * self) {
}


/**
 * Tracker music item factory.
 */
GType rygel_tracker_music_item_factory_get_type (void) {
	static volatile gsize rygel_tracker_music_item_factory_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_tracker_music_item_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelTrackerMusicItemFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_tracker_music_item_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelTrackerMusicItemFactory), 0, (GInstanceInitFunc) rygel_tracker_music_item_factory_instance_init, NULL };
		GType rygel_tracker_music_item_factory_type_id;
		rygel_tracker_music_item_factory_type_id = g_type_register_static (RYGEL_TRACKER_TYPE_ITEM_FACTORY, "RygelTrackerMusicItemFactory", &g_define_type_info, 0);
		g_once_init_leave (&rygel_tracker_music_item_factory_type_id__volatile, rygel_tracker_music_item_factory_type_id);
	}
	return rygel_tracker_music_item_factory_type_id__volatile;
}



