/* rygel-media-export-media-cache.c generated by valac 0.12.0, the Vala compiler
 * generated from rygel-media-export-media-cache.vala, do not modify */

/*
 * Copyright (C) 2009,2010 Jens Georg <mail@jensge.org>.
 *
 * Author: Jens Georg <mail@jensge.org>
 *
 * This file is part of Rygel.
 *
 * Rygel is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Rygel is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <string.h>
#include <gee.h>
#include <stdlib.h>
#include <gio/gio.h>
#include <sqlite3.h>
#include <rygel.h>
#include <glib/gi18n-lib.h>
#include <libgupnp-av/gupnp-av.h>


#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_TYPE (rygel_media_export_object_type_get_type ())

#define RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY (rygel_media_export_exists_cache_entry_get_type ())
typedef struct _RygelMediaExportExistsCacheEntry RygelMediaExportExistsCacheEntry;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE (rygel_media_export_media_cache_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCache))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCacheClass))

typedef struct _RygelMediaExportMediaCache RygelMediaExportMediaCache;
typedef struct _RygelMediaExportMediaCacheClass RygelMediaExportMediaCacheClass;
typedef struct _RygelMediaExportMediaCachePrivate RygelMediaExportMediaCachePrivate;

#define RYGEL_MEDIA_EXPORT_TYPE_DATABASE (rygel_media_export_database_get_type ())
#define RYGEL_MEDIA_EXPORT_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabase))
#define RYGEL_MEDIA_EXPORT_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DATABASE))
#define RYGEL_MEDIA_EXPORT_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DATABASE, RygelMediaExportDatabaseClass))

typedef struct _RygelMediaExportDatabase RygelMediaExportDatabase;
typedef struct _RygelMediaExportDatabaseClass RygelMediaExportDatabaseClass;

#define RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY (rygel_media_export_object_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactory))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_OBJECT_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY))
#define RYGEL_MEDIA_EXPORT_OBJECT_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_OBJECT_FACTORY, RygelMediaExportObjectFactoryClass))

typedef struct _RygelMediaExportObjectFactory RygelMediaExportObjectFactory;
typedef struct _RygelMediaExportObjectFactoryClass RygelMediaExportObjectFactoryClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY (rygel_media_export_sql_factory_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactory))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY))
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FACTORY, RygelMediaExportSQLFactoryClass))

typedef struct _RygelMediaExportSQLFactory RygelMediaExportSQLFactory;
typedef struct _RygelMediaExportSQLFactoryClass RygelMediaExportSQLFactoryClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_STRING (rygel_media_export_sql_string_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block2Data Block2Data;

#define RYGEL_MEDIA_EXPORT_TYPE_DETAIL_COLUMN (rygel_media_export_detail_column_get_type ())
typedef struct _Block3Data Block3Data;
typedef struct _Block4Data Block4Data;
#define _rygel_media_export_exists_cache_entry_free0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_exists_cache_entry_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
typedef struct _Block6Data Block6Data;
typedef struct _Block7Data Block7Data;

#define RYGEL_TYPE_NULL_CONTAINER (rygel_null_container_get_type ())
#define RYGEL_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainer))
#define RYGEL_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))
#define RYGEL_IS_NULL_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_IS_NULL_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_TYPE_NULL_CONTAINER))
#define RYGEL_NULL_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_TYPE_NULL_CONTAINER, RygelNullContainerClass))

typedef struct _RygelNullContainer RygelNullContainer;
typedef struct _RygelNullContainerClass RygelNullContainerClass;

#define RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER (rygel_media_export_media_cache_upgrader_get_type ())
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgrader))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_IS_MEDIA_CACHE_UPGRADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER))
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_UPGRADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE_UPGRADER, RygelMediaExportMediaCacheUpgraderClass))

typedef struct _RygelMediaExportMediaCacheUpgrader RygelMediaExportMediaCacheUpgrader;
typedef struct _RygelMediaExportMediaCacheUpgraderClass RygelMediaExportMediaCacheUpgraderClass;
#define _rygel_media_export_media_cache_upgrader_unref0(var) ((var == NULL) ? NULL : (var = (rygel_media_export_media_cache_upgrader_unref (var), NULL)))
typedef struct _Block8Data Block8Data;

#define RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER (rygel_media_export_db_container_get_type ())
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainer))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_IS_DB_CONTAINER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER))
#define RYGEL_MEDIA_EXPORT_DB_CONTAINER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_DB_CONTAINER, RygelMediaExportDBContainerClass))

typedef struct _RygelMediaExportDBContainer RygelMediaExportDBContainer;
typedef struct _RygelMediaExportDBContainerClass RygelMediaExportDBContainerClass;
typedef struct _Block9Data Block9Data;
#define __vala_GValue_free0(var) ((var == NULL) ? NULL : (var = (_vala_GValue_free (var), NULL)))

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR (rygel_media_export_sql_operator_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperator))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_IS_SQL_OPERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR))
#define RYGEL_MEDIA_EXPORT_SQL_OPERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_OPERATOR, RygelMediaExportSqlOperatorClass))

typedef struct _RygelMediaExportSqlOperator RygelMediaExportSqlOperator;
typedef struct _RygelMediaExportSqlOperatorClass RygelMediaExportSqlOperatorClass;

#define RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION (rygel_media_export_sql_function_get_type ())
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunction))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_IS_SQL_FUNCTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION))
#define RYGEL_MEDIA_EXPORT_SQL_FUNCTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), RYGEL_MEDIA_EXPORT_TYPE_SQL_FUNCTION, RygelMediaExportSqlFunctionClass))

typedef struct _RygelMediaExportSqlFunction RygelMediaExportSqlFunction;
typedef struct _RygelMediaExportSqlFunctionClass RygelMediaExportSqlFunctionClass;
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;

typedef enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_SQLITE_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE,
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH
} RygelMediaExportMediaCacheError;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR rygel_media_export_media_cache_error_quark ()
typedef enum  {
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER,
	RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM
} RygelMediaExportObjectType;

struct _RygelMediaExportExistsCacheEntry {
	gint64 mtime;
	gint64 size;
};

struct _RygelMediaExportMediaCache {
	GObject parent_instance;
	RygelMediaExportMediaCachePrivate * priv;
};

struct _RygelMediaExportMediaCacheClass {
	GObjectClass parent_class;
};

struct _RygelMediaExportMediaCachePrivate {
	RygelMediaExportDatabase* db;
	RygelMediaExportObjectFactory* factory;
	RygelMediaExportSQLFactory* sql;
	GeeHashMap* exists_cache;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_IO_ERROR,
	RYGEL_MEDIA_EXPORT_DATABASE_ERROR_SQLITE_ERROR
} RygelMediaExportDatabaseError;
#define RYGEL_MEDIA_EXPORT_DATABASE_ERROR rygel_media_export_database_error_quark ()
typedef gboolean (*RygelMediaExportDatabaseRowCallback) (sqlite3_stmt* stmt, void* user_data);
typedef enum  {
	RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER,
	RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_METADATA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE,
	RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON,
	RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA,
	RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE
} RygelMediaExportSQLString;

struct _Block2Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObject* parent;
};

typedef enum  {
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE,
	RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE
} RygelMediaExportDetailColumn;

struct _Block3Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gint count;
};

struct _Block4Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gboolean exists;
	gint64 tmp_timestamp;
	gint64 tmp_size;
};

struct _Block5Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObjects* children;
	RygelMediaContainer* container;
};

struct _Block6Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	glong count;
};

struct _Block7Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	RygelMediaObjects* children;
	RygelMediaContainer* parent;
};

struct _Block8Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	gint rows;
};

struct _Block9Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* children;
};

struct _Block10Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* data;
};

struct _Block11Data {
	int _ref_count_;
	RygelMediaExportMediaCache * self;
	GeeArrayList* uris;
};


static gpointer rygel_media_export_media_cache_parent_class = NULL;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance;
static RygelMediaExportMediaCache* rygel_media_export_media_cache_instance = NULL;

GQuark rygel_media_export_media_cache_error_quark (void);
GType rygel_media_export_object_type_get_type (void) G_GNUC_CONST;
GType rygel_media_export_exists_cache_entry_get_type (void) G_GNUC_CONST;
RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self);
void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self);
GType rygel_media_export_media_cache_get_type (void) G_GNUC_CONST;
GType rygel_media_export_database_get_type (void) G_GNUC_CONST;
GType rygel_media_export_object_factory_get_type (void) G_GNUC_CONST;
GType rygel_media_export_sql_factory_get_type (void) G_GNUC_CONST;
#define RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, RygelMediaExportMediaCachePrivate))
enum  {
	RYGEL_MEDIA_EXPORT_MEDIA_CACHE_DUMMY_PROPERTY
};
gchar* rygel_media_export_media_cache_get_id (GFile* file);
GQuark rygel_media_export_database_error_quark (void);
void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error);
gint rygel_media_export_database_exec (RygelMediaExportDatabase* self, const gchar* sql, GValue* values, int values_length1, RygelMediaExportDatabaseRowCallback callback, void* callback_target, GCancellable* cancellable, GError** error);
GType rygel_media_export_sql_string_get_type (void) G_GNUC_CONST;
const gchar* rygel_media_export_sql_factory_make (RygelMediaExportSQLFactory* self, RygelMediaExportSQLString query);
static void _vala_GValue_array_free (GValue* array, gint array_length);
void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error);
void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error);
void rygel_media_export_database_begin (RygelMediaExportDatabase* self, GError** error);
static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error);
void rygel_media_export_database_commit (RygelMediaExportDatabase* self, GError** error);
void rygel_media_export_database_rollback (RygelMediaExportDatabase* self);
void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error);
RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (Block2Data* _data2_);
static gboolean _lambda3_ (sqlite3_stmt* statement, Block2Data* _data2_);
GType rygel_media_export_detail_column_get_type (void) G_GNUC_CONST;
static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, const gchar* object_id, sqlite3_stmt* statement);
static gboolean __lambda3__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const gchar* item_id, GError** error);
RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static gboolean _lambda4_ (sqlite3_stmt* statement, Block3Data* _data3_);
static gboolean __lambda4__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static void rygel_media_export_media_cache_get_exists_cache (RygelMediaExportMediaCache* self, GError** error);
static gboolean _lambda5_ (sqlite3_stmt* statement, RygelMediaExportMediaCache* self);
static gboolean __lambda5__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (Block4Data* _data4_);
static gboolean _lambda6_ (sqlite3_stmt* statement, Block4Data* _data4_);
static gboolean __lambda6__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, glong offset, glong max_count, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static gboolean _lambda7_ (sqlite3_stmt* statement, Block5Data* _data5_);
static gboolean __lambda7__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, guint offset, guint max_count, guint* total_matches, GError** error);
static gchar* rygel_media_export_media_cache_translate_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error);
RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, glong offset, glong max_count, GError** error);
glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static gboolean _lambda0_ (sqlite3_stmt* statement, Block6Data* _data6_);
static gboolean __lambda0__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static gboolean _lambda2_ (sqlite3_stmt* statement, Block7Data* _data7_);
RygelNullContainer* rygel_null_container_new (void);
RygelNullContainer* rygel_null_container_construct (GType object_type);
GType rygel_null_container_get_type (void) G_GNUC_CONST;
static gboolean __lambda2__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error);
static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_new (void);
RygelMediaExportSQLFactory* rygel_media_export_sql_factory_construct (GType object_type);
static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_new (void);
RygelMediaExportObjectFactory* rygel_media_export_object_factory_construct (GType object_type);
RygelMediaExportDatabase* rygel_media_export_database_new (const gchar* name, GError** error);
RygelMediaExportDatabase* rygel_media_export_database_construct (GType object_type, const gchar* name, GError** error);
#define RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version "10"
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_new (RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
RygelMediaExportMediaCacheUpgrader* rygel_media_export_media_cache_upgrader_construct (GType object_type, RygelMediaExportDatabase* database, RygelMediaExportSQLFactory* sql);
gpointer rygel_media_export_media_cache_upgrader_ref (gpointer instance);
void rygel_media_export_media_cache_upgrader_unref (gpointer instance);
GParamSpec* rygel_media_export_param_spec_media_cache_upgrader (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void rygel_media_export_value_set_media_cache_upgrader (GValue* value, gpointer v_object);
void rygel_media_export_value_take_media_cache_upgrader (GValue* value, gpointer v_object);
gpointer rygel_media_export_value_get_media_cache_upgrader (const GValue* value);
GType rygel_media_export_media_cache_upgrader_get_type (void) G_GNUC_CONST;
gboolean rygel_media_export_media_cache_upgrader_needs_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint* current_version, GError** error);
void rygel_media_export_media_cache_upgrader_upgrade (RygelMediaExportMediaCacheUpgrader* self, gint old_version);
void rygel_media_export_media_cache_upgrader_fix_schema (RygelMediaExportMediaCacheUpgrader* self, GError** error);
void rygel_media_export_media_cache_upgrader_ensure_indices (RygelMediaExportMediaCacheUpgrader* self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static gboolean _lambda12_ (sqlite3_stmt* statement, Block8Data* _data8_);
static gboolean __lambda12__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self);
void rygel_media_export_database_null (GValue* result);
void rygel_media_export_database_analyze (RygelMediaExportDatabase* self);
GType rygel_media_export_db_container_get_type (void) G_GNUC_CONST;
RygelMediaExportDBContainer* rygel_media_export_object_factory_get_container (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, const gchar* id, const gchar* title, guint child_count, const gchar* uri);
RygelMediaItem* rygel_media_export_object_factory_get_item (RygelMediaExportObjectFactory* self, RygelMediaExportMediaCache* media_db, RygelMediaContainer* parent, const gchar* id, const gchar* title, const gchar* upnp_class);
static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item);
GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static gboolean _lambda13_ (sqlite3_stmt* statement, Block9Data* _data9_);
static gboolean __lambda13__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error);
static gchar* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const gchar* operand, gchar** collate, GError** error);
static void _vala_GValue_free (GValue* self);
GType rygel_media_export_sql_operator_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new_from_search_criteria_op (GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct_from_search_criteria_op (GType object_type, GUPnPSearchCriteriaOp op, const gchar* arg, const gchar* collate);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_new (const gchar* name, const gchar* arg);
RygelMediaExportSqlFunction* rygel_media_export_sql_function_construct (GType object_type, const gchar* name, const gchar* arg);
GType rygel_media_export_sql_function_get_type (void) G_GNUC_CONST;
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_new (const gchar* name, const gchar* arg, const gchar* collate);
RygelMediaExportSqlOperator* rygel_media_export_sql_operator_construct (GType object_type, const gchar* name, const gchar* arg, const gchar* collate);
gchar* rygel_media_export_sql_operator_to_string (RygelMediaExportSqlOperator* self);
GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, glong max_count, GError** error);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static gboolean _lambda1_ (sqlite3_stmt* statement, Block10Data* _data10_);
static gboolean __lambda1__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error);
void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error);
GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static gboolean _lambda14_ (sqlite3_stmt* statement, Block11Data* _data11_);
static gboolean __lambda14__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self);
static void rygel_media_export_media_cache_finalize (GObject* obj);


GQuark rygel_media_export_media_cache_error_quark (void) {
	return g_quark_from_static_string ("rygel_media_export_media_cache_error-quark");
}


GType rygel_media_export_object_type_get_type (void) {
	static volatile gsize rygel_media_export_object_type_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_object_type_type_id__volatile)) {
		static const GEnumValue values[] = {{RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER", "container"}, {RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM, "RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM", "item"}, {0, NULL, NULL}};
		GType rygel_media_export_object_type_type_id;
		rygel_media_export_object_type_type_id = g_enum_register_static ("RygelMediaExportObjectType", values);
		g_once_init_leave (&rygel_media_export_object_type_type_id__volatile, rygel_media_export_object_type_type_id);
	}
	return rygel_media_export_object_type_type_id__volatile;
}


RygelMediaExportExistsCacheEntry* rygel_media_export_exists_cache_entry_dup (const RygelMediaExportExistsCacheEntry* self) {
	RygelMediaExportExistsCacheEntry* dup;
	dup = g_new0 (RygelMediaExportExistsCacheEntry, 1);
	memcpy (dup, self, sizeof (RygelMediaExportExistsCacheEntry));
	return dup;
}


void rygel_media_export_exists_cache_entry_free (RygelMediaExportExistsCacheEntry* self) {
	g_free (self);
}


GType rygel_media_export_exists_cache_entry_get_type (void) {
	static volatile gsize rygel_media_export_exists_cache_entry_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_exists_cache_entry_type_id__volatile)) {
		GType rygel_media_export_exists_cache_entry_type_id;
		rygel_media_export_exists_cache_entry_type_id = g_boxed_type_register_static ("RygelMediaExportExistsCacheEntry", (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, (GBoxedFreeFunc) rygel_media_export_exists_cache_entry_free);
		g_once_init_leave (&rygel_media_export_exists_cache_entry_type_id__volatile, rygel_media_export_exists_cache_entry_type_id);
	}
	return rygel_media_export_exists_cache_entry_type_id__volatile;
}


gchar* rygel_media_export_media_cache_get_id (GFile* file) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = g_file_get_uri (file);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _tmp1_, (gsize) (-1));
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}


static void _vala_GValue_array_free (GValue* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			g_value_unset (&array[i]);
		}
	}
	g_free (array);
}


void rygel_media_export_media_cache_remove_by_id (RygelMediaExportMediaCache* self, const gchar* id, GError** error) {
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = 1;
	_tmp2_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_DELETE);
	rygel_media_export_database_exec (self->priv->db, _tmp2_, values, values_length1, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			return;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


void rygel_media_export_media_cache_remove_object (RygelMediaExportMediaCache* self, RygelMediaObject* object, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	rygel_media_export_media_cache_remove_by_id (self, object->id, &_inner_error_);
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static gpointer _g_error_copy0 (gpointer self) {
	return self ? g_error_copy (self) : NULL;
}


void rygel_media_export_media_cache_save_container (RygelMediaExportMediaCache* self, RygelMediaContainer* container, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (container != NULL);
	rygel_media_export_database_begin (self->priv->db, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch5_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) container, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch5_rygel_media_export_database_error;
		}
		goto __finally5;
	}
	rygel_media_export_database_commit (self->priv->db, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch5_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally5;
	__catch5_rygel_media_export_database_error:
	{
		GError * _error_;
		GError* _tmp0_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		rygel_media_export_database_rollback (self->priv->db);
		_tmp0_ = _g_error_copy0 (_error_);
		_inner_error_ = _tmp0_;
		_g_error_free0 (_error_);
		goto __finally5;
	}
	__finally5:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


void rygel_media_export_media_cache_save_item (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	rygel_media_export_database_begin (self->priv->db, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch6_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	rygel_media_export_media_cache_save_metadata (self, item, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch6_rygel_media_export_database_error;
		}
		goto __finally6;
	}
	rygel_media_export_media_cache_create_object (self, (RygelMediaObject*) item, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch6_rygel_media_export_database_error;
		}
		goto __finally6;
	}
	rygel_media_export_database_commit (self->priv->db, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch6_rygel_media_export_database_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	goto __finally6;
	__catch6_rygel_media_export_database_error:
	{
		GError * _error_;
		const gchar* _tmp0_ = NULL;
		GError* _tmp1_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = _ ("Failed to add item with ID %s: %s");
		g_warning (_tmp0_, ((RygelMediaObject*) item)->id, _error_->message);
		rygel_media_export_database_rollback (self->priv->db);
		_tmp1_ = _g_error_copy0 (_error_);
		_inner_error_ = _tmp1_;
		_g_error_free0 (_error_);
		goto __finally6;
	}
	__finally6:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (Block2Data* _data2_) {
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		_g_object_unref0 (_data2_->self);
		_g_object_unref0 (_data2_->parent);
		g_slice_free (Block2Data, _data2_);
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lambda3_ (sqlite3_stmt* statement, Block2Data* _data2_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	RygelMediaObject* _tmp0_;
	RygelMediaContainer* _tmp1_;
	RygelMediaContainer* parent_container;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* id;
	RygelMediaObject* _tmp4_ = NULL;
	RygelMediaObject* object;
	RygelMediaObject* _tmp5_;
	self = _data2_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = _data2_->parent;
	_tmp1_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp0_) ? ((RygelMediaContainer*) _tmp0_) : NULL);
	parent_container = _tmp1_;
	_tmp2_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
	_tmp3_ = g_strdup (_tmp2_);
	id = _tmp3_;
	_tmp4_ = rygel_media_export_media_cache_get_object_from_statement (self, parent_container, id, statement);
	object = _tmp4_;
	rygel_media_object_set_parent_ref (object, parent_container);
	_tmp5_ = _g_object_ref0 (object);
	_g_object_unref0 (_data2_->parent);
	_data2_->parent = _tmp5_;
	result = TRUE;
	_g_object_unref0 (object);
	_g_free0 (id);
	_g_object_unref0 (parent_container);
	return result;
}


static gboolean __lambda3__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda3_ (stmt, self);
	return result;
}


RygelMediaObject* rygel_media_export_media_cache_get_object (RygelMediaExportMediaCache* self, const gchar* object_id, GError** error) {
	RygelMediaObject* result = NULL;
	Block2Data* _data2_;
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportDatabaseRowCallback cb;
	void* cb_target = NULL;
	GDestroyNotify cb_target_destroy_notify = NULL;
	const gchar* _tmp2_ = NULL;
	RygelMediaObject* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_id != NULL, NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_object_ref (self);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, object_id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = 1;
	_data2_->parent = NULL;
	cb = __lambda3__rygel_media_export_database_row_callback;
	cb_target = block2_data_ref (_data2_);
	cb_target_destroy_notify = block2_data_unref;
	_tmp2_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT);
	rygel_media_export_database_exec (self->priv->db, _tmp2_, values, values_length1, cb, cb_target, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			return NULL;
		} else {
			(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
			cb = NULL;
			cb_target = NULL;
			cb_target_destroy_notify = NULL;
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block2_data_unref (_data2_);
			_data2_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = _g_object_ref0 (_data2_->parent);
	result = _tmp3_;
	(cb_target_destroy_notify == NULL) ? NULL : (cb_target_destroy_notify (cb_target), NULL);
	cb = NULL;
	cb_target = NULL;
	cb_target_destroy_notify = NULL;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block2_data_unref (_data2_);
	_data2_ = NULL;
	return result;
}


RygelMediaItem* rygel_media_export_media_cache_get_item (RygelMediaExportMediaCache* self, const gchar* item_id, GError** error) {
	RygelMediaItem* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* object;
	gboolean _tmp1_ = FALSE;
	RygelMediaObject* _tmp4_;
	RygelMediaItem* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (item_id != NULL, NULL);
	_tmp0_ = rygel_media_export_media_cache_get_object (self, item_id, &_inner_error_);
	object = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (object != NULL) {
		_tmp1_ = !RYGEL_IS_MEDIA_ITEM (object);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp2_ = NULL;
		GError* _tmp3_ = NULL;
		_tmp2_ = _ ("Object %s is not an item");
		_tmp3_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, _tmp2_, item_id);
		_inner_error_ = _tmp3_;
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			return NULL;
		} else {
			_g_object_unref0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = object;
	_tmp5_ = _g_object_ref0 (RYGEL_IS_MEDIA_ITEM (_tmp4_) ? ((RygelMediaItem*) _tmp4_) : NULL);
	result = _tmp5_;
	_g_object_unref0 (object);
	return result;
}


RygelMediaContainer* rygel_media_export_media_cache_get_container (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	RygelMediaContainer* result = NULL;
	RygelMediaObject* _tmp0_ = NULL;
	RygelMediaObject* object;
	gboolean _tmp1_ = FALSE;
	RygelMediaObject* _tmp3_;
	RygelMediaContainer* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = rygel_media_export_media_cache_get_object (self, container_id, &_inner_error_);
	object = _tmp0_;
	if (_inner_error_ != NULL) {
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	if (object != NULL) {
		_tmp1_ = !RYGEL_IS_MEDIA_CONTAINER (object);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GError* _tmp2_ = NULL;
		_tmp2_ = g_error_new (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_INVALID_TYPE, "Object with id %s is " "not a MediaContainer", container_id);
		_inner_error_ = _tmp2_;
		if ((_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) || (_inner_error_->domain == RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR)) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (object);
			return NULL;
		} else {
			_g_object_unref0 (object);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp3_ = object;
	_tmp4_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp3_) ? ((RygelMediaContainer*) _tmp3_) : NULL);
	result = _tmp4_;
	_g_object_unref0 (object);
	return result;
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		g_slice_free (Block3Data, _data3_);
	}
}


static gboolean _lambda4_ (sqlite3_stmt* statement, Block3Data* _data3_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = _data3_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_int (statement, 0);
	_data3_->count = _tmp0_;
	result = FALSE;
	return result;
}


static gboolean __lambda4__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda4_ (stmt, self);
	return result;
}


gint rygel_media_export_media_cache_get_child_count (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	gint result = 0;
	Block3Data* _data3_;
	GValue _tmp0_ = {0};
	GValue* _tmp1_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	const gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (container_id != NULL, 0);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_data3_->count = 0;
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, container_id);
	_tmp1_ = g_new0 (GValue, 1);
	_tmp1_[0] = _tmp0_;
	values = _tmp1_;
	values_length1 = 1;
	_values_size_ = 1;
	_tmp2_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_COUNT);
	rygel_media_export_database_exec (self->priv->db, _tmp2_, values, values_length1, __lambda4__rygel_media_export_database_row_callback, _data3_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			return 0;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block3_data_unref (_data3_);
			_data3_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return 0;
		}
	}
	result = _data3_->count;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}


static gboolean _lambda5_ (sqlite3_stmt* statement, RygelMediaExportMediaCache* self) {
	gboolean result = FALSE;
	RygelMediaExportExistsCacheEntry entry = {0};
	gint64 _tmp0_;
	gint64 _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_val_if_fail (statement != NULL, FALSE);
	memset (&entry, 0, sizeof (RygelMediaExportExistsCacheEntry));
	_tmp0_ = sqlite3_column_int64 (statement, 1);
	entry.mtime = _tmp0_;
	_tmp1_ = sqlite3_column_int64 (statement, 0);
	entry.size = _tmp1_;
	_tmp2_ = sqlite3_column_text (statement, 2);
	gee_abstract_map_set ((GeeAbstractMap*) self->priv->exists_cache, _tmp2_, &entry);
	result = TRUE;
	return result;
}


static gboolean __lambda5__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda5_ (stmt, self);
	return result;
}


static void rygel_media_export_media_cache_get_exists_cache (RygelMediaExportMediaCache* self, GError** error) {
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, RYGEL_MEDIA_EXPORT_TYPE_EXISTS_CACHE_ENTRY, (GBoxedCopyFunc) rygel_media_export_exists_cache_entry_dup, rygel_media_export_exists_cache_entry_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->exists_cache);
	self->priv->exists_cache = _tmp0_;
	_tmp1_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS_CACHE);
	rygel_media_export_database_exec (self->priv->db, _tmp1_, NULL, 0, __lambda5__rygel_media_export_database_row_callback, self, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (Block4Data* _data4_) {
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		_g_object_unref0 (_data4_->self);
		g_slice_free (Block4Data, _data4_);
	}
}


static gboolean _lambda6_ (sqlite3_stmt* statement, Block4Data* _data4_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	gint _tmp0_;
	gint64 _tmp1_;
	gint64 _tmp2_;
	self = _data4_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_int (statement, 0);
	_data4_->exists = _tmp0_ == 1;
	_tmp1_ = sqlite3_column_int64 (statement, 1);
	_data4_->tmp_timestamp = _tmp1_;
	_tmp2_ = sqlite3_column_int64 (statement, 2);
	_data4_->tmp_size = _tmp2_;
	result = FALSE;
	return result;
}


static gboolean __lambda6__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda6_ (stmt, self);
	return result;
}


gboolean rygel_media_export_media_cache_exists (RygelMediaExportMediaCache* self, GFile* file, gint64* timestamp, gint64* size, GError** error) {
	gint64 _timestamp = 0LL;
	gint64 _size = 0LL;
	gboolean result = FALSE;
	Block4Data* _data4_;
	gchar* _tmp0_ = NULL;
	gchar* uri;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	gboolean _tmp3_;
	const gchar* _tmp5_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (file != NULL, FALSE);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	_data4_->exists = FALSE;
	_tmp0_ = g_file_get_uri (file);
	uri = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, uri);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = 1;
	_data4_->tmp_timestamp = (gint64) 0;
	_data4_->tmp_size = (gint64) 0;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) self->priv->exists_cache, uri);
	if (_tmp3_) {
		gpointer _tmp4_ = NULL;
		RygelMediaExportExistsCacheEntry* entry;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) self->priv->exists_cache, uri);
		entry = (RygelMediaExportExistsCacheEntry*) _tmp4_;
		gee_abstract_map_unset ((GeeAbstractMap*) self->priv->exists_cache, uri, NULL);
		_timestamp = (*entry).mtime;
		_size = (*entry).size;
		result = TRUE;
		_rygel_media_export_exists_cache_entry_free0 (entry);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (uri);
		block4_data_unref (_data4_);
		_data4_ = NULL;
		if (timestamp) {
			*timestamp = _timestamp;
		}
		if (size) {
			*size = _size;
		}
		return result;
	}
	_tmp5_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_EXISTS);
	rygel_media_export_database_exec (self->priv->db, _tmp5_, values, values_length1, __lambda6__rygel_media_export_database_row_callback, _data4_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			return FALSE;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			_g_free0 (uri);
			block4_data_unref (_data4_);
			_data4_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_timestamp = _data4_->tmp_timestamp;
	_size = _data4_->tmp_size;
	result = _data4_->exists;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (uri);
	block4_data_unref (_data4_);
	_data4_ = NULL;
	if (timestamp) {
		*timestamp = _timestamp;
	}
	if (size) {
		*size = _size;
	}
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_g_object_unref0 (_data5_->children);
		_g_object_unref0 (_data5_->container);
		g_slice_free (Block5Data, _data5_);
	}
}


static gboolean _lambda7_ (sqlite3_stmt* statement, Block5Data* _data5_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* child_id;
	RygelMediaObject* _tmp2_ = NULL;
	RygelMediaObject* _tmp3_;
	gpointer _tmp4_ = NULL;
	RygelMediaObject* _tmp5_;
	self = _data5_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
	_tmp1_ = g_strdup (_tmp0_);
	child_id = _tmp1_;
	_tmp2_ = rygel_media_export_media_cache_get_object_from_statement (self, _data5_->container, child_id, statement);
	_tmp3_ = _tmp2_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _data5_->children, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = gee_abstract_list_last ((GeeAbstractList*) _data5_->children);
	_tmp5_ = (RygelMediaObject*) _tmp4_;
	rygel_media_object_set_parent_ref (_tmp5_, _data5_->container);
	_g_object_unref0 (_tmp5_);
	result = TRUE;
	_g_free0 (child_id);
	return result;
}


static gboolean __lambda7__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda7_ (stmt, self);
	return result;
}


RygelMediaObjects* rygel_media_export_media_cache_get_children (RygelMediaExportMediaCache* self, RygelMediaContainer* container, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	Block5Data* _data5_;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	GValue* _tmp4_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	RygelMediaExportDatabaseRowCallback callback;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	const gchar* _tmp5_ = NULL;
	RygelMediaObjects* _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container != NULL, NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->container = _g_object_ref0 (container);
	_tmp0_ = rygel_media_objects_new ();
	_data5_->children = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, ((RygelMediaObject*) _data5_->container)->id);
	g_value_init (&_tmp2_, G_TYPE_INT64);
	g_value_set_int64 (&_tmp2_, (gint64) offset);
	g_value_init (&_tmp3_, G_TYPE_INT64);
	g_value_set_int64 (&_tmp3_, (gint64) max_count);
	_tmp4_ = g_new0 (GValue, 3);
	_tmp4_[0] = _tmp1_;
	_tmp4_[1] = _tmp2_;
	_tmp4_[2] = _tmp3_;
	values = _tmp4_;
	values_length1 = 3;
	_values_size_ = 3;
	callback = __lambda7__rygel_media_export_database_row_callback;
	callback_target = block5_data_ref (_data5_);
	callback_target_destroy_notify = block5_data_unref;
	_tmp5_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_CHILDREN);
	rygel_media_export_database_exec (self->priv->db, _tmp5_, values, values_length1, callback, callback_target, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return NULL;
	}
	_tmp6_ = _g_object_ref0 (_data5_->children);
	result = _tmp6_;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


static guint rygel_media_export_media_cache_modify_limit (RygelMediaExportMediaCache* self, guint max_count) {
	guint result = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	if (max_count == 0) {
		result = (guint) (-1);
		return result;
	} else {
		result = max_count;
		return result;
	}
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, guint offset, guint max_count, guint* total_matches, GError** error) {
	guint _total_matches = 0U;
	RygelMediaObjects* result = NULL;
	GValueArray* _tmp0_ = NULL;
	GValueArray* args;
	gchar* _tmp1_ = NULL;
	gchar* filter;
	guint _tmp7_;
	guint max_objects;
	glong _tmp8_;
	glong _tmp9_;
	RygelMediaObjects* _tmp10_ = NULL;
	RygelMediaObjects* _tmp11_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = rygel_media_export_media_cache_translate_search_expression (self, expression, args, "WHERE", &_inner_error_);
	filter = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
	if (expression != NULL) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = rygel_search_expression_to_string (expression);
		_tmp3_ = _tmp2_;
		g_debug ("rygel-media-export-media-cache.vala:259: Original search: %s", _tmp3_);
		_g_free0 (_tmp3_);
		g_debug ("rygel-media-export-media-cache.vala:260: Parsed search expression: %s", filter);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				GValue* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < args->n_values)) {
					break;
				}
				_tmp5_ = g_value_array_get_nth (args, (guint) i);
				_tmp6_ = g_value_get_string (_tmp5_);
				g_debug ("rygel-media-export-media-cache.vala:264: Arg %d: %s", i, _tmp6_);
			}
		}
	}
	_tmp7_ = rygel_media_export_media_cache_modify_limit (self, max_count);
	max_objects = _tmp7_;
	_tmp8_ = rygel_media_export_media_cache_get_object_count_by_filter (self, filter, args, container_id, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_total_matches = (guint) _tmp9_;
	_tmp10_ = rygel_media_export_media_cache_get_objects_by_filter (self, filter, args, container_id, (glong) offset, (glong) max_objects, &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	result = _tmp11_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
	if (total_matches) {
		*total_matches = _total_matches;
	}
	return result;
}


glong rygel_media_export_media_cache_get_object_count_by_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, const gchar* container_id, GError** error) {
	glong result = 0L;
	GValueArray* _tmp0_ = NULL;
	GValueArray* args;
	gchar* _tmp1_ = NULL;
	gchar* filter;
	glong _tmp7_;
	glong _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (container_id != NULL, 0L);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = rygel_media_export_media_cache_translate_search_expression (self, expression, args, "WHERE", &_inner_error_);
	filter = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return 0L;
	}
	if (expression != NULL) {
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp2_ = rygel_search_expression_to_string (expression);
		_tmp3_ = _tmp2_;
		g_debug ("rygel-media-export-media-cache.vala:287: Original search: %s", _tmp3_);
		_g_free0 (_tmp3_);
		g_debug ("rygel-media-export-media-cache.vala:288: Parsed search expression: %s", filter);
	}
	{
		gint i;
		i = 0;
		{
			gboolean _tmp4_;
			_tmp4_ = TRUE;
			while (TRUE) {
				GValue* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				if (!_tmp4_) {
					i++;
				}
				_tmp4_ = FALSE;
				if (!(i < args->n_values)) {
					break;
				}
				_tmp5_ = g_value_array_get_nth (args, (guint) i);
				_tmp6_ = g_value_get_string (_tmp5_);
				g_debug ("rygel-media-export-media-cache.vala:292: Arg %d: %s", i, _tmp6_);
			}
		}
	}
	_tmp7_ = rygel_media_export_media_cache_get_object_count_by_filter (self, filter, args, container_id, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return 0L;
	}
	result = _tmp8_;
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		g_slice_free (Block6Data, _data6_);
	}
}


static gboolean _lambda0_ (sqlite3_stmt* statement, Block6Data* _data6_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = _data6_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_int (statement, 0);
	_data6_->count = (glong) _tmp0_;
	result = FALSE;
	return result;
}


static gboolean __lambda0__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda0_ (stmt, self);
	return result;
}


glong rygel_media_export_media_cache_get_object_count_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, GError** error) {
	glong result = 0L;
	Block6Data* _data6_;
	GValue _tmp0_ = {0};
	GValue v;
	RygelMediaExportDatabaseRowCallback callback;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* sql;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, 0L);
	g_return_val_if_fail (filter != NULL, 0L);
	g_return_val_if_fail (args != NULL, 0L);
	g_return_val_if_fail (container_id != NULL, 0L);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, container_id);
	v = _tmp0_;
	g_value_array_prepend (args, &v);
	_data6_->count = (glong) 0;
	g_debug ("rygel-media-export-media-cache.vala:309: Parameters to bind: %u", args->n_values);
	callback = __lambda0__rygel_media_export_database_row_callback;
	callback_target = block6_data_ref (_data6_);
	callback_target_destroy_notify = block6_data_unref;
	_tmp1_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECT_COUNT_BY_FILTER);
	sql = _tmp1_;
	_tmp2_ = g_strdup_printf (sql, filter);
	_tmp3_ = _tmp2_;
	rygel_media_export_database_exec (self->priv->db, _tmp3_, args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
	_g_free0 (_tmp3_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		block6_data_unref (_data6_);
		_data6_ = NULL;
		return 0L;
	}
	result = _data6_->count;
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		_g_object_unref0 (_data7_->self);
		_g_object_unref0 (_data7_->parent);
		_g_object_unref0 (_data7_->children);
		g_slice_free (Block7Data, _data7_);
	}
}


static gboolean _lambda2_ (sqlite3_stmt* statement, Block7Data* _data7_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* child_id;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	gchar* parent_id;
	gboolean _tmp4_ = FALSE;
	GError * _inner_error_ = NULL;
	self = _data7_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ID);
	_tmp1_ = g_strdup (_tmp0_);
	child_id = _tmp1_;
	_tmp2_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_PARENT);
	_tmp3_ = g_strdup (_tmp2_);
	parent_id = _tmp3_;
	if (_data7_->parent == NULL) {
		_tmp4_ = TRUE;
	} else {
		_tmp4_ = g_strcmp0 (parent_id, ((RygelMediaObject*) _data7_->parent)->id) != 0;
	}
	if (_tmp4_) {
		RygelNullContainer* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp5_ = rygel_null_container_new ();
		_g_object_unref0 (_data7_->parent);
		_data7_->parent = (RygelMediaContainer*) _tmp5_;
		_tmp6_ = g_strdup (parent_id);
		_g_free0 (((RygelMediaObject*) _data7_->parent)->id);
		((RygelMediaObject*) _data7_->parent)->id = _tmp6_;
	}
	if (_data7_->parent != NULL) {
		RygelMediaObject* _tmp7_ = NULL;
		RygelMediaObject* _tmp8_;
		gpointer _tmp9_ = NULL;
		RygelMediaObject* _tmp10_;
		_tmp7_ = rygel_media_export_media_cache_get_object_from_statement (self, _data7_->parent, child_id, statement);
		_tmp8_ = _tmp7_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _data7_->children, _tmp8_);
		_g_object_unref0 (_tmp8_);
		_tmp9_ = gee_abstract_list_last ((GeeAbstractList*) _data7_->children);
		_tmp10_ = (RygelMediaObject*) _tmp9_;
		rygel_media_object_set_parent_ref (_tmp10_, _data7_->parent);
		_g_object_unref0 (_tmp10_);
	} else {
		g_warning ("Inconsistent database: item %s " "has no parent %s", child_id, parent_id);
	}
	result = TRUE;
	_g_free0 (parent_id);
	_g_free0 (child_id);
	return result;
	goto __finally7;
	__catch7_rygel_media_export_database_error:
	{
		GError * _error_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("rygel-media-export-media-cache.vala:366: Failed to get parent item: %s", _error_->message);
		result = FALSE;
		_g_error_free0 (_error_);
		_g_free0 (parent_id);
		_g_free0 (child_id);
		return result;
	}
	__finally7:
	if (_inner_error_ != NULL) {
		_g_free0 (parent_id);
		_g_free0 (child_id);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_g_free0 (parent_id);
	_g_free0 (child_id);
}


static gboolean __lambda2__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda2_ (stmt, self);
	return result;
}


RygelMediaObjects* rygel_media_export_media_cache_get_objects_by_filter (RygelMediaExportMediaCache* self, const gchar* filter, GValueArray* args, const gchar* container_id, glong offset, glong max_count, GError** error) {
	RygelMediaObjects* result = NULL;
	Block7Data* _data7_;
	RygelMediaObjects* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue v;
	GValue _tmp2_ = {0};
	RygelMediaExportDatabaseRowCallback callback;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* sql;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	RygelMediaObjects* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = rygel_media_objects_new ();
	_data7_->children = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_LONG);
	g_value_set_long (&_tmp1_, offset);
	v = _tmp1_;
	g_value_array_append (args, &v);
	g_value_init (&_tmp2_, G_TYPE_LONG);
	g_value_set_long (&_tmp2_, max_count);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp2_;
	g_value_array_append (args, &v);
	_data7_->parent = NULL;
	g_debug ("rygel-media-export-media-cache.vala:341: Parameters to bind: %u", args->n_values);
	callback = __lambda2__rygel_media_export_database_row_callback;
	callback_target = block7_data_ref (_data7_);
	callback_target_destroy_notify = block7_data_unref;
	_tmp3_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_OBJECTS_BY_FILTER);
	_tmp4_ = g_strdup (_tmp3_);
	sql = _tmp4_;
	_tmp5_ = g_strdup_printf (sql, filter);
	_tmp6_ = _tmp5_;
	rygel_media_export_database_exec (self->priv->db, _tmp6_, args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
	_g_free0 (_tmp6_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sql);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		block7_data_unref (_data7_);
		_data7_ = NULL;
		return NULL;
	}
	_tmp7_ = _g_object_ref0 (_data7_->children);
	result = _tmp7_;
	_g_free0 (sql);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	block7_data_unref (_data7_);
	_data7_ = NULL;
	return result;
}


RygelMediaExportMediaCache* rygel_media_export_media_cache_get_default (GError** error) {
	RygelMediaExportMediaCache* result = NULL;
	RygelMediaExportMediaCache* _tmp2_;
	GError * _inner_error_ = NULL;
	if (rygel_media_export_media_cache_instance == NULL) {
		RygelMediaExportMediaCache* _tmp0_ = NULL;
		RygelMediaExportMediaCache* _tmp1_;
		_tmp0_ = rygel_media_export_media_cache_new (&_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		_g_object_unref0 (rygel_media_export_media_cache_instance);
		rygel_media_export_media_cache_instance = _tmp1_;
	}
	_tmp2_ = _g_object_ref0 (rygel_media_export_media_cache_instance);
	result = _tmp2_;
	return result;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_construct (GType object_type, GError** error) {
	RygelMediaExportMediaCache * self = NULL;
	RygelMediaExportSQLFactory* _tmp0_ = NULL;
	RygelMediaExportObjectFactory* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	self = (RygelMediaExportMediaCache*) g_object_new (object_type, NULL);
	_tmp0_ = rygel_media_export_sql_factory_new ();
	_g_object_unref0 (self->priv->sql);
	self->priv->sql = _tmp0_;
	rygel_media_export_media_cache_open_db (self, "media-export", &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp1_ = rygel_media_export_object_factory_new ();
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp1_;
	rygel_media_export_media_cache_get_exists_cache (self, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (self);
		return NULL;
	}
	return self;
}


static RygelMediaExportMediaCache* rygel_media_export_media_cache_new (GError** error) {
	return rygel_media_export_media_cache_construct (RYGEL_MEDIA_EXPORT_TYPE_MEDIA_CACHE, error);
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		g_slice_free (Block8Data, _data8_);
	}
}


static gboolean _lambda12_ (sqlite3_stmt* statement, Block8Data* _data8_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	gint _tmp0_;
	self = _data8_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_int (statement, 0);
	_data8_->rows = _tmp0_;
	result = FALSE;
	return result;
}


static gboolean __lambda12__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda12_ (stmt, self);
	return result;
}


static void rygel_media_export_media_cache_open_db (RygelMediaExportMediaCache* self, const gchar* name, GError** error) {
	RygelMediaExportDatabase* _tmp0_ = NULL;
	RygelMediaExportDatabase* _tmp1_;
	gint old_version;
	gint _tmp2_;
	gint current_version;
	RygelMediaExportMediaCacheUpgrader* _tmp3_ = NULL;
	RygelMediaExportMediaCacheUpgrader* upgrader;
	gint _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = rygel_media_export_database_new (name, &_inner_error_);
	_tmp1_ = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_g_object_unref0 (self->priv->db);
	self->priv->db = _tmp1_;
	old_version = -1;
	_tmp2_ = atoi (RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
	current_version = _tmp2_;
	_tmp3_ = rygel_media_export_media_cache_upgrader_new (self->priv->db, self->priv->sql);
	upgrader = _tmp3_;
	_tmp5_ = rygel_media_export_media_cache_upgrader_needs_upgrade (upgrader, &_tmp4_, &_inner_error_);
	old_version = _tmp4_;
	_tmp6_ = _tmp5_;
	if (_inner_error_ != NULL) {
		_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			goto __catch8_rygel_media_export_database_error;
		}
		goto __finally8;
	}
	if (_tmp6_) {
		rygel_media_export_media_cache_upgrader_upgrade (upgrader, old_version);
	} else {
		if (old_version == current_version) {
			rygel_media_export_media_cache_upgrader_fix_schema (upgrader, &_inner_error_);
			if (_inner_error_ != NULL) {
				_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
				if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
					goto __catch8_rygel_media_export_database_error;
				}
				goto __finally8;
			}
		} else {
			GError* _tmp7_ = NULL;
			g_warning ("The version \"%d\" of the detected database" " is newer than our supported version \"%d\"", old_version, current_version);
			_g_object_unref0 (self->priv->db);
			self->priv->db = NULL;
			_tmp7_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Database format" " not supported");
			_inner_error_ = _tmp7_;
			_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch8_rygel_media_export_database_error;
			}
			goto __finally8;
		}
	}
	rygel_media_export_media_cache_upgrader_ensure_indices (upgrader);
	_rygel_media_export_media_cache_upgrader_unref0 (upgrader);
	goto __finally8;
	__catch8_rygel_media_export_database_error:
	{
		GError * _error_;
		Block8Data* _data8_;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_debug ("rygel-media-export-media-cache.vala:418: %s", "Could not find schema version;" " checking for empty database...");
		_data8_ = g_slice_new0 (Block8Data);
		_data8_->_ref_count_ = 1;
		_data8_->self = g_object_ref (self);
		_data8_->rows = -1;
		rygel_media_export_database_exec (self->priv->db, "SELECT count(type) FROM sqlite_master " "WHERE rowid=1", NULL, 0, __lambda12__rygel_media_export_database_row_callback, _data8_, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			block8_data_unref (_data8_);
			_data8_ = NULL;
			if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
				goto __catch9_rygel_media_export_database_error;
			}
			block8_data_unref (_data8_);
			_data8_ = NULL;
			_g_error_free0 (_error_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		if (_data8_->rows == 0) {
			gboolean _tmp8_;
			g_debug ("rygel-media-export-media-cache.vala:431: Empty database, creating new " \
"schema version %s", RYGEL_MEDIA_EXPORT_SQL_FACTORY_schema_version);
			_tmp8_ = rygel_media_export_media_cache_create_schema (self);
			if (!_tmp8_) {
				_g_object_unref0 (self->priv->db);
				self->priv->db = NULL;
				block8_data_unref (_data8_);
				_data8_ = NULL;
				_g_error_free0 (_error_);
				return;
			}
		} else {
			g_warning ("rygel-media-export-media-cache.vala:439: Incompatible schema... cannot" \
" proceed");
			_g_object_unref0 (self->priv->db);
			self->priv->db = NULL;
			block8_data_unref (_data8_);
			_data8_ = NULL;
			_g_error_free0 (_error_);
			return;
		}
		block8_data_unref (_data8_);
		_data8_ = NULL;
		goto __finally9;
		__catch9_rygel_media_export_database_error:
		{
			GError * _error_;
			GError* _tmp9_ = NULL;
			_error_ = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("rygel-media-export-media-cache.vala:445: Something weird going on: %s", _error_->message);
			_g_object_unref0 (self->priv->db);
			self->priv->db = NULL;
			_tmp9_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_GENERAL_ERROR, "Invalid database");
			_inner_error_ = _tmp9_;
			_g_error_free0 (_error_);
			goto __finally9;
		}
		__finally9:
		if (_inner_error_ != NULL) {
			_g_error_free0 (_error_);
			goto __finally8;
		}
		_g_error_free0 (_error_);
	}
	__finally8:
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
}


static void rygel_media_export_media_cache_save_metadata (RygelMediaExportMediaCache* self, RygelMediaItem* item, GError** error) {
	gint64 _tmp0_;
	GValue _tmp1_ = {0};
	GValue _tmp2_ = {0};
	GValue _tmp3_ = {0};
	GValue _tmp4_ = {0};
	GValue _tmp5_ = {0};
	GValue _tmp6_ = {0};
	GValue _tmp7_ = {0};
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_ = {0};
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue _tmp14_ = {0};
	GValue _tmp15_ = {0};
	GValue _tmp16_ = {0};
	GValue _tmp17_ = {0};
	GValue _tmp18_ = {0};
	GValue _tmp19_ = {0};
	GValue _tmp20_ = {0};
	GValue _tmp21_ = {0};
	GValue* _tmp22_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	const gchar* _tmp60_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = rygel_media_item_get_size (item);
	g_value_init (&_tmp1_, G_TYPE_INT64);
	g_value_set_int64 (&_tmp1_, _tmp0_);
	g_value_init (&_tmp2_, G_TYPE_STRING);
	g_value_set_string (&_tmp2_, item->mime_type);
	g_value_init (&_tmp3_, G_TYPE_INT);
	g_value_set_int (&_tmp3_, -1);
	g_value_init (&_tmp4_, G_TYPE_INT);
	g_value_set_int (&_tmp4_, -1);
	g_value_init (&_tmp5_, G_TYPE_STRING);
	g_value_set_string (&_tmp5_, ((RygelMediaObject*) item)->upnp_class);
	rygel_media_export_database_null (&_tmp6_);
	_tmp7_ = _tmp6_;
	rygel_media_export_database_null (&_tmp8_);
	_tmp9_ = _tmp8_;
	g_value_init (&_tmp10_, G_TYPE_STRING);
	g_value_set_string (&_tmp10_, item->date);
	g_value_init (&_tmp11_, G_TYPE_INT);
	g_value_set_int (&_tmp11_, -1);
	g_value_init (&_tmp12_, G_TYPE_INT);
	g_value_set_int (&_tmp12_, -1);
	g_value_init (&_tmp13_, G_TYPE_INT);
	g_value_set_int (&_tmp13_, -1);
	g_value_init (&_tmp14_, G_TYPE_INT);
	g_value_set_int (&_tmp14_, -1);
	g_value_init (&_tmp15_, G_TYPE_INT);
	g_value_set_int (&_tmp15_, -1);
	g_value_init (&_tmp16_, G_TYPE_INT);
	g_value_set_int (&_tmp16_, -1);
	g_value_init (&_tmp17_, G_TYPE_INT);
	g_value_set_int (&_tmp17_, -1);
	g_value_init (&_tmp18_, G_TYPE_STRING);
	g_value_set_string (&_tmp18_, ((RygelMediaObject*) item)->id);
	g_value_init (&_tmp19_, G_TYPE_STRING);
	g_value_set_string (&_tmp19_, item->dlna_profile);
	rygel_media_export_database_null (&_tmp20_);
	_tmp21_ = _tmp20_;
	_tmp22_ = g_new0 (GValue, 18);
	_tmp22_[0] = _tmp1_;
	_tmp22_[1] = _tmp2_;
	_tmp22_[2] = _tmp3_;
	_tmp22_[3] = _tmp4_;
	_tmp22_[4] = _tmp5_;
	_tmp22_[5] = _tmp7_;
	_tmp22_[6] = _tmp9_;
	_tmp22_[7] = _tmp10_;
	_tmp22_[8] = _tmp11_;
	_tmp22_[9] = _tmp12_;
	_tmp22_[10] = _tmp13_;
	_tmp22_[11] = _tmp14_;
	_tmp22_[12] = _tmp15_;
	_tmp22_[13] = _tmp16_;
	_tmp22_[14] = _tmp17_;
	_tmp22_[15] = _tmp18_;
	_tmp22_[16] = _tmp19_;
	_tmp22_[17] = _tmp21_;
	values = _tmp22_;
	values_length1 = 18;
	_values_size_ = 18;
	if (RYGEL_IS_AUDIO_ITEM (item)) {
		RygelMediaItem* _tmp23_;
		RygelAudioItem* _tmp24_;
		RygelAudioItem* audio_item;
		GValue _tmp25_ = {0};
		GValue _tmp26_;
		GValue _tmp27_ = {0};
		GValue _tmp28_;
		GValue _tmp29_ = {0};
		GValue _tmp30_;
		GValue _tmp31_ = {0};
		GValue _tmp32_;
		GValue _tmp33_ = {0};
		GValue _tmp34_;
		_tmp23_ = item;
		_tmp24_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp23_) ? ((RygelAudioItem*) _tmp23_) : NULL);
		audio_item = _tmp24_;
		g_value_init (&_tmp25_, G_TYPE_LONG);
		g_value_set_long (&_tmp25_, audio_item->duration);
		_tmp26_ = _tmp25_;
		G_IS_VALUE (&values[14]) ? (g_value_unset (&values[14]), NULL) : NULL;
		values[14] = _tmp26_;
		g_value_init (&_tmp27_, G_TYPE_INT);
		g_value_set_int (&_tmp27_, audio_item->bitrate);
		_tmp28_ = _tmp27_;
		G_IS_VALUE (&values[8]) ? (g_value_unset (&values[8]), NULL) : NULL;
		values[8] = _tmp28_;
		g_value_init (&_tmp29_, G_TYPE_INT);
		g_value_set_int (&_tmp29_, audio_item->sample_freq);
		_tmp30_ = _tmp29_;
		G_IS_VALUE (&values[9]) ? (g_value_unset (&values[9]), NULL) : NULL;
		values[9] = _tmp30_;
		g_value_init (&_tmp31_, G_TYPE_INT);
		g_value_set_int (&_tmp31_, audio_item->bits_per_sample);
		_tmp32_ = _tmp31_;
		G_IS_VALUE (&values[10]) ? (g_value_unset (&values[10]), NULL) : NULL;
		values[10] = _tmp32_;
		g_value_init (&_tmp33_, G_TYPE_INT);
		g_value_set_int (&_tmp33_, audio_item->channels);
		_tmp34_ = _tmp33_;
		G_IS_VALUE (&values[11]) ? (g_value_unset (&values[11]), NULL) : NULL;
		values[11] = _tmp34_;
		if (RYGEL_IS_MUSIC_ITEM (item)) {
			RygelMediaItem* _tmp35_;
			RygelMusicItem* _tmp36_;
			RygelMusicItem* music_item;
			GValue _tmp37_ = {0};
			GValue _tmp38_;
			GValue _tmp39_ = {0};
			GValue _tmp40_;
			GValue _tmp41_ = {0};
			GValue _tmp42_;
			GValue _tmp43_ = {0};
			GValue _tmp44_;
			_tmp35_ = item;
			_tmp36_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (_tmp35_) ? ((RygelMusicItem*) _tmp35_) : NULL);
			music_item = _tmp36_;
			g_value_init (&_tmp37_, G_TYPE_STRING);
			g_value_set_string (&_tmp37_, music_item->artist);
			_tmp38_ = _tmp37_;
			G_IS_VALUE (&values[5]) ? (g_value_unset (&values[5]), NULL) : NULL;
			values[5] = _tmp38_;
			g_value_init (&_tmp39_, G_TYPE_STRING);
			g_value_set_string (&_tmp39_, music_item->album);
			_tmp40_ = _tmp39_;
			G_IS_VALUE (&values[6]) ? (g_value_unset (&values[6]), NULL) : NULL;
			values[6] = _tmp40_;
			g_value_init (&_tmp41_, G_TYPE_STRING);
			g_value_set_string (&_tmp41_, music_item->genre);
			_tmp42_ = _tmp41_;
			G_IS_VALUE (&values[17]) ? (g_value_unset (&values[17]), NULL) : NULL;
			values[17] = _tmp42_;
			g_value_init (&_tmp43_, G_TYPE_INT);
			g_value_set_int (&_tmp43_, music_item->track_number);
			_tmp44_ = _tmp43_;
			G_IS_VALUE (&values[12]) ? (g_value_unset (&values[12]), NULL) : NULL;
			values[12] = _tmp44_;
			rygel_music_item_lookup_album_art (music_item);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	if (RYGEL_IS_VISUAL_ITEM (item)) {
		RygelMediaItem* _tmp45_;
		RygelVisualItem* _tmp46_;
		RygelVisualItem* visual_item;
		gint _tmp47_;
		GValue _tmp48_ = {0};
		GValue _tmp49_;
		gint _tmp50_;
		GValue _tmp51_ = {0};
		GValue _tmp52_;
		gint _tmp53_;
		GValue _tmp54_ = {0};
		GValue _tmp55_;
		_tmp45_ = item;
		_tmp46_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (_tmp45_) ? ((RygelVisualItem*) _tmp45_) : NULL);
		visual_item = _tmp46_;
		_tmp47_ = rygel_visual_item_get_width (visual_item);
		g_value_init (&_tmp48_, G_TYPE_INT);
		g_value_set_int (&_tmp48_, _tmp47_);
		_tmp49_ = _tmp48_;
		G_IS_VALUE (&values[2]) ? (g_value_unset (&values[2]), NULL) : NULL;
		values[2] = _tmp49_;
		_tmp50_ = rygel_visual_item_get_height (visual_item);
		g_value_init (&_tmp51_, G_TYPE_INT);
		g_value_set_int (&_tmp51_, _tmp50_);
		_tmp52_ = _tmp51_;
		G_IS_VALUE (&values[3]) ? (g_value_unset (&values[3]), NULL) : NULL;
		values[3] = _tmp52_;
		_tmp53_ = rygel_visual_item_get_color_depth (visual_item);
		g_value_init (&_tmp54_, G_TYPE_INT);
		g_value_set_int (&_tmp54_, _tmp53_);
		_tmp55_ = _tmp54_;
		G_IS_VALUE (&values[13]) ? (g_value_unset (&values[13]), NULL) : NULL;
		values[13] = _tmp55_;
		if (RYGEL_IS_VIDEO_ITEM (item)) {
			RygelMediaItem* _tmp56_;
			RygelVideoItem* _tmp57_;
			RygelVideoItem* video_item;
			GValue _tmp58_ = {0};
			GValue _tmp59_;
			_tmp56_ = item;
			_tmp57_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp56_) ? ((RygelVideoItem*) _tmp56_) : NULL);
			video_item = _tmp57_;
			g_value_init (&_tmp58_, G_TYPE_STRING);
			g_value_set_string (&_tmp58_, video_item->author);
			_tmp59_ = _tmp58_;
			G_IS_VALUE (&values[5]) ? (g_value_unset (&values[5]), NULL) : NULL;
			values[5] = _tmp59_;
			_g_object_unref0 (video_item);
		}
		_g_object_unref0 (visual_item);
	}
	_tmp60_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_SAVE_METADATA);
	rygel_media_export_database_exec (self->priv->db, _tmp60_, values, values_length1, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
}


static void rygel_media_export_media_cache_create_object (RygelMediaExportMediaCache* self, RygelMediaObject* item, GError** error) {
	gint type;
	GValue parent = {0};
	gchar* _tmp3_ = NULL;
	gint _tmp4_;
	GValue _tmp6_ = {0};
	const gchar* _tmp7_ = NULL;
	GValue _tmp8_ = {0};
	GValue _tmp9_ = {0};
	GValue _tmp10_;
	GValue _tmp11_ = {0};
	GValue _tmp12_ = {0};
	GValue _tmp13_ = {0};
	GValue* _tmp14_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	const gchar* _tmp15_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (item != NULL);
	type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_CONTAINER;
	if (RYGEL_IS_MEDIA_ITEM (item)) {
		type = (gint) RYGEL_MEDIA_EXPORT_OBJECT_TYPE_ITEM;
	}
	if (item->parent == NULL) {
		GValue _tmp0_ = {0};
		GValue _tmp1_ = {0};
		rygel_media_export_database_null (&_tmp0_);
		_tmp1_ = _tmp0_;
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp1_;
	} else {
		GValue _tmp2_ = {0};
		g_value_init (&_tmp2_, G_TYPE_STRING);
		g_value_set_string (&_tmp2_, ((RygelMediaObject*) item->parent)->id);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		parent = _tmp2_;
	}
	_tmp4_ = gee_collection_get_size ((GeeCollection*) item->uris);
	if (_tmp4_ == 0) {
		_g_free0 (_tmp3_);
		_tmp3_ = NULL;
	} else {
		gpointer _tmp5_ = NULL;
		_tmp5_ = gee_abstract_list_get ((GeeAbstractList*) item->uris, 0);
		_g_free0 (_tmp3_);
		_tmp3_ = (gchar*) _tmp5_;
	}
	g_value_init (&_tmp6_, G_TYPE_STRING);
	g_value_set_string (&_tmp6_, item->id);
	_tmp7_ = rygel_media_object_get_title (item);
	g_value_init (&_tmp8_, G_TYPE_STRING);
	g_value_set_string (&_tmp8_, _tmp7_);
	g_value_init (&_tmp9_, G_TYPE_INT);
	g_value_set_int (&_tmp9_, type);
	if (G_IS_VALUE (&parent)) {
		g_value_init (&_tmp11_, G_VALUE_TYPE (&parent));
		g_value_copy (&parent, &_tmp11_);
	} else {
		_tmp11_ = parent;
	}
	_tmp10_ = _tmp11_;
	g_value_init (&_tmp12_, G_TYPE_INT64);
	g_value_set_int64 (&_tmp12_, (gint64) item->modified);
	g_value_init (&_tmp13_, G_TYPE_STRING);
	g_value_set_string (&_tmp13_, _tmp3_);
	_tmp14_ = g_new0 (GValue, 6);
	_tmp14_[0] = _tmp6_;
	_tmp14_[1] = _tmp8_;
	_tmp14_[2] = _tmp9_;
	_tmp14_[3] = _tmp10_;
	_tmp14_[4] = _tmp12_;
	_tmp14_[5] = _tmp13_;
	values = _tmp14_;
	values_length1 = 6;
	_values_size_ = 6;
	_tmp15_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_INSERT);
	rygel_media_export_database_exec (self->priv->db, _tmp15_, values, values_length1, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		values = (_vala_GValue_array_free (values, values_length1), NULL);
		_g_free0 (_tmp3_);
		G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
		return;
	}
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	_g_free0 (_tmp3_);
	G_IS_VALUE (&parent) ? (g_value_unset (&parent), NULL) : NULL;
}


/**
     * Create the current schema.
     *
     * If schema creation fails, schema will be rolled back
     * completely.
     *
     * @returns: true on success, false on failure
     */
static gboolean rygel_media_export_media_cache_create_schema (RygelMediaExportMediaCache* self) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	rygel_media_export_database_begin (self->priv->db, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	_tmp0_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_SCHEMA);
	rygel_media_export_database_exec (self->priv->db, _tmp0_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	_tmp1_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_COMMON);
	rygel_media_export_database_exec (self->priv->db, _tmp1_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	_tmp2_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TABLE_CLOSURE);
	rygel_media_export_database_exec (self->priv->db, _tmp2_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	_tmp3_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_INDEX_COMMON);
	rygel_media_export_database_exec (self->priv->db, _tmp3_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	_tmp4_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_TRIGGER_CLOSURE);
	rygel_media_export_database_exec (self->priv->db, _tmp4_, NULL, 0, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	rygel_media_export_database_commit (self->priv->db, &_inner_error_);
	if (_inner_error_ != NULL) {
		goto __catch10_g_error;
	}
	rygel_media_export_database_analyze (self->priv->db);
	result = TRUE;
	return result;
	goto __finally10;
	__catch10_g_error:
	{
		GError * err;
		err = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("rygel-media-export-media-cache.vala:552: Failed to create schema: %s", err->message);
		rygel_media_export_database_rollback (self->priv->db);
		_g_error_free0 (err);
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	result = FALSE;
	return result;
}


static RygelMediaObject* rygel_media_export_media_cache_get_object_from_statement (RygelMediaExportMediaCache* self, RygelMediaContainer* parent, const gchar* object_id, sqlite3_stmt* statement) {
	RygelMediaObject* result = NULL;
	RygelMediaObject* object;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* title;
	gint _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (object_id != NULL, NULL);
	g_return_val_if_fail (statement != NULL, NULL);
	object = NULL;
	_tmp0_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TITLE);
	_tmp1_ = g_strdup (_tmp0_);
	title = _tmp1_;
	_tmp2_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TYPE);
	switch (_tmp2_) {
		case 0:
		{
			const gchar* _tmp3_ = NULL;
			gchar* _tmp4_;
			gchar* uri;
			RygelMediaExportDBContainer* _tmp5_ = NULL;
			RygelMediaObject* _tmp6_;
			RygelMediaContainer* _tmp7_;
			RygelMediaContainer* container;
			_tmp3_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
			_tmp4_ = g_strdup (_tmp3_);
			uri = _tmp4_;
			_tmp5_ = rygel_media_export_object_factory_get_container (self->priv->factory, self, object_id, title, (guint) 0, uri);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp5_;
			_tmp6_ = object;
			_tmp7_ = _g_object_ref0 (RYGEL_IS_MEDIA_CONTAINER (_tmp6_) ? ((RygelMediaContainer*) _tmp6_) : NULL);
			container = _tmp7_;
			if (uri != NULL) {
				gee_abstract_collection_add ((GeeAbstractCollection*) ((RygelMediaObject*) container)->uris, uri);
			}
			_g_object_unref0 (container);
			_g_free0 (uri);
			break;
		}
		case 1:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_;
			gchar* upnp_class;
			RygelMediaItem* _tmp10_ = NULL;
			RygelMediaObject* _tmp11_;
			const gchar* _tmp12_ = NULL;
			gchar* _tmp13_;
			gchar* uri;
			_tmp8_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CLASS);
			_tmp9_ = g_strdup (_tmp8_);
			upnp_class = _tmp9_;
			_tmp10_ = rygel_media_export_object_factory_get_item (self->priv->factory, self, parent, object_id, title, upnp_class);
			_g_object_unref0 (object);
			object = (RygelMediaObject*) _tmp10_;
			_tmp11_ = object;
			rygel_media_export_media_cache_fill_item (self, statement, RYGEL_IS_MEDIA_ITEM (_tmp11_) ? ((RygelMediaItem*) _tmp11_) : NULL);
			_tmp12_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_URI);
			_tmp13_ = g_strdup (_tmp12_);
			uri = _tmp13_;
			if (uri != NULL) {
				RygelMediaObject* _tmp14_;
				_tmp14_ = object;
				rygel_media_item_add_uri (RYGEL_IS_MEDIA_ITEM (_tmp14_) ? ((RygelMediaItem*) _tmp14_) : NULL, uri);
			}
			_g_free0 (uri);
			_g_free0 (upnp_class);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	if (object != NULL) {
		gint64 _tmp15_;
		_tmp15_ = sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TIMESTAMP);
		object->modified = (guint64) _tmp15_;
	}
	result = object;
	_g_free0 (title);
	return result;
}


static void rygel_media_export_media_cache_fill_item (RygelMediaExportMediaCache* self, sqlite3_stmt* statement, RygelMediaItem* item) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gint64 _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (statement != NULL);
	g_return_if_fail (item != NULL);
	_tmp0_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DATE);
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (item->date);
	item->date = _tmp1_;
	_tmp2_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_MIME_TYPE);
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (item->mime_type);
	item->mime_type = _tmp3_;
	_tmp4_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DLNA_PROFILE);
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (item->dlna_profile);
	item->dlna_profile = _tmp5_;
	_tmp6_ = sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SIZE);
	rygel_media_item_set_size (item, _tmp6_);
	if (RYGEL_IS_AUDIO_ITEM (item)) {
		RygelMediaItem* _tmp7_;
		RygelAudioItem* _tmp8_;
		RygelAudioItem* audio_item;
		gint64 _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp7_ = item;
		_tmp8_ = _g_object_ref0 (RYGEL_IS_AUDIO_ITEM (_tmp7_) ? ((RygelAudioItem*) _tmp7_) : NULL);
		audio_item = _tmp8_;
		_tmp9_ = sqlite3_column_int64 (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_DURATION);
		audio_item->duration = (glong) _tmp9_;
		_tmp10_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITRATE);
		audio_item->bitrate = _tmp10_;
		_tmp11_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_SAMPLE_FREQ);
		audio_item->sample_freq = _tmp11_;
		_tmp12_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_BITS_PER_SAMPLE);
		audio_item->bits_per_sample = _tmp12_;
		_tmp13_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_CHANNELS);
		audio_item->channels = _tmp13_;
		if (RYGEL_IS_MUSIC_ITEM (item)) {
			RygelMediaItem* _tmp14_;
			RygelMusicItem* _tmp15_;
			RygelMusicItem* music_item;
			const gchar* _tmp16_ = NULL;
			gchar* _tmp17_;
			const gchar* _tmp18_ = NULL;
			gchar* _tmp19_;
			const gchar* _tmp20_ = NULL;
			gchar* _tmp21_;
			gint _tmp22_;
			_tmp14_ = item;
			_tmp15_ = _g_object_ref0 (RYGEL_IS_MUSIC_ITEM (_tmp14_) ? ((RygelMusicItem*) _tmp14_) : NULL);
			music_item = _tmp15_;
			_tmp16_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
			_tmp17_ = g_strdup (_tmp16_);
			_g_free0 (music_item->artist);
			music_item->artist = _tmp17_;
			_tmp18_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_ALBUM);
			_tmp19_ = g_strdup (_tmp18_);
			_g_free0 (music_item->album);
			music_item->album = _tmp19_;
			_tmp20_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_GENRE);
			_tmp21_ = g_strdup (_tmp20_);
			_g_free0 (music_item->genre);
			music_item->genre = _tmp21_;
			_tmp22_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_TRACK);
			music_item->track_number = _tmp22_;
			rygel_music_item_lookup_album_art (music_item);
			_g_object_unref0 (music_item);
		}
		_g_object_unref0 (audio_item);
	}
	if (RYGEL_IS_VISUAL_ITEM (item)) {
		RygelMediaItem* _tmp23_;
		RygelVisualItem* _tmp24_;
		RygelVisualItem* visual_item;
		gint _tmp25_;
		gint _tmp26_;
		gint _tmp27_;
		_tmp23_ = item;
		_tmp24_ = _g_object_ref0 (RYGEL_IS_VISUAL_ITEM (_tmp23_) ? ((RygelVisualItem*) _tmp23_) : NULL);
		visual_item = _tmp24_;
		_tmp25_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_WIDTH);
		rygel_visual_item_set_width (visual_item, _tmp25_);
		_tmp26_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_HEIGHT);
		rygel_visual_item_set_height (visual_item, _tmp26_);
		_tmp27_ = sqlite3_column_int (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_COLOR_DEPTH);
		rygel_visual_item_set_color_depth (visual_item, _tmp27_);
		if (RYGEL_IS_VIDEO_ITEM (item)) {
			RygelMediaItem* _tmp28_;
			RygelVideoItem* _tmp29_;
			RygelVideoItem* video_item;
			const gchar* _tmp30_ = NULL;
			gchar* _tmp31_;
			_tmp28_ = item;
			_tmp29_ = _g_object_ref0 (RYGEL_IS_VIDEO_ITEM (_tmp28_) ? ((RygelVideoItem*) _tmp28_) : NULL);
			video_item = _tmp29_;
			_tmp30_ = sqlite3_column_text (statement, (gint) RYGEL_MEDIA_EXPORT_DETAIL_COLUMN_AUTHOR);
			_tmp31_ = g_strdup (_tmp30_);
			_g_free0 (video_item->author);
			video_item->author = _tmp31_;
			_g_object_unref0 (video_item);
		}
		_g_object_unref0 (visual_item);
	}
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->children);
		g_slice_free (Block9Data, _data9_);
	}
}


static gboolean _lambda13_ (sqlite3_stmt* statement, Block9Data* _data9_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	self = _data9_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_text (statement, 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data9_->children, _tmp0_);
	result = TRUE;
	return result;
}


static gboolean __lambda13__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda13_ (stmt, self);
	return result;
}


GeeArrayList* rygel_media_export_media_cache_get_child_ids (RygelMediaExportMediaCache* self, const gchar* container_id, GError** error) {
	GeeArrayList* result = NULL;
	Block9Data* _data9_;
	GeeArrayList* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* values;
	gint values_length1;
	gint _values_size_;
	const gchar* _tmp3_ = NULL;
	GeeArrayList* _tmp4_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (container_id != NULL, NULL);
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal);
	_data9_->children = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, container_id);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	values = _tmp2_;
	values_length1 = 1;
	_values_size_ = 1;
	_tmp3_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_CHILD_IDS);
	rygel_media_export_database_exec (self->priv->db, _tmp3_, values, values_length1, __lambda13__rygel_media_export_database_row_callback, _data9_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == RYGEL_MEDIA_EXPORT_DATABASE_ERROR) {
			g_propagate_error (error, _inner_error_);
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			return NULL;
		} else {
			values = (_vala_GValue_array_free (values, values_length1), NULL);
			block9_data_unref (_data9_);
			_data9_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp4_ = _g_object_ref0 (_data9_->children);
	result = _tmp4_;
	values = (_vala_GValue_array_free (values, values_length1), NULL);
	block9_data_unref (_data9_);
	_data9_ = NULL;
	return result;
}


static gchar* rygel_media_export_media_cache_translate_search_expression (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, const gchar* prefix, GError** error) {
	gchar* result = NULL;
	gchar* _tmp1_ = NULL;
	gchar* filter;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	g_return_val_if_fail (prefix != NULL, NULL);
	if (expression == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	_tmp1_ = rygel_media_export_media_cache_search_expression_to_sql (self, expression, args, &_inner_error_);
	filter = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp2_ = g_strdup_printf (" %s %s", prefix, filter);
	result = _tmp2_;
	_g_free0 (filter);
	return result;
}


static gchar* rygel_media_export_media_cache_search_expression_to_sql (RygelMediaExportMediaCache* self, RygelSearchExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	if (expression == NULL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("");
		result = _tmp0_;
		return result;
	}
	if (RYGEL_IS_LOGICAL_EXPRESSION (expression)) {
		RygelSearchExpression* _tmp1_;
		gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		_tmp1_ = expression;
		_tmp2_ = rygel_media_export_media_cache_logical_expression_to_sql (self, RYGEL_IS_LOGICAL_EXPRESSION (_tmp1_) ? ((RygelLogicalExpression*) _tmp1_) : NULL, args, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp3_;
		return result;
	} else {
		RygelSearchExpression* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar* _tmp6_;
		_tmp4_ = expression;
		_tmp5_ = rygel_media_export_media_cache_relational_expression_to_sql (self, RYGEL_IS_RELATIONAL_EXPRESSION (_tmp4_) ? ((RygelRelationalExpression*) _tmp4_) : NULL, args, &_inner_error_);
		_tmp6_ = _tmp5_;
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		}
		result = _tmp6_;
		return result;
	}
}


static gchar* rygel_media_export_media_cache_logical_expression_to_sql (RygelMediaExportMediaCache* self, RygelLogicalExpression* expression, GValueArray* args, GError** error) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* left_sql_string;
	gchar* _tmp1_ = NULL;
	gchar* right_sql_string;
	gchar* _tmp2_;
	gchar* operator_sql_string;
	gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_tmp0_ = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand1, args, &_inner_error_);
	left_sql_string = _tmp0_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = rygel_media_export_media_cache_search_expression_to_sql (self, (RygelSearchExpression*) ((RygelSearchExpression*) expression)->operand2, args, &_inner_error_);
	right_sql_string = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (left_sql_string);
		return NULL;
	}
	_tmp2_ = g_strdup ("OR");
	operator_sql_string = _tmp2_;
	if (GPOINTER_TO_INT (((RygelSearchExpression*) expression)->op) == RYGEL_LOGICAL_OPERATOR_AND) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup ("AND");
		_g_free0 (operator_sql_string);
		operator_sql_string = _tmp3_;
	}
	_tmp4_ = g_strdup_printf ("(%s %s %s)", left_sql_string, operator_sql_string, right_sql_string);
	result = _tmp4_;
	_g_free0 (operator_sql_string);
	_g_free0 (right_sql_string);
	_g_free0 (left_sql_string);
	return result;
}


static gchar* rygel_media_export_media_cache_map_operand_to_column (RygelMediaExportMediaCache* self, const gchar* operand, gchar** collate, GError** error) {
	gchar* _collate = NULL;
	gchar* result = NULL;
	gchar* column;
	gboolean use_collation;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	static GQuark _tmp1__label4 = 0;
	static GQuark _tmp1__label5 = 0;
	static GQuark _tmp1__label6 = 0;
	static GQuark _tmp1__label7 = 0;
	static GQuark _tmp1__label8 = 0;
	static GQuark _tmp1__label9 = 0;
	static GQuark _tmp1__label10 = 0;
	static GQuark _tmp1__label11 = 0;
	static GQuark _tmp1__label12 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (operand != NULL, NULL);
	column = NULL;
	use_collation = FALSE;
	_tmp0_ = operand;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("res")))) {
		switch (0) {
			default:
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("o.uri");
				_g_free0 (column);
				column = _tmp2_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("res@duration")))) {
		switch (0) {
			default:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("m.duration");
				_g_free0 (column);
				column = _tmp3_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("@refID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("NULL");
				_g_free0 (column);
				column = _tmp4_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("@id")))) {
		switch (0) {
			default:
			{
				gchar* _tmp5_;
				_tmp5_ = g_strdup ("o.upnp_id");
				_g_free0 (column);
				column = _tmp5_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label4) ? _tmp1__label4 : (_tmp1__label4 = g_quark_from_static_string ("@parentID")))) {
		switch (0) {
			default:
			{
				gchar* _tmp6_;
				_tmp6_ = g_strdup ("o.parent");
				_g_free0 (column);
				column = _tmp6_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label5) ? _tmp1__label5 : (_tmp1__label5 = g_quark_from_static_string ("upnp:class")))) {
		switch (0) {
			default:
			{
				gchar* _tmp7_;
				_tmp7_ = g_strdup ("m.class");
				_g_free0 (column);
				column = _tmp7_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label6) ? _tmp1__label6 : (_tmp1__label6 = g_quark_from_static_string ("dc:title")))) {
		switch (0) {
			default:
			{
				gchar* _tmp8_;
				_tmp8_ = g_strdup ("o.title");
				_g_free0 (column);
				column = _tmp8_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label7) ? _tmp1__label7 : (_tmp1__label7 = g_quark_from_static_string ("upnp:artist")))) || (_tmp1_ == ((0 != _tmp1__label8) ? _tmp1__label8 : (_tmp1__label8 = g_quark_from_static_string ("dc:creator"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp9_;
				_tmp9_ = g_strdup ("m.author");
				_g_free0 (column);
				column = _tmp9_;
				use_collation = TRUE;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label9) ? _tmp1__label9 : (_tmp1__label9 = g_quark_from_static_string ("dc:date")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				_tmp10_ = g_strdup ("strftime(\"%Y\", m.date)");
				_g_free0 (column);
				column = _tmp10_;
				break;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label10) ? _tmp1__label10 : (_tmp1__label10 = g_quark_from_static_string ("upnp:album")))) {
		switch (0) {
			default:
			{
				gchar* _tmp11_;
				_tmp11_ = g_strdup ("m.album");
				_g_free0 (column);
				column = _tmp11_;
				use_collation = TRUE;
				break;
			}
		}
	} else if ((_tmp1_ == ((0 != _tmp1__label11) ? _tmp1__label11 : (_tmp1__label11 = g_quark_from_static_string ("upnp:genre")))) || (_tmp1_ == ((0 != _tmp1__label12) ? _tmp1__label12 : (_tmp1__label12 = g_quark_from_static_string ("dc:genre"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp12_;
				_tmp12_ = g_strdup ("m.genre");
				_g_free0 (column);
				column = _tmp12_;
				use_collation = TRUE;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				gchar* _tmp13_ = NULL;
				gchar* message;
				GError* _tmp14_ = NULL;
				_tmp13_ = g_strdup_printf ("Unsupported column %s", operand);
				message = _tmp13_;
				_tmp14_ = g_error_new_literal (RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR, RYGEL_MEDIA_EXPORT_MEDIA_CACHE_ERROR_UNSUPPORTED_SEARCH, message);
				_inner_error_ = _tmp14_;
				g_propagate_error (error, _inner_error_);
				_g_free0 (message);
				_g_free0 (column);
				return NULL;
			}
		}
	}
	if ((&_collate) != NULL) {
		if (use_collation) {
			gchar* _tmp15_;
			_tmp15_ = g_strdup ("COLLATE CASEFOLD");
			_g_free0 (_collate);
			_collate = _tmp15_;
		} else {
			gchar* _tmp16_;
			_tmp16_ = g_strdup ("");
			_g_free0 (_collate);
			_collate = _tmp16_;
		}
	}
	result = column;
	if (collate) {
		*collate = _collate;
	} else {
		_g_free0 (_collate);
	}
	return result;
}


static void _vala_GValue_free (GValue* self) {
	g_value_unset (self);
	g_free (self);
}


static gchar* rygel_media_export_media_cache_relational_expression_to_sql (RygelMediaExportMediaCache* self, RygelRelationalExpression* exp, GValueArray* args, GError** error) {
	gchar* result = NULL;
	GValue* v;
	gchar* collate;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* column;
	RygelMediaExportSqlOperator* operator = NULL;
	gchar* _tmp14_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	v = NULL;
	collate = NULL;
	_tmp1_ = rygel_media_export_media_cache_map_operand_to_column (self, (const gchar*) ((RygelSearchExpression*) exp)->operand1, &_tmp0_, &_inner_error_);
	_g_free0 (collate);
	collate = _tmp0_;
	column = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (collate);
		__vala_GValue_free0 (v);
		return NULL;
	}
	switch (GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op)) {
		case GUPNP_SEARCH_CRITERIA_OP_EXISTS:
		{
			gchar* sql_function = NULL;
			gchar* _tmp4_ = NULL;
			if (g_strcmp0 ((const gchar*) ((RygelSearchExpression*) exp)->operand2, "true") == 0) {
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("%s IS NOT NULL AND %s != ''");
				_g_free0 (sql_function);
				sql_function = _tmp2_;
			} else {
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("%s IS NULL OR %s = ''");
				_g_free0 (sql_function);
				sql_function = _tmp3_;
			}
			_tmp4_ = g_strdup_printf (sql_function, column, column);
			result = _tmp4_;
			_g_free0 (sql_function);
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
		case GUPNP_SEARCH_CRITERIA_OP_EQ:
		case GUPNP_SEARCH_CRITERIA_OP_NEQ:
		case GUPNP_SEARCH_CRITERIA_OP_LESS:
		case GUPNP_SEARCH_CRITERIA_OP_LEQ:
		case GUPNP_SEARCH_CRITERIA_OP_GREATER:
		case GUPNP_SEARCH_CRITERIA_OP_GEQ:
		{
			GValue* _tmp5_ = NULL;
			RygelMediaExportSqlOperator* _tmp6_ = NULL;
			_tmp5_ = g_new0 (GValue, 1);
			g_value_init (_tmp5_, G_TYPE_STRING);
			g_value_set_string (_tmp5_, (const gchar*) ((RygelSearchExpression*) exp)->operand2);
			__vala_GValue_free0 (v);
			v = _tmp5_;
			_tmp6_ = rygel_media_export_sql_operator_new_from_search_criteria_op (GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op), column, collate);
			_g_object_unref0 (operator);
			operator = _tmp6_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_CONTAINS:
		{
			RygelMediaExportSqlFunction* _tmp7_ = NULL;
			GValue* _tmp8_ = NULL;
			_tmp7_ = rygel_media_export_sql_function_new ("contains", column);
			_g_object_unref0 (operator);
			operator = (RygelMediaExportSqlOperator*) _tmp7_;
			_tmp8_ = g_new0 (GValue, 1);
			g_value_init (_tmp8_, G_TYPE_STRING);
			g_value_set_string (_tmp8_, (const gchar*) ((RygelSearchExpression*) exp)->operand2);
			__vala_GValue_free0 (v);
			v = _tmp8_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DOES_NOT_CONTAIN:
		{
			RygelMediaExportSqlFunction* _tmp9_ = NULL;
			GValue* _tmp10_ = NULL;
			_tmp9_ = rygel_media_export_sql_function_new ("NOT contains", column);
			_g_object_unref0 (operator);
			operator = (RygelMediaExportSqlOperator*) _tmp9_;
			_tmp10_ = g_new0 (GValue, 1);
			g_value_init (_tmp10_, G_TYPE_STRING);
			g_value_set_string (_tmp10_, (const gchar*) ((RygelSearchExpression*) exp)->operand2);
			__vala_GValue_free0 (v);
			v = _tmp10_;
			break;
		}
		case GUPNP_SEARCH_CRITERIA_OP_DERIVED_FROM:
		{
			RygelMediaExportSqlOperator* _tmp11_ = NULL;
			gchar* _tmp12_ = NULL;
			GValue* _tmp13_ = NULL;
			_tmp11_ = rygel_media_export_sql_operator_new ("LIKE", column, "");
			_g_object_unref0 (operator);
			operator = _tmp11_;
			_tmp12_ = g_strdup_printf ("%s%%", (const gchar*) ((RygelSearchExpression*) exp)->operand2);
			_tmp13_ = g_new0 (GValue, 1);
			g_value_init (_tmp13_, G_TYPE_STRING);
			g_value_take_string (_tmp13_, _tmp12_);
			__vala_GValue_free0 (v);
			v = _tmp13_;
			break;
		}
		default:
		{
			g_warning ("rygel-media-export-media-cache.vala:813: Unsupported op %d", (gint) GPOINTER_TO_INT (((RygelSearchExpression*) exp)->op));
			result = NULL;
			_g_object_unref0 (operator);
			_g_free0 (column);
			_g_free0 (collate);
			__vala_GValue_free0 (v);
			return result;
		}
	}
	if (v != NULL) {
		g_value_array_append (args, v);
	}
	_tmp14_ = rygel_media_export_sql_operator_to_string (operator);
	result = _tmp14_;
	_g_object_unref0 (operator);
	_g_free0 (column);
	_g_free0 (collate);
	__vala_GValue_free0 (v);
	return result;
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_object_unref0 (_data10_->data);
		g_slice_free (Block10Data, _data10_);
	}
}


static gboolean _lambda1_ (sqlite3_stmt* statement, Block10Data* _data10_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	self = _data10_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_text (statement, 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data10_->data, _tmp0_);
	result = TRUE;
	return result;
}


static gboolean __lambda1__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda1_ (stmt, self);
	return result;
}


GeeList* rygel_media_export_media_cache_get_meta_data_column_by_filter (RygelMediaExportMediaCache* self, const gchar* column, const gchar* filter, GValueArray* args, glong offset, glong max_count, GError** error) {
	GeeList* result = NULL;
	Block10Data* _data10_;
	GValue _tmp0_ = {0};
	GValue v;
	GValue _tmp1_ = {0};
	GeeArrayList* _tmp2_ = NULL;
	RygelMediaExportDatabaseRowCallback callback;
	void* callback_target = NULL;
	GDestroyNotify callback_target_destroy_notify = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* sql;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_;
	GeeList* _tmp7_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (column != NULL, NULL);
	g_return_val_if_fail (filter != NULL, NULL);
	g_return_val_if_fail (args != NULL, NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	g_value_init (&_tmp0_, G_TYPE_LONG);
	g_value_set_long (&_tmp0_, offset);
	v = _tmp0_;
	g_value_array_append (args, &v);
	g_value_init (&_tmp1_, G_TYPE_LONG);
	g_value_set_long (&_tmp1_, max_count);
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	v = _tmp1_;
	g_value_array_append (args, &v);
	_tmp2_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_data10_->data = _tmp2_;
	callback = __lambda1__rygel_media_export_database_row_callback;
	callback_target = block10_data_ref (_data10_);
	callback_target_destroy_notify = block10_data_unref;
	_tmp3_ = rygel_media_export_sql_factory_make (self->priv->sql, RYGEL_MEDIA_EXPORT_SQL_STRING_GET_META_DATA_COLUMN);
	_tmp4_ = g_strdup (_tmp3_);
	sql = _tmp4_;
	_tmp5_ = g_strdup_printf (sql, column, filter);
	_tmp6_ = _tmp5_;
	rygel_media_export_database_exec (self->priv->db, _tmp6_, args->values, (gint) args->n_values, callback, callback_target, NULL, &_inner_error_);
	_g_free0 (_tmp6_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (sql);
		(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
		callback = NULL;
		callback_target = NULL;
		callback_target_destroy_notify = NULL;
		G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return NULL;
	}
	_tmp7_ = _g_object_ref0 ((GeeList*) _data10_->data);
	result = _tmp7_;
	_g_free0 (sql);
	(callback_target_destroy_notify == NULL) ? NULL : (callback_target_destroy_notify (callback_target), NULL);
	callback = NULL;
	callback_target = NULL;
	callback_target_destroy_notify = NULL;
	G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
	block10_data_unref (_data10_);
	_data10_ = NULL;
	return result;
}


GeeList* rygel_media_export_media_cache_get_object_attribute_by_search_expression (RygelMediaExportMediaCache* self, const gchar* attribute, RygelSearchExpression* expression, glong offset, guint max_count, GError** error) {
	GeeList* result = NULL;
	GValueArray* _tmp0_ = NULL;
	GValueArray* args;
	gchar* _tmp1_ = NULL;
	gchar* filter;
	gchar* _tmp2_ = NULL;
	gchar* column;
	guint _tmp3_;
	guint max_objects;
	GeeList* _tmp4_ = NULL;
	GeeList* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (attribute != NULL, NULL);
	_tmp0_ = g_value_array_new ((guint) 0);
	args = _tmp0_;
	_tmp1_ = rygel_media_export_media_cache_translate_search_expression (self, expression, args, "AND", &_inner_error_);
	filter = _tmp1_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_value_array_free0 (args);
		return NULL;
	}
	g_debug ("rygel-media-export-media-cache.vala:862: Parsed filter: %s", filter);
	_tmp2_ = rygel_media_export_media_cache_map_operand_to_column (self, attribute, NULL, &_inner_error_);
	column = _tmp2_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	_tmp3_ = rygel_media_export_media_cache_modify_limit (self, max_count);
	max_objects = _tmp3_;
	_tmp4_ = rygel_media_export_media_cache_get_meta_data_column_by_filter (self, column, filter, args, offset, (glong) max_objects, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (column);
		_g_free0 (filter);
		_g_value_array_free0 (args);
		return NULL;
	}
	result = _tmp5_;
	_g_free0 (column);
	_g_free0 (filter);
	_g_value_array_free0 (args);
	return result;
}


void rygel_media_export_media_cache_flag_object (RygelMediaExportMediaCache* self, GFile* file, const gchar* flag, GError** error) {
	GValue _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	GValue _tmp2_ = {0};
	GValue* _tmp3_ = NULL;
	GValue* args;
	gint args_length1;
	gint _args_size_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	g_return_if_fail (flag != NULL);
	g_value_init (&_tmp0_, G_TYPE_STRING);
	g_value_set_string (&_tmp0_, flag);
	_tmp1_ = g_file_get_uri (file);
	g_value_init (&_tmp2_, G_TYPE_STRING);
	g_value_take_string (&_tmp2_, _tmp1_);
	_tmp3_ = g_new0 (GValue, 2);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp2_;
	args = _tmp3_;
	args_length1 = 2;
	_args_size_ = 2;
	rygel_media_export_database_exec (self->priv->db, "UPDATE Object SET flags = ? WHERE uri = ?", args, args_length1, NULL, NULL, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		args = (_vala_GValue_array_free (args, args_length1), NULL);
		return;
	}
	args = (_vala_GValue_array_free (args, args_length1), NULL);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_object_unref0 (_data11_->uris);
		g_slice_free (Block11Data, _data11_);
	}
}


static gboolean _lambda14_ (sqlite3_stmt* statement, Block11Data* _data11_) {
	RygelMediaExportMediaCache * self;
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	self = _data11_->self;
	g_return_val_if_fail (statement != NULL, FALSE);
	_tmp0_ = sqlite3_column_text (statement, 0);
	gee_abstract_collection_add ((GeeAbstractCollection*) _data11_->uris, _tmp0_);
	result = TRUE;
	return result;
}


static gboolean __lambda14__rygel_media_export_database_row_callback (sqlite3_stmt* stmt, gpointer self) {
	gboolean result;
	result = _lambda14_ (stmt, self);
	return result;
}


GeeList* rygel_media_export_media_cache_get_flagged_uris (RygelMediaExportMediaCache* self, const gchar* flag, GError** error) {
	GeeList* result = NULL;
	Block11Data* _data11_;
	GeeArrayList* _tmp0_ = NULL;
	GValue _tmp1_ = {0};
	GValue* _tmp2_ = NULL;
	GValue* args;
	gint args_length1;
	gint _args_size_;
	GeeList* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (flag != NULL, NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	_data11_->uris = _tmp0_;
	g_value_init (&_tmp1_, G_TYPE_STRING);
	g_value_set_string (&_tmp1_, flag);
	_tmp2_ = g_new0 (GValue, 1);
	_tmp2_[0] = _tmp1_;
	args = _tmp2_;
	args_length1 = 1;
	_args_size_ = 1;
	rygel_media_export_database_exec (self->priv->db, "SELECT uri FROM object WHERE flags = ?", args, args_length1, __lambda14__rygel_media_export_database_row_callback, _data11_, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		args = (_vala_GValue_array_free (args, args_length1), NULL);
		block11_data_unref (_data11_);
		_data11_ = NULL;
		return NULL;
	}
	_tmp3_ = _g_object_ref0 ((GeeList*) _data11_->uris);
	result = _tmp3_;
	args = (_vala_GValue_array_free (args, args_length1), NULL);
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}


static void rygel_media_export_media_cache_class_init (RygelMediaExportMediaCacheClass * klass) {
	rygel_media_export_media_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (RygelMediaExportMediaCachePrivate));
	G_OBJECT_CLASS (klass)->finalize = rygel_media_export_media_cache_finalize;
}


static void rygel_media_export_media_cache_instance_init (RygelMediaExportMediaCache * self) {
	self->priv = RYGEL_MEDIA_EXPORT_MEDIA_CACHE_GET_PRIVATE (self);
}


static void rygel_media_export_media_cache_finalize (GObject* obj) {
	RygelMediaExportMediaCache * self;
	self = RYGEL_MEDIA_EXPORT_MEDIA_CACHE (obj);
	_g_object_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->factory);
	_g_object_unref0 (self->priv->sql);
	_g_object_unref0 (self->priv->exists_cache);
	G_OBJECT_CLASS (rygel_media_export_media_cache_parent_class)->finalize (obj);
}


/**
 * Persistent storage of media objects
 *
 *  MediaExportDB is a sqlite3 backed persistent storage of media objects
 */
GType rygel_media_export_media_cache_get_type (void) {
	static volatile gsize rygel_media_export_media_cache_type_id__volatile = 0;
	if (g_once_init_enter (&rygel_media_export_media_cache_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (RygelMediaExportMediaCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rygel_media_export_media_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RygelMediaExportMediaCache), 0, (GInstanceInitFunc) rygel_media_export_media_cache_instance_init, NULL };
		GType rygel_media_export_media_cache_type_id;
		rygel_media_export_media_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "RygelMediaExportMediaCache", &g_define_type_info, 0);
		g_once_init_leave (&rygel_media_export_media_cache_type_id__volatile, rygel_media_export_media_cache_type_id);
	}
	return rygel_media_export_media_cache_type_id__volatile;
}



