// RadioActive Copyright (C) 1999-2000 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
//
// $Id: repeat-button.cc,v 1.1 2000/10/24 16:13:56 cactus Exp $

#include "repeat-button.h"

using namespace Gtk;
using namespace SigC;

RepeatButton::RepeatButton (int time = 0):
    button_mask (0),
    timeout_time (time)
{
    button_press_event.connect (slot (this, &RepeatButton::button_press_handler));
    button_release_event.connect (slot (this, &RepeatButton::button_release_handler));
}

RepeatButton::RepeatButton (const string& text, int time = 0):
    Button (text),
    button_mask (0),
    timeout_time (time)
{
    button_press_event.connect (slot (this, &RepeatButton::button_press_handler));
    button_release_event.connect (slot (this, &RepeatButton::button_release_handler));
}

int RepeatButton::button_press_handler (GdkEventButton *e)
{
    if (!button_mask && time)
    {
	hold ();
	Gtk::Main::timeout.connect (slot (this, &RepeatButton::timeout_handler),
				    timeout_time);
    }

    button_mask |= e->button;
    
    return false;
}

int RepeatButton::button_release_handler (GdkEventButton *e)
{
    button_mask &= !e->button;

    return false;
}

int RepeatButton::timeout_handler ()
{
    if (!button_mask)
	return false;
    
    hold ();
    return true;
}
