// $Id: wndMain.h,v 1.38 2001/02/07 17:05:08 cactus Exp $ -*- c++ -*-

// RadioActive Copyright (C) 1999 RDI Gerg <cactus@cactus.rulez.org>
// 
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2
// (included in the RadioActive distribution in doc/GPL) as published by
// the Free Software Foundation.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

#ifndef RADIO_wndMain
#define RADIO_wndMain

#include "tuner.h"
#include "driver.h"
#include "speedtuner.h"
#include "volume.h"

#include "properties.h"

#include <gnome--.h>
#include <vector>

class wndMain: public Gtk::Window
{
    Radio& radio;
    Tuner tuner;
    SpeedTuner buttons;
    Volume volume;
    Properties properties;
    
    Gtk::Menu menu;

    float curr_val;
    vector<pair<float, string> > prog_vals;
    string radio_file;
    int x, y;

    gint key_press(GdkEventKey*);

public:
    wndMain(Radio& radiodev);

    void set_speedtuner(const vector<pair<float, string> >& values);
    vector<pair<float, string> > get_speedtuner();
    void show_properties();
    static void about();
    void set();

    void get_position(int& pos_x, int& pos_y);

    // These are needed by the panel applet version
    SigC::Signal2<void, int, const pair<float, string>&> speedtuner_changed;
    SigC::Signal1<void, int> program_changed;
    
private:
    void tuner_changed(float val);
    void speed_click(int btn);
    void speed_change(int btn);
    void tuner_fine_tune(int weigth);
    virtual int delete_event_impl(GdkEventAny* e);
    int mouse_clicked(GdkEventButton* e);
    void dev_change(const string& dev);
    int cache_pos();
};

#endif
