# 0.95 Release “Enfant suisse”

As of Nov 19, 2015, the Pitivi team is proud to announce the fifth beta
release of Pitivi toward the 1.0 version. This is mostly an incremental
bugfixing release, so make sure to see the [0.91](releases/0.91.md),
[0.92](releases/0.92.md), [0.93](releases/0.93.md) and
[0.94](releases/0.94.md) release notes to get the full picture.

This is considered a beta release since the “big picture” remains
“making Pitivi stable” (that's why the next release will bring proxy
editing). Note that while we use the word “beta” here, this *is* the
latest “stable” release, and is the one we recommend over all previous
ones.

Pitivi works well for us and we make nice movies with it. Try it out,
have fun and report detailed bugs for issues you may encounter!

Blog post associated with this release:
<http://jeff.ecchi.ca/blog/2015/11/19/pitivi-0-95-enfant-suisse/>

## Changes and completed tasks

82 tasks have been closed, See the list of [reported tasks that have
been resolved in
0.95](https://phabricator.freedesktop.org/maniphest/query/iwzeFEu9xmQG/#R).

Since the 0.94 release, 392 commits were made in Pitivi, fixing many
bugs and implementing the following features:

### The timeline has been rewritten

The timeline has been rewritten using plain GTK+. This means that we do
not depend on the Clutter library anymore; it was causing many problems
for our use cases.

### The clip transformation box has been reimplemented

The transformation tool was previously dropped when Pitivi was ported to
the GStreamer Editing Services. It has now been reimplemented. While its
current state means that it lost a few features compared to its previous
incarnation, it should be more robust and much simpler to maintain.

### New video sink

The glimagesink (video rendering widget) was replaced by the new
gtk(gl)sink, which integrates more cleanly inside the application and
avoids various bugs we used to encounter while embedding the old sink
into Gtk.

### Direct importing to the timeline

It is now possible to import external files directly into the timeline.
Just drag & drop from your favorite file manager to create a clip on the
timeline.

### Integration with GstValidate

With this new release, we serialize all the operations done by the user
as
[GstValidateScenarios](http://gstreamer.freedesktop.org/data/doc/gstreamer/head/gst-validate/html/scenarios.html)
(more details
[here](https://blogs.gnome.org/tsaunier/2014/04/21/gst-validate-a-suite-of-tools-to-run-integration-tests-for-gstreamer-2/)),
allowing us to reproduce bugs much more easily. See the [bug
reporting](Bug_reporting.md) page for details on how to create
scenario files for testing.

### Fits small screens again

We heard 1024x768 is still a thing, so we added some tricks to adapt the
UI when running on small screens.

## Requirements changes

-   We dropped our dependency on Clutter
-   We now depend on GStreamer 1.6
-   We now depend on the new gtksink (from gst-plugins-bad 1.6)

Generally speaking, you can refer to the bottom of Pitivi's check.py for
the dependencies' versions specific to a given release. See also
[dependencies](attic/Dependencies.md) for additional tips.

## Known issues

-   Some users might experience a playback performance regression with
    the new timeline. See ticket
    [T3348](https://phabricator.freedesktop.org/T3348#52546) for
    details, to subscribe yourself or provide feedback for the
    investigation.
-   The title editor UI is still quite primitive. Please join us to make
    it work up to your expectations! See the existing
    \[<https://phabricator.freedesktop.org/maniphest/?statuses=open>()&projects=PHID-PROJ-ext-TITLEEDITOR\#R
    title editor bugs\].
-   Translations are not all fully up to date.
-   The automatic clip aligner feature does not work. We need someone to
    [port it to use our new audio waveforms processing
    module](https://phabricator.freedesktop.org/T3058).
-   [No dialog to install missing codecs after discovering
    clips](https://phabricator.freedesktop.org/T2989), and no error gets
    raised in that case. This means that the clip will “appear” to have
    imported correctly, but if you try inserting it into the timeline
    you may get errors in the background or Pitivi's UI may hang.

See the list of [currently known
issues](https://phabricator.freedesktop.org/project/view/15/)

## Contributors for this release

In Pitivi:

` 213  Thibault Saunier`\
` 100  Alexandru Băluț`\
`  18  Mathieu Duponchelle`\
`  17  Jean-François Fortin Tam`\
`  14  Piotr Drąg (translations)`\
`   7  Dušan Kazik (translations)`\
`   7  Marek Černocký (translations)`\
`   4  Daniel Mustieles (translations)`\
`   4  Josef Andersson (translations)`\
`   2  Balázs Úr (translations)`\
`   2  Gábor Kelemen (translations)`\
`   2  Inaki Larranaga Murgoitio (translations)`\
`   2  Lubosz Sarnecki`\
`   1  Aurimas Černius (translations)`\
`   1  Cheng-Chia Tseng (translations)`\
`   1  Christian Kirbach (translations)`\
`   1  Jiri Grönroos (translations)`\
`   1  Jordi Mas (translations)`\
`   1  Luke Faraone`\
`   1  Rafael Fontenelle (translations)`\
`   1  Samir Ribic (translations)`\
`   1  Tiago S (translations)`\
`   1  Wim Taymans`\
`   1  Мирослав Николић (translations)`

In [GES](GES.md) (from 1.4.0 to 1.6.1):

`  244  Thibault Saunier`\
`  108  Mathieu Duponchelle`\
`   28  Tim-Philipp Müller`\
`   13  Justin Kim`\
`    8  Luis de Bethencourt`\
`    7  Sebastian Dröge`\
`    7  Stefan Sauer`\
`    4  Edward Hervey`\
`    2  Joris Valette`\
`    1  Jan Schmidt`\
`    1  Nicolas Dufresne`
