/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/*
 *  Medusa
 *
 *  Copyright (C) 2001 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 *
 *  medusa-system-state.h -- API to turn off medusa's daily running, turn it back on,
 *  and check if medusa has been blocked on a system.
 */

#ifndef MEDUSA_SYSTEM_STATE_H
#define MEDUSA_SYSTEM_STATE_H

#include <glib.h>

/* This API will allow you to query whether medusa services are available.
   The services may be in one of three states:
   1.  Enabled -- Index and search services are available
   2.  Disabled -- Index and search services are not available, but if a user requests
   there availability, they are turned on
   3.  Blocked -- Index and search services are not available, and have been permenantly turned
   off by the system administrator.  Users may not request that they be enabled */
  
/* These functions return TRUE if the transaction was successfully completed,
   or FALSE if services are currently blocked, or if there is an I/O error at the system level */
gboolean    medusa_enable_medusa_services                   (gboolean turn_services_on);
gboolean    medusa_system_services_are_enabled               (void);
gboolean    medusa_system_services_are_blocked               (void);
gboolean    medusa_system_services_have_been_enabled_by_user (const char *username);

typedef void (* MedusaSystemStateFunc)     (gpointer data);

typedef enum MedusaSystemState {
        MEDUSA_SYSTEM_STATE_ENABLED = 1 << 0,
        MEDUSA_SYSTEM_STATE_DISABLED = 1 << 1,
        MEDUSA_SYSTEM_STATE_BLOCKED = 1 << 2
} MedusaSystemState;


/* These functions need to be called within a gtk_main_loop */

/* Returns an update function id, that can be used to remove the callback with  medusa_system_services_remove_update_function */
int         medusa_execute_when_system_state_changes                  (MedusaSystemState states_that_should_cause_an_update,
                                                                       MedusaSystemStateFunc callback,
                                                                       gpointer callback_data);
int         medusa_execute_once_when_system_state_changes             (MedusaSystemState states_that_should_cause_an_update,
                                                                       MedusaSystemStateFunc callback,
                                                                       gpointer callback_data);

void        medusa_remove_state_changed_function                      (int update_function_id);




#endif /* MEDUSA_SYSTEM_STATE_H */


