/* -*- Mode: C; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 8 -*- */

/*
 *  Medusa
 *
 *  Copyright (C) 2000 Eazel, Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public
 *  License along with this library; if not, write to the Free
 *  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Author: Rebecca Schulman <rebecka@eazel.com>
 *
 *  medusa-system-state-test.c - Test program for the medusa system state API
 *
 */

#include <glib.h>
#include <libmedusa/medusa-system-state.h>

int
main (int argc, char **argv)
{
        g_print ("\n");
        g_print ("Testing status of medusa services.\n\n");
        g_print ("Settings can be changed for yourself by running medusa-enable-indexing\n");
        g_print ("or by editing the medusa.conf file in /etc/medusa as root.\n");

        g_print ("\n");
        if (medusa_system_services_are_blocked ()) {
                g_print ("Medusa system services are blocked.\n");
        }
        else {
                g_print ("Medusa system services are not blocked.\n");
                if (medusa_system_services_are_enabled ()) {
                        g_print ("Medusa system services are enabled.\n");
                }
                else {
                        g_print ("Medusa system services are not enabled.\n");
                }
        }

        return 0;
}
