/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gdk;

import org.gnu.glib.Handle;

public class Gdk 
{
	
    /**
     * Get the default dimensions of the screen.
     */
    public static Dimension getScreenDimension(){
        int width = Gdk.gdk_screen_width();
        int height = Gdk.gdk_screen_height();
        return new Dimension(width,height);
    }
	
    /**
     * Emits a short beep.
     */
    public static void beep(){
        Gdk.gdk_beep();
    }
	
    static {
        System.loadLibrary(org.gnu.glib.Config.LIBRARY_NAME + org.gnu.glib.Config.GTK_API_VERSION);
    }
		
    native static final protected void gdk_input_set_extension_events (int window, int mask, int mode);
    native static final protected void gdk_flush ();
    native static final protected String gdk_set_locale ();
    native static final protected int gdk_screen_width ();
    native static final protected int gdk_screen_height ();
    native static final protected int gdk_screen_width_mm ();
    native static final protected int gdk_screen_height_mm ();
    native static final protected void gdk_beep ();
    native static final protected void gdk_set_show_events (boolean showEvents);
    native static final protected boolean gdk_get_show_events ();
    native static final protected String gdk_keyval_name (int keyval);
    native static final protected int gdk_keyval_from_name (String keyvalName);
    native static final protected int gdk_keyval_to_upper (int keyval);
    native static final protected int gdk_keyval_to_lower (int keyval);
    native static final protected boolean gdk_keyval_is_upper (int keyval);
    native static final protected boolean gdk_keyval_is_lower (int keyval);

    native static final private void gdk_init(int[] argc, String[] argv);
    native static final private boolean gdk_init_check(int[] argc, String[] argv);
    native static final private void gdk_parse_args(int[] argc, String[] argv);
    native static final private String gdk_get_program_class();
    native static final private void gdk_set_program_class(String program_class);
    native static final private void gdk_error_trap_push();
    native static final private int gdk_error_trap_pop();
    native static final private String gdk_get_display_arg_name();
    native static final private String gdk_get_display();
    native static final private int gdk_pointer_grab(Handle window, boolean owner_events, int event_mask, Handle confine_to, Handle cursor, int time_);
    native static final private int gdk_keyboard_grab(Handle window, boolean owner_events, int time_);
    native static final private void gdk_pointer_ungrab(int time_);
    native static final private void gdk_keyboard_ungrab(int time_);
    native static final private boolean gdk_pointer_is_grabbed();
    native static final private void gdk_set_double_click_time(int msec);
    native static final private boolean gdk_rectangle_intersect(Handle src1, Handle src2, Handle dest);
    native static final private void gdk_rectangle_union(Handle src1, Handle src2, Handle dest);
    native static final private int gdk_rectangle_get_type();
    native static final private boolean gdk_event_send_client_message(Handle event, int winid);
    native static final private void gdk_event_send_clientmessage_toall(Handle event);
    native static final private boolean gdk_event_send_client_message_for_display(Handle display, Handle event, int winid);
    native static final private void gdk_notify_startup_complete();
    native static final private void gdk_threads_enter();
    native static final private void gdk_threads_leave();
    native static final private void gdk_threads_init();

    /**
    // Not implemented.
    native static final private void gdk_threads_set_lock_functions(GCallback enter_fn, GCallback leave_fn);

    // Deprecated or undocumented functions.
    native static final private void gdk_add_option_entries_libgtk_only(GOptionGroup* group);
    native static final private void gdk_pre_parse_libgtk_only();
    native static final private boolean gdk_pointer_grab_info_libgtk_only(Handle display, Handle grab_window, gboolean* owner_events);
    native static final private boolean gdk_keyboard_grab_info_libgtk_only(Handle display, Handle grab_window, gboolean* owner_events);
    native static final private void gdk_add_option_entries_libgtk_only(GOptionGroup* group);
    native static final private void gdk_pre_parse_libgtk_only();
    native static final private void gdk_exit(int error_code);
    native static final private void gdk_set_use_xshm(boolean use_xshm);
    native static final private boolean gdk_get_use_xshm();
    native static final private boolean gdk_pointer_grab_info_libgtk_only(Handle display, Handle grab_window, gboolean* owner_events);
    native static final private boolean gdk_keyboard_grab_info_libgtk_only(Handle display, Handle grab_window, gboolean* owner_events);
    native static final private String gdk_wcstombs(constGdkWChar* src);
    native static final private int gdk_mbstowcs(Handle dest, String src, int dest_max);
    native static final private int gdk_input_add_full(int source, int condition, int function, gpointer data, int destroy);
    native static final private int gdk_input_add(int source, int condition, int function, gpointer data);
    native static final private void gdk_input_remove(int tag);
    */
}

