
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <libgnomeprintmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "./enums.h"
#include "./config.h"
#include "./context.h"
#include "./font.h"
#include "./job.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType gnome_print_config_get_type(void);
GType gnome_print_context_get_type(void);
GType gnome_font_get_type(void);
GType gnome_print_job_get_type(void);

//Declarations of the *_error_quark() functions:

} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Gnome { namespace Print {  class Config_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Print {  class Context_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Print {  class Font_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }
namespace Gnome { namespace Print {  class Job_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  } }

namespace Gnome { namespace Print { 

void wrap_init()
{
  // Register Error domains:

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(gnome_print_config_get_type(), &Gnome::Print::Config_Class::wrap_new);
  Glib::wrap_register(gnome_print_context_get_type(), &Gnome::Print::Context_Class::wrap_new);
  Glib::wrap_register(gnome_font_get_type(), &Gnome::Print::Font_Class::wrap_new);
  Glib::wrap_register(gnome_print_job_get_type(), &Gnome::Print::Job_Class::wrap_new);

  // Register the gtkmm gtypes:
  Gnome::Print::Config::get_type();
  Gnome::Print::Context::get_type();
  Gnome::Print::Font::get_type();
  Gnome::Print::Job::get_type();

} // wrap_init()

} //Print
} //Gnome


