/* main.cc
 *
 * Copyright (C) 2003 libgnomeprintmm Development Team
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#include <libgnomeprintmm.h>
#include <libgnomeprint/gnome-print.h> //For constants.
#include <iostream>


int main (int argc, char** argv)
{
  //This should read the contents of one file and output them to another file.
  
  //Get the command-line arguments:
  std::string output_filepath;
  if(argc > 1 )
  {
    output_filepath = argv[1];
  }
  else
  {
    std::cout << "Call this with and output file path, such as" << std::endl
              << "./example test.ps" << std::endl;
    return 0;
  }

  //Initialize:
  Gnome::Print::init();

  Glib::RefPtr<Gnome::Print::Job> refJob = Gnome::Print::Job::create();

  Glib::RefPtr<Gnome::Print::Config> refConfig = refJob->get_config();
  if(!refConfig)
  {
    std::cerr << "Config is null." << std::endl;
    return 1;
  }
  
  //TOOD: Is this a property?
  refConfig->set("Printer", "GENERIC");
  
  refJob->set_print_to_file(output_filepath);

  refConfig->set(GNOME_PRINT_KEY_PAPER_SIZE, "USLetter");

  
  Glib::RefPtr<Gnome::Print::Context> refContext = refJob->get_context();
  if(!refContext)
  {
    std::cerr << "Context is null." << std::endl;
    return 1;
  }
    
  refContext->begin_page("1");


  //Print some text on the page:
    
  Glib::RefPtr<Gnome::Print::Font> refFontLuxi = Gnome::Print::Font::find_closest("Luxi Sans Bold", 12);
  if(!refFontLuxi)
  {
    std::cerr << "Font is null: Font not found." << std::endl;
    return 1;
  }
  
  refContext->set_font(refFontLuxi);
  refContext->move_to(100, 200);
  refContext->show("The quick brown fox jumps over the lazy dog.");


  //Print some more text underneath the first text: 
  Glib::RefPtr<Gnome::Print::Font> refFont2 = Gnome::Print::Font::find_closest("Sans Bold", 12);
  refContext->set_font(refFont2);
  refContext->move_to(100, 180);
  refContext->show("Some more text.");

  refContext->show_page();

  refJob->close();
  refJob->print();
  
  return 0;
}


