
#include <libgnomemm/moduleinfo.h>
#include <libgnomemm/private/moduleinfo_p.h>

// -*- c++ -*-
/* $Id: moduleinfo.ccg,v 1.6 2002/03/27 19:12:25 murrayc Exp $ */

/*
 *
 * Copyright 2001      Free Software Foundation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <glibmm/utility.h>

namespace Gnome
{

ModuleInfo::ModuleInfo()
{
  GnomeModuleInfo tmp = {0, };
  gobject_ = gnomemm_module_info_copy(&tmp);
}

ModuleInfo::ModuleInfo(const gchar* name, const gchar* version, const gchar* description)
{
  //These strings should be statically allocated string literals.

  GnomeModuleInfo tmp = {name, version, description, 0};
  gobject_ = gnomemm_module_info_copy(&tmp);
}

void ModuleInfo::set_requirements(GnomeModuleRequirement* requirements)
{
  if(gobj()->requirements == 0)
    gobj()->requirements = requirements;
}

void ModuleInfo::set_post_args_parse(GnomeModuleHook function)
{
  gobj()->post_args_parse = function;
}


//The copy and free functions are hidden, but they are registered, so we can use them generically:
GnomeModuleInfo* gnomemm_module_info_copy(const GnomeModuleInfo* src)
{
  //Actually, we'll copy the implementation, because g_boxed_* can't be used before the system is initialized:
  return (GnomeModuleInfo*)g_memdup (src, sizeof (GnomeModuleInfo));
  //return (GnomeModuleInfo*)g_boxed_copy(GNOME_TYPE_MODULE_INFO, (gconstpointer)src);
}

void gnomemm_module_info_free(GnomeModuleInfo* src)
{
  //Actually, we'll copy the implementation, because g_boxed_* can't be used before the system is initialized:
  g_free (src);
  //g_boxed_free(GNOME_TYPE_MODULE_INFO, (gpointer)src);
}

} //namespace Gnome


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::ModuleInfo wrap(GnomeModuleInfo* object, bool take_copy /* = false */)
{
  return Gnome::ModuleInfo(object, take_copy);
}

} // namespace Glib


namespace Gnome
{


// static
GType ModuleInfo::get_type()
{
  return gnome_module_info_get_type();
}


ModuleInfo::ModuleInfo(const ModuleInfo& src)
:
  gobject_ ((src.gobject_) ? gnomemm_module_info_copy(src.gobject_) : 0)
{}

ModuleInfo::ModuleInfo(GnomeModuleInfo* castitem, bool make_a_copy /* = true */)
{
  // For BoxedType wrappers, make_a_copy is true by default.  The static
  // BoxedType wrappers must always take a copy, thus make_a_copy = true
  // ensures identical behaviour if the default argument is used.

  if(make_a_copy)
  {
    if(castitem)
      gobject_ = gnomemm_module_info_copy(castitem);
    else
      gobject_ = 0;
  }
  else
  {
    // It was given to us by a function which has already made a copy for us to keep.
    gobject_ = castitem;
  }
}

ModuleInfo& ModuleInfo::operator=(const ModuleInfo& src)
{
  GnomeModuleInfo *const new_gobject = (src.gobject_) ? gnomemm_module_info_copy(src.gobject_) : 0;

  if(gobject_)
    gnomemm_module_info_free(gobject_);
  gobject_ = new_gobject;

  return *this;
}

ModuleInfo::~ModuleInfo()
{
  if(gobject_)
    gnomemm_module_info_free(gobject_);}


GnomeModuleInfo* ModuleInfo::gobj_copy() const
{
  return gnomemm_module_info_copy(gobject_);
}

Glib::ustring ModuleInfo::get_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->name);
}

Glib::ustring ModuleInfo::get_version() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->version);
}

Glib::ustring ModuleInfo::get_description() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gobj()->description);
}


} // namespace Gnome


