/* gnome-db-goo.h
 *
 * Copyright (C) 2007 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_GOO__
#define __GNOME_DB_GOO__

#include <goocanvas.h>
#include <libgda/gda-decl.h>
#include <libgnomedb/gnome-db-decl.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_GOO          (gnome_db_goo_get_type())
#define GNOME_DB_GOO(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_goo_get_type(), GnomeDbGoo)
#define GNOME_DB_GOO_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_goo_get_type (), GnomeDbGooClass)
#define GNOME_DB_IS_GOO(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_goo_get_type ())

typedef enum {
	GNOME_DB_GOO_LAYOUT_DEFAULT,
	GNOME_DB_GOO_LAYOUT_RADIAL
} GnomeDbGooLayoutAlgorithm;

/* struct for the object's data */
struct _GnomeDbGoo
{
	GooCanvas           widget;

	/* pointer position when a context menu was last opened */
	gdouble             xmouse;
	gdouble             ymouse;
	/* private */
	GnomeDbGooPrivate  *priv;
};

/* struct for the object's class */
struct _GnomeDbGooClass
{
	GooCanvasClass      parent_class;

	/* virtual functions */
	void           (*create_canvas_items) (GnomeDbGoo *canvas); /* create individual GnomeDbGooItem objects */
	void           (*clean_canvas_items)  (GnomeDbGoo *canvas); /* clean any extra structure, not the individual items */

	void           (*graph_item_added)    (GnomeDbGoo *canvas, GdaGraphItem *item);
	void           (*graph_item_dropped)  (GnomeDbGoo *canvas, GdaGraphItem *item);

	GtkWidget     *(*build_context_menu)  (GnomeDbGoo *canvas);

	/* signals */
	void           (*drag_action)        (GnomeDbGoo *canvas, GnomeDbGooItem *from_item, GnomeDbGooItem *to_item);
};

/* generic widget's functions */
GType              gnome_db_goo_get_type                (void) G_GNUC_CONST;

GdaGraph          *gnome_db_goo_get_graph               (GnomeDbGoo *canvas);
GtkWidget         *gnome_db_goo_set_in_scrolled_window  (GnomeDbGoo *canvas);
void               gnome_db_goo_declare_item            (GnomeDbGoo *canvas, GnomeDbGooItem *item);

GnomeDbGooItem    *gnome_db_goo_get_item_for_object     (GnomeDbGoo *canvas, GdaObject *ref_obj);
void               gnome_db_goo_set_zoom_factor         (GnomeDbGoo *canvas, gdouble n);
gdouble            gnome_db_goo_get_zoom_factor         (GnomeDbGoo *canvas);
gdouble            gnome_db_goo_fit_zoom_factor         (GnomeDbGoo *canvas);
gboolean           gnome_db_goo_auto_layout_enabled     (GnomeDbGoo *canvas);
void               gnome_db_goo_perform_auto_layout     (GnomeDbGoo *canvas, gboolean animate, 
							 GnomeDbGooLayoutAlgorithm algorithm);
void               gnome_db_goo_center                  (GnomeDbGoo *canvas);
#define GNOME_DB_GOO_ENTITY_COLOR      "yellow"
#define GNOME_DB_GOO_DB_TABLE_COLOR    "lightblue"
#define GNOME_DB_GOO_QUERY_COLOR       "lightgreen"

G_END_DECLS

#endif
