/* gnome-db-goo-field.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_GOO_FIELD__
#define __GNOME_DB_GOO_FIELD__

#include <libgnomedb/gnome-db-decl.h>
#include "gnome-db-goo-text.h"

G_BEGIN_DECLS

/*
 * 
 * "Drag item" GooCanvas item: a GnomeDbGooItem item which is used to represent
 * an element being dragged, and destroys itself when the mouse button is released
 *
 */

#define GNOME_DB_TYPE_GOO_FIELD          (gnome_db_goo_field_get_type())
#define GNOME_DB_GOO_FIELD(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_goo_field_get_type(), GnomeDbGooField)
#define GNOME_DB_GOO_FIELD_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_goo_field_get_type (), GnomeDbGooFieldClass)
#define GNOME_DB_IS_GOO_FIELD(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_goo_field_get_type ())


/* struct for the object's data */
struct _GnomeDbGooField
{
	GnomeDbGooText          object;

	GnomeDbGooFieldPrivate *priv;
};

/* struct for the object's class */
struct _GnomeDbGooFieldClass
{
	GnomeDbGooTextClass     parent_class;
};

/* generic widget's functions */
GType             gnome_db_goo_field_get_type        (void) G_GNUC_CONST;
GooCanvasItem*    gnome_db_goo_field_new             (GooCanvasItem *parent, GdaEntityField *field,
						      gdouble x, gdouble y, ...);
GdaEntityField   *gnome_db_goo_field_get_field       (GnomeDbGooField *cfield);
GnomeDbGooEntity *gnome_db_goo_field_get_parent_item (GnomeDbGooField *cfield);

G_END_DECLS

#endif
