/* gnome-db-graph-item.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_GRAPH_ITEM_H_
#define __GNOME_DB_GRAPH_ITEM_H_

#include <libgnomedb/gnome-db-base.h>
#include <libgnomedb/gnome-db-decl.h>

/* Implements the GnomeDbXmlStorage interface */

G_BEGIN_DECLS

#define GNOME_DB_TYPE_GRAPH_ITEM          (gnome_db_graph_item_get_type())
#define GNOME_DB_GRAPH_ITEM(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_graph_item_get_type(), GnomeDbGraphItem)
#define GNOME_DB_GRAPH_ITEM_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_graph_item_get_type (), GnomeDbGraphItemClass)
#define IS_GNOME_DB_GRAPH_ITEM(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_graph_item_get_type ())

/* error reporting */
extern GQuark gnome_db_graph_item_error_quark (void);
#define GNOME_DB_GRAPH_ITEM_ERROR gnome_db_graph_item_error_quark ()

enum
{
	GNOME_DB_GRAPH_ITEM_XML_LOAD_ERROR
};


/* struct for the object's data */
struct _GnomeDbGraphItem
{
	GnomeDbBase               object;
	GnomeDbGraphItemPrivate  *priv;
};

/* struct for the object's class */
struct _GnomeDbGraphItemClass
{
	GnomeDbBaseClass   class;
	
	/* signals */
	void        (*moved) (GnomeDbGraphItem *item);
};

GType            gnome_db_graph_item_get_type            (void);

GObject         *gnome_db_graph_item_new                 (GnomeDbDict *dict, GnomeDbBase *ref_obj);
GnomeDbBase          *gnome_db_graph_item_get_ref_object      (GnomeDbGraphItem *item);
void             gnome_db_graph_item_set_position        (GnomeDbGraphItem *item, gdouble x, gdouble y);
void             gnome_db_graph_item_get_position        (GnomeDbGraphItem *item, gdouble *x, gdouble *y);

G_END_DECLS

#endif
