/* gnome-db-target.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_TARGET_H_
#define __GNOME_DB_TARGET_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>
#include "gnome-db-query.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_TARGET          (gnome_db_target_get_type())
#define GNOME_DB_TARGET(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_target_get_type(), GnomeDbTarget)
#define GNOME_DB_TARGET_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_target_get_type (), GnomeDbTargetClass)
#define IS_GNOME_DB_TARGET(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_target_get_type ())


/* Properties:
 * name        type          read/write      description
 * --------------------------------------------------------------------------------------------
 * query       pointer       RW              The GnomeDbQuery object to which the object is attached
 */

/* Interfaces:
 * GnomeDbXmlStorage
 * GnomeDbRerefer
 * GnomeDbAlias
 */

/* error reporting */
extern GQuark gnome_db_target_error_quark (void);
#define GNOME_DB_TARGET_ERROR gnome_db_target_error_quark ()

/* different possible types for a query */
typedef enum {
        GNOME_DB_TARGET_TYPE_INNER,
	GNOME_DB_TARGET_TYPE_LEFT_OUTER,
	GNOME_DB_TARGET_TYPE_RIGHT_OUTER,
	GNOME_DB_TARGET_TYPE_FULL_OUTER,
        GNOME_DB_TARGET_TYPE_CROSS,
        GNOME_DB_TARGET_TYPE_LAST
} GnomeDbTargetType;

enum
{
	GNOME_DB_TARGET_XML_LOAD_ERROR,
	GNOME_DB_TARGET_META_DATA_UPDATE,
	GNOME_DB_TARGET_FIELDS_ERROR
};


/* struct for the object's data */
struct _GnomeDbTarget
{
	GnomeDbBase               object;
	GnomeDbTargetPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbTargetClass
{
	GnomeDbBaseClass                    class;
};

GType           gnome_db_target_get_type               (void);
GObject        *gnome_db_target_new_with_entity        (GnomeDbQuery *query, GnomeDbEntity *entity);
GObject        *gnome_db_target_new_with_xml_id        (GnomeDbQuery *query, const gchar *entity_xml_id);
GObject        *gnome_db_target_new_copy               (GnomeDbTarget *orig);

GnomeDbQuery        *gnome_db_target_get_query              (GnomeDbTarget *target);
GnomeDbEntity       *gnome_db_target_get_represented_entity (GnomeDbTarget *target);

void            gnome_db_target_set_alias              (GnomeDbTarget *target, const gchar *alias);
const gchar    *gnome_db_target_get_alias              (GnomeDbTarget *target);
gchar          *gnome_db_target_get_complete_name      (GnomeDbTarget *target);

G_END_DECLS

#endif
