/* gnome-db-server-function.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_SERVER_FUNCTION_H_
#define __GNOME_DB_SERVER_FUNCTION_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_SERVER_FUNCTION          (gnome_db_server_function_get_type())
#define GNOME_DB_SERVER_FUNCTION(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_server_function_get_type(), GnomeDbServerFunction)
#define GNOME_DB_SERVER_FUNCTION_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_server_function_get_type (), GnomeDbServerFunctionClass)
#define IS_GNOME_DB_SERVER_FUNCTION(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_server_function_get_type ())


/* error reporting */
extern GQuark gnome_db_server_function_error_quark (void);
#define GNOME_DB_SERVER_FUNCTION_ERROR gnome_db_server_function_error_quark ()

enum
{
	GNOME_DB_SERVER_FUNCTION_XML_LOAD_ERROR
};


/* struct for the object's data */
struct _GnomeDbServerFunction
{
	GnomeDbBase                         object;
	GnomeDbServerFunctionPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbServerFunctionClass
{
	GnomeDbBaseClass                    class;

	/* signals */
	void   (*templ_signal)        (GnomeDbServerFunction *obj);
};

GType             gnome_db_server_function_get_type      (void);
GObject          *gnome_db_server_function_new           (GnomeDbServer *srv);
void              gnome_db_server_function_set_dbms_id   (GnomeDbServerFunction *func, const gchar *id);
gchar            *gnome_db_server_function_get_dbms_id   (GnomeDbServerFunction *func);
void              gnome_db_server_function_set_sqlname   (GnomeDbServerFunction *func, const gchar *sqlname);
const gchar      *gnome_db_server_function_get_sqlname   (GnomeDbServerFunction *func);
void              gnome_db_server_function_set_arg_types (GnomeDbServerFunction *func, const GSList *arg_types);
const GSList     *gnome_db_server_function_get_arg_types (GnomeDbServerFunction *func);
void              gnome_db_server_function_set_ret_type  (GnomeDbServerFunction *func, GnomeDbServerDataType *dt);
GnomeDbServerDataType *gnome_db_server_function_get_ret_type  (GnomeDbServerFunction *func);

gboolean          gnome_db_server_function_accepts_args  (GnomeDbServerFunction *func, const GSList *arg_types);

G_END_DECLS

#endif
