/* gnome-db-renderer.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_RENDERER_H_
#define __GNOME_DB_RENDERER_H_

#include <glib-object.h>
#include <libxml/tree.h>
#include "gnome-db-decl.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_RENDERER          (gnome_db_renderer_get_type())
#define GNOME_DB_RENDERER(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_RENDERER, GnomeDbRenderer)
#define IS_GNOME_DB_RENDERER(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_RENDERER)
#define GNOME_DB_RENDERER_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GNOME_DB_TYPE_RENDERER, GnomeDbRendererIface))

/* rendering options */
typedef enum {
	GNOME_DB_RENDERER_EXTRA_PRETTY_SQL   = 1 << 0,
	GNOME_DB_RENDERER_EXTRA_VAL_ATTRS    = 1 << 1,
	GNOME_DB_RENDERER_ERROR_IF_DEFAULT   = 1 << 2
} GnomeDbRendererOptions;

/* struct for the interface */
struct _GnomeDbRendererIface
{
	GTypeInterface           g_iface;

	/* virtual table */
	gchar      *(* render_as_sql)   (GnomeDbRenderer *iface, GnomeDbDataSet *context, guint options, GError **error); 
	gchar      *(* render_as_str)   (GnomeDbRenderer *iface, GnomeDbDataSet *context);
	gboolean    (* is_valid)        (GnomeDbRenderer *iface, GnomeDbDataSet *context, GError **error);
};

GType           gnome_db_renderer_get_type        (void) G_GNUC_CONST;

gchar          *gnome_db_renderer_render_as_sql   (GnomeDbRenderer *iface, GnomeDbDataSet *context, guint options, GError **error);
gchar          *gnome_db_renderer_render_as_str   (GnomeDbRenderer *iface, GnomeDbDataSet *context);
gboolean        gnome_db_renderer_is_valid        (GnomeDbRenderer *iface, GnomeDbDataSet *context, GError **error);

G_END_DECLS

#endif
