/* gnome-db-database.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_DATABASE_H_
#define __GNOME_DB_DATABASE_H_

#include <glib-object.h>
#include "gnome-db-decl.h"
#include "gnome-db-base.h"
#include "gnome-db-dict.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_DATABASE          (gnome_db_database_get_type())
#define GNOME_DB_DATABASE(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_database_get_type(), GnomeDbDatabase)
#define GNOME_DB_DATABASE_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_database_get_type (), GnomeDbDatabaseClass)
#define IS_GNOME_DB_DATABASE(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_database_get_type ())


/* error reporting */
extern GQuark gnome_db_database_error_quark (void);
#define GNOME_DB_DATABASE_ERROR gnome_db_database_error_quark ()

enum
{
	GNOME_DB_DATABASE_XML_SAVE_ERROR,
	GNOME_DB_DATABASE_XML_LOAD_ERROR,
	GNOME_DB_DATABASE_META_DATA_UPDATE,
	GNOME_DB_DATABASE_META_DATA_UPDATE_USER_STOPPED,
	GNOME_DB_DATABASE_TABLES_ERROR,
	GNOME_DB_DATABASE_SEQUENCES_ERROR
};



/* struct for the object's data */
struct _GnomeDbDatabase
{
	GnomeDbBase                   object;
	GnomeDbDatabasePrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbDatabaseClass
{
	GnomeDbBaseClass class;

	/* signals */
	void   (*table_added)               (GnomeDbDatabase *obj, GnomeDbTable *table);
	void   (*table_removed)             (GnomeDbDatabase *obj, GnomeDbTable *table);
	void   (*table_updated)             (GnomeDbDatabase *obj, GnomeDbTable *table);

	void   (*field_added)               (GnomeDbDatabase *obj, GnomeDbField *field);
	void   (*field_removed)             (GnomeDbDatabase *obj, GnomeDbField *field);
	void   (*field_updated)             (GnomeDbDatabase *obj, GnomeDbField *field);

	void   (*sequence_added)            (GnomeDbDatabase *obj, GnomeDbSequence *seq);
	void   (*sequence_removed)          (GnomeDbDatabase *obj, GnomeDbSequence *seq);
	void   (*sequence_updated)          (GnomeDbDatabase *obj, GnomeDbSequence *seq);

	void   (*constraint_added)          (GnomeDbDatabase *obj, GnomeDbConstraint *cstr);
	void   (*constraint_removed)        (GnomeDbDatabase *obj, GnomeDbConstraint *cstr);
	void   (*constraint_updated)        (GnomeDbDatabase *obj, GnomeDbConstraint *cstr);
	
	void   (*fs_link_added)              (GnomeDbDatabase *obj, GnomeDbSequence *seq, GnomeDbField *field);
	void   (*fs_link_removed)            (GnomeDbDatabase *obj, GnomeDbSequence *seq, GnomeDbField *field);

	void   (*data_update_started)       (GnomeDbDatabase *obj);
	void   (*update_progress)           (GnomeDbDatabase *obj, gchar * msg, guint now, guint total);
	void   (*data_update_finished)      (GnomeDbDatabase *obj);
};

GType              gnome_db_database_get_type                  (void);
GObject           *gnome_db_database_new                       (GnomeDbDict *dict);

GnomeDbDict            *gnome_db_database_get_dict                  (GnomeDbDatabase *mgdb);

gboolean           gnome_db_database_update_dbms_data          (GnomeDbDatabase *mgdb, GError **error);
void               gnome_db_database_stop_update_dbms_data     (GnomeDbDatabase *mgdb);

GSList            *gnome_db_database_get_tables                (GnomeDbDatabase *mgdb);
GnomeDbTable         *gnome_db_database_get_table_by_name         (GnomeDbDatabase *mgdb, const gchar *name);
GnomeDbTable         *gnome_db_database_get_table_by_xml_id       (GnomeDbDatabase *mgdb, const gchar *xml_id);
GnomeDbField         *gnome_db_database_get_field_by_name         (GnomeDbDatabase *mgdb, const gchar *fullname);
GnomeDbField         *gnome_db_database_get_field_by_xml_id       (GnomeDbDatabase *mgdb, const gchar *xml_id);

GnomeDbSequence      *gnome_db_database_get_sequence_by_name      (GnomeDbDatabase *mgdb, const gchar *name);
GnomeDbSequence      *gnome_db_database_get_sequence_by_xml_id    (GnomeDbDatabase *mgdb, const gchar *xml_id);
GnomeDbSequence      *gnome_db_database_get_sequence_to_field     (GnomeDbDatabase *mgdb, GnomeDbField *field);
void               gnome_db_database_link_sequence             (GnomeDbDatabase *mgdb, 
						          GnomeDbSequence *seq, GnomeDbField *field);
void               gnome_db_database_unlink_sequence           (GnomeDbDatabase *mgdb, 
							  GnomeDbSequence *seq, GnomeDbField *field);

void               gnome_db_database_add_constraint            (GnomeDbDatabase *mgdb, GnomeDbConstraint *cstr);
GSList            *gnome_db_database_get_all_constraints       (GnomeDbDatabase *mgdb);
GSList            *gnome_db_database_get_all_fk_constraints    (GnomeDbDatabase *mgdb);
GSList            *gnome_db_database_get_table_constraints     (GnomeDbDatabase *mgdb, GnomeDbTable *table);
GSList            *gnome_db_database_get_tables_fk_constraints (GnomeDbDatabase *mgdb, GnomeDbTable *table1, GnomeDbTable *table2,
							  gboolean table1_has_fk);

G_END_DECLS

#endif
