/* gnome-db-qfield.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


/*
 * This object is the qfield object for most of Mergeant's objects, it provides
 * basic facilities:
 * - a reference to the GnomeDbDict object
 * - a unique id which is used to XML storing procedures
 * - some attributes such as name, description and owner of the object (only used
 *   for DBMS object which are derived from this class.
 */


#ifndef __GNOME_DB_QFIELD_H_
#define __GNOME_DB_QFIELD_H_

#include "gnome-db-decl.h"
#include <libxml/tree.h>
#include "gnome-db-base.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_QFIELD          (gnome_db_qfield_get_type())
#define GNOME_DB_QFIELD(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_qfield_get_type(), GnomeDbQfield)
#define GNOME_DB_QFIELD_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_qfield_get_type (), GnomeDbQfieldClass)
#define IS_GNOME_DB_QFIELD(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_qfield_get_type ())


/* error reporting */
extern GQuark gnome_db_qfield_error_quark (void);
#define GNOME_DB_QFIELD_ERROR gnome_db_qfield_error_quark ()

enum
{
	GNOME_DB_QFIELD_XML_LOAD_ERROR
};


/* struct for the object's data */
struct _GnomeDbQfield
{
	GnomeDbBase                 object;
	GnomeDbQfieldPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbQfieldClass
{
	GnomeDbBaseClass            class;

	/* pure virtual functions */
	GObject          *(*copy)           (GnomeDbQfield *orig);
	GSList           *(*get_params)     (GnomeDbQfield *qfield);
	gboolean          (*is_equal)       (GnomeDbQfield *qfield1, GnomeDbQfield *qfield2);
	gboolean          (*is_list)        (GnomeDbQfield *qfield);
};

GType             gnome_db_qfield_get_type        (void);
GObject          *gnome_db_qfield_new_from_xml    (GnomeDbQuery *query, xmlNodePtr node, GError **error);
GObject          *gnome_db_qfield_new_copy        (GnomeDbQfield *orig);
GObject          *gnome_db_qfield_new_from_sql    (GnomeDbQuery *query, const gchar *sqlfield, GError **error);

GnomeDbServerDataType *gnome_db_qfield_get_data_type   (GnomeDbQfield *qfield);
GSList           *gnome_db_qfield_get_parameters  (GnomeDbQfield *qfield);
void              gnome_db_qfield_set_alias       (GnomeDbQfield *qfield, const gchar *alias);
const gchar      *gnome_db_qfield_get_alias       (GnomeDbQfield *qfield);

void              gnome_db_qfield_set_visible     (GnomeDbQfield *qfield, gboolean visible);
gboolean          gnome_db_qfield_is_visible      (GnomeDbQfield *qfield);

void              gnome_db_qfield_set_internal    (GnomeDbQfield *qfield, gboolean internal);
gboolean          gnome_db_qfield_is_internal     (GnomeDbQfield *qfield);

gboolean          gnome_db_qfield_is_equal        (GnomeDbQfield *qfield1, GnomeDbQfield *qfield2);

gboolean          gnome_db_qfield_is_list         (GnomeDbQfield *qfield);

G_END_DECLS

#endif
