/* gnome-db-data-set.h
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_DATA_SET_H_
#define __GNOME_DB_DATA_SET_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_DATA_SET          (gnome_db_data_set_get_type())
#define GNOME_DB_DATA_SET(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_data_set_get_type(), GnomeDbDataSet)
#define GNOME_DB_DATA_SET_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_data_set_get_type (), GnomeDbDataSetClass)
#define IS_GNOME_DB_DATA_SET(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_data_set_get_type ())


/* Interfaces:
 * GnomeDbRerefer
 */

/* error reporting */
extern GQuark gnome_db_data_set_error_quark (void);
#define GNOME_DB_DATA_SET_ERROR gnome_db_data_set_error_quark ()

enum
{
	GNOME_DB_DATA_SET_NO_NODE_ERROR,
	GNOME_DB_DATA_SET_NODE_OUTDATED_ERROR,
	GNOME_DB_DATA_SET_VALUE_PROV_OBJ_TYPE_ERROR,
	GNOME_DB_DATA_SET_VALUE_PROV_DATA_TYPE_ERROR,
	GNOME_DB_DATA_SET_VALUE_PROV_INVISIBLE_ERROR,
	GNOME_DB_DATA_SET_VALUE_PROV_QUERY_TYPE_ERROR,
	GNOME_DB_DATA_SET_DEPENDENCY_NOT_IN_DATASET_ERROR,
	GNOME_DB_DATA_SET_DEPENDENCY_POSITION_ERROR,
	GNOME_DB_DATA_SET_XML_SPEC_ERROR
};

typedef enum {
	GNOME_DB_DATA_SET_PARAM_READ_ONLY = 1 << 0, /* param should not be affected by user modifications */
	GNOME_DB_DATA_SET_PARAM_HIDE      = 1 << 1  /* param should not be shown to the user */
} GnomeDbDataSetParamHint;

/* 
 * use either 'param' or 'params' and 'data_for_param'
 * FIXME: take 'pos_for_param' out of the nodes into another public attribute of GnomeDbDataSet (=> reduce mem usage)
 */
struct _GnomeDbDataSetNode {
	/* this GnomeDbDataSetNode is only for one parameter, free fill */
        GnomeDbParameter *param; 

	/* this GnomeDbDataSetNode is for one or more parameters, listed in 'params' and the params values
	   depend on the data in 'data_for_param' */
        GSList           *params;
        GnomeDbDataModel *data_for_param; 
	GHashTable       *pos_for_param; /* key=param value=column in 'data_for_param' where its source field is */
};

#define GNOME_DB_DATA_SET_NODE(x) ((GnomeDbDataSetNode *)x)

/* struct for the object's data */
struct _GnomeDbDataSet
{
	GnomeDbBase               object;
	GSList                   *parameters;
        GSList                   *nodes;
	GHashTable               *hints; /* key = param, value = hint as a guint */

	GnomeDbDataSetPrivate    *priv;
};

/* struct for the object's class */
struct _GnomeDbDataSetClass
{
	GnomeDbBaseClass          class;

	void               (*param_changed) (GnomeDbDataSet *dataset, GnomeDbParameter *param);
};

GType               gnome_db_data_set_get_type                 (void);
GObject            *gnome_db_data_set_new                      (GnomeDbDict *dict, GSList *params);
GObject            *gnome_db_data_set_new_copy                 (GnomeDbDataSet *orig, GHashTable *replacements);
GObject            *gnome_db_data_set_new_from_spec            (GnomeDbDict *dict, const gchar *xml_spec, GError **error);
gchar              *gnome_db_data_set_get_spec                 (GnomeDbDataSet *dataset);
 
void                gnome_db_data_set_add_param                (GnomeDbDataSet *dataset, GnomeDbParameter *param);
void                gnome_db_data_set_merge_dataset_params     (GnomeDbDataSet *dataset, GnomeDbDataSet *dataset_to_merge);
gboolean            gnome_db_data_set_is_coherent              (GnomeDbDataSet *dataset, GError **error);
gboolean            gnome_db_data_set_is_valid                 (GnomeDbDataSet *dataset);
gboolean            gnome_db_data_set_needs_user_input         (GnomeDbDataSet *dataset);

GnomeDbParameter   *gnome_db_data_set_find_parameter           (GnomeDbDataSet *dataset, const gchar *param_name);
GnomeDbParameter   *gnome_db_data_set_find_parameter_for_field (GnomeDbDataSet *dataset, GnomeDbField *for_field);
GnomeDbDataSetNode *gnome_db_data_set_find_node_for_param      (GnomeDbDataSet *dataset, GnomeDbParameter *param);

void                gnome_db_data_set_set_param_default_value  (GnomeDbDataSet *dataset, GnomeDbParameter *param, const GdaValue *value);
void                gnome_db_data_set_set_param_default_alias  (GnomeDbDataSet *dataset, GnomeDbParameter *param, GnomeDbParameter *alias);
const GdaValue     *gnome_db_data_set_get_param_default_value  (GnomeDbDataSet *dataset, GnomeDbParameter *param);

G_END_DECLS

#endif
