/* gnome-db-data-proxy.h
 *
 * Copyright (C) 2004 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_DATA_PROXY_H_
#define __GNOME_DB_DATA_PROXY_H_

#include "gnome-db-decl.h"
#include "gnome-db-base.h"
#include <libgda/libgda.h>
#include <gtk/gtktreemodel.h>


G_BEGIN_DECLS

#define GNOME_DB_TYPE_DATA_PROXY          (gnome_db_data_proxy_get_type())
#define GNOME_DB_DATA_PROXY(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_data_proxy_get_type(), GnomeDbDataProxy)
#define GNOME_DB_DATA_PROXY_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_data_proxy_get_type (), GnomeDbDataProxyClass)
#define IS_GNOME_DB_DATA_PROXY(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_data_proxy_get_type ())

/* error reporting */
extern GQuark gnome_db_data_proxy_error_quark (void);
#define GNOME_DB_DATA_PROXY_ERROR gnome_db_data_proxy_error_quark ()

enum {
	GNOME_DB_DATA_PROXY_COMMIT_ERROR
};

/*
 * NOTE about the model's columns:
 *
 * - negative column numbers are used to return information regarding the whole row and
 *   are enumerated below.
 * - if (column >= 0) and (column < model's n_cols) then the GtktreeModel stores the GdaValue for the model's column
 * - if (column >= model's n_cols) and (column < 2*model's n_cols), then the GtktreeModel stores the attributes for
 *   the data at column/2
 * - if (column >= 2*model's n_cols) and (column < 3*model's n_cols), then the GtktreeModel stores the un-modified
 *   GdaValue value for the data at column/3
 *
 * So the number of columns available in the GtkTreeModel depends on the actual data stored in the GnomeDbDataModel.
 */ 
enum {
	PROXY_COL_MODEL_N_COLUMNS = -6, /* number of columns in the GnomeDbDataModel */
	PROXY_COL_MODEL_POINTER   = -5, /* pointer to the GnomeDbDataModel */
	PROXY_COL_MODEL_ROW       = -4, /* row number in the GnomeDbDataModel, or -1 for new rows */
	PROXY_COL_MODIFIED        = -3, /* TRUE if row has been modified */
	PROXY_COL_TO_DELETE       = -2, /* TRUE if row is marked to be deleted */
};
#define PROXY_NB_GEN_COLUMNS 5

/* struct for the object's data */
struct _GnomeDbDataProxy
{
	GnomeDbBase                    object;
	GnomeDbDataProxyPrivate       *priv;
};


/* struct for the object's class */
struct _GnomeDbDataProxyClass
{
	GnomeDbBaseClass                    class;
};

GType             gnome_db_data_proxy_get_type             (void);
GObject          *gnome_db_data_proxy_new                  (GnomeDbDataModel *model);

gboolean          gnome_db_data_proxy_is_read_only         (GnomeDbDataProxy *proxy);
gint              gnome_db_data_proxy_get_n_rows           (GnomeDbDataProxy *proxy);
gint              gnome_db_data_proxy_get_n_columns        (GnomeDbDataProxy *proxy);
gboolean          gnome_db_data_proxy_set_value            (GnomeDbDataProxy *proxy, GtkTreeIter *iter, 
								 gint col, const GdaValue *value);
const GdaValue    *gnome_db_data_proxy_get_value            (GnomeDbDataProxy *proxy, GtkTreeIter *iter, gint col);
GSList           *gnome_db_data_proxy_get_values           (GnomeDbDataProxy *proxy, GtkTreeIter *iter, 
								 gint *cols_index, gint n_cols);
void              gnome_db_data_proxy_delete               (GnomeDbDataProxy *proxy, GtkTreeIter *iter);
void              gnome_db_data_proxy_undelete             (GnomeDbDataProxy *proxy, GtkTreeIter *iter);

gboolean          gnome_db_data_proxy_get_iter_from_values (GnomeDbDataProxy *proxy, GtkTreeIter *iter,
								 GSList *values, gint *cols_index);
GnomeDbDataModel *gnome_db_data_proxy_get_model            (GnomeDbDataProxy *proxy);
void              gnome_db_data_proxy_append               (GnomeDbDataProxy *proxy, GtkTreeIter *iter);

gboolean          gnome_db_data_proxy_has_been_modified    (GnomeDbDataProxy *proxy);
void              gnome_db_data_proxy_reset_all            (GnomeDbDataProxy *proxy);
void              gnome_db_data_proxy_reset_value          (GnomeDbDataProxy *proxy, GtkTreeIter *iter, gint col);

gboolean          gnome_db_data_proxy_commit_all           (GnomeDbDataProxy *proxy, GError **error);
gboolean          gnome_db_data_proxy_commit_row           (GnomeDbDataProxy *proxy, GtkTreeIter *iter, GError **error);

void              gnome_db_data_proxy_set_sample_size      (GnomeDbDataProxy *proxy, gint sample_size);
gint              gnome_db_data_proxy_get_sample_size      (GnomeDbDataProxy *proxy);
void              gnome_db_data_proxy_set_sample_start     (GnomeDbDataProxy *proxy, gint sample_start);
gint              gnome_db_data_proxy_get_sample_start     (GnomeDbDataProxy *proxy);
gint              gnome_db_data_proxy_get_sample_end       (GnomeDbDataProxy *proxy);


G_END_DECLS

#endif
