/* gnome-db-constraint.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_CONSTRAINT_H_
#define __GNOME_DB_CONSTRAINT_H_

#include "gnome-db-base.h"
#include "gnome-db-ref-base.h"
#include "gnome-db-decl.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_CONSTRAINT          (gnome_db_constraint_get_type())
#define GNOME_DB_CONSTRAINT(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_constraint_get_type(), GnomeDbConstraint)
#define GNOME_DB_CONSTRAINT_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_constraint_get_type (), GnomeDbConstraintClass)
#define IS_GNOME_DB_CONSTRAINT(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_constraint_get_type ())


/* error reporting */
extern GQuark gnome_db_constraint_error_quark (void);
#define GNOME_DB_CONSTRAINT_ERROR gnome_db_constraint_error_quark ()

enum
{
	GNOME_DB_CONSTRAINT_XML_SAVE_ERROR,
	GNOME_DB_CONSTRAINT_XML_LOAD_ERROR
};

typedef enum
{
	CONSTRAINT_PRIMARY_KEY,
	CONSTRAINT_FOREIGN_KEY,
	CONSTRAINT_UNIQUE,
	CONSTRAINT_NOT_NULL,
	CONSTRAINT_CHECK_EXPR,
	CONSTRAINT_UNKNOWN
} GnomeDbConstraintType;

typedef enum
{
	CONSTRAINT_FK_ACTION_CASCADE,
	CONSTRAINT_FK_ACTION_SET_NULL,
	CONSTRAINT_FK_ACTION_SET_DEFAULT,
	CONSTRAINT_FK_ACTION_SET_VALUE,
	CONSTRAINT_FK_ACTION_NO_ACTION
} GnomeDbConstraintFkAction;

typedef struct
{
	GnomeDbTableField *fkey;
	GnomeDbTableField *ref_pkey;
	GnomeDbRefBase *ref_pkey_repl; /* can be used instead of ref_pkey, the object will fill ref_pkey itself */
} GnomeDbConstraintFkeyPair;

#define GNOME_DB_CONSTRAINT_FK_PAIR(x) ((GnomeDbConstraintFkeyPair*) (x))

/* struct for the object's data */
struct _GnomeDbConstraint
{
	GnomeDbBase                  object;
	GnomeDbConstraintPrivate  *priv;
};

/* struct for the object's class */
struct _GnomeDbConstraintClass
{
	GnomeDbBaseClass                    class;

	/* signals */
	void   (*templ_signal)        (GnomeDbConstraint *obj);
};

GType              gnome_db_constraint_get_type            (void);
GObject           *gnome_db_constraint_new                 (GnomeDbTable *table, GnomeDbConstraintType type);
GObject           *gnome_db_constraint_new_with_db         (GnomeDbDatabase *db);
GnomeDbConstraintType gnome_db_constraint_get_constraint_type (GnomeDbConstraint *cstr);
gboolean           gnome_db_constraint_equal               (GnomeDbConstraint *cstr1, GnomeDbConstraint *cstr2);
GnomeDbTable         *gnome_db_constraint_get_table           (GnomeDbConstraint *cstr);
gboolean           gnome_db_constraint_uses_field          (GnomeDbConstraint *cstr, GnomeDbTableField *field);

/* Primary KEY specific */
void               gnome_db_constraint_pkey_set_fields     (GnomeDbConstraint *cstr, const GSList *fields);
GSList            *gnome_db_constraint_pkey_get_fields     (GnomeDbConstraint *cstr);

/* Foreign KEY specific */
void               gnome_db_constraint_fkey_set_fields     (GnomeDbConstraint *cstr, const GSList *pairs);
GnomeDbTable         *gnome_db_constraint_fkey_get_ref_table  (GnomeDbConstraint *cstr);
GSList            *gnome_db_constraint_fkey_get_fields     (GnomeDbConstraint *cstr);
void               gnome_db_constraint_fkey_set_actions    (GnomeDbConstraint *cstr, 
							 GnomeDbConstraintFkAction on_update, 
							 GnomeDbConstraintFkAction on_delete);
void               gnome_db_constraint_fkey_get_actions    (GnomeDbConstraint *cstr, 
							 GnomeDbConstraintFkAction *on_update, 
							 GnomeDbConstraintFkAction *on_delete);

/* UNIQUE specific */
void               gnome_db_constraint_unique_set_fields   (GnomeDbConstraint *cstr, const GSList *fields);
GSList            *gnome_db_constraint_unique_get_fields   (GnomeDbConstraint *cstr);

/* NOT NULL specific */
void               gnome_db_constraint_not_null_set_field  (GnomeDbConstraint *cstr, GnomeDbTableField *field);
GnomeDbTableField         *gnome_db_constraint_not_null_get_field  (GnomeDbConstraint *cstr);

/* Check specific */
/* TODO */

G_END_DECLS

#endif
