/* gnome-db-wrapper-field.h
 *
 * Copyright (C) 2004 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_WRAPPER_FIELD_H_
#define __GNOME_DB_WRAPPER_FIELD_H_

#include "gnome-db-decl.h"
#include "gnome-db-base.h"

G_BEGIN_DECLS

#define GNOME_DB_WRAPPER_FIELD_TYPE          (gnome_db_wrapper_field_get_type())
#define GNOME_DB_WRAPPER_FIELD(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_wrapper_field_get_type(), GnomeDbWrapperField)
#define GNOME_DB_WRAPPER_FIELD_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_wrapper_field_get_type (), GnomeDbWrapperFieldClass)
#define IS_GNOME_DB_WRAPPER_FIELD(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_wrapper_field_get_type ())


/* error reporting */
extern GQuark gnome_db_wrapper_field_error_quark (void);
#define GNOME_DB_WRAPPER_FIELD_ERROR gnome_db_wrapper_field_error_quark ()

enum
{
	GNOME_DB_WRAPPER_FIELD_DATA_TYPE_ERROR
};


/* struct for the object's data */
struct _GnomeDbWrapperField
{
	GnomeDbBase                 object;
	GnomeDbWrapperFieldPrivate *priv;
};

/* struct for the object's class */
struct _GnomeDbWrapperFieldClass
{
	GnomeDbBaseClass            class;
};

GType             gnome_db_wrapper_field_get_type        (void);
GObject          *gnome_db_wrapper_field_new_in_model    (GnomeDbModelWrapper *model, gint col);
GObject          *gnome_db_wrapper_field_new_in_entity   (GnomeDbEntity *entity, GnomeDbField *field);

G_END_DECLS

#endif
