/* gnome-db-layout.h
 *
 * Copyright (C) 2004 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_LAYOUT_H_
#define __GNOME_DB_LAYOUT_H_

#include "gnome-db-decl.h"
#include <gtk/gtk.h>

G_BEGIN_DECLS

#define GNOME_DB_LAYOUT_TYPE          (gnome_db_layout_get_type())
#define GNOME_DB_LAYOUT(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_layout_get_type(), GnomeDbLayout)
#define GNOME_DB_LAYOUT_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_layout_get_type (), GnomeDbLayoutClass)
#define IS_GNOME_DB_LAYOUT(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_layout_get_type ())

typedef struct _GnomeDbLayout        GnomeDbLayout;
typedef struct _GnomeDbLayoutClass   GnomeDbLayoutClass;
typedef struct _GnomeDbLayoutPrivate GnomeDbLayoutPrivate;

/* error reporting */
extern GQuark gnome_db_layout_error_quark (void);
#define GNOME_DB_LAYOUT_ERROR gnome_db_layout_error_quark ()

/* struct for the object's data */
struct _GnomeDbLayout
{
	GtkVBox                 object;
	GnomeDbLayoutPrivate    *priv;
};

/* struct for the object's class */
struct _GnomeDbLayoutClass
{
	GtkVBoxClass          class;
};

GType           gnome_db_layout_get_type                 (void);
GtkWidget      *gnome_db_layout_new                      (GnomeDbCustomLayout *layout);
GtkWidget      *gnome_db_layout_lookup_widget            (GnomeDbLayout *layout, const gchar *widget_name);

G_END_DECLS

#endif
