/* gnome-db-entity.h
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_ENTITY_H_
#define __GNOME_DB_ENTITY_H_

#include <glib-object.h>
#include "gnome-db-decl.h"
#include <libgda/gda-xql-item.h>

G_BEGIN_DECLS

#define GNOME_DB_ENTITY_TYPE          (gnome_db_entity_get_type())
#define GNOME_DB_ENTITY(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_entity_get_type(), GnomeDbEntity)
#define IS_GNOME_DB_ENTITY(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_entity_get_type ())
#define GNOME_DB_ENTITY_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GNOME_DB_ENTITY_TYPE, GnomeDbEntityIface))


/* struct for the interface */
struct _GnomeDbEntityIface
{
	GTypeInterface           g_iface;

	/* virtual table */
	gboolean         (*has_field)            (GnomeDbEntity *iface, GnomeDbField *field);
	GSList          *(*get_fields)           (GnomeDbEntity *iface);
	GnomeDbField    *(*get_field_by_name)    (GnomeDbEntity *iface, const gchar *name);
	GnomeDbField    *(*get_field_by_xml_id)  (GnomeDbEntity *iface, const gchar *xml_id);
	GnomeDbField    *(*get_field_by_index)   (GnomeDbEntity *iface, gint index);
	gint             (*get_field_index)      (GnomeDbEntity *iface, GnomeDbField *field);
	void             (*add_field)            (GnomeDbEntity *iface, GnomeDbField *field);
	void             (*add_field_before)     (GnomeDbEntity *iface, GnomeDbField *field, GnomeDbField *field_before);
	void             (*swap_fields)          (GnomeDbEntity *iface, GnomeDbField *field1, GnomeDbField *field2);
	void             (*remove_field)         (GnomeDbEntity *iface, GnomeDbField *field);
	gboolean         (*is_writable)          (GnomeDbEntity *iface);
	GSList          *(*get_parameters)       (GnomeDbEntity *iface);

	/* signals */
	void             (*field_added)          (GnomeDbEntity *iface, GnomeDbField *field);
	void             (*field_removed)        (GnomeDbEntity *iface, GnomeDbField *field);
	void             (*field_updated)        (GnomeDbEntity *iface, GnomeDbField *field);
	void             (*fields_order_changed) (GnomeDbEntity *iface);
};

GType            gnome_db_entity_get_type        (void) G_GNUC_CONST;

gboolean         gnome_db_entity_has_field           (GnomeDbEntity *iface, GnomeDbField *field);
GSList          *gnome_db_entity_get_fields          (GnomeDbEntity *iface);
gint             gnome_db_entity_get_n_fields        (GnomeDbEntity *iface);
GnomeDbField    *gnome_db_entity_get_field_by_name   (GnomeDbEntity *iface, const gchar *name);
GnomeDbField    *gnome_db_entity_get_field_by_xml_id (GnomeDbEntity *iface, const gchar *xml_id);
GnomeDbField    *gnome_db_entity_get_field_by_index  (GnomeDbEntity *iface, gint index);
gint             gnome_db_entity_get_field_index     (GnomeDbEntity *iface, GnomeDbField *field);
void             gnome_db_entity_add_field           (GnomeDbEntity *iface, GnomeDbField *field);
void             gnome_db_entity_add_field_before    (GnomeDbEntity *iface, GnomeDbField *field, GnomeDbField *field_before);
void             gnome_db_entity_swap_fields         (GnomeDbEntity *iface, GnomeDbField *field1, GnomeDbField *field2);
void             gnome_db_entity_remove_field        (GnomeDbEntity *iface, GnomeDbField *field);
gboolean         gnome_db_entity_is_writable         (GnomeDbEntity *iface);

GSList          *gnome_db_entity_get_parameters      (GnomeDbEntity *iface);
GnomeDbDataSet  *gnome_db_entity_get_exec_dataset    (GnomeDbEntity *iface);




G_END_DECLS

#endif
