/* gnome-db-table-field.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_TABLE_FIELD_H_
#define __GNOME_DB_TABLE_FIELD_H_

#include "gnome-db-base.h"
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_TABLE_FIELD_TYPE          (gnome_db_table_field_get_type())
#define GNOME_DB_TABLE_FIELD(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_table_field_get_type(), GnomeDbTableField)
#define GNOME_DB_TABLE_FIELD_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_table_field_get_type (), GnomeDbTableFieldClass)
#define IS_GNOME_DB_TABLE_FIELD(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_table_field_get_type ())


/* error reporting */
extern GQuark gnome_db_table_field_error_quark (void);
#define GNOME_DB_TABLE_FIELD_ERROR gnome_db_table_field_error_quark ()

enum
{
	GNOME_DB_TABLE_FIELD_XML_LOAD_ERROR
};


/* struct for the object's data */
struct _GnomeDbTableField
{
	GnomeDbBase                  object;
	GnomeDbTableFieldPrivate       *priv;
};

/* struct for the object's class */
struct _GnomeDbTableFieldClass
{
	GnomeDbBaseClass                    class;

	/* signals */
	void   (*templ_signal)        (GnomeDbTableField *obj);
};

GType           gnome_db_table_field_get_type          (void);
GObject        *gnome_db_table_field_new               (GnomeDbDict *dict, GnomeDbServerDataType *type);

void            gnome_db_table_field_set_length        (GnomeDbTableField *field, gint length);
gint            gnome_db_table_field_get_length        (GnomeDbTableField *field);
void            gnome_db_table_field_set_scale         (GnomeDbTableField *field, gint length);
gint            gnome_db_table_field_get_scale         (GnomeDbTableField *field);
GSList         *gnome_db_table_field_get_constraints   (GnomeDbTableField *field);
void            gnome_db_table_field_set_data_type     (GnomeDbTableField *field, GnomeDbServerDataType *type);
void            gnome_db_table_field_set_default_value (GnomeDbTableField *field, const GdaValue *value);
const GdaValue *gnome_db_table_field_get_default_value (GnomeDbTableField *field);
gboolean        gnome_db_table_field_is_null_allowed   (GnomeDbTableField *field);
gboolean        gnome_db_table_field_is_pkey_part      (GnomeDbTableField *field);
gboolean        gnome_db_table_field_is_pkey_alone     (GnomeDbTableField *field);
gboolean        gnome_db_table_field_is_fkey_part      (GnomeDbTableField *field);
gboolean        gnome_db_table_field_is_fkey_alone     (GnomeDbTableField *field);

G_END_DECLS

#endif
