/* gnome-db-matrix.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_MATRIX__
#define __GNOME_DB_MATRIX__

#include <gtk/gtk.h>
#include "gnome-db-dict.h"
#include "gnome-db-enums.h"

G_BEGIN_DECLS

#define GNOME_DB_MATRIX_TYPE          (gnome_db_matrix_get_type())
#define GNOME_DB_MATRIX(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_matrix_get_type(), GnomeDbMatrix)
#define GNOME_DB_MATRIX_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_matrix_get_type (), GnomeDbMatrixClass)
#define IS_GNOME_DB_MATRIX(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_matrix_get_type ())


typedef struct _GnomeDbMatrix      GnomeDbMatrix;
typedef struct _GnomeDbMatrixClass GnomeDbMatrixClass;
typedef struct _GnomeDbMatrixPriv  GnomeDbMatrixPriv;

typedef enum {
	GNOME_DB_MATRIX_TABULAR_SYNTHETIC = 0,
	GNOME_DB_MATRIX_LIST_DETAILLED    = 1,
	GNOME_DB_MATRIX_LIST_SYNTHETIC    = 2,
} GnomeDbMatrixType;

/* struct for the object's data */
struct _GnomeDbMatrix
{
	GtkVBox             object;

	GnomeDbMatrixPriv     *priv;
};

/* struct for the object's class */
struct _GnomeDbMatrixClass
{
	GtkVBoxClass parent_class;
};

/* 
 * Generic widget's methods 
 */
GType        gnome_db_matrix_get_type            (void);
GtkWidget   *gnome_db_matrix_new                 (GnomeDbDict *dict,
						 GnomeDbQuery *rows_select_query, GnomeDbTarget *rows_target,
						 GnomeDbQuery *cols_select_query, GnomeDbTarget *cols_target,
						 GnomeDbTable *modif_table, GSList *modif_table_fields);
void         gnome_db_matrix_set_view_type       (GnomeDbMatrix *matrix, GnomeDbMatrixType type);

G_END_DECLS

#endif



