/* gnome-db-data-handler.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_DATA_HANDLER_H_
#define __GNOME_DB_DATA_HANDLER_H_

#include <gtk/gtk.h>
#include "gnome-db-decl.h"
#include <libgda/libgda.h>

G_BEGIN_DECLS

#define GNOME_DB_DATA_HANDLER_TYPE          (gnome_db_data_handler_get_type())
#define GNOME_DB_DATA_HANDLER(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_data_handler_get_type(), GnomeDbDataHandler)
#define IS_GNOME_DB_DATA_HANDLER(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_data_handler_get_type ())
#define GNOME_DB_DATA_HANDLER_GET_IFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GNOME_DB_DATA_HANDLER_TYPE, GnomeDbDataHandlerIface))


/* struct for the interface */
struct _GnomeDbDataHandlerIface
{
	GTypeInterface           g_iface;

	/* virtual table */
	GnomeDbDataEntry     *(* get_entry_from_value) (GnomeDbDataHandler *dh, const GdaValue *value, GdaValueType type);
	gchar           *(* get_sql_from_value)   (GnomeDbDataHandler *dh, const GdaValue *value);
	gchar           *(* get_str_from_value)   (GnomeDbDataHandler *dh, const GdaValue *value);
	GdaValue        *(* get_value_from_sql)   (GnomeDbDataHandler *dh, const gchar *sql, GdaValueType type);
	GdaValue        *(* get_value_from_str)   (GnomeDbDataHandler *dh, const gchar *str, GdaValueType type);
	GdaValue        *(* get_sane_init_value)  (GnomeDbDataHandler *dh, GdaValueType type);
	GtkCellRenderer *(* get_cell_renderer)    (GnomeDbDataHandler *dh, GdaValueType type);

	guint            (* get_nb_gda_types)     (GnomeDbDataHandler * dh);
	GdaValueType     (* get_gda_type_index)   (GnomeDbDataHandler * dh, guint index);
	gboolean         (* accepts_gda_type)     (GnomeDbDataHandler * dh, GdaValueType type);
	
	const gchar     *(* get_descr)            (GnomeDbDataHandler * dh);
	const gchar     *(* get_descr_detail)     (GnomeDbDataHandler * dh);
	const gchar     *(* get_version)          (GnomeDbDataHandler * dh);
	gboolean         (* is_plugin)            (GnomeDbDataHandler * dh);
	const gchar     *(* get_plugin_name)      (GnomeDbDataHandler * dh);
	const gchar     *(* get_plugin_file)      (GnomeDbDataHandler * dh);
	gchar           *(* get_key)              (GnomeDbDataHandler * dh);
	
};




guint        gnome_db_data_handler_get_type               (void);

/* Creates new widgets for data manipulation */
GnomeDbDataEntry     *gnome_db_data_handler_get_entry_from_value   (GnomeDbDataHandler * dh, const GdaValue *value, GdaValueType type);
GtkCellRenderer *gnome_db_data_handler_get_cell_renderer      (GnomeDbDataHandler * dh, GdaValueType type);


/* Simply does data manipulation */
gchar           *gnome_db_data_handler_get_sql_from_value     (GnomeDbDataHandler * dh, const GdaValue *value);
gchar           *gnome_db_data_handler_get_str_from_value     (GnomeDbDataHandler * dh, const GdaValue *value);
GdaValue        *gnome_db_data_handler_get_value_from_sql     (GnomeDbDataHandler * dh, const gchar *sql, GdaValueType type);
GdaValue        *gnome_db_data_handler_get_value_from_str     (GnomeDbDataHandler * dh, const gchar *str, GdaValueType type);
GdaValue        *gnome_db_data_handler_get_sane_init_value    (GnomeDbDataHandler * dh, GdaValueType type);


/* information about the data handler itself */
guint            gnome_db_data_handler_get_nb_gda_types       (GnomeDbDataHandler * dh);
GdaValueType     gnome_db_data_handler_get_gda_type_index     (GnomeDbDataHandler * dh, guint index);
gboolean         gnome_db_data_handler_accepts_gda_type       (GnomeDbDataHandler * dh, GdaValueType type);

const gchar     *gnome_db_data_handler_get_descr              (GnomeDbDataHandler * dh);
const gchar     *gnome_db_data_handler_get_descr_detail       (GnomeDbDataHandler * dh);
const gchar     *gnome_db_data_handler_get_version            (GnomeDbDataHandler * dh);
gboolean         gnome_db_data_handler_is_plugin              (GnomeDbDataHandler * dh);
const gchar     *gnome_db_data_handler_get_plugin_name        (GnomeDbDataHandler * dh);
const gchar     *gnome_db_data_handler_get_plugin_file        (GnomeDbDataHandler * dh);
gchar           *gnome_db_data_handler_get_key                (GnomeDbDataHandler * dh);


G_END_DECLS

#endif
