/* utility.h
 *
 * Copyright (C) 2003 - 2005 Vivien Malerba <malerba@gnome-db.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <gtk/gtk.h>
#include "gnome-db-data-set.h"
#include "gnome-db-data-entry.h"


/*
 *
 * Data Entry utilities
 *
 */
GtkWidget*              utility_entry_build_actions_menu      (GObject *obj_data, guint attrs, GCallback function);
GdkColor **             utility_entry_build_info_colors_array (void);

/*
 *
 * Query execution function with user feedback. To be removed?
 *
 */
gboolean                utility_query_execute_modif (GnomeDbQuery *query, GnomeDbDataSet *context,
                                                     gboolean ask_dictirm_insert,
                                                     gboolean ask_dictirm_update,
                                                     gboolean ask_dictirm_delete,
                                                     GtkWidget *parent_window,
                                                     gboolean *user_cancelled,
                                                     gboolean *query_error);
