/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <libgda/gda-config.h>
#include <libgnomedb/gnome-db-provider-selector.h>
#include <libgnomedb/gnome-db-util.h>

#define PARENT_TYPE GTK_TYPE_OPTION_MENU

struct _GnomeDbProviderSelectorPrivate {
};

static void gnome_db_provider_selector_class_init (GnomeDbProviderSelectorClass *klass);
static void gnome_db_provider_selector_init       (GnomeDbProviderSelector *selector,
						   GnomeDbProviderSelectorClass *klass);
static void gnome_db_provider_selector_finalize   (GObject *object);

static GObjectClass *parent_class = NULL;

/*
 * Private functions
 */

static void
show_providers (GnomeDbProviderSelector *selector)
{
	GList *prov_list;
	GList *l;

	gtk_option_menu_remove_menu (GTK_OPTION_MENU (selector));

	/* get provider list */
	prov_list = gda_config_get_provider_list ();
	for (l = prov_list; l != NULL; l = l->next) {
		GdaProviderInfo *prov_info = (GdaProviderInfo *) l->data;

		if (!prov_info)
			continue;

		gnome_db_option_menu_add_item (GTK_OPTION_MENU (selector), prov_info->id);
	}

	gda_config_free_provider_list (prov_list);
}

/*
 * GnomeDbProviderSelector class implementation
 */

static void
gnome_db_provider_selector_class_init (GnomeDbProviderSelectorClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->finalize = gnome_db_provider_selector_finalize;
}

static void
gnome_db_provider_selector_init (GnomeDbProviderSelector *selector,
				 GnomeDbProviderSelectorClass *klass)
{
	g_return_if_fail (GNOME_DB_IS_PROVIDER_SELECTOR (selector));

	selector->priv = g_new0 (GnomeDbProviderSelectorPrivate, 1);
	show_providers (selector);
}

static void
gnome_db_provider_selector_finalize (GObject *object)
{
	GnomeDbProviderSelector *selector = (GnomeDbProviderSelector *) object;

	g_return_if_fail (GNOME_DB_IS_PROVIDER_SELECTOR (selector));

	g_free (selector->priv);
	selector->priv = NULL;

	parent_class->finalize (object);
}

GType
gnome_db_provider_selector_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomeDbProviderSelectorClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_db_provider_selector_class_init,
			NULL,
			NULL,
			sizeof (GnomeDbProviderSelector),
			0,
			(GInstanceInitFunc) gnome_db_provider_selector_init
		};
		type = g_type_register_static (PARENT_TYPE,
					       "GnomeDbProviderSelector",
					       &info, 0);
	}
	return type;
}

/**
 * gnome_db_provider_selector_new
 *
 * Create a new #GnomeDbProviderSelector widget.
 *
 * Returns: the newly created widget.
 */
GtkWidget *
gnome_db_provider_selector_new (void)
{
	GnomeDbProviderSelector *selector;

	selector = g_object_new (GNOME_DB_TYPE_PROVIDER_SELECTOR, NULL);
	return GTK_WIDGET (selector);
}
