Summary:         Library for writing gnome database programs
Name:            libgnomedb
Version:         @version@
Release:         1
Source:          %{name}-%{version}.tar.gz
Group:           System Environment/Libraries
License:         LGPL
BuildRoot:       %{_tmppath}/%{name}-%{version}-root
BuildRequires:   pkgconfig >= 0.8
Requires:        libgnomeui >= 1.103.0
Requires:        libgda >= @version@
Requires:        gtk2 >= 1.3.6
Requires:        libbonoboui
Requires:        libglade2
BuildRequires:   libgnomeui-devel >= 1.103.0
BuildRequires:   libgda-devel >= @version@
BuildRequires:   gtk2-devel >= 1.3.6
BuildRequires:   libbonoboui-devel
BuildRequires:   libglade2-devel

%description
libgnomedb is a library that eases the task of writing
gnome database programs.

%package devel
Summary:         Development libraries and header files for libgnomedb.
Group:           Development/Libraries
Requires:        %name = %{version}
Requires:        pkgconfig >= 0.8
Requires:        libgnomeui >= 1.103.0
Requires:        libgnomeui-devel >= 1.103.0
Requires:        libgda >= @version@
Requires:        libgda-devel >= @version@
Requires:        gtk2 >= 1.3.6
Requires:        gtk2-devel >= 1.3.6
Requires:        libbonoboui
Requires:        libbonoboui-devel
Requires:        libglade2
Requires:        libglade2-devel

%description devel
This package contains the header files and libraries needed to write
or compile programs that use libgda.

%prep
%setup -q -n %{name}-%{version}

%build
%configure
make %{?_smp_mflags}

%install
rm -rf %{buildroot}
%makeinstall

%find_lang libgnomedb-2

%post -p /sbin/ldconfig
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`

for SCHEMA in %{_sysconfdir}/gconf/schemas/libgnomedb.schemas; do
/usr/bin/gconftool-2 --makefile-install-rule $SCHEMA > /dev/null 2>&1
done

%postun -p /sbin/ldconfig

%clean
rm -rf %{buildroot}

%files -f libgnomedb-2.lang
%defattr(-,root,root)
%doc AUTHORS COPYING ChangeLog README NEWS
%{_sysconfdir}/gconf/schemas/libgnomedb.schemas
%{_libdir}/*.so.*
%{_libdir}/libglade/2.0/*.so
%{_datadir}/pixmaps/*
%{_datadir}/gnome-db/pixmaps/*

%files devel
%defattr(-,root,root)
%doc %{_datadir}/gtk-doc/html/libgnomedb/*
%{_includedir}/libgnomedb/*
%{_libdir}/libglade/2.0/*a
%{_libdir}/*.so
%{_libdir}/*a
%{_libdir}/pkgconfig/*


%changelog
* Mon Feb 25 2002 Chris Chabot <chabotc@reviewboard.com>
- Cleaned up formatting
- Added requirements

* Thu Feb 21 2002 Chris Chabot <chabotc@reviewboard.com>
- Initial spec file
