/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <libgnomedb/gnome-db-dsn-config.h>

#define PARENT_TYPE GTK_TYPE_VBOX

struct _GnomeDbDsnConfigPrivate {
};

static void gnome_db_dsn_config_class_init (GnomeDbDsnConfigClass *klass);
static void gnome_db_dsn_config_init       (GnomeDbDsnConfig *config,
					    GnomeDbDsnConfigClass *klass);
static void gnome_db_dsn_config_finalize   (GObject *object);

static GObjectClass *parent_class = NULL;

/*
 * GnomeDbDsnConfig class implementation
 */

static void
gnome_db_dsn_config_class_init (GnomeDbDsnConfigClass *klass)
{
	GObjectClass *object_class = G_OBJECT_CLASS (klass);

	parent_class = g_type_class_peek_parent (klass);

	object_class->finalize = gnome_db_dsn_config_finalize;
}

static void
gnome_db_dsn_config_init (GnomeDbDsnConfig *config, GnomeDbDsnConfigClass *klass)
{
	g_return_if_fail (GNOME_DB_IS_DSN_CONFIG (config));

	/* allocate private structure */
	config->priv = g_new0 (GnomeDbDsnConfigPrivate, 1);
}

static void
gnome_db_dsn_config_finalize (GObject *object)
{
	GnomeDbDsnConfig *config = (GnomeDbDsnConfig *) object;

	g_return_if_fail (GNOME_DB_IS_DSN_CONFIG (config));

	/* free memory */
	g_free (config->priv);
	config->priv = NULL;

	/* chain to parent class */
	parent_class->finalize (object);
}

GType
gnome_db_dsn_config_get_type (void)
{
	static GType type = 0;

	if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomeDbDsnConfigClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_db_dsn_config_class_init,
			NULL,
			NULL,
			sizeof (GnomeDbDsnConfig),
			0,
			(GInstanceInitFunc) gnome_db_dsn_config_init
		};
		type = g_type_register_static (PARENT_TYPE, "GnomeDbDsnConfig",
					       &info, 0);
	}
	return type;
}

/**
 * gnome_db_dsn_config_new
 */
GtkWidget *
gnome_db_dsn_config_new (void)
{
	GnomeDbDsnConfig *config;

	config = g_object_new (GNOME_DB_TYPE_DSN_CONFIG, NULL);
	return GTK_WIDGET (config);
}
